/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.btree_list;

import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.Tuple2;
import org.javimmutable.collections.btree_list.BtreeEmptyNode;
import org.javimmutable.collections.btree_list.BtreeInsertResult;
import org.javimmutable.collections.btree_list.BtreeNode;
import org.javimmutable.collections.common.ArrayHelper;
import org.javimmutable.collections.cursors.StandardCursor;
import org.javimmutable.collections.indexed.IndexedArray;
import org.javimmutable.collections.iterators.EmptyIterator;
import org.javimmutable.collections.iterators.IndexedIterator;

class BtreeLeafNode<T>
implements BtreeNode<T>,
ArrayHelper.Allocator<T> {
    private final T[] values;

    BtreeLeafNode(T value) {
        this.values = new Object[]{value};
    }

    static <T> BtreeLeafNode<T> of(Indexed<? extends T> source, int offset, int limit) {
        int length = limit - offset;
        assert (length > 0 && length <= 18);
        assert (limit <= source.size());
        Object[] values = new Object[length];
        for (int i = 0; i < length; ++i) {
            values[i] = source.get(offset + i);
        }
        return new BtreeLeafNode<Object>(values);
    }

    private BtreeLeafNode(T[] values) {
        this.values = values;
    }

    @Override
    public int childCount() {
        return this.values.length;
    }

    @Override
    public int valueCount() {
        return this.values.length;
    }

    @Override
    public T get(int index) {
        return this.values[index];
    }

    @Override
    @Nonnull
    public BtreeNode<T> assign(int index, T value) {
        return new BtreeLeafNode<T>(ArrayHelper.assign(this.values, index, value));
    }

    @Override
    @Nonnull
    public BtreeInsertResult<T> insertAt(int index, T value) {
        T[] newValues = ArrayHelper.insert(this, this.values, index, value);
        int newLength = newValues.length;
        if (newLength <= 18) {
            return BtreeInsertResult.createInPlace(new BtreeLeafNode<T>(newValues));
        }
        int breakPoint = index < this.values.length ? 9 : newLength - 9;
        return BtreeInsertResult.createSplit(new BtreeLeafNode<T>(ArrayHelper.subArray(this, newValues, 0, breakPoint)), new BtreeLeafNode<T>(ArrayHelper.subArray(this, newValues, breakPoint, newLength)));
    }

    @Override
    @Nonnull
    public BtreeInsertResult<T> append(T value) {
        return this.insertAt(this.values.length, value);
    }

    @Override
    @Nonnull
    public BtreeInsertResult<T> insertNode(int addWhenZero, boolean atEnd, @Nonnull BtreeNode<T> node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsIndex(int index) {
        return index < this.values.length;
    }

    @Override
    public void checkInvariants(boolean isRoot) {
        if (this.values.length > 18) {
            throw new IllegalStateException();
        }
        if (this.values.length < 9 && !isRoot) {
            throw new IllegalStateException();
        }
    }

    @Override
    @Nonnull
    public Cursor<T> cursor() {
        return StandardCursor.of(IndexedArray.retained(this.values));
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return IndexedIterator.iterator(IndexedArray.retained(this.values));
    }

    @Override
    @Nonnull
    public Iterator<BtreeNode<T>> childIterator() {
        return EmptyIterator.of();
    }

    @Override
    @Nonnull
    public BtreeNode<T> delete(int index) {
        if (this.values.length == 1 && index == 0) {
            return BtreeEmptyNode.of();
        }
        return new BtreeLeafNode<T>(ArrayHelper.delete(this, this.values, index));
    }

    @Override
    @Nonnull
    public BtreeNode<T> mergeChildren(BtreeNode<T> sibling) {
        BtreeLeafNode leaf = (BtreeLeafNode)sibling;
        assert (leaf.values.length + this.values.length <= 18);
        return new BtreeLeafNode<T>(ArrayHelper.concat(this, this.values, leaf.values));
    }

    @Override
    @Nonnull
    public Tuple2<BtreeNode<T>, BtreeNode<T>> distributeChildren(BtreeNode<T> sibling) {
        BtreeLeafNode leaf = (BtreeLeafNode)sibling;
        assert (leaf.values.length + this.values.length >= 18);
        assert (leaf.values.length + this.values.length <= 36);
        return Tuple2.of(new BtreeLeafNode<T>(ArrayHelper.subArray(this, this.values, leaf.values, 0, 9)), new BtreeLeafNode<T>(ArrayHelper.subArray(this, this.values, leaf.values, 9, this.values.length + leaf.values.length)));
    }

    @Override
    public int depth() {
        return 1;
    }

    @Override
    @Nonnull
    public T[] allocate(int size) {
        return new Object[size];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BtreeLeafNode that = (BtreeLeafNode)o;
        return Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        return this.values != null ? Arrays.hashCode(this.values) : 0;
    }
}

