/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.btree_list;

import org.javimmutable.collections.Tuple2;
import org.javimmutable.collections.btree_list.BtreeNode;

class BtreeInsertResult<T> {
    final Type type;
    final BtreeNode<T> newNode;
    final BtreeNode<T> extraNode;

    private BtreeInsertResult(Type type, BtreeNode<T> newNode, BtreeNode<T> extraNode) {
        this.type = type;
        this.newNode = newNode;
        this.extraNode = extraNode;
    }

    static <T> BtreeInsertResult<T> createInPlace(BtreeNode<T> newNode) {
        return new BtreeInsertResult<T>(Type.INPLACE, newNode, null);
    }

    static <T> BtreeInsertResult<T> createSplit(BtreeNode<T> newNode, BtreeNode<T> extraNode) {
        return new BtreeInsertResult<T>(Type.SPLIT, newNode, extraNode);
    }

    static <T> BtreeInsertResult<T> createSplit(Tuple2<BtreeNode<T>, BtreeNode<T>> nodes) {
        return BtreeInsertResult.createSplit(nodes.getFirst(), nodes.getSecond());
    }

    public String toString() {
        return String.format("<%s,%s,%s>", new Object[]{this.type, this.newNode, this.extraNode});
    }

    static enum Type {
        INPLACE,
        SPLIT;

    }
}

