/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.btree_list;

import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.Tuple2;
import org.javimmutable.collections.btree_list.BtreeInsertResult;
import org.javimmutable.collections.btree_list.BtreeLeafNode;
import org.javimmutable.collections.btree_list.BtreeNode;
import org.javimmutable.collections.cursors.StandardCursor;
import org.javimmutable.collections.iterators.EmptyIterator;

@Immutable
class BtreeEmptyNode<T>
implements BtreeNode<T> {
    private static final BtreeEmptyNode EMPTY = new BtreeEmptyNode();

    BtreeEmptyNode() {
    }

    @Nonnull
    public static <T> BtreeEmptyNode<T> of() {
        return EMPTY;
    }

    @Override
    public int childCount() {
        return 0;
    }

    @Override
    public int valueCount() {
        return 0;
    }

    @Override
    public T get(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    public BtreeNode<T> assign(int index, T value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    public BtreeInsertResult<T> insertAt(int index, T value) {
        if (index == 0) {
            return BtreeInsertResult.createInPlace(new BtreeLeafNode<T>(value));
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    public BtreeInsertResult<T> append(T value) {
        return BtreeInsertResult.createInPlace(new BtreeLeafNode<T>(value));
    }

    @Override
    @Nonnull
    public BtreeInsertResult<T> insertNode(int addWhenZero, boolean atEnd, @Nonnull BtreeNode<T> node) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public BtreeNode<T> delete(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    public BtreeNode<T> mergeChildren(BtreeNode<T> sibling) {
        return sibling;
    }

    @Override
    @Nonnull
    public Tuple2<BtreeNode<T>, BtreeNode<T>> distributeChildren(BtreeNode<T> sibling) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsIndex(int index) {
        return false;
    }

    @Override
    public void checkInvariants(boolean atRoot) {
    }

    @Override
    @Nonnull
    public Cursor<T> cursor() {
        return StandardCursor.of();
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return EmptyIterator.of();
    }

    @Override
    public int depth() {
        return 1;
    }

    @Override
    @Nonnull
    public Iterator<BtreeNode<T>> childIterator() {
        return EmptyIterator.of();
    }
}

