/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.btree_list;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.Tuple2;
import org.javimmutable.collections.btree_list.BtreeEmptyNode;
import org.javimmutable.collections.btree_list.BtreeInsertResult;
import org.javimmutable.collections.btree_list.BtreeNode;
import org.javimmutable.collections.common.ArrayHelper;
import org.javimmutable.collections.cursors.LazyMultiCursor;
import org.javimmutable.collections.indexed.IndexedArray;
import org.javimmutable.collections.iterators.IndexedIterator;
import org.javimmutable.collections.iterators.LazyMultiIterator;

class BtreeBranchNode<T>
implements BtreeNode<T>,
ArrayHelper.Allocator<BtreeNode<T>> {
    private final BtreeNode<T>[] children;
    private final int valueCount;

    BtreeBranchNode(@Nonnull BtreeNode<T> child1, @Nonnull BtreeNode<T> child2) {
        this(child1, child2, child1.valueCount() + child2.valueCount());
    }

    BtreeBranchNode(@Nonnull BtreeNode<T> child1, @Nonnull BtreeNode<T> child2, int valueCount) {
        this.children = BtreeBranchNode.allocateNodes(2);
        this.children[0] = child1;
        this.children[1] = child2;
        this.valueCount = valueCount;
    }

    private BtreeBranchNode(@Nonnull BtreeNode<T>[] children) {
        this(children, BtreeBranchNode.countValues(children));
    }

    private BtreeBranchNode(@Nonnull BtreeNode<T>[] children, int valueCount) {
        this.children = children;
        this.valueCount = valueCount;
    }

    static <T> BtreeBranchNode<T> of(Indexed<BtreeNode<T>> source, int offset, int limit) {
        int length = limit - offset;
        assert (length > 0 && length <= 18);
        assert (limit <= source.size());
        BtreeNode<T>[] children = BtreeBranchNode.allocateNodes(length);
        for (int i = 0; i < length; ++i) {
            children[i] = source.get(offset + i);
        }
        return new BtreeBranchNode<T>(children);
    }

    @SafeVarargs
    @Nonnull
    static <T> BtreeBranchNode<T> forTesting(BtreeNode<T> ... children) {
        assert (children.length <= 18);
        return new BtreeBranchNode<T>((BtreeNode[])children.clone());
    }

    @Nonnull
    static <T> BtreeBranchNode<T> forTesting(List<BtreeNode<T>> childrenList) {
        BtreeNode<T>[] children = BtreeBranchNode.allocateNodes(childrenList.size());
        return new BtreeBranchNode<T>(childrenList.toArray(children));
    }

    @Nonnull
    private static <T> BtreeNode<T>[] allocateNodes(int size) {
        return new BtreeNode[size];
    }

    @Override
    public int childCount() {
        return this.children.length;
    }

    @Override
    public int valueCount() {
        return this.valueCount;
    }

    @Override
    public T get(int index) {
        Location<T> loc = this.findIndexForGetAssign(index);
        return ((Location)loc).child.get(((Location)loc).logicalIndex);
    }

    @Override
    @Nonnull
    public BtreeNode<T> assign(int index, T value) {
        Location<T> loc = this.findIndexForGetAssign(index);
        BtreeNode<T>[] newChildren = ArrayHelper.assign(this.children, ((Location)loc).childIndex, ((Location)loc).child.assign(((Location)loc).logicalIndex, value));
        return new BtreeBranchNode<T>(newChildren, this.valueCount);
    }

    @Override
    @Nonnull
    public BtreeInsertResult<T> insertAt(int index, T value) {
        Location<T> loc = this.findIndexForInsertAppend(index);
        BtreeInsertResult<T> childResult = ((Location)loc).child.insertAt(((Location)loc).logicalIndex, value);
        return this.resultForInsert(index < this.valueCount, ((Location)loc).childIndex, 1, childResult);
    }

    @Override
    @Nonnull
    public BtreeInsertResult<T> append(T value) {
        return this.insertAt(this.valueCount, value);
    }

    @Override
    @Nonnull
    public BtreeInsertResult<T> insertNode(int addWhenZero, boolean atEnd, @Nonnull BtreeNode<T> node) {
        if (addWhenZero == 0) {
            int totalChildren = this.childCount() + node.childCount();
            if (totalChildren <= 18) {
                BtreeNode<T> newNode = atEnd ? this.mergeChildren(node) : node.mergeChildren(this);
                return BtreeInsertResult.createInPlace(newNode);
            }
            Tuple2<BtreeNode<T>, BtreeNode<T>> newNodes = atEnd ? this.distributeChildren(node) : node.distributeChildren(this);
            return BtreeInsertResult.createSplit(newNodes);
        }
        int childIndex = atEnd ? this.children.length - 1 : 0;
        BtreeInsertResult<T> childResult = this.children[childIndex].insertNode(addWhenZero - 1, atEnd, node);
        return this.resultForInsert(!atEnd, childIndex, node.valueCount(), childResult);
    }

    @Override
    public boolean containsIndex(int index) {
        return index < this.valueCount;
    }

    @Override
    @Nonnull
    public BtreeNode<T> delete(int index) {
        BtreeNode nextChild;
        BtreeNode mergeChild;
        int mergeIndex;
        BtreeNode<T>[] children = this.children;
        int thisChildCount = children.length;
        Location<T> loc = this.findIndexForGetAssign(index);
        int childIndex = ((Location)loc).childIndex;
        int newValueCount = this.valueCount - 1;
        BtreeNode newChild = ((Location)loc).child.delete(((Location)loc).logicalIndex);
        int newChildCount = newChild.childCount();
        if (newChildCount >= 9) {
            return new BtreeBranchNode(ArrayHelper.assign(children, childIndex, newChild), newValueCount);
        }
        if (newChildCount == 0) {
            if (thisChildCount == 1) {
                return BtreeEmptyNode.of();
            }
            return new BtreeBranchNode<T>(ArrayHelper.delete(this, children, childIndex), newValueCount);
        }
        if (thisChildCount == 1) {
            return new BtreeBranchNode(ArrayHelper.assign(children, childIndex, newChild), newValueCount);
        }
        if (childIndex == thisChildCount - 1) {
            mergeIndex = childIndex - 1;
            mergeChild = children[mergeIndex];
            nextChild = newChild;
        } else {
            mergeIndex = childIndex;
            mergeChild = newChild;
            nextChild = children[childIndex + 1];
        }
        if (mergeChild.childCount() + nextChild.childCount() <= 18) {
            BtreeNode merged = mergeChild.mergeChildren(nextChild);
            return new BtreeBranchNode(ArrayHelper.assignDelete(this, children, mergeIndex, merged), newValueCount);
        }
        Tuple2 distributed = mergeChild.distributeChildren(nextChild);
        return new BtreeBranchNode(ArrayHelper.assignTwo(children, mergeIndex, distributed.getFirst(), distributed.getSecond()), newValueCount);
    }

    @Override
    @Nonnull
    public BtreeNode<T> mergeChildren(BtreeNode<T> sibling) {
        BtreeBranchNode branch = (BtreeBranchNode)sibling;
        assert (this.children.length + branch.children.length <= 18);
        return new BtreeBranchNode<T>(ArrayHelper.concat(this, this.children, branch.children), this.valueCount + branch.valueCount);
    }

    @Override
    @Nonnull
    public Tuple2<BtreeNode<T>, BtreeNode<T>> distributeChildren(BtreeNode<T> sibling) {
        BtreeBranchNode branch = (BtreeBranchNode)sibling;
        assert (branch.children.length + this.children.length >= 18);
        assert (branch.children.length + this.children.length <= 36);
        int totalLength = this.children.length + branch.children.length;
        int breakIndex = totalLength / 2;
        return Tuple2.of(new BtreeBranchNode<T>(ArrayHelper.subArray(this, this.children, branch.children, 0, breakIndex)), new BtreeBranchNode<T>(ArrayHelper.subArray(this, this.children, branch.children, breakIndex, totalLength)));
    }

    @Override
    @Nonnull
    public BtreeNode<T> compress() {
        return this.children.length == 1 ? this.children[0].compress() : this;
    }

    @Override
    public void checkInvariants(boolean isRoot) {
        if (this.children.length > 18) {
            throw new IllegalStateException();
        }
        if (this.children.length < 9 && !isRoot) {
            throw new IllegalStateException();
        }
        if (this.valueCount != BtreeBranchNode.countValues(this.children)) {
            throw new IllegalStateException();
        }
        int depth = this.children[0].depth();
        for (BtreeNode<T> child : this.children) {
            if (child.depth() != depth) {
                throw new IllegalStateException();
            }
            child.checkInvariants(false);
        }
    }

    @Override
    @Nonnull
    public Cursor<T> cursor() {
        return LazyMultiCursor.cursor(IndexedArray.retained(this.children));
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return LazyMultiIterator.iterator(IndexedArray.retained(this.children));
    }

    @Override
    @Nonnull
    public Iterator<BtreeNode<T>> childIterator() {
        return IndexedIterator.iterator(IndexedArray.retained(this.children));
    }

    @Override
    public int depth() {
        return 1 + this.children[0].depth();
    }

    @Nonnull
    public BtreeNode<T>[] allocate(int size) {
        return new BtreeNode[size];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BtreeBranchNode that = (BtreeBranchNode)o;
        return this.valueCount == that.valueCount && Arrays.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hash(this.children, this.valueCount);
    }

    @Nonnull
    private BtreeInsertResult<T> resultForInsert(boolean breakLeft, int childIndex, int sizeDelta, BtreeInsertResult<T> result) {
        BtreeNode<T>[] children = this.children;
        if (result.type == BtreeInsertResult.Type.INPLACE) {
            BtreeNode<T>[] newChildren = ArrayHelper.assign(children, childIndex, result.newNode);
            return BtreeInsertResult.createInPlace(new BtreeBranchNode(newChildren, this.valueCount + sizeDelta));
        }
        assert (result.type == BtreeInsertResult.Type.SPLIT);
        BtreeNode<T>[] newChildren = ArrayHelper.assignInsert(this, children, childIndex, result.newNode, result.extraNode);
        int newLength = newChildren.length;
        if (newLength <= 18) {
            return BtreeInsertResult.createInPlace(new BtreeBranchNode(newChildren, this.valueCount + sizeDelta));
        }
        int breakPoint = breakLeft ? 9 : newLength - 9;
        return BtreeInsertResult.createSplit(new BtreeBranchNode(ArrayHelper.subArray(this, newChildren, 0, breakPoint)), new BtreeBranchNode(ArrayHelper.subArray(this, newChildren, breakPoint, newLength)));
    }

    private Location<T> findIndexForGetAssign(int index) {
        int childIndex = 0;
        for (BtreeNode<T> child : this.children) {
            if (child.containsIndex(index)) {
                return new Location(child, childIndex, index);
            }
            ++childIndex;
            index -= child.valueCount();
        }
        throw new IndexOutOfBoundsException();
    }

    private Location<T> findIndexForInsertAppend(int index) {
        if (index == 0) {
            return new Location(this.children[0], 0, 0);
        }
        if (index == this.valueCount) {
            int lastIndex = this.children.length - 1;
            BtreeNode<T> lastChild = this.children[lastIndex];
            return new Location(lastChild, lastIndex, lastChild.valueCount());
        }
        return this.findIndexForGetAssign(index);
    }

    private static <T> int countValues(BtreeNode<T>[] children) {
        int answer = 0;
        for (BtreeNode<T> child : children) {
            answer += child.valueCount();
        }
        return answer;
    }

    private static class Location<T> {
        private final BtreeNode<T> child;
        private final int childIndex;
        private final int logicalIndex;

        private Location(BtreeNode<T> child, int childIndex, int logicalIndex) {
            this.child = child;
            this.childIndex = childIndex;
            this.logicalIndex = logicalIndex;
        }
    }
}

