/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.array;

import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursorable;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.InvariantCheckable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterable;
import org.javimmutable.collections.array.EmptyTrieNode;
import org.javimmutable.collections.array.SingleBranchTrieNode;
import org.javimmutable.collections.common.MutableDelta;

@Immutable
public abstract class TrieNode<T>
implements Cursorable<JImmutableMap.Entry<Integer, T>>,
SplitableIterable<JImmutableMap.Entry<Integer, T>>,
InvariantCheckable {
    public static final int ROOT_SHIFT = 30;

    public abstract boolean isEmpty();

    public abstract T getValueOr(int var1, int var2, T var3);

    public abstract Holder<T> find(int var1, int var2);

    public abstract TrieNode<T> assign(int var1, int var2, T var3, MutableDelta var4);

    public abstract TrieNode<T> delete(int var1, int var2, MutableDelta var3);

    public abstract int getShift();

    public abstract boolean isLeaf();

    public TrieNode<T> trimmedToMinimumDepth() {
        return this;
    }

    public TrieNode<T> paddedToMinimumDepthForShift(int shift) {
        SingleBranchTrieNode node = this;
        int nodeShift = ((TrieNode)node).getShift();
        while (nodeShift < shift) {
            node = SingleBranchTrieNode.forBranchIndex(nodeShift += 5, 0, node);
        }
        return node;
    }

    public static <T> TrieNode<T> of() {
        return EmptyTrieNode.instance();
    }

    public static int shiftForIndex(int index) {
        switch (Integer.numberOfLeadingZeros(index)) {
            case 0: 
            case 1: {
                return 30;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return 25;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return 20;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return 15;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return 10;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return 5;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }
}

