/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.array;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.javimmutable.collections.array.EmptyTrieNode;
import org.javimmutable.collections.array.FullBranchTrieNode;
import org.javimmutable.collections.array.LeafTrieNode;
import org.javimmutable.collections.array.MultiBranchTrieNode;
import org.javimmutable.collections.array.SingleBranchTrieNode;
import org.javimmutable.collections.array.TrieNode;

class TrieArrayBuilder<T> {
    private final LeafBuilder<T> leafBuilder = new LeafBuilder();

    TrieArrayBuilder() {
    }

    synchronized int size() {
        return ((LeafBuilder)this.leafBuilder).index;
    }

    synchronized void add(T value) {
        ((LeafBuilder)this.leafBuilder).add(value);
    }

    @Nonnull
    synchronized TrieNode<T> build() {
        return ((LeafBuilder)this.leafBuilder).build();
    }

    private static <T> TrieNode<T> branchForBuild(@Nonnull TrieNode<T>[] nodes, int length, int shift) {
        TrieNode branch;
        switch (length) {
            case 0: {
                branch = null;
                break;
            }
            case 1: {
                branch = SingleBranchTrieNode.forBranchIndex(shift, 0, nodes[0]);
                break;
            }
            case 32: {
                branch = new FullBranchTrieNode(shift, (TrieNode[])nodes.clone());
                break;
            }
            default: {
                branch = MultiBranchTrieNode.forEntries(shift, nodes, length);
            }
        }
        return branch;
    }

    private static <T> TrieNode<T> resultForBuild(@Nullable BranchBuilder<T> next, @Nullable TrieNode<T> node) {
        if (next != null) {
            return ((BranchBuilder)next).build(node);
        }
        if (node == null) {
            return EmptyTrieNode.of();
        }
        return node;
    }

    private static class BranchBuilder<T> {
        private final TrieNode<T>[] nodes = new TrieNode[32];
        private final int shift;
        private int offset;
        private BranchBuilder<T> next;

        private BranchBuilder(int shift) {
            this.shift = shift;
        }

        private void add(TrieNode<T> node) {
            this.nodes[this.offset] = node;
            ++this.offset;
            if (this.offset == 32) {
                this.push();
            }
        }

        private void push() {
            assert (this.offset == 32);
            FullBranchTrieNode branch = new FullBranchTrieNode(this.shift, (TrieNode[])this.nodes.clone());
            if (this.next == null) {
                this.next = new BranchBuilder<T>(this.shift + 5);
            }
            super.add(branch);
            this.offset = 0;
        }

        private TrieNode<T> build(@Nullable TrieNode<T> extra) {
            int length;
            assert (this.offset < 32);
            if (extra != null) {
                this.nodes[this.offset] = extra;
                length = this.offset + 1;
            } else {
                length = this.offset;
            }
            TrieNode node = TrieArrayBuilder.branchForBuild(this.nodes, length, this.shift);
            return TrieArrayBuilder.resultForBuild(this.next, node);
        }
    }

    private static class LeafBuilder<T> {
        private final TrieNode<T>[] leaves = new LeafTrieNode[32];
        private int offset;
        private int index;
        private BranchBuilder<T> next;

        private LeafBuilder() {
        }

        private void add(T value) {
            this.leaves[this.offset] = LeafTrieNode.of(this.index, value);
            ++this.index;
            ++this.offset;
            if (this.offset == 32) {
                this.push();
            }
        }

        private void push() {
            assert (this.offset == 32);
            FullBranchTrieNode branch = new FullBranchTrieNode(0, (TrieNode[])this.leaves.clone());
            if (this.next == null) {
                this.next = new BranchBuilder(5);
            }
            ((BranchBuilder)this.next).add(branch);
            this.offset = 0;
        }

        private TrieNode<T> build() {
            assert (this.offset < 32);
            TrieNode node = TrieArrayBuilder.branchForBuild(this.leaves, this.offset, 0);
            return TrieArrayBuilder.resultForBuild(this.next, node);
        }
    }
}

