/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.array;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.array.MultiBranchTrieNode;
import org.javimmutable.collections.array.TrieNode;
import org.javimmutable.collections.common.MutableDelta;

@Immutable
public class SingleBranchTrieNode<T>
extends TrieNode<T> {
    private final int shift;
    private final int branchIndex;
    private final TrieNode<T> child;

    private SingleBranchTrieNode(int shift, int branchIndex, TrieNode<T> child) {
        assert (shift >= 0);
        this.shift = shift;
        this.branchIndex = branchIndex;
        this.child = child;
    }

    static <T> SingleBranchTrieNode<T> forIndex(int shift, int index, TrieNode<T> child) {
        int branchIndex = index >>> shift & 0x1F;
        return new SingleBranchTrieNode<T>(shift, branchIndex, child);
    }

    static <T> SingleBranchTrieNode<T> forBranchIndex(int shift, int branchIndex, TrieNode<T> child) {
        return new SingleBranchTrieNode<T>(shift, branchIndex, child);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public T getValueOr(int shift, int index, T defaultValue) {
        assert (this.shift == shift);
        int branchIndex = index >>> shift & 0x1F;
        return this.branchIndex == branchIndex ? this.child.getValueOr(shift - 5, index, defaultValue) : defaultValue;
    }

    @Override
    public Holder<T> find(int shift, int index) {
        assert (this.shift == shift);
        int branchIndex = index >>> shift & 0x1F;
        return this.branchIndex == branchIndex ? this.child.find(shift - 5, index) : Holders.of();
    }

    @Override
    public TrieNode<T> assign(int shift, int index, T value, MutableDelta sizeDelta) {
        assert (this.shift == shift);
        int branchIndex = index >>> shift & 0x1F;
        if (this.branchIndex == branchIndex) {
            TrieNode<T> newChild = this.child.assign(shift - 5, index, value, sizeDelta);
            return this.selectNodeForUpdateResult(shift, branchIndex, newChild);
        }
        return MultiBranchTrieNode.forBranchIndex(shift, this.branchIndex, this.child).assign(shift, index, value, sizeDelta);
    }

    @Override
    public TrieNode<T> delete(int shift, int index, MutableDelta sizeDelta) {
        assert (this.shift == shift);
        int branchIndex = index >>> shift & 0x1F;
        if (this.branchIndex != branchIndex) {
            return this;
        }
        TrieNode<T> newChild = this.child.delete(shift - 5, index, sizeDelta);
        return this.selectNodeForDeleteResult(shift, branchIndex, newChild);
    }

    @Override
    public int getShift() {
        return this.shift;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public TrieNode<T> trimmedToMinimumDepth() {
        return this.branchIndex == 0 ? this.child.trimmedToMinimumDepth() : this;
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<Integer, T>> iterator() {
        return this.child.iterator();
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<Integer, T>> cursor() {
        return this.child.cursor();
    }

    @Override
    public void checkInvariants() {
        if (this.shift < 0 || this.shift > 30) {
            throw new IllegalStateException("illegal shift value: " + this.shift);
        }
        if (this.branchIndex < 0 || this.branchIndex >= 32) {
            throw new IllegalStateException("illegal branchIndex value: " + this.branchIndex);
        }
        this.child.checkInvariants();
    }

    int getBranchIndex() {
        return this.branchIndex;
    }

    TrieNode<T> getChild() {
        return this.child;
    }

    private TrieNode<T> selectNodeForUpdateResult(int shift, int branchIndex, TrieNode<T> newChild) {
        assert (newChild.isLeaf() || newChild.getShift() == shift - 5);
        return newChild == this.child ? this : new SingleBranchTrieNode<T>(shift, branchIndex, newChild);
    }

    private TrieNode<T> selectNodeForDeleteResult(int shift, int branchIndex, TrieNode<T> newChild) {
        if (newChild == this.child) {
            return this;
        }
        if (newChild.isEmpty()) {
            return SingleBranchTrieNode.of();
        }
        if (newChild.isLeaf()) {
            return newChild;
        }
        assert (newChild.getShift() == shift - 5);
        return new SingleBranchTrieNode<T>(shift, branchIndex, newChild);
    }
}

