/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.array;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.array.FullBranchTrieNode;
import org.javimmutable.collections.array.LeafTrieNode;
import org.javimmutable.collections.array.SingleBranchTrieNode;
import org.javimmutable.collections.array.TrieNode;
import org.javimmutable.collections.common.MutableDelta;
import org.javimmutable.collections.cursors.LazyMultiCursor;
import org.javimmutable.collections.indexed.IndexedArray;
import org.javimmutable.collections.iterators.LazyMultiIterator;

@Immutable
public class MultiBranchTrieNode<T>
extends TrieNode<T> {
    private final int shift;
    private final int bitmask;
    @Nonnull
    private final TrieNode<T>[] entries;

    private MultiBranchTrieNode(int shift, int bitmask, @Nonnull TrieNode<T>[] entries) {
        assert (shift >= 0);
        this.shift = shift;
        this.bitmask = bitmask;
        this.entries = entries;
    }

    static <T> MultiBranchTrieNode<T> forTesting(int shift) {
        TrieNode<T>[] entries = MultiBranchTrieNode.allocate(0);
        return new MultiBranchTrieNode<T>(shift, 0, entries);
    }

    static <T> MultiBranchTrieNode<T> forIndex(int shift, int index, @Nonnull TrieNode<T> child) {
        int branchIndex = index >>> shift & 0x1F;
        return MultiBranchTrieNode.forBranchIndex(shift, branchIndex, child);
    }

    static <T> MultiBranchTrieNode<T> forBranchIndex(int shift, int branchIndex, @Nonnull TrieNode<T> child) {
        assert (branchIndex >= 0 && branchIndex < 32);
        TrieNode<T>[] entries = MultiBranchTrieNode.allocate(1);
        entries[0] = child;
        return new MultiBranchTrieNode<T>(shift, 1 << branchIndex, entries);
    }

    static <T> MultiBranchTrieNode<T> forEntries(int shift, @Nonnull TrieNode<T>[] entries) {
        int length = entries.length;
        int bitmask = length == 32 ? -1 : (1 << length) - 1;
        return new MultiBranchTrieNode<T>(shift, bitmask, (TrieNode[])entries.clone());
    }

    static <T> MultiBranchTrieNode<T> forEntries(int shift, @Nonnull TrieNode<T>[] entries, int length) {
        int bitmask = length == 32 ? -1 : (1 << length) - 1;
        TrieNode<T>[] ourEntries = MultiBranchTrieNode.allocate(length);
        System.arraycopy(entries, 0, ourEntries, 0, length);
        return new MultiBranchTrieNode<T>(shift, bitmask, ourEntries);
    }

    static <T> MultiBranchTrieNode<T> forSource(int index, int size, @Nonnull Indexed<? extends T> source, int offset) {
        TrieNode<T>[] entries = MultiBranchTrieNode.allocate(size);
        for (int i = 0; i < size; ++i) {
            entries[i] = LeafTrieNode.of(index++, source.get(offset++));
        }
        int bitmask = size == 32 ? -1 : (1 << size) - 1;
        return new MultiBranchTrieNode<T>(0, bitmask, entries);
    }

    static <T> MultiBranchTrieNode<T> fullWithout(int shift, @Nonnull TrieNode<T>[] entries, int withoutIndex) {
        assert (entries.length == 32);
        TrieNode<T>[] newEntries = MultiBranchTrieNode.allocate(31);
        System.arraycopy(entries, 0, newEntries, 0, withoutIndex);
        System.arraycopy(entries, withoutIndex + 1, newEntries, withoutIndex, 31 - withoutIndex);
        int newMask = ~(1 << withoutIndex);
        return new MultiBranchTrieNode<T>(shift, newMask, newEntries);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.length == 0;
    }

    @Override
    public T getValueOr(int shift, int index, T defaultValue) {
        assert (this.shift == shift);
        int bitmask = this.bitmask;
        int bit = 1 << (index >>> shift & 0x1F);
        if ((bitmask & bit) == 0) {
            return defaultValue;
        }
        int childIndex = MultiBranchTrieNode.realIndex(bitmask, bit);
        return this.entries[childIndex].getValueOr(shift - 5, index, defaultValue);
    }

    @Override
    public Holder<T> find(int shift, int index) {
        assert (this.shift == shift);
        int bitmask = this.bitmask;
        int bit = 1 << (index >>> shift & 0x1F);
        if ((bitmask & bit) == 0) {
            return Holders.of();
        }
        int childIndex = MultiBranchTrieNode.realIndex(bitmask, bit);
        return this.entries[childIndex].find(shift - 5, index);
    }

    @Override
    public TrieNode<T> assign(int shift, int index, T value, MutableDelta sizeDelta) {
        assert (this.shift == shift);
        int bit = 1 << (index >>> shift & 0x1F);
        int bitmask = this.bitmask;
        int childIndex = MultiBranchTrieNode.realIndex(bitmask, bit);
        TrieNode<T>[] entries = this.entries;
        if ((bitmask & bit) == 0) {
            LeafTrieNode<T> newChild = LeafTrieNode.of(index, value);
            sizeDelta.add(1);
            return this.selectNodeForInsertResult(shift, bit, bitmask, childIndex, entries, newChild);
        }
        TrieNode<T> child = entries[childIndex];
        TrieNode<T> newChild = child.assign(shift - 5, index, value, sizeDelta);
        return this.selectNodeForUpdateResult(shift, bitmask, childIndex, entries, child, newChild);
    }

    @Override
    public TrieNode<T> delete(int shift, int index, MutableDelta sizeDelta) {
        assert (this.shift == shift);
        int bit = 1 << (index >>> shift & 0x1F);
        int bitmask = this.bitmask;
        TrieNode<T>[] entries = this.entries;
        if ((bitmask & bit) == 0) {
            return this;
        }
        int childIndex = MultiBranchTrieNode.realIndex(bitmask, bit);
        TrieNode<T> child = entries[childIndex];
        TrieNode<T> newChild = child.delete(shift - 5, index, sizeDelta);
        return this.selectNodeForDeleteResult(shift, bit, bitmask, entries, childIndex, child, newChild);
    }

    @Override
    public int getShift() {
        return this.shift;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public TrieNode<T> trimmedToMinimumDepth() {
        return this.bitmask == 1 ? this.entries[0].trimmedToMinimumDepth() : this;
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<Integer, T>> cursor() {
        if (this.shift != 30) {
            return LazyMultiCursor.cursor(IndexedArray.retained(this.entries));
        }
        return LazyMultiCursor.cursor(IndexedArray.retained(this.entriesForSignedOrderIteration()));
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<Integer, T>> iterator() {
        if (this.shift != 30) {
            return LazyMultiIterator.iterator(IndexedArray.retained(this.entries));
        }
        return LazyMultiIterator.iterator(IndexedArray.retained(this.entriesForSignedOrderIteration()));
    }

    @Override
    public void checkInvariants() {
        if (this.shift < 0 || this.shift > 30) {
            throw new IllegalStateException("illegal shift value: " + this.shift);
        }
        if (this.entries.length != Integer.bitCount(this.bitmask)) {
            throw new IllegalStateException("unexpected entries size: expected=" + Integer.bitCount(this.bitmask) + " actual=" + this.entries.length);
        }
        for (TrieNode<T> entry : this.entries) {
            entry.checkInvariants();
        }
    }

    int getBitmask() {
        return this.bitmask;
    }

    TrieNode<T>[] getEntries() {
        return (TrieNode[])this.entries.clone();
    }

    private TrieNode<T> selectNodeForUpdateResult(int shift, int bitmask, int childIndex, TrieNode<T>[] entries, TrieNode<T> child, TrieNode<T> newChild) {
        if (newChild == child) {
            return this;
        }
        assert (newChild.isLeaf() || newChild.getShift() == shift - 5);
        TrieNode[] newEntries = (TrieNode[])entries.clone();
        newEntries[childIndex] = newChild;
        return new MultiBranchTrieNode<T>(shift, bitmask, newEntries);
    }

    private TrieNode<T> selectNodeForInsertResult(int shift, int bit, int bitmask, int childIndex, TrieNode<T>[] entries, TrieNode<T> newChild) {
        int oldLength = entries.length;
        TrieNode<T>[] newEntries = MultiBranchTrieNode.allocate(oldLength + 1);
        if (bitmask != 0) {
            System.arraycopy(entries, 0, newEntries, 0, childIndex);
            System.arraycopy(entries, childIndex, newEntries, childIndex + 1, oldLength - childIndex);
        }
        newEntries[childIndex] = newChild;
        if (newEntries.length == 32) {
            return new FullBranchTrieNode<T>(shift, newEntries);
        }
        return new MultiBranchTrieNode<T>(shift, bitmask | bit, newEntries);
    }

    private TrieNode<T> selectNodeForDeleteResult(int shift, int bit, int bitmask, TrieNode<T>[] entries, int childIndex, TrieNode<T> child, TrieNode<T> newChild) {
        if (newChild.isEmpty()) {
            switch (entries.length) {
                case 1: {
                    return MultiBranchTrieNode.of();
                }
                case 2: {
                    int newBitmask = bitmask & ~bit;
                    int remainingIndex = Integer.numberOfTrailingZeros(newBitmask);
                    TrieNode<T> remainingChild = entries[MultiBranchTrieNode.realIndex(bitmask, 1 << remainingIndex)];
                    if (remainingChild.isLeaf()) {
                        return remainingChild;
                    }
                    return SingleBranchTrieNode.forBranchIndex(shift, remainingIndex, remainingChild);
                }
            }
            int newLength = entries.length - 1;
            TrieNode<T>[] newArray = MultiBranchTrieNode.allocate(newLength);
            System.arraycopy(entries, 0, newArray, 0, childIndex);
            System.arraycopy(entries, childIndex + 1, newArray, childIndex, newLength - childIndex);
            return new MultiBranchTrieNode<T>(shift, bitmask & ~bit, newArray);
        }
        return this.selectNodeForUpdateResult(shift, bitmask, childIndex, entries, child, newChild);
    }

    private TrieNode<T>[] entriesForSignedOrderIteration() {
        TrieNode<T>[] entries = this.entries;
        TrieNode<T>[] nodes = MultiBranchTrieNode.allocate(entries.length);
        int bitmask = this.bitmask;
        int offset = 0;
        if ((bitmask & 4) != 0) {
            nodes[offset++] = entries[MultiBranchTrieNode.realIndex(bitmask, 4)];
        }
        if ((bitmask & 8) != 0) {
            nodes[offset++] = entries[MultiBranchTrieNode.realIndex(bitmask, 8)];
        }
        if ((bitmask & 1) != 0) {
            nodes[offset++] = entries[MultiBranchTrieNode.realIndex(bitmask, 1)];
        }
        if ((bitmask & 2) != 0) {
            nodes[offset++] = entries[MultiBranchTrieNode.realIndex(bitmask, 2)];
        }
        assert (offset == nodes.length);
        return nodes;
    }

    private static int realIndex(int bitmask, int bit) {
        return Integer.bitCount(bitmask & bit - 1);
    }

    static <T> TrieNode<T>[] allocate(int size) {
        return new TrieNode[size];
    }
}

