/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.array;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.array.SingleBranchTrieNode;
import org.javimmutable.collections.array.TrieNode;
import org.javimmutable.collections.common.MutableDelta;
import org.javimmutable.collections.cursors.SingleValueCursor;
import org.javimmutable.collections.iterators.SingleValueIterator;

@Immutable
public class LeafTrieNode<T>
extends TrieNode<T>
implements JImmutableMap.Entry<Integer, T>,
Holders.Filled<T> {
    private final int index;
    private final T value;
    private final int shift;

    private LeafTrieNode(int index, T value, int shift) {
        this.index = index;
        this.value = value;
        this.shift = shift;
    }

    static <T> LeafTrieNode<T> of(int index, @Nonnull T value) {
        return new LeafTrieNode<T>(index, value, LeafTrieNode.shiftForIndex(index));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @Nonnull
    public Integer getKey() {
        return this.index;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public T getValueOr(int shift, int index, T defaultValue) {
        assert (shift >= -5);
        return this.index == index ? this.value : defaultValue;
    }

    @Override
    public Holder<T> find(int shift, int index) {
        assert (shift >= -5);
        return this.index == index ? this : Holders.of();
    }

    @Override
    public TrieNode<T> assign(int shift, int index, T value, MutableDelta sizeDelta) {
        assert (shift >= -5);
        if (this.index == index) {
            if (this.value == value) {
                return this;
            }
            return this.withValue(value);
        }
        assert (shift >= 0);
        return SingleBranchTrieNode.forIndex(shift, this.index, this).assign(shift, index, value, sizeDelta);
    }

    @Override
    public TrieNode<T> delete(int shift, int index, MutableDelta sizeDelta) {
        assert (shift >= -5);
        if (this.index == index) {
            sizeDelta.subtract(1);
            return LeafTrieNode.of();
        }
        return this;
    }

    @Override
    public int getShift() {
        return this.shift;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public TrieNode<T> paddedToMinimumDepthForShift(int shift) {
        if (this.shift >= shift) {
            return this;
        }
        return SingleBranchTrieNode.forIndex(shift, this.index, this);
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<Integer, T>> iterator() {
        return SingleValueIterator.of(this);
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<Integer, T>> cursor() {
        return SingleValueCursor.of(this);
    }

    @Override
    public void checkInvariants() {
        if (this.shift < -5 || this.shift > 30) {
            throw new IllegalStateException("illegal shift value: " + this.shift);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeafTrieNode that = (LeafTrieNode)o;
        if (this.index != that.index) {
            return false;
        }
        if (this.shift != that.shift) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.index;
        result = 31 * result + this.value.hashCode();
        result = 31 * result + this.shift;
        return result;
    }

    public String toString() {
        return MapEntry.makeToString(this);
    }

    private TrieNode<T> withValue(T newValue) {
        return new LeafTrieNode<T>(this.index, newValue, this.shift);
    }
}

