/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.array;

import java.io.Serializable;
import java.util.Iterator;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.JImmutableArray;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.array.TrieArrayBuilder;
import org.javimmutable.collections.array.TrieNode;
import org.javimmutable.collections.common.AbstractJImmutableArray;
import org.javimmutable.collections.common.MutableDelta;
import org.javimmutable.collections.iterators.IteratorHelper;
import org.javimmutable.collections.iterators.TransformIterator;
import org.javimmutable.collections.serialization.JImmutableArrayProxy;

@Immutable
public class JImmutableTrieArray<T>
extends AbstractJImmutableArray<T>
implements Serializable {
    private static final JImmutableTrieArray EMPTY = new JImmutableTrieArray(TrieNode.of(), 0);
    private static final long serialVersionUID = -121805L;
    private final TrieNode<T> root;
    private final int size;

    private JImmutableTrieArray(TrieNode<T> root, int size) {
        this.root = root;
        this.size = size;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Nonnull
    public static <T> Collector<T, ?, JImmutableArray<T>> collector() {
        return Collector.of(() -> new Builder(), (b, v) -> b.add(v), (b1, b2) -> (Builder)b1.add(((Builder)b2).iterator()), b -> b.build(), new Collector.Characteristics[0]);
    }

    public static <T> JImmutableTrieArray<T> of() {
        return EMPTY;
    }

    @Deprecated
    public static <T> JImmutableArray<T> of(Indexed<? extends T> source, int offset, int limit) {
        return (JImmutableArray)JImmutableTrieArray.builder().add(source, offset, limit).build();
    }

    @Override
    @Nullable
    public T getValueOr(int index, @Nullable T defaultValue) {
        if (this.root.getShift() < TrieNode.shiftForIndex(index)) {
            return defaultValue;
        }
        return this.root.getValueOr(this.root.getShift(), index, defaultValue);
    }

    @Override
    @Nonnull
    public Holder<T> find(int index) {
        if (this.root.getShift() < TrieNode.shiftForIndex(index)) {
            return Holders.of();
        }
        return this.root.find(this.root.getShift(), index);
    }

    @Override
    @Nonnull
    public JImmutableTrieArray<T> assign(int index, @Nullable T value) {
        MutableDelta sizeDelta = new MutableDelta();
        TrieNode<T> newRoot = this.root.paddedToMinimumDepthForShift(TrieNode.shiftForIndex(index));
        return (newRoot = newRoot.assign(newRoot.getShift(), index, value, sizeDelta)) == this.root ? this : new JImmutableTrieArray<T>(newRoot, this.size + sizeDelta.getValue());
    }

    @Override
    @Nonnull
    public JImmutableTrieArray<T> delete(int index) {
        if (this.root.getShift() < TrieNode.shiftForIndex(index)) {
            return this;
        }
        MutableDelta sizeDelta = new MutableDelta();
        TrieNode<T> newRoot = this.root.delete(this.root.getShift(), index, sizeDelta).trimmedToMinimumDepth();
        return newRoot == this.root ? this : new JImmutableTrieArray<T>(newRoot, this.size + sizeDelta.getValue());
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @Nonnull
    public JImmutableTrieArray<T> deleteAll() {
        return JImmutableTrieArray.of();
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<Integer, T>> cursor() {
        return this.root.cursor();
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<Integer, T>> iterator() {
        return this.root.iterator();
    }

    @Override
    public void checkInvariants() {
        this.root.checkInvariants();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof JImmutableArray && IteratorHelper.iteratorEquals(this.iterator(), ((JImmutableArray)o).iterator());
    }

    public int hashCode() {
        return IteratorHelper.iteratorHashCode(this.iterator());
    }

    public String toString() {
        return IteratorHelper.iteratorToString(this.iterator());
    }

    private Object writeReplace() {
        return new JImmutableArrayProxy(this);
    }

    public static class Builder<T>
    implements JImmutableArray.Builder<T> {
        private final TrieArrayBuilder<T> builder = new TrieArrayBuilder();

        private Builder() {
        }

        @Override
        public int size() {
            return this.builder.size();
        }

        @Nonnull
        public Builder<T> add(T value) {
            this.builder.add(value);
            return this;
        }

        @Override
        @Nonnull
        public JImmutableTrieArray<T> build() {
            return this.builder.size() == 0 ? JImmutableTrieArray.of() : new JImmutableTrieArray(this.builder.build(), this.builder.size());
        }

        @Nonnull
        private Iterator<T> iterator() {
            return TransformIterator.of(this.builder.build().iterator(), e -> e.getValue());
        }
    }
}

