/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.array;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.array.LeafTrieNode;
import org.javimmutable.collections.array.MultiBranchTrieNode;
import org.javimmutable.collections.array.TrieNode;
import org.javimmutable.collections.common.MutableDelta;
import org.javimmutable.collections.cursors.LazyMultiCursor;
import org.javimmutable.collections.indexed.IndexedArray;
import org.javimmutable.collections.iterators.LazyMultiIterator;

@Immutable
public class FullBranchTrieNode<T>
extends TrieNode<T> {
    private final int shift;
    private final TrieNode<T>[] entries;

    FullBranchTrieNode(int shift, TrieNode<T>[] entries) {
        assert (shift != 30);
        this.shift = shift;
        this.entries = entries;
    }

    static <T> FullBranchTrieNode<T> fromSource(int index, Indexed<? extends T> source, int offset) {
        assert (source.size() - offset >= 32);
        TrieNode<T>[] entries = MultiBranchTrieNode.allocate(32);
        for (int i = 0; i < 32; ++i) {
            entries[i] = LeafTrieNode.of(index++, source.get(offset++));
        }
        return new FullBranchTrieNode(0, entries);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public T getValueOr(int shift, int index, T defaultValue) {
        assert (this.shift == shift);
        int childIndex = index >>> shift & 0x1F;
        return this.entries[childIndex].getValueOr(shift - 5, index, defaultValue);
    }

    @Override
    public Holder<T> find(int shift, int index) {
        assert (this.shift == shift);
        int childIndex = index >>> shift & 0x1F;
        return this.entries[childIndex].find(shift - 5, index);
    }

    @Override
    public TrieNode<T> assign(int shift, int index, T value, MutableDelta sizeDelta) {
        assert (this.shift == shift);
        int childIndex = index >>> shift & 0x1F;
        TrieNode<T> child = this.entries[childIndex];
        TrieNode<T> newChild = child.assign(shift - 5, index, value, sizeDelta);
        if (newChild == child) {
            return this;
        }
        return this.createUpdatedEntries(shift, childIndex, newChild);
    }

    @Override
    public TrieNode<T> delete(int shift, int index, MutableDelta sizeDelta) {
        assert (this.shift == shift);
        int childIndex = index >>> shift & 0x1F;
        TrieNode<T> child = this.entries[childIndex];
        TrieNode<T> newChild = child.delete(shift - 5, index, sizeDelta);
        return this.createDeleteResultNode(shift, childIndex, child, newChild);
    }

    @Override
    public int getShift() {
        return this.shift;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<Integer, T>> iterator() {
        return LazyMultiIterator.iterator(IndexedArray.retained(this.entries));
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<Integer, T>> cursor() {
        return LazyMultiCursor.cursor(IndexedArray.retained(this.entries));
    }

    @Override
    public void checkInvariants() {
        if (this.shift < 0 || this.shift > 30) {
            throw new IllegalStateException("illegal shift value: " + this.shift);
        }
        if (this.entries.length != 32) {
            throw new IllegalStateException("unexpected entries size: expected=32 actual=" + this.entries.length);
        }
        for (TrieNode<T> entry : this.entries) {
            entry.checkInvariants();
        }
    }

    private TrieNode<T> createUpdatedEntries(int shift, int childIndex, TrieNode<T> newChild) {
        assert (newChild.isLeaf() || newChild.getShift() == shift - 5);
        TrieNode[] newEntries = (TrieNode[])this.entries.clone();
        newEntries[childIndex] = newChild;
        return new FullBranchTrieNode<T>(shift, newEntries);
    }

    private TrieNode<T> createDeleteResultNode(int shift, int childIndex, TrieNode<T> child, TrieNode<T> newChild) {
        if (newChild == child) {
            return this;
        }
        if (newChild.isEmpty()) {
            return MultiBranchTrieNode.fullWithout(shift, this.entries, childIndex);
        }
        return this.createUpdatedEntries(shift, childIndex, newChild);
    }
}

