/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.array;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.array.LeafTrieNode;
import org.javimmutable.collections.array.TrieNode;
import org.javimmutable.collections.common.MutableDelta;
import org.javimmutable.collections.cursors.StandardCursor;
import org.javimmutable.collections.iterators.EmptyIterator;

@Immutable
public class EmptyTrieNode<T>
extends TrieNode<T> {
    private static final EmptyTrieNode EMPTY = new EmptyTrieNode();

    static <T> EmptyTrieNode<T> instance() {
        return EMPTY;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public T getValueOr(int shift, int index, T defaultValue) {
        return defaultValue;
    }

    @Override
    public Holder<T> find(int shift, int index) {
        return Holders.of();
    }

    @Override
    public TrieNode<T> assign(int shift, int index, T value, MutableDelta sizeDelta) {
        sizeDelta.add(1);
        return LeafTrieNode.of(index, value);
    }

    @Override
    public TrieNode<T> delete(int shift, int index, MutableDelta sizeDelta) {
        return this;
    }

    @Override
    public int getShift() {
        return 0;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public TrieNode<T> paddedToMinimumDepthForShift(int shift) {
        return this;
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<Integer, T>> cursor() {
        return StandardCursor.of();
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<Integer, T>> iterator() {
        return EmptyIterator.of();
    }

    @Override
    public void checkInvariants() {
    }
}

