/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Indexed;

public interface MutableBuilder<T, C> {
    public int size();

    @Nonnull
    public MutableBuilder<T, C> add(T var1);

    @Nonnull
    public C build();

    @Nonnull
    default public MutableBuilder<T, C> add(Cursor<? extends T> source) {
        Cursor<T> cursor = source.start();
        while (cursor.hasValue()) {
            this.add(cursor.getValue());
            cursor = cursor.next();
        }
        return this;
    }

    @Nonnull
    default public MutableBuilder<T, C> add(Iterator<? extends T> source) {
        while (source.hasNext()) {
            this.add(source.next());
        }
        return this;
    }

    @Nonnull
    default public MutableBuilder<T, C> add(Iterable<? extends T> source) {
        return this.add(source.iterator());
    }

    @Nonnull
    default public <K extends T> MutableBuilder<T, C> add(K ... source) {
        return this.add((Iterable<? extends T>)Arrays.asList(source));
    }

    @Nonnull
    default public MutableBuilder<T, C> add(Indexed<? extends T> source, int offset, int limit) {
        for (int i = offset; i < limit; ++i) {
            this.add(source.get(i));
        }
        return this;
    }

    @Nonnull
    default public MutableBuilder<T, C> add(Indexed<? extends T> source) {
        return this.add(source, 0, source.size());
    }
}

