/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.JImmutableMap;

@Immutable
public class MapEntry<K, V>
implements JImmutableMap.Entry<K, V>,
Map.Entry<K, V> {
    @Nonnull
    protected final K key;
    protected final V value;

    public MapEntry(@Nonnull Map.Entry<K, V> entry) {
        this(entry.getKey(), entry.getValue());
    }

    public MapEntry(@Nonnull JImmutableMap.Entry<K, V> entry) {
        this(entry.getKey(), entry.getValue());
    }

    public MapEntry(@Nonnull K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Nonnull
    public static <K, V> MapEntry<K, V> of(@Nonnull Map.Entry<K, V> entry) {
        return new MapEntry<K, V>(entry);
    }

    @Nonnull
    public static <K, V> MapEntry<K, V> of(@Nonnull JImmutableMap.Entry<K, V> entry) {
        return new MapEntry<K, V>(entry);
    }

    @Nonnull
    public static <K, V> MapEntry<K, V> of(@Nonnull K key, V value) {
        return new MapEntry<K, V>(key, value);
    }

    @Override
    @Nonnull
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V v) {
        throw new UnsupportedOperationException();
    }

    public JImmutableMap.Entry<K, V> jimmutableEntry() {
        return this;
    }

    public Map.Entry<K, V> javaEntry() {
        return this;
    }

    @Override
    public int hashCode() {
        return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof JImmutableMap.Entry) {
            JImmutableMap.Entry jentry = (JImmutableMap.Entry)o;
            return (this.key == null ? jentry.getKey() == null : this.key.equals(jentry.getKey())) && (this.value == null ? jentry.getValue() == null : this.value.equals(jentry.getValue()));
        }
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry2 = (Map.Entry)o;
        return (this.key == null ? entry2.getKey() == null : this.key.equals(entry2.getKey())) && (this.value == null ? entry2.getValue() == null : this.value.equals(entry2.getValue()));
    }

    public String toString() {
        return MapEntry.makeToString(this);
    }

    private static void addToString(StringBuilder sb, Object obj) {
        if (obj == null) {
            sb.append("null");
        } else {
            sb.append(obj);
        }
    }

    public static String makeToString(JImmutableMap.Entry entry) {
        StringBuilder sb = new StringBuilder();
        MapEntry.addToString(sb, entry);
        return sb.toString();
    }

    public static void addToString(StringBuilder sb, JImmutableMap.Entry entry) {
        MapEntry.addToString(sb, entry.getKey());
        sb.append("=");
        MapEntry.addToString(sb, entry.getValue());
    }

    public static <K, V> List<Map.Entry<K, V>> toMutableEntries(@Nonnull Collection<JImmutableMap.Entry<K, V>> source) {
        return source.stream().map(e -> MapEntry.of(e)).collect(Collectors.toList());
    }

    public static <K, V> List<JImmutableMap.Entry<K, V>> toImmutableEntries(@Nonnull Collection<Map.Entry<K, V>> source) {
        return source.stream().map(e -> MapEntry.of(e)).collect(Collectors.toList());
    }
}

