/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Cursorable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.GenericCollector;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.InvariantCheckable;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.Mapped;

@Immutable
public interface JImmutableSet<T>
extends Insertable<T, JImmutableSet<T>>,
Cursorable<T>,
IterableStreamable<T>,
Mapped<T, T>,
InvariantCheckable {
    @Override
    @Nonnull
    public JImmutableSet<T> insert(@Nonnull T var1);

    @Override
    @Nonnull
    public JImmutableSet<T> insertAll(@Nonnull Iterable<? extends T> var1);

    @Override
    @Nonnull
    public JImmutableSet<T> insertAll(@Nonnull Cursor<? extends T> var1);

    @Override
    @Nonnull
    public JImmutableSet<T> insertAll(@Nonnull Iterator<? extends T> var1);

    public boolean contains(@Nullable T var1);

    public boolean containsAll(@Nonnull Iterable<? extends T> var1);

    public boolean containsAll(@Nonnull Cursor<? extends T> var1);

    public boolean containsAll(@Nonnull Iterator<? extends T> var1);

    public boolean containsAny(@Nonnull Iterable<? extends T> var1);

    public boolean containsAny(@Nonnull Cursor<? extends T> var1);

    public boolean containsAny(@Nonnull Iterator<? extends T> var1);

    @Nonnull
    public JImmutableSet<T> delete(T var1);

    @Nonnull
    public JImmutableSet<T> deleteAll(@Nonnull Iterable<? extends T> var1);

    @Nonnull
    public JImmutableSet<T> deleteAll(@Nonnull Cursor<? extends T> var1);

    @Nonnull
    public JImmutableSet<T> deleteAll(@Nonnull Iterator<? extends T> var1);

    @Nonnull
    public JImmutableSet<T> union(@Nonnull Iterable<? extends T> var1);

    @Nonnull
    public JImmutableSet<T> union(@Nonnull Cursor<? extends T> var1);

    @Nonnull
    public JImmutableSet<T> union(@Nonnull Iterator<? extends T> var1);

    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Iterable<? extends T> var1);

    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Cursor<? extends T> var1);

    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Iterator<? extends T> var1);

    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull JImmutableSet<? extends T> var1);

    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Set<? extends T> var1);

    public int size();

    public boolean isEmpty();

    @Nonnull
    public JImmutableSet<T> deleteAll();

    @Nonnull
    public Set<T> getSet();

    @Override
    @Nullable
    default public T get(T key) {
        return (T)(this.contains(key) ? key : null);
    }

    @Override
    default public T getValueOr(T key, T defaultValue) {
        return this.contains(key) ? key : defaultValue;
    }

    @Override
    @Nonnull
    default public Holder<T> find(T key) {
        return this.contains(key) ? Holders.of(key) : Holders.of();
    }

    default public <A> JImmutableSet<A> transform(@Nonnull Func1<T, A> transform) {
        return this.transform(this.deleteAll(), transform);
    }

    @Nonnull
    default public JImmutableSet<T> select(@Nonnull Predicate<T> predicate) {
        Insertable<T, JImmutableSet<T>> answer = this.deleteAll();
        for (Object value : this) {
            if (!predicate.test(value)) continue;
            answer = answer.insert(value);
        }
        return answer.size() == this.size() ? this : answer;
    }

    @Nonnull
    default public JImmutableSet<T> reject(@Nonnull Predicate<T> predicate) {
        JImmutableSet answer = this;
        for (Object value : this) {
            if (!predicate.test(value)) continue;
            answer = answer.delete(value);
        }
        return answer.size() == this.size() ? this : answer;
    }

    @Nonnull
    default public Collector<T, ?, JImmutableSet<T>> setCollector() {
        return GenericCollector.unordered(this, this.deleteAll(), a -> a.isEmpty(), (a, v) -> a.insert(v), (a, b) -> a.insertAll((Iterable)b));
    }
}

