/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.GenericCollector;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.JImmutableList;
import org.javimmutable.collections.MutableBuilder;

@Immutable
public interface JImmutableRandomAccessList<T>
extends JImmutableList<T> {
    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> assign(int var1, @Nullable T var2);

    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> insert(@Nullable T var1);

    @Override
    @Nonnull
    default public JImmutableRandomAccessList<T> insert(@Nonnull Iterable<? extends T> values) {
        return this.insertAll((Iterable)values);
    }

    @Nonnull
    public JImmutableRandomAccessList<T> insert(int var1, @Nullable T var2);

    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> insertFirst(@Nullable T var1);

    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> insertLast(@Nullable T var1);

    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> insertAll(@Nonnull Iterable<? extends T> var1);

    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> insertAll(@Nonnull Cursor<? extends T> var1);

    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> insertAll(@Nonnull Iterator<? extends T> var1);

    @Nonnull
    public JImmutableRandomAccessList<T> insertAll(int var1, @Nonnull Iterable<? extends T> var2);

    @Nonnull
    public JImmutableRandomAccessList<T> insertAll(int var1, @Nonnull Cursor<? extends T> var2);

    @Nonnull
    public JImmutableRandomAccessList<T> insertAll(int var1, @Nonnull Iterator<? extends T> var2);

    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> insertAllFirst(@Nonnull Iterable<? extends T> var1);

    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> insertAllFirst(@Nonnull Cursor<? extends T> var1);

    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> insertAllFirst(@Nonnull Iterator<? extends T> var1);

    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> insertAllLast(@Nonnull Iterable<? extends T> var1);

    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> insertAllLast(@Nonnull Cursor<? extends T> var1);

    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> insertAllLast(@Nonnull Iterator<? extends T> var1);

    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> deleteFirst();

    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> deleteLast();

    @Nonnull
    public JImmutableRandomAccessList<T> delete(int var1);

    @Override
    @Nonnull
    public JImmutableRandomAccessList<T> deleteAll();

    @Override
    @Nonnull
    default public JImmutableRandomAccessList<T> select(@Nonnull Predicate<T> predicate) {
        JImmutableList answer = this.deleteAll();
        for (Object value : this) {
            if (!predicate.test(value)) continue;
            answer = answer.insert(value);
        }
        return answer.size() == this.size() ? this : answer;
    }

    @Override
    @Nonnull
    default public JImmutableRandomAccessList<T> reject(@Nonnull Predicate<T> predicate) {
        JImmutableRandomAccessList<T> answer = this;
        int index = 0;
        for (Object value : this) {
            if (!1.$assertionsDisabled && value != answer.get(index)) {
                throw new AssertionError();
            }
            if (predicate.test(value)) {
                answer = answer.delete(index);
                continue;
            }
            ++index;
        }
        return answer.size() == this.size() ? this : answer;
    }

    @Nonnull
    default public Collector<T, ?, JImmutableRandomAccessList<T>> ralistCollector() {
        return GenericCollector.ordered(this, this.deleteAll(), a -> a.isEmpty(), (a, v) -> a.insert(v), (a, b) -> a.insertAll((Iterable)b));
    }

    @Override
    public <A> JImmutableRandomAccessList<A> transform(@Nonnull Func1<T, A> var1);

    @Override
    public <A> JImmutableRandomAccessList<A> transformSome(@Nonnull Func1<T, Holder<A>> var1);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface Builder<T>
    extends MutableBuilder<T, JImmutableRandomAccessList<T>> {
    }
}

