/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.util.Map;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Cursorable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.GenericCollector;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.InvariantCheckable;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.Mapped;

@Immutable
public interface JImmutableMap<K, V>
extends Insertable<Entry<K, V>, JImmutableMap<K, V>>,
Mapped<K, V>,
IterableStreamable<Entry<K, V>>,
Cursorable<Entry<K, V>>,
InvariantCheckable {
    @Override
    @Nonnull
    public JImmutableMap<K, V> insert(@Nonnull Entry<K, V> var1);

    @Override
    @Nonnull
    public Holder<V> find(@Nonnull K var1);

    @Nonnull
    public Holder<Entry<K, V>> findEntry(@Nonnull K var1);

    @Nonnull
    public JImmutableMap<K, V> assign(@Nonnull K var1, V var2);

    @Nonnull
    public JImmutableMap<K, V> assignAll(@Nonnull JImmutableMap<? extends K, ? extends V> var1);

    @Nonnull
    public JImmutableMap<K, V> assignAll(@Nonnull Map<? extends K, ? extends V> var1);

    @Nonnull
    public JImmutableMap<K, V> delete(@Nonnull K var1);

    public int size();

    public boolean isEmpty();

    @Nonnull
    public JImmutableMap<K, V> deleteAll();

    @Nonnull
    public Map<K, V> getMap();

    @Nonnull
    public Cursor<K> keysCursor();

    @Nonnull
    public Cursor<V> valuesCursor();

    @Nonnull
    public IterableStreamable<K> keys();

    @Nonnull
    public IterableStreamable<V> values();

    @Nonnull
    default public Collector<Entry<K, V>, ?, JImmutableMap<K, V>> mapCollector() {
        return GenericCollector.unordered(this, this.deleteAll(), a -> a.isEmpty(), (a, v) -> a.insert((Entry)v), (a, b) -> (JImmutableMap)a.insertAll(b));
    }

    @Nonnull
    default public JImmutableMap<K, V> update(@Nonnull K key, @Nonnull Func1<Holder<V>, V> generator) {
        Holder<V> current = this.find(key);
        V newValue = generator.apply(current);
        return this.assign(key, newValue);
    }

    @Immutable
    public static interface Entry<K, V> {
        @Nonnull
        public K getKey();

        public V getValue();
    }
}

