/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Cursorable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.GenericCollector;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.InvariantCheckable;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.MutableBuilder;

@Immutable
public interface JImmutableList<T>
extends Insertable<T, JImmutableList<T>>,
Indexed<T>,
Cursorable<T>,
IterableStreamable<T>,
InvariantCheckable {
    @Override
    public int size();

    @Override
    public T get(int var1);

    @Nonnull
    public JImmutableList<T> assign(int var1, @Nullable T var2);

    @Override
    @Nonnull
    public JImmutableList<T> insert(@Nullable T var1);

    @Override
    @Nonnull
    public JImmutableList<T> insert(@Nonnull Iterable<? extends T> var1);

    @Nonnull
    public JImmutableList<T> insertFirst(@Nullable T var1);

    @Nonnull
    public JImmutableList<T> insertLast(@Nullable T var1);

    @Override
    @Nonnull
    public JImmutableList<T> insertAll(@Nonnull Iterable<? extends T> var1);

    @Override
    @Nonnull
    public JImmutableList<T> insertAll(@Nonnull Cursor<? extends T> var1);

    @Override
    @Nonnull
    public JImmutableList<T> insertAll(@Nonnull Iterator<? extends T> var1);

    @Nonnull
    public JImmutableList<T> insertAllFirst(@Nonnull Iterable<? extends T> var1);

    @Nonnull
    public JImmutableList<T> insertAllFirst(@Nonnull Cursor<? extends T> var1);

    @Nonnull
    public JImmutableList<T> insertAllFirst(@Nonnull Iterator<? extends T> var1);

    @Nonnull
    public JImmutableList<T> insertAllLast(@Nonnull Iterable<? extends T> var1);

    @Nonnull
    public JImmutableList<T> insertAllLast(@Nonnull Cursor<? extends T> var1);

    @Nonnull
    public JImmutableList<T> insertAllLast(@Nonnull Iterator<? extends T> var1);

    @Nonnull
    public JImmutableList<T> deleteFirst();

    @Nonnull
    public JImmutableList<T> deleteLast();

    public boolean isEmpty();

    @Nonnull
    public JImmutableList<T> deleteAll();

    @Nonnull
    public List<T> getList();

    @Nonnull
    default public JImmutableList<T> select(@Nonnull Predicate<T> predicate) {
        Insertable<T, JImmutableList<T>> answer = this.deleteAll();
        for (Object value : this) {
            if (!predicate.test(value)) continue;
            answer = answer.insert(value);
        }
        return answer.size() == this.size() ? this : answer;
    }

    @Nonnull
    default public JImmutableList<T> reject(@Nonnull Predicate<T> predicate) {
        return this.select(predicate.negate());
    }

    @Nonnull
    default public Collector<T, ?, JImmutableList<T>> listCollector() {
        return GenericCollector.ordered(this, this.deleteAll(), a -> a.isEmpty(), (a, v) -> a.insert(v), (a, b) -> a.insertAll((Iterable)b));
    }

    public <A> JImmutableList<A> transform(@Nonnull Func1<T, A> var1);

    public <A> JImmutableList<A> transformSome(@Nonnull Func1<T, Holder<A>> var1);

    public static interface Builder<T>
    extends MutableBuilder<T, JImmutableList<T>> {
    }
}

