/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Func2;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.SplitableIterable;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.Streamable;

public interface IterableStreamable<T>
extends SplitableIterable<T>,
Streamable<T> {
    @Override
    @Nonnull
    public SplitableIterator<T> iterator();

    public int getSpliteratorCharacteristics();

    @Override
    @Nonnull
    default public Spliterator<T> spliterator() {
        return this.iterator().spliterator(this.getSpliteratorCharacteristics());
    }

    @Override
    @Nonnull
    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    @Nonnull
    default public Stream<T> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    default public int count() {
        int answer = 0;
        for (Object ignored : this) {
            ++answer;
        }
        return answer;
    }

    default public int count(@Nonnull Predicate<T> predicate) {
        int answer = 0;
        for (Object value : this) {
            if (!predicate.test(value)) continue;
            ++answer;
        }
        return answer;
    }

    default public boolean allMatch(@Nonnull Predicate<T> predicate) {
        for (Object value : this) {
            if (predicate.test(value)) continue;
            return false;
        }
        return true;
    }

    default public boolean anyMatch(@Nonnull Predicate<T> predicate) {
        for (Object value : this) {
            if (!predicate.test(value)) continue;
            return true;
        }
        return false;
    }

    default public Holder<T> first(@Nonnull Predicate<T> predicate) {
        for (Object value : this) {
            if (!predicate.test(value)) continue;
            return Holders.of(value);
        }
        return Holders.of();
    }

    default public <C extends Insertable<T, C>> C collect(@Nonnull C collection) {
        for (Object value : this) {
            collection = collection.insert(value);
        }
        return collection;
    }

    default public <C extends Insertable<T, C>> C collect(int maxToCollect, @Nonnull C collection) {
        Iterator iterator = this.iterator();
        for (int i = 0; i < maxToCollect && iterator.hasNext(); ++i) {
            collection = collection.insert(iterator.next());
        }
        return collection;
    }

    default public <C extends Insertable<T, C>> C collect(@Nonnull C collection, @Nonnull Predicate<T> predicate) {
        for (Object value : this) {
            if (!predicate.test(value)) continue;
            collection = collection.insert(value);
        }
        return collection;
    }

    default public <C extends Insertable<T, C>> C collect(int maxToCollect, @Nonnull C collection, @Nonnull Predicate<T> predicate) {
        Iterator iterator = this.iterator();
        while (maxToCollect > 0 && iterator.hasNext()) {
            Object value = iterator.next();
            if (!predicate.test(value)) continue;
            collection = collection.insert(value);
            --maxToCollect;
        }
        return collection;
    }

    default public <A, C extends Insertable<A, C>> C transform(@Nonnull C collection, @Nonnull Func1<T, A> transform) {
        for (Object value : this) {
            collection = collection.insert(transform.apply((T)value));
        }
        return collection;
    }

    default public <A, C extends Insertable<A, C>> C transform(int maxToCollect, @Nonnull C collection, @Nonnull Func1<T, A> transform) {
        Iterator iterator = this.iterator();
        while (maxToCollect > 0 && iterator.hasNext()) {
            Object value = iterator.next();
            collection = collection.insert(transform.apply((T)value));
            --maxToCollect;
        }
        return collection;
    }

    default public <A, C extends Insertable<A, C>> C transformSome(@Nonnull C collection, @Nonnull Func1<T, Holder<A>> transform) {
        for (Object value : this) {
            Holder<A> transformed = transform.apply((T)value);
            if (!transformed.isFilled()) continue;
            collection = collection.insert(transformed.getValue());
        }
        return collection;
    }

    default public <A, C extends Insertable<A, C>> C transformSome(int maxToCollect, @Nonnull C collection, @Nonnull Func1<T, Holder<A>> transform) {
        Iterator iterator = this.iterator();
        while (maxToCollect > 0 && iterator.hasNext()) {
            Object value = iterator.next();
            Holder<A> transformed = transform.apply((T)value);
            if (!transformed.isFilled()) continue;
            collection = collection.insert(transformed.getValue());
            --maxToCollect;
        }
        return collection;
    }

    default public <C extends Insertable<T, C>> Partitions<C> partition(@Nonnull C matched, @Nonnull C unmatched, @Nonnull Predicate<T> predicate) {
        for (Object value : this) {
            if (predicate.test(value)) {
                matched = matched.insert(value);
                continue;
            }
            unmatched = unmatched.insert(value);
        }
        return new Partitions<C>(matched, unmatched);
    }

    default public Holder<T> reduce(Func2<T, T, T> accumulator) {
        Iterator iterator = this.iterator();
        if (!iterator.hasNext()) {
            return Holders.of();
        }
        Object answer = iterator.next();
        while (iterator.hasNext()) {
            answer = accumulator.apply(answer, iterator.next());
        }
        return Holders.of(answer);
    }

    public static class Partitions<T> {
        private final T matched;
        private final T unmatched;

        public Partitions(T matched, T unmatched) {
            this.matched = matched;
            this.unmatched = unmatched;
        }

        public T getMatched() {
            return this.matched;
        }

        public T getUnmatched() {
            return this.unmatched;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Partitions that = (Partitions)o;
            return Objects.equals(this.matched, that.matched) && Objects.equals(this.unmatched, that.unmatched);
        }

        public int hashCode() {
            return Objects.hash(this.matched, this.unmatched);
        }
    }
}

