/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.javimmutable.collections.Holder;

public class Holders<V> {
    private static final Empty EMPTY = new Empty();

    @Nonnull
    public static <V> Holder<V> of() {
        return EMPTY;
    }

    @Nonnull
    public static <V> Holder<V> of(final @Nullable V value) {
        return new Filled<V>(){

            @Override
            public V getValue() {
                return value;
            }

            public int hashCode() {
                return Holders.hashCode(this);
            }

            public boolean equals(Object o) {
                return o instanceof Holder && Holders.areEqual(this, (Holder)o);
            }

            public String toString() {
                return String.format("[%s]", value);
            }
        };
    }

    @Nonnull
    public static <V> Holder<V> fromNullable(@Nullable V value) {
        if (value == null) {
            return Holders.of();
        }
        return Holders.of(value);
    }

    private Holders() {
    }

    public static <T> boolean areEqual(Holder<T> a, Holder<T> b) {
        if (a == null || b == null) {
            return a == null && b == null;
        }
        if (a.isEmpty()) {
            return b.isEmpty();
        }
        if (b.isEmpty()) {
            return false;
        }
        T v1 = a.getValue();
        T v2 = b.getValue();
        if (v1 == null || v2 == null) {
            return v1 == null && v2 == null;
        }
        return v1.equals(v2);
    }

    public static <T> int hashCode(Holder<T> a) {
        if (a.isEmpty()) {
            return -1;
        }
        if (a.getValue() == null) {
            return 1;
        }
        return a.getValue().hashCode();
    }

    public static interface Filled<V>
    extends Holder<V> {
        @Override
        default public boolean isEmpty() {
            return false;
        }

        @Override
        default public boolean isFilled() {
            return true;
        }

        @Override
        default public V getValueOrNull() {
            return (V)this.getValue();
        }

        @Override
        default public V getValueOr(V defaultValue) {
            return (V)this.getValue();
        }

        @Override
        default public void ifPresent(@Nonnull Consumer<? super V> consumer) {
            consumer.accept(this.getValue());
        }

        @Override
        default public <U> Holder<U> map(@Nonnull Function<? super V, ? extends U> transforminator) {
            return Holders.of(transforminator.apply(this.getValue()));
        }

        @Override
        default public V orElse(V defaultValue) {
            return (V)this.getValue();
        }

        @Override
        default public V orElseGet(@Nonnull Supplier<? extends V> supplier) {
            return (V)this.getValue();
        }

        @Override
        default public <X extends Throwable> V orElseThrow(@Nonnull Supplier<? extends X> supplier) throws X {
            return (V)this.getValue();
        }
    }

    private static class Empty<V>
    implements Holder<V> {
        private Empty() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isFilled() {
            return false;
        }

        @Override
        public V getValue() {
            throw new UnsupportedOperationException("cannot get empty value");
        }

        @Override
        public V getValueOrNull() {
            return null;
        }

        @Override
        public V getValueOr(V defaultValue) {
            return defaultValue;
        }

        @Override
        public void ifPresent(@Nonnull Consumer<? super V> consumer) {
        }

        @Override
        public <U> Holder<U> map(@Nonnull Function<? super V, ? extends U> transforminator) {
            return Holders.of();
        }

        @Override
        public V orElse(V defaultValue) {
            return defaultValue;
        }

        @Override
        public V orElseGet(@Nonnull Supplier<? extends V> supplier) {
            return supplier.get();
        }

        @Override
        public <X extends Throwable> V orElseThrow(@Nonnull Supplier<? extends X> supplier) throws X {
            throw (Throwable)supplier.get();
        }

        public int hashCode() {
            return Holders.hashCode(this);
        }

        public boolean equals(Object o) {
            return o instanceof Holder && Holders.areEqual(this, (Holder)o);
        }

        public String toString() {
            return "[]";
        }
    }
}

