<!-- markdownlint-disable-next-line -->

---

## Hacktoberfest-2022

What is it? Click on the poster below to watch the video for more details 📽

[![Watch The Video](https://user-images.githubusercontent.com/100344844/193969307-16d1b675-ba62-4eac-bd5c-3172f99034ec.PNG)](https://www.linkedin.com/feed/update/urn:li:activity:6985569051586490368/)

## Register for Hacktober2022 event - https://hacktoberfest.com/


## Hacktoberfest Practice Pull Requests

Repository for you to raise a Pull Request to **practice** open-source! 🎉

### Add your name to the alphabetical list and, optionally, a link to your GitHub account (in alphabetical order below your letter too)

### Option 1. Complete this process in Github (in your browser)

[![Watch this video](https://user-images.githubusercontent.com/100344844/193969323-ce5b871f-f484-47bb-9231-c47746256573.png)](https://hacktoberfest.com/participation/#beginner-resources)

1. Fork the project:

- Click the gray `Fork` button at the top right of this page. This creates _your_ copy of the project and saves it as a new repository in your GitHub account

2. Create a New Branch:

- On your new repository's page, click the gray `main` button in the upper left to reveal a dropdown menu.
- Enter the name of your new branch in the text box. (Branch names usually refer to what is being changed. Example: `nameAdd`).
- Click on `Create branch <new branch name>` and this will automatically take you to your new branch. You can make edits on the main branch, but this may cause issues down the line. The best practice is to create a new branch for each separate issue you work on. That way your `main` branch remains in sync with Eddie's `main` branch.

3. Edit:

- On the top right of the Readme file, click on the pencil icon to edit the file by adding your name.
- After editing the Readme file, add a commit message and click on the green button saying "Commit Changes". Make sure you have selected the branch you have created.

4. Raise a Pull Request:

- Click `Pull Requests` (which is the third option at the top of this page after the options `Code` and `Issues`).
- Click the green `New Pull Request` button. This will prep the new pull request for you by auto-filling the `base repository: base` with 'EddieGitHubCommunity: main' AND auto-filling your `head repository: compare` with `your repository: main`
- Click on your head repository's `compare` dropdown, and switch branches from your 'main' branch to `<new branch name>`.
- Finally, click the green `Create Pull Request` button. Great job! You did it!

You can ask questions by raising an [issue](https://github.com/KapilKumar7/Hacktoberfest2022-masai/issues/new).

### Option 2. Complete this process on your computer (locally)

- Fork the project:
  Click the gray `Fork` button at the top right of this page. This creates _your_ copy of the project and saves it as a new repository in your GitHub account

- Click on the green `Code` button, then either the HTTPS or SSH option, and click the icon to copy the URL. Now you have a copy of the project. Thus, you can play around with it locally on your computer.

- Run the following commands into a terminal window (Command Prompt, Powershell, Terminal, Bash, ZSH). Do this to download the forked copy of this repository to your computer.

```bash
  git clone https://github.com/YOUR_GITHUB_USERNAME/Hacktoberfest2022-masai.git
```

- Switch to the cloned folder. You can paste this command into the same terminal window.

```bash
  cd Hacktoberfest2022-masai
```

- Make a new branch. Your username would make a good branch because it's unique.

```bash
  git checkout -b <name-of-new-branch>
```

- Open the `README.md` file

- **Add your name to the section that matches your Initial in [this list](https://github.com/KapilKumar7/Hacktoberfest2022-masai#hacktoberfest-community), make sure that your name is in alphabetical order. Then save your changes.**

- For example
  `- [Full Name](https://github.com/your-username)`

- Stage your changes.

```bash
  git add README.md
```

or

```bash
  git add .
```

- Commit the changes.

```bash
  git commit -m "Add <your-github-username>"
```

- Check the status of your repository.

```bash
  git status
```

- The response should be like this:

```bash
On branch <name-of-your-branch>
nothing to commit, working tree clean
```

- Pushing your repository to GitHub.

```bash
  git push origin <name-of-your-branch>
```

or

```bash
  git branch -M main
  git push -u origin main
```

> **Warning**: If you get an error message like the one below, you probably forgot to fork the repository before cloning it. It is best to start over and fork the project repository first.

```bash
ERROR: Permission to KapilKumar7/Hacktoberfest2022-masai.git denied to <your-github-username>.
fatal: Could not read from remote repository.
Please make sure you have the correct access rights and that the repository exists.
```

- On the GitHub website, navigate to your forked repo - on the top of the files section, you'll notice a new section containing a `Compare & Pull Request` button!

- Click on that button, this will load a new page, comparing the local branch in your forked repository against the main branch in the EddieHub Hacktoberfest repository. Accept the default values in the dropdown boxes and click the green `Create Pull Request` button. After creating the PR (Pull Request), our GitHub Actions workflow will add a welcome message to your PR.
  Note: A pull request allows us to merge your changes with the original project repo.

- Your pull request will be reviewed and then eventually merged.

Hurray! You successfully have made your first contribution! 🎉

---

## How can I fix a merge conflict?

A GitHub conflict is when people make changes to the same area or line in a file. This must be fixed before it is merged in order to prevent collision in the main branch.

- **To read more about this, go to [GitHub Docs - About Merge Conflicts](https://docs.github.com/en/github/collaborating-with-pull-requests/addressing-merge-conflicts/about-merge-conflicts)**

- **To find out about how to fix a Git Conflict, go to [GitHub Docs - Resolve Merge Conflict](https://docs.github.com/en/github/collaborating-with-pull-requests/addressing-merge-conflicts/resolving-a-merge-conflict-on-github)**

- You can also ask for help in the Hacktoberfest [Discord server](https://discord.gg/hacktoberfest) or submit an issue in the 

---

## `Hacktoberfest Community`

### **Contents**

| [A](#a) | [B](#b) | [C](#c) | [D](#d) | [E](#e) |
| ------- | ------- | ------- | ------- | ------- |
| [F](#f) | [G](#g) | [H](#h) | [I](#i) | [J](#j) |
| [K](#k) | [L](#l) | [M](#m) | [N](#n) | [O](#o) |
| [P](#p) | [Q](#q) | [R](#r) | [S](#s) | [T](#t) |
| [U](#u) | [V](#v) | [W](#w) | [X](#x) | [Y](#y) |
|         |         | [Z](#z) |

---

- ### **A**
  - [Aakash](https://github.com/aakash1233333)
  - [Abhishek Dwibedy](https://github.com/abhishekdwibedy-2002)
  - [Aditya](https://github.com/AdityaPote)
  - [Aditya Raj](https://github.com/Aditya2254)
  - [Alimurrofid](https://github.com/alimurrofid)
  - [Aman Jain](https://github.com/amannayak0007)
  - [Amit Kumar](https://github.com/amitsvg)
  - [Anand R P](https://github.com/AnandRP2030)
  - [Andres Acevedo](https://github.com/andace)
  - [Ankit Raj](https://github.com/ankytastic)
  - [AnshDeep Yadav](https://github.com/AnshDeep24) 
  - [Arnab Sadhukhan](https://github.com/Arnab11)
  - [Asheesh](https://github.com/asheeshjaat)
  - [Ashlin Dev](https://github.com/Ashlin21dev)  
  - [Avinash Pandey](https://github.com/avinash38143) 

  
- ### **B** 
  - [Baishali Roy](https://github.com/baishalicode123)
- ### **C**
  - [Christover R Moa](https://github.com/tophermoa)
  - [cocomo](https://github.com/cocomo29)
  - [CristinaEU1](https://github.com/CristinaEU1)
- ### **D**  
  - [Dakshesh Apkare](https://github.com/Daksheshapkare)
- ### **E**  
- ### **F** 
  - [Flourish Oke](https://github.com/TimTemi)
- ### **G**  
  - [Gaurav](https://github.com/GaurKS) 
  - [gono3coding](https://github.com/gono3coding)
  - [Gustavo Higuera Mayoral](https://github.com/GustavoHiguera)
- ### **H**
  - [Harsha kaslikar](https://github.com/HKaslikar)
  - [Himanshu Singh Negi](https://github.com/HimanshuSinghNegi) 
- ### **I**
  - [Ismeet Kour Chhabda](https://github.com/ismeet010)
- ### **J**
  - [Jatin Kansal](https://github.com/jatinkansal2005)
  - [JoaoVictorG](https://github.com/JoaoVictorG)
  
- ### **K**   
  - [Kapil Kumar](https://github.com/KapilKumar7)
  - [Kpil Kumar](https://github.com/KpilKumar)
- ### **L**
  - [Logadheep](https://github.com/Logadheep)
- ### **M**
  - [Mahendra](https://github.com/mahendra2217)
  - [Mallikarjun Rayar](https://github.com/manojrayar)  
  - [Mayank Kaushik](https://github.com/Mayank23k)
  - [Michael Giardina](https://github.com/giardim)
  - [Muhammad Immad](https://github.com/itsimmad)


- ### **N**
  - [Nikita Mahamuni](https://github.com/Nikita0509)
  - [Nishant](https://github.com/Nishant50)  
  - [Neerav Parakh](https://github.com/NeeravParakh) 

- ### **O**
  - [Olga Mozejko](https://github.com/OlgaMozejko)
- ### **P** 
  - [Pavan Kulkarni](https://github.com/pavandeveloperr)
  - [Pramuditya](https://github.com/pramuditya8)
  - [Prasham Shah](https://github.com/Prasham2407)
  - [Pratyaksha Newalkar](https://github.com/Pratyaksha462)
  - [Prerna Rathore](https://github.com/PrernaRathore10)
  - [Priyanshu Jaiswal](https://github.com/jpriyanshu1406)
  - [Pronajit Dey](https://github.com/pronajitdey) 
  
- ### **Q**
- ### **R**
  - [Rahul Palamarthi](https://github.com/Rahul-Palamarthi)
  - [Rhoda Pickens](https://github.com/RhodaPickens)
  - [Riya Tyagi](https://github.com/riyatyag-6)
  - [Rohan Gope](https://github.com/Darkrider0007)  
  - [Roshan k Jha](https://github.com/iam-roshanj)
  

- ### **S**
  - [Sanjay](https://github.com/sanjayk0508)
  - [Shivangi Singh](https://github.com/shivangi1217) 
  - [Shreya Mishra](https://github.com/Shreya-Lu) 
  - [Shreya Rajpal](https://github.com/Shreyaar12)
  - [Silky Modi](https://github.com/silky-modi22) 
  - [Soham Dey](https://github.com/IamSohamDey)
  - [Soumik Seal](https://github.com/Soumik8114)
  - [Sujatha Pulagam](https://github.com/Sujatha369)
  - [Swadesh Pal](https://github.com/Swadeshit27)

  
- ### **T**
  - [Thomps](https://github.com/If-Then-andSometimesElse)
- ### **U**
  - [Ujjwal Jha](https://github.com/i-ujjwaljha)
- ### **V**
  - [Vikash Kumar](https://github.com/Vikash0122)
- ### **W**
- ### **X**
- ### **Y**
- ### **Z**



***
<!-- # 📝 Licensed by <img src="https://img.shields.io/github/license/payloadbox/xss-payload-list"> -->
# Don't forget to ⭐ the Repository.

# Created by
Created with &#129293; by <a href="https://github.com/KapilKumar7" target="_blank">Kapil Kumar</a>

<b>Follow <a href="https://github.com/KapilKumar7" target="_blank">Kapil Kumar</a> for more creative things. 

<br>

***
## Contributors ✨

Thanks to all the wonderful people -

<a href = "https://github.com/KapilKumar7/Hacktoberfest2022-masai/graphs/contributors">
  <img src = "https://contrib.rocks/image?repo=KapilKumar7/Hacktoberfest2022-masai"/>
</a>


 
