# algorithms and datastructures collection

## algorithms

| | **insertion sort** | **merge sort** | **heap sort** | **quick sort** | **counting sort** | **bucket sort** |
|------------|-----------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------|
| C | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/insertion_sort/insertion_sort.c) | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/merge_sort/C/merge_sortv2.c) | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/heap_sort/heap_sort.c) | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/quick_sort/quicksort.c) | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/counting_sort/counting_sort.c) | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/bucket_sort/bucket_sort.c) |
| Python | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/insertion_sort/insertion_sort.py) | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/merge_sort/python/merge_sortv3.py) | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/heap_sort/heap_sort.py) | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/quick_sort/quicksort.py) | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/counting_sort/counting_sort.py) | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/bucket_sort/bucket_sort.c) |
| Scala | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/insertion_sort/insertion_sort.scala) | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/merge_sort/scala/merge_sort.scala) | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/heap_sort/heap_sort.scala) | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/quick_sort/quicksort.scala) | ❌ | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/bucket_sort/bucket_sort.scala) |
| TypeScript | ❌ | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/merge_sort/TS/merge_sort.ts) | ❌ | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/sorting_algorithms/quick_sort/quicksort.ts) | ❌ | ❌ |
| Java | | | | | | |

## datastructures

| | **linked list** | **stack** | **binary tree** | **binary search tree** | **priority queue** | **hash table** |
|------------|-----------------|-----------|-----------------|------------------------|--------------------|----------------|
| C | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/tree/main/datastructures/linked_list/C) | ❌ | ❌ | ❌ | ❌ | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/datastructures/hash_table/hash_table.c) |
| Python | ❌ | ❌ | ❌ | ❌ | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/datastructures/priority_queue/priority_queue.py) | ❌ |
| Scala | ❌ | ✅ [code](https://github.com/KaiErikNiermann/algorithms-practice/blob/main/datastructures/stack/stack.scala) | ❌ | ❌ | ❌ | ❌ |
| TypeScript | ❌ | ❌ | ❌ | ❌ | ❌ | ❌ |

### Notes

My focus here was to have a collection of algorithms written in different langauges as a means to understand the algorithms while at the same time praciticing programming languages. Additionally I wanted to focus on simplicity and clarity of each implementation.

Some algorithms have different versions, usually earlier versions are less clean but sometimes easier to understand implementations.

I will likely add to this collection over time. If there are any errors please do say so and I will try my best to correct them.

### References
  
- [_Introduction to Algorithms, Fourth Edition_](http://mitpress.mit.edu/9780262046305/introduction-to-algorithms/)
- [_Wikipedia_](https://en.wikipedia.org/wiki/Category:Algorithms_and_data_structures)