<div align=center>

# Hacktoberfest Swag <!-- current year start -->2022<!-- current year end -->


![Hacktoberfest](https://user-images.githubusercontent.com/76551267/192132571-7d0d7952-9fcc-4e93-96bb-8350b20dcbfc.png "Hacktoberfest")

[![Website](https://img.shields.io/badge/Website-visit-2a8?style=for-the-badge&logo=google-chrome&logoColor=white)](https://benbarth.github.io/hacktoberfest-swag/)
[![Validation](https://img.shields.io/github/workflow/status/benbarth/hacktoberfest-swag/Update%20README/master?logo=github&style=for-the-badge)](https://github.com/benbarth/hacktoberfest-swag/actions?query=workflow%3A"Update+README")

Looking for Hacktoberfest swag? You've come to the right place.

</div>

## What is Hacktoberfest?

"Hacktoberfest is a month-long celebration of open source software." - _DigitalOcean_

Hacktoberfest is open to everyone. For the [official limited edition Hacktoberfest shirt](https://hacktoberfest.digitalocean.com), _you must register and make four pull requests_ in the month of October (to a repository with the _hacktoberfest_ label) - you can even contribute to this repository! You can sign up at [hacktoberfest.digitalocean.com](https://hacktoberfest.digitalocean.com).

Hacktoberfest® encourages participation in the open source community.

In all of the hacktoberfest excitement, many companies want to join the celebration by rewarding their contributors with even more swag! That's why we're here!

### The purpose of this list is to incentivize meaningful contributions. If you intend to make low-value changes -- just for swag. _Don't._

# Special Note For Everyone

```py
'''
always make more then 4 pull request
lets you have made only 4 pull request to different projects
but one project is excluded from hacktoberfest event then your pull request will not be count and
then you have remains 3 valid pull request if these projects is not excluded.
if you fail to make 4 pull request then you cant get swags or t-shirts.

i will recommend you make pull request to your own repo which is very very safest side for you..
keep in mind that repo has hacktoberfest topic..
'''
```

# Contribution rules📚:

- The project must work when opening Contributors.html
- You are allowed to make pull requests that break the rules. We just merge it ;)
- Do NOT add any build steps e.g npm install (we want to keep this a simple static site)
- Do NOT remove other content.
- Styling/code can be pretty, ugly or stupid, big or small as long as it works
- Add your name to the Contributors.html file
- Try to keep pull requests small to minimize merge conflicts
- To get a shirt, you must make four approved pull requests (PRs) on opted-in projects between October 1-31 in any time zone.
- This year, the first 40,000 participants can earn a T-shirt.

## Getting Started 🤩🤗:

- Fork this repo (button on top)
- Clone on your local machine

```
git clone https://github.com/KIET7UKE/Hacktoberfest-2K22

```
- Navigate to project directory.
```
cd Hacktoberfest-2K22
```

- Create a new Branch

```markdown
git checkout -b my-new-branch
```
- Add your contribution
```
git add .
```
- Commit your changes.

```markdown
git commit -m "Relevant message"
```
- Then push 
```
git push origin my-new-branch
```


- Create a new pull request from your forked repository

<br>

## View Some JS Live Demo Projects

| Day |                                 Name                                  |
| --- | :-------------------------------------------------------------------: |
| 1   |       [Dice Roller](https://grand-dolphin-6cf5fb.netlify.app/)        |
| 2   |    [Expense Tracker](https://roaring-daifuku-02836d.netlify.app/)     |
| 3   |     [HangMan Game](https://shiny-stroopwafel-00478e.netlify.app/)     |
| 4   | [3Equal Numbers](https://coruscating-salamander-170f30.netlify.app/)  |
| 5   |    [Stick Hero Game](https://fabulous-axolotl-f56cdc.netlify.app/)    |
| 6   | [Infinite Scrolling App](https://joyful-tiramisu-cc72b7.netlify.app/) |
| 7   |     [Sticky Notes](https://snazzy-frangipane-3e7d34.netlify.app/)     |
| 8   |       [Math Puzzle](https://dainty-kringle-4febd3.netlify.app/)       |
| 9   |         [Word Game](https://elegant-yeot-92b156.netlify.app/)         |
| 10  |       [Math Game](https://gleeful-figolla-d97c01.netlify.app/)        |
| 11  |       [Sorting Visualizer](https://punyakrit.github.io/Sorting-Visualizer/)        |

## Rules

- Don't use filthy words and be welcome for beginners and other people in this community.

---

## Contributing

Before making any contribution, big or small, Contributors are advised to go through the [Contributing Guidelines](./Contribution.md).

## Code of Conduct

To maintain a safe and inclusive space for everyone to learn and grow, contributors are advised to follow the [Code of Conduct](./Code_Of_Conduct.md).

<!-- ------------------------------------------------------------------------------------------------------------------------------------------------------------------ -->
<br>

<div align="center">

### Show some ❤️ by starring⭐ this awesome Repository!

</div>
  

#

	

<h3 align=center> Project Admin ❤️ </h3>

© 2022 Sahil Sharma and contributors\
This project is licensed under the [**MIT license**](https://github.com/KIET7UKE/Hacktoberfest-2K22/blob/main/LICENSE).

[![forthebadge](https://forthebadge.com/images/badges/built-with-love.svg)](https://forthebadge.com)
<a href="#top"><img src="https://img.shields.io/badge/-Back%20to%20Top-red?style=for-the-badge" align="right"/></a>

<p align="center">
<table align="center">
  <tbody><tr>
     <td align="center"><a href="https://github.com/KIET7UKE"><img alt="" src="https://avatars.githubusercontent.com/u/76551267?s=400&u=6683bf9ce8686492846628c6fc000bef22361a4e&v=4" width="125px;"><br><sub><b> Sahil Sharma </b></sub></a><br></td> </a></td>
</tbody></table>

<!-- ------------------------------------------------------------------------------------------------------------------------------------------------------------------ -->

<h3 align=center> Contributors ❤️ </h3>
 
<a href="https://github.com/KIET7UKE/Hacktoberfest-2K22/graphs/contributors">
  <img src="https://contributors-img.web.app/image?repo=KIET7UKE/Hacktoberfest-2K22&max=500" alt="Contributors list" width="100%"/>
</a>
