---
title: 解説を読む・テストケースを見る
---

## 解説を読む

### まとめて表示

- [View All Editorials](https://greasyfork.org/ja/scripts/416554-view-all-editorials) - 「解説」ページに、問題の解説を表示する。

    <div align="center">
      <img loading = "lazy" src="../../images/userscript/view-all-editorials.png" alt="view all editorials">
    </div>

### 問題別のタブを追加

- [Tabbed AtCoder Editorial](https://greasyfork.org/ja/scripts/447075-tabbed-atcoder-editorial) - 「解説」ページに、問題別に解説を見ることができるタブを追加する。

  <div align="center">
    <img loading = "lazy" src="../../images/userscript/tabbed_atcoder_editorial.png" alt="tabbed atcoder editorial">
  </div>

### 新しいタブで開く

- [AtCoder Editorial New Tab](https://greasyfork.org/ja/scripts/424207-atcoder-editorial-new-tab) - 「問題」ページにある「解説」ボタンを押すと、該当する解説を新しいタブで開くことができる。

### 該当ページに移動

- [Atcoder Easy Jump](https://greasyfork.org/ja/scripts/491701-atcoder-easy-jump) - 外部リンクへ移動するときに表示される警告画面を省略する。

    !!! warning "注意"
        外部リンクへ直接移動するリスクを理解した上で導入することを推奨。

- [AtCoder Traffic Light](https://greasyfork.org/ja/scripts/420136-atcoder-traffic-light) - 「問題」ページから、直接解説ページに移動できる。また、解説ボタンの色が読み込み状況に応じて変化する。

    <div align="center">
      <img loading = "lazy" src="../../images/userscript/atcoder_traffic_light.png" alt="snuke? smeke?">
    </div>

### 問題単位で一覧を表示

- [Editorials Dropdown for AtCoder](https://greasyfork.org/ja/scripts/500819-editorials-dropdown-for-atcoder) - 「問題」ページの解説ボタンの右側に、解説の一覧を表示するドロップダウンメニューを追加する。

    <div align="center">
      <img loading="lazy" src="../../images/userscript/editorials_dropdown_for_atcoder.png" alt="editorials dropdown for atcoder">
    </div>

### 解説コードのエディタを変更

- [AtCoder Ace Editor Editorial](https://greasyfork.org/ja/scripts/473919-atcoder-ace-editor-editorial) - 「解説」ページで、Ace Editorに対応していない解説コードを変換する。[View All Editorials](https://greasyfork.org/ja/scripts/416554-view-all-editorials)にも対応している。

    <div align="center">
      <img loading = "lazy" src="../../images//userscript/atcoder_ace_editor_editorial.png" alt="atcoder_ace_editor_editorial">
    </div>

### ソースコードを整形

- [AtCoder Formatter](https://greasyfork.org/ja/scripts/454753-atcoder-formatter) - 複数のページに対して、ソースコードを整形できるボタンを追加する。2022年11月時点で、C++、C#、Pythonに対応。

### 競プロ典型90問の復習

- [add-typical90-link](https://greasyfork.org/ja/scripts/427326-add-typical90-link) - 「[競プロ典型90問](https://atcoder.jp/contests/typical90)」に、「解説リンク」タブを追加する。このタブから[GitHub](https://github.com/E869120/kyopro_educational_90/tree/main/editorial)で公開されている解説に移動できる。

    <div align="center">
      <img loading = "lazy" src="../../images/userscript/add_typical90_link.png" alt="add typical90 link">
    </div>

- [AtCoder Editorial for Typical90](https://greasyfork.org/ja/scripts/427584-atcoder-editorial-for-typical90) - 「[競プロ典型 90 問](https://atcoder.jp/contests/typical90)」に解説タブを追加し、[GitHub](https://github.com/E869120/kyopro_educational_90)で公開されている問題の解説・想定ソースコードなどのリンクを表示する。

    <div align="center">
      <img loading = "lazy" src="../../images/userscript/atcoder_editorial_for_typical90.png" alt="atcoder editorial for typical90">
    </div>

- [typical90-direct-editorial-link](https://greasyfork.org/ja/scripts/455946-typical90-direct-editorial-link) - 「[競プロ典型90問](https://atcoder.jp/contests/typical90)」に、「解説リンク(Twitter)」ボタンを追加する。

    <div align="center">
      <img loading = "lazy" src="../../images/userscript/typical90_direct_editorial_link.png" alt="typical90 direct editorial link">
    </div>

### 解説に投票

- [AtCoder Editorial Voting](https://greasyfork.org/ja/scripts/492964-atcoder-editorial-voting) - 解説に投票できる。また、投票数にマウスのカーソルを合わせると、投票者のレーティング分布が表示される。

    <div align="center">
      <img loading = "lazy" src="../../images/userscript/atcoder_editorial_voting.png" alt="atcoder editorial voting">
    </div>

### 解説を隠す・非表示に

- [AtCoder Editorial Cover](https://greasyfork.org/en/scripts/463760-atcoder-editorial-cover) - 問題の「解説」を一度隠した上で、ボタンを押すと徐々に表示される。

    <div align="center">
      <img loading = "lazy" src="../../images/userscript/atcoder_editorial_cover.png" alt="atcoder editorial cover">
    </div>

- [AtCoder Hide Editorial](https://greasyfork.org/ja/scripts/425127-atcoder-hide-editorial) - 問題の「解説」に関するURLを取り除く。

    <div align="center">
      <img loading = "lazy" src="../../images/userscript/atcoder_hide_editorial.png" alt="atcoder hide editorial">
    </div>

- [Hide Solutions](https://greasyfork.org/ja/scripts/485421-hide-solutions) - (英語表記のみ対応) 問題の「解説」ボタンやタブを非表示にする。

## テストケースを見る

- [AtCoder TestCase Extension](https://greasyfork.org/ja/scripts/371832-atcoder-testcase-extension) - 公開されているテストケースのリンクを追加する。

    <div align="center">
      <img loading = "lazy" src="../../images/userscript/atcoder_testcase_extension.png" alt="atcoder testcase extension">
    </div>

## 復習の効果をより高める

### 外部サービス

- [AtCoder Problems Marker](https://greasyfork.org/ja/scripts/395711-atcoder-problems-marker) - [AtCoder Problems](https://kenkoooo.com/atcoder/) で表示される問題に、ユーザが独自のマーカー(解説ACなど)を付けられるようにする。

    <div align="center">
      <img loading = "lazy" src="../../images/userscript/atcoder_problems_marker.png" alt="atcoder problems marker">
    </div>

- [VirtualContestUpSolver](https://greasyfork.org/ja/scripts/421963-virtualcontestupsolver) - [AtCoder Problems](https://kenkoooo.com/atcoder/)のバーチャルコンテストで出題された問題のうち、復習したかどうかを管理できる。

    !!! warning "注意"
        利用には、バーチャルコンテストに参加できる状態(GitHubアカウントを利用してユーザ認証を済ませた状態)にあり、少なくとも1回以上の参加が必要。

    <div align="center">
      <img loading = "lazy" src="../../images/userscript/virtual_contest_upsolver.png" alt="virtual contest upsolver">
    </div>
