---
title: Scripts - はじめに
---

[AtCoder](https://atcoder.jp/)のWebページをより見やすくするためのサービスを紹介しています。

また、問題やコンテストの成績について、リアルタイムの情報を見ることなどもできます。

!!! info "参考"

    初めてサービスを利用するときは、以下の記事やリンクをご参照ください。

    - おすすめサービスの[紹介記事](https://scrapbox.io/magurofly/AtCoder%E3%82%92%E3%81%99%E3%82%8B%E3%81%A8%E3%81%8D%E3%80%81%E5%85%A5%E3%82%8C%E3%81%A6%E3%81%8A%E3%81%8F%E3%81%A8%E3%81%84%E3%81%84%E6%8B%A1%E5%BC%B5%E6%A9%9F%E8%83%BD%E3%81%AA%E3%81%A9)

        4つの観点(注意喚起・有益な情報がわかる・見た目を変える・便利機能)からユーザスクリプト、Google Chromeの拡張機能を紹介した記事です。

    - ユーザスクリプトを利用するために、[スクリプトマネージャ](https://greasyfork.org/ja)を導入する

    - Google Chromeの拡張機能の[使い方](https://www.google.com/search?sxsrf=ALeKk033ZO4VOoYJmsx9txWxx32vSveVQw%3A1594530427618&ei=e5oKX9GlJaSzmAXYjZ4Y&q=chrome+%E6%8B%A1%E5%BC%B5%E6%A9%9F%E8%83%BD+%E4%BD%BF%E3%81%84%E6%96%B9&oq=chrome%E6%8B%A1%E5%BC%B5%E6%A9%9F%E8%83%BD%E3%81%A8%E3%81%AF&gs_lcp=CgZwc3ktYWIQARgBMgcIABBHELADMgcIABBHELADMgcIABBHELADMgcIABBHELADMgcIABBHELADMgcIABBHELADMgcIABBHELADMgcIABBHELADUABYAGC7uwRoAXAAeACAAQCIAQCSAQCYAQCqAQdnd3Mtd2l6&sclient=psy-ab)を調べる

## 対象読者

- 問題を解きたい
- ソースコードの提出・確認が簡単にできるようにしたい
- 解説を読みたい / テストケースを見たい
- コンテストに参加したい
- コンテストの成績・統計情報が見たい
- Webページをより見やすくしたい
- ライバルとなるユーザを探したい

## 目次

### ユーザスクリプト

- [問題を解く](../user_scripts/solve_problems)
- [ソースコードの提出・確認を簡単に](../user_scripts/submit_codes)
- [解説を読む・テストケースを見る](../user_scripts/read_editorials)
- [コンテストに参加する](../user_scripts/participate_in_contests)
- [コンテストの成績や関連する統計情報を見る](../user_scripts/view_scores)
- [Webページに色付けする](../user_scripts/colors)
- [ライバルを探す・競う](../user_scripts/rivals)
- [ネタスクリプト](../user_scripts/jokes)
- [開発者向けの情報](../user_scripts/for_developers)

### Google Chromeの拡張機能

- [問題を解く](../chrome_extensions/solve_problems)
- [ソースコードの提出・確認を簡単に](../chrome_extensions/submit_codes)
- [テストケースを見る・復習の効果をより高める](../chrome_extensions/review)
- [コンテストに参加する](../chrome_extensions/participate_in_contests)
- [コンテストの成績を見る](../chrome_extensions/view_scores)
- [Webページをより見やすく](../chrome_extensions/improve_ui)
