---
title: 情報オリンピック
---

## JOI (Japanese Olympiad in Informatics)

### Webアプリ・Webサイト

#### 公式サイトを見る

- [日本情報オリンピック](https://www.ioi-jp.org/) - 情報オリンピック日本委員会のWebページ。[予選・本選で出題された問題と解説](https://www.ioi-jp.org/problem_archive.php)や[春季トレーニング合宿の過去問](https://www.ioi-jp.org/camp/index.html)などが掲載されている。

    <div align="center">
      <img loading = "lazy" src="../../images/related_contest_sites/joi/joi.png" alt="joi">
    </div>

#### 問題を解く

- [jcioi/joi-contests-site](https://contests.ioi-jp.org/) - 日本情報オリンピックの本戦・春合宿 オンラインコンテストをまとめたWebサイト。
    - [GitHub](https://github.com/jcioi/joi-contests-site) ![GitHub Repo stars](https://img.shields.io/github/stars/jcioi/joi-contests-site?style=plastic)

- [AOJ/Atcoder-JOI](https://joi.goodbaton.com/) - [AOJ](http://judge.u-aizu.ac.jp/onlinejudge/)や[AtCoder](https://atcoder.jp/)のユーザIDを利用して、難易度別の回答状況や個別の問題の正誤状況を把握できるWebサイト。

    <div align="center">
      <img loading = "lazy" src="../../images/related_contest_sites/joi/aoj_atcoder_joi.png" alt="aoj atcoder joi">
    </div>

#### 問題の難易度を知る

- [JOI非公式難易度表](https://docs.google.com/spreadsheets/d/1zXDtkFmskO5NSxkqck8uDbcJtAhTVZtzPh2hLw64Sw4/edit#gid=0) - JOIで出題された問題に関する非公式の難易度表。有志の投票に基づいて決められている。

    <div align="center">
      <img loading = "lazy" src="../../images/related_contest_sites/joi/difficulty_table.png" alt="difficulty table">
    </div>

### 記事・書籍

#### コードを書くための環境構築を行う

- [情オリの実機練習のためのラクラク環境構築](https://iro-happa.hatenablog.com/entry/2023/03/27/165726) - 春季トレーニング合宿の実機練習における環境構築の方法が紹介されている。

#### プログラミング言語を学ぶ

- [Introducion to JOI](https://pro-ktmr.github.io/joig-course/text/index.html) - C++の基礎文法について、JOIの過去問を通して学ぶことができる。
- [JOI 公式テキスト Pythonで問題解決](https://www.amazon.co.jp/dp/4407359447) - JOIの公式テキスト。プログラミングとアルゴリズムの基礎をPythonで学ぶことができる。
    - [書籍の紹介と便利リンク集](https://pro-ktmr.github.io/joi-text/)
    - [公式解説動画](https://www.youtube.com/channel/UCI_npX8-fWv235zqCj8Oa9w)
    - [PyTry](https://pro-ktmr.github.io/pytry/) - 競技プログラミング初心者向けのPython実行環境。

#### 参加記を読む

- [JOI春合宿2020 参加記](https://drive.google.com/file/d/1iW2sTAz9VyhzWbO0ByVHiha0jG0aIJ7H/view) - [E869120](https://atcoder.jp/users/E869120)さんによる2020年日本情報オリンピック春季トレーニング合宿の参加記。情報オリンピック日本代表の選考までの練習過程と選考会での立ち回りについて詳細に書かれている。

#### 勉強会の案内

- 調査中。

## IOI (International Olympiad in Informatics)

### Webアプリ・Webサイト

#### 出題範囲に関するクイズを解く

- [IOI Syllabus クイズ①](https://quiz-maker.site/quiz/play/x4Qzf820220330074405) - [IOI Syllabus 2020](https://ioinformatics.org/files/ioi-syllabus-2020.pdf)の出題範囲に関するクイズを解くことができる。

    <div align="center">
      <img loading = "lazy" src="../../images/related_contest_sites/ioi/ioi_syllabus_quiz1.png" alt="ioi syllabus quiz1">
    </div>

#### 問題を解く

- [oj.uz](https://oj.uz/) - 海外の情報オリンピックの問題を閲覧・回答できるWebサイト。

    <div align="center">
      <img loading = "lazy" src="../../images/related_contest_sites/joi/oj_uz.png" alt="oj uz">
    </div>

- [OI Checklist](https://oichecklist.pythonanywhere.com/) - [oj.uz](https://oj.uz/)の回答状況を把握するためのWebサイト。

    !!! warning "注意"

        回答状況の更新は自動で行われず、利用者が手動で行う必要がある。

    <div align="center">
      <img loading = "lazy" src="../../images/related_contest_sites/joi/oi_checklist.png" alt="oj uz">
    </div>

#### アルゴリズムに関する資料を読む

- [OI Public Library](https://github.com/enkerewpo/OI-Public-Library) - アルゴリズムに関する資料集。中国語と英語で提供されている。

### 記事

#### 参加記を読む

- [IOI2020 参加記](https://drive.google.com/file/d/1UOFW6Vtxz5S5hWBK78swQg368F6L15kp/view) - [E869120](https://atcoder.jp/users/E869120)さんによる第32回国際情報オリンピック(IOI2020)の参加記。「金メダルを確実に取る」という観点から、本番での立ち回りが詳細に解説されている。また、筆者が5年間の競技生活を通して得た経験は、後進に勇気と希望を与えてくれる内容だと思われる。
- [国際情報オリンピック (IOI 2020) 参加記 ~ 情報オリンピックへの感謝の気持ちを込めて ~](https://drive.google.com/file/d/1NGhlPCmRadq8j2oNeFmH4LfPiooI7H_1/view) - [square1001](https://atcoder.jp/users/square1001)さんによる第32回国際情報オリンピック(IOI2020)の参加記。部分点を確実に取りながら、満点を目指す戦略が詳しく解説されている。また、筆者が大会に参加するまでの過程や競技プログラミングを通して得られた経験には、後進にとって有益な情報が多く含まれていると思われる。
- [IOI2023 参加記 - Kodaman のメモ](https://kodaman.hatenablog.com/entry/2023/09/10/160836) - [KoD](https://atcoder.jp/users/KoD)さんによる第35回国際情報オリンピック(IOI 2023)参加記。コンテストの戦略・思考過程を中心に振り返っている。
- [国際情報オリンピック2023 参加記](https://qiita.com/black-yuki/items/10b297ffe486cd36cd8a) - [blackyuki](https://atcoder.jp/users/blackyuki)さんによる第35回国際情報オリンピック(IOI 2023)参加記。コンテストの対策・戦略・思考過程を振り返っている。

## EGOI (European Girls’ Olympiad in Informatics)

### 記事

#### 参加記を読む

- [EGOI2023　イギリス代表としての参加記](https://clara775.hatenablog.com/entry/2023/07/27/005753) - [うえこ](https://clara775.hatenablog.com/)さんによる「European Girls' Olympiad in Informatics 2023 (EGOI2023)」の参加記。コンテスト当日の振り返りに加えて、各国の参加者との国際交流・関連イベント・観光・グルメなど幅広い話題に言及されている。
    - [EGOI2024 日本代表としての参加記](https://clara775.hatenablog.com/entry/2024/07/29/145535) - 同じ筆者によるEGOI2024の参加記。
- [EGOI2024 参加記](https://a-kyopro.hatenablog.com/entry/2024/07/30/111623) - [あかり](https://a-kyopro.hatenablog.com)さんによるEGOI2024の参加記。コンテスト当日の思考過程や各種イベントを振り返っている。
