---
title: Articles, Blogs, Books and Videos - はじめに
---

新しい知識を学ぶときに参考となる記事・ブログ・資料集・書籍・動画などを掲載しています。

また、プログラミング検定や競技プログラミングで身につけた能力の活用方法に関するページもあります。

## 対象読者

- プログラミング言語・アルゴリズム・ヒューリスティック問題・数学などの知識を学びたい
- ユーザによる問題の解説が読みたい
- 他のユーザと交流したい
- コンテストの問題を作成・出題してみたい
- プログラミングの能力を測定したい / 身につけた能力を活かして就職・転職したい

## 目次

### 記事

- [入門者・初心者向けの内容](../articles/introduction)
- [コードを書くための環境構築を行う](../articles/development_env)
- [プログラミング言語を学ぶ](../articles/programming_languages)
- [コンテストに向けた練習方法を知る](../articles/how_to_practice)
- [アルゴリズムを学ぶ](../articles/algorithm)
- [ヒューリスティック問題を解く](../articles/heuristic)
- [数学を学ぶ](../articles/math)
- [実装テクニックを学ぶ](../articles/implementation)
- [解説ブログ・サイトを見る](../articles/user_editorials)
- [難問を解く](../articles/how_to_approach_difficult_problems)
- [問題を作成・出題する](../articles/for_writers)
- [コンテストに関する統計情報を見る](../articles/view_scores)
- [1年をふりかえる](../articles/look_back_on_past)
- [部活・サークル・同好会に参加する](../articles/club_activities)
- [プログラミング検定を受ける](../articles/past)
- [競技プログラミングと就転職](../articles/jobs)

### ブログ

- アルゴリズム部門
    - [C](../blogs/algorithm/c)
    - [C&#43;&#43;](../blogs/algorithm/cpp)
    - [Crystal](../blogs/algorithm/crystal)
    - [C&#35;](../blogs/algorithm/csharp)
    - [Java](../blogs/algorithm/java)
    - [Python](../blogs/algorithm/python)
    - [Ruby](../blogs/algorithm/ruby)
    - [Rust](../blogs/algorithm/rust)
- ヒューリスティック部門
    - [C&#43;&#43;](../blogs/heuristic/cpp)
    - [Crystal](../blogs/heuristic/crystal)
    - [C&#35;](../blogs/heuristic/csharp)
    - [Java](../blogs/heuristic/java)
    - [Python](../blogs/heuristic/python)
    - [Rust](../blogs/heuristic/rust)

### 資料集

- [資料集](../materials)

### 書籍

- [書籍](../books)

### 動画

- YouTube
    - [チャンネル](../youtube/channel)
    - [個別の動画](../youtube/video)
- [ニコニコ動画](../videos/niconico)
- [番組アーカイブ](../videos/archived_video)

### SNS

- [SNS](../sns)
