---
title: Libraries and Snippets - はじめに
---

主要言語で実装されたアルゴリズムのライブラリ・スニペットを紹介しています。

!!! info "参考"

    ライブラリ・スニペットを採用するときの判断材料となるよう、GitHubのStar数、[AtCoder](https://atcoder.jp/)のユーザアカウント情報を掲載しています。

!!! warning "注意"

    コンテストで利用する場合は、事前に最新のジャッジシステムやライブラリチェッカーでの動作確認を推奨します。

## 対象読者

- アルゴリズムの実装や活用方法を学びたい
- [AtCoder](https://atcoder.jp/)公式が、様々なアルゴリズムをC++で実装しているライブラリ「AtCoder Library (ACL)」を利用したい
- 自作のライブラリが正しく実装されているか確認したい
- ユーザが公開しているライブラリを活用したい

## 目次

- [AtCoder Library (ACL)](./atcoder_library)
    - [補助資料・解説記事](./articles)
    - [各言語への移植](./porting_of_acl)
- [ライブラリチェッカー](./library_checker)
- 有志による公開ライブラリ
    - [複数の言語](./libraries)
    - [C&#43;&#43;](./cpp)
    - [C&#35;](./csharp)
    - [D](./d)
    - [Java](./java)
    - [Python](./python)
    - [Rust](./rust)
    - [Others](./others)
