# AtCoder Clans

【非公式】競技プログラミングサイト[AtCoder](https://atcoder.jp/)がもっと楽しくなるリンク集です。有志による非公式サービス・ツール・ライブラリ・記事などをまとめています。

<p align="center">
    <a href="https://github.com/KATO-Hiro/AtCoderClans/actions/workflows/link_checker.yml" target="_blank">
        <img src="https://img.shields.io/github/actions/workflow/status/KATO-Hiro/AtCoderClans/link_checker.yml?branch=master&label=Links&style=plastic" alt="Markdown links">
    </a>
    <a href="https://github.com/KATO-Hiro/AtCoderClans/actions/workflows/deploy.yml" target="_blank">
        <img src="https://img.shields.io/github/actions/workflow/status/KATO-Hiro/AtCoderClans/deploy.yml?branch=master&event=push&label=Deployment&style=plastic" alt="GitHub Workflow Status (with event)">
    </a>
    <a href="https://github.com/KATO-Hiro/AtCoderClans/blob/master/LICENSE">
        <img src="https://img.shields.io/badge/license-MIT-brightgreen.svg?style=plastic" alt="License: MIT" />
    </a>
    <a href="https://twitter.com/atcoderclans">
        <img src="https://img.shields.io/twitter/follow/AtCoderClans?style=social" alt="Twitter Follow" />
    </a>
</p>
<p align="center">
  <a href="https://github.com/sponsors/KATO-Hiro">
    <img src="https://img.shields.io/static/v1?label=Sponsor&message=%E2%9D%A4&logo=GitHub&color=ff69b4"/>
  </a>
</p>

---

## 特長

* **網羅性が高い**: 初心者から上級者向けの情報まで幅広く掲載しています。
* **最新**: 最新の情報が入手できます。また、[X (旧 Twitter)](https://twitter.com/atcoderclans)で直近1週間の内容をお届けしています。
* **日本語の紹介文**: 日本語で紹介しています。
* **眺めるだけでも楽しい**: サービス・ツールのサムネイルが豊富です。
* **目的に応じて探せる**: 欲しい情報がすぐに探せるように、カテゴリ分けをしています。

## 対象ユーザとメリット

- [AtCoder](https://atcoder.jp/)ユーザ - 困ったことや不便なことが解決できるかもしれません。気になったサービス・ツールなどを使ってみましょう!

- 開発者 - 公開したサービスやツールなどの利用者が増えるだけでなく、ネタ探しや共同開発につながることも期待しています。

- [AtCoder](https://atcoder.jp/)運営チーム - 非公式サービス・ツールの全体像を踏まえ、公式として対応の有無を判断する材料の一つになると思います。また、企業向けの参考資料にもなるかもしれません。

- 企業の採用担当者 - [AtCoder](https://atcoder.jp/)ユーザの実務能力・ポテンシャルの評価材料の一つになると思います。ひいては人材発掘の効率化にも、つながるかもしれません。

---

## 最新情報を確認する

### AtCoder公式

<!-- markdown-link-check-disable -->

- [AtCoderInfo](https://info.atcoder.jp/) - [AtCoder](https://atcoder.jp/)の公式ポータルサイトです。コンテストの参加方法や取り組み方、採用担当者向け情報などが公開されています。

- [AtCoder生成AI対策ルール - 20241206版](https://info.atcoder.jp/entry/llm-rules-ja) - AtCoder Beginner Contest (通称 ABC) および AtCoder Regular Contest (同 ARC)のコンテスト開催中を対象として、生成AIの利用における禁止事項が説明されています ([英語版](https://info.atcoder.jp/entry/llm-rules-en))。
    - [生成AIの技術向上に伴うABCおよびARCにおけるルール変更について](https://atcoder.jp/posts/1347) - 上記のルール変更の背景、作成方針、概要、今後の変更の可能性について言及されています ([英語版](https://atcoder.jp/posts/1350))。
    - [ARCのDivision制に伴うルール変更について](https://atcoder.jp/posts/1368) - ARC の Division制の導入に伴うルールの変更点が紹介されています。

- [ARCのDivision制についての告知](https://atcoder.jp/posts/1364) - ARC189以降、AtCoder Regular Contest (通称 ARC) は難易度の異なる2種類のコンテストに分けられることが告知されています。

- [【重要なお知らせ】AtCoderを騙る偽サイトにご注意ください](https://atcoder.jp/posts/1268) - [AtCoder](https://atcoder.jp/)の偽サイトへのアクセス・ログインなどをしないように注意喚起している記事です。
- [AtCoderアカウントのパスワード管理について](https://atcoder.jp/posts/1366) - 不正アクセス防止のため、[AtCoder](https://atcoder.jp/)アカウントのパスワード確認・必要に応じて変更を促しています。

<!-- markdown-link-check-enable -->

### 非公式サービス・ツール・ライブラリ・記事など

直近1〜2週間の更新状況を掲載しています(ベータ版)。

=== "記事"

    2024-12-24

    - 「[コンテストに関する統計情報を見る](articles/view_scores)」ページ
        - [AtCoder Junior League 2024 Winter - 学校ランキング (12月24日時点)](https://x.com/atcoder/status/1871385196383375665)

    2024-12-23

    - 「[入門者・初心者向けの内容](articles/introduction)」ページ
        - [楽しい競技プログラミングの世界](https://drive.google.com/file/d/1Vu1_9VzPhMjiVKfJvCPUhmXBbkywG6co)

    2024-12-18

    - 「[競技プログラミングと就転職](articles/jobs)」ページ
        - [競プロ知識を現実の問題解決に応用する](https://qiita.com/shozawa/items/3394e346293ee008cd04)

    - 「[ヒューリスティック問題を解く](articles/heuristic)」ページ
        - [【競プロ】ヒューリスティックコンテストで戦うヒント](https://qiita.com/tanaka-a/items/ab1c1f539a826606dc65)

    2024-12-16

    - 「[コンテストに関する統計情報を見る](articles/view_scores)」ページ
        - [AtCoder Junior League 2024 Winter - 学校ランキング (12月16日時点)](https://x.com/atcoder/status/1868475958212387298)

    2024-12-14

    - 「[ヒューリスティック問題を解く](articles/heuristic)」ページ
        - [HACK TO THE FUTURE 2025 (AHC040) 解説](https://www.terry-u16.net/entry/ahc040)

    2024-12-11

    - 「[ヒューリスティック問題を解く](articles/heuristic)」ページ
        - [AutoSampler：Optunaの最適化アルゴリズムを自動選択する機能を公開](https://tech.preferred.jp/ja/blog/optuna-autosampler/)

=== "ブログ"
    アルゴリズム部門・ヒューリスティック部門におけるランキング上位の日本人ユーザのブログをまとめています(順不同)。

    2024-12-22

    - 「[ヒューリスティック部門 - C#](blogs/heuristic/csharp)」ページ
        - [chokudai](https://atcoder.jp/users/chokudai)さん - [はてなブログ](https://chokudai.hatenablog.com/)

=== "動画"

    2024-12-21

    - 「[YouTube - チャンネル](youtube/channel)」ページ
        - [Cαfe1942](https://www.youtube.com/playlist?list=PLWDxpG33dobEYiBtm06Gky8apePjny6mj)

    2024-12-17

    - 「[YouTube - 個別の動画](youtube/video)」ページ
        - [1分で国際数学オリンピックの1問目【ゆっくり解説】](https://www.youtube.com/watch?v=p_ETbKjVcyY)

=== "ライブラリ・スニペット"

    2024-12-22

    - 「[AtCoder Library (ACL)の各言語への移植](libraries/porting_of_acl)」ページ
        - [tatyam-prime/acl-cpp-python](https://github.com/tatyam-prime/acl-cpp-python) - ![GitHub stars](https://img.shields.io/github/stars/tatyam-prime/acl-cpp-python?style=plastic)

=== "色変記事"

    色変記事とは、コンテストの参加者が所定のレーティングに到達した喜びをつづった記事(動画も含む)のことです。

    2024-12-26

    - 「[レーティング2000〜2399(黄色)](milestones/yellow)」ページ
        - [blueberry1001](https://atcoder.jp/users/blueberry1001)さん - [【Atcoder】高校2年生でAtcoder黄色になりました](https://qiita.com/bluebery1001/items/3253399ebf287e197346)

    2024-12-20

    - 「[レーティング1600〜1999(青色)](milestones/blue)」ページ
        - [Cafe_j19419](https://atcoder.jp/users/Cafe_j19419)さん - [AtCoder Algorithm 入青記事](https://note.com/cafe_j19419/n/n26aa290b318a)

    2024-12-19

    - 「[レーティング2800〜(赤色、銅・銀・金王冠)](milestones/red)」ページ
        - [noshi91](https://atcoder.jp/users/noshi91)さん - [AtCoder で rating が 3200 に到達しました - noshi91のメモ](https://noshi91.hatenablog.com/entry/2024/12/18/171613)

    2024-12-12

    - 「[レーティング800〜1199(緑色)](milestones/green)」ページ
        - [kota1t](https://atcoder.jp/users/kota1t)さん - [初投稿&AtCoder入茶&入緑](https://qiita.com/Kota1t/items/23bd20c7eb59e47d68f0)

=== "国内外のコンテストサイト"

    2024-12-25

    - 「[ICPC (国際大学対抗プログラミングコンテスト)](related_contest_sites/icpc)」ページ
        - [ICPC 2024 横浜大会参加記](https://e869120.hatenablog.com/entry/2024/12/25/124746)

=== "アーカイブス"

    諸事情により提供・開発が終了した(と思われる)サービス・ツールなどに対して、感謝や敬意を表するため掲載しています。

    2024-12-22

    - Atcoder Clock

## AtCoder公式グッズを購入する

- [SUZURI](https://suzuri.jp/AtCoder) - [AtCoder](https://atcoder.jp/)のロゴ入りグッズが購入できる。

    <div align="center">
        <img loading = "lazy" src="images/web_app/suzuri.png" alt="suzuri">
    </div>

## 競プロLINEスタンプ・グッズ(非公式)を購入する

- [LINE STORE](https://store.line.me/stickershop/product/22113834/en) - [burioden](https://atcoder.jp/users/burioden)さんが作成・配信している競プロLINEスタンプ(非公式)。[第2弾](https://store.line.me/stickershop/product/22810021/en)、[第3弾](https://store.line.me/stickershop/product/22851268/en)、[第4弾](https://store.line.me/stickershop/product/25256215/en)もある。
    - [kyopro-neko](https://github.com/burioden/kyopro-neko) ![GitHub Repo stars](https://img.shields.io/github/stars/burioden/kyopro-neko?style=plastic) - 「競プロするねこ」のイラスト集。
        - [アドバイスするねこ](https://github.com/burioden/kyopro-neko/tree/main/advice_neko) - 同キャラクターが、さまざまなアドバイスをしてくれる。
    - [SUZURI](https://suzuri.jp/burioden) - 「競プロするねこ」のイラストが書かれたグッズを購入できる。

    <div align="center">
        <img loading = "lazy" src="images/unofficial_goods/kyopro_neko_ac.jpg" alt="kyopro neko ac" />
    </div>

## 本サービスのスポンサー(敬称略・順不同)

本サービスの開発・運営を応援してくださり、ありがとうございます。

[GitHub Sponsors](https://github.com/sponsors/KATO-Hiro)で寄付していただいた方には、いくつかの特典をご用意しております。

### 💚 AtCoder Clans Sponsor

- [chokudai](https://github.com/chokudai)

### 🌐 Domain Supporter

- [KoyanagiHitoshi](https://github.com/KoyanagiHitoshi)

### 🍨 Ice Cream Supporter

- ia7ck
- tomii9273
- toshi201

### 🙂 Special Supporter

- otsuneko
- yunix-kyopro
