---
title: プロジェクトの方針・方向性
---

## 目的

AtCoderに関連するサービス・ツール・ライブラリ・記事など網羅的にまとめ、最新の情報が閲覧できるようにします。

## 目標

- ユーザが必要な情報に短時間でアクセスできることを目指します。

## 背景

レポジトリ作成者がAtCoderを始めてしばらくしてから、こちらの[記事](https://noimin.hatenablog.com/entry/2017/12/16/230900)で便利なサービス・ツールを知り、感動しました。

こうした競技プログラミングに関する便利なサービス・ツール・学習資料をまとめた代表的な例として、
[Awesome Competitive Programming](https://github.com/lnishan/awesome-competitive-programming)があります。

ただ、上記のページでは更新頻度が大きく低下しており、最近公開されたサービス・ツールなどについては反映がされにくい状況です。

関連して、AtCoderの対象ユーザ層からすると、英語に対して苦手意識を持つ方も少なくないと思います。このため、優れたサービス・ツールが公開されていても、自分で調べるか・知人などに教えてもらわない限り知らない、という状況が発生します。また、開発者もしくはサービス・ツールの知名度が低いというだけで、ユーザの利用が進まないという事例が散見されるように感じています。こうした開発者と利用者の間に、言語や認知の壁があるように思いました。

そこで、AtCoderの非公式サービス・ツール・ライブラリ・記事などを**日本語**でまとめたリンク集を用意しました。AtCoderユーザ、サービス・ツールなどの開発者・執筆者、AtCoder運営チーム、企業の採用担当者それぞれに[メリット](../../)があると考えています。

## 概略

- 原則として、サービス・ツール・ライブラリ・記事などのご紹介(他薦を含む)をいただいた場合は、掲載いたします。

## 詳細

- 作者の意向を最優先いたします。
- 掲載の方針・基準は、以下の通りです。
    - 掲載する:
        - ユーザからご紹介(他薦を含む)をいただいた
        - 本サイトの運営者がユーザに紹介したいと思った など
    - 掲載しない:
        - 掲載お断り・転載不可などの記載や連絡があった
        - ユーザ・運営チームに不利益をもたらす可能性があると判断される場合 など
- 掲載の順序・分類方法は、以下の通りです。
    - 媒体(サービス・ツール・ライブラリ・記事など)
    - 目的・用途
    - 上記の分類で掲載数が多い場合は、類似した内容でカテゴリ分け
    - 同じカテゴリにおいては、アルファベット順もしくは五十音順 / 需要が多い順に並べる

## セキュリティ対策

使用しているライブラリ・ツールなどの更新があれば、随時反映させています。

## プライバシーへの配慮

[プライバシーポリシー](../../privacy_policy)をご参照ください。
