---
title: 書籍
---

## アルゴリズム部門

### 絵で視覚的に理解する

- [アルゴリズム図鑑 増補改訂版: 絵で見てわかる33のアルゴリズム](https://www.amazon.co.jp/dp/479817243X/) - アルゴリズムが絵で説明されており、雰囲気をつかむのに向いている。スマートフォンアプリ([Android](https://play.google.com/store/apps/details?id=wiki.algorithm.algorithms&hl=ja)、[iOS](https://apps.apple.com/jp/app/%E3%82%A2%E3%83%AB%E3%82%B4%E3%83%AA%E3%82%BA%E3%83%A0%E5%9B%B3%E9%91%91/id1047532631))だと無料で読むことができる。

    !!! warning "注意"

        コードを書くときは、別の書籍を読む必要がある。


- [アルゴリズム ビジュアル大事典](https://www.amazon.co.jp/%E3%82%A2%E3%83%AB%E3%82%B4%E3%83%AA%E3%82%BA%E3%83%A0-%E3%83%93%E3%82%B8%E3%83%A5%E3%82%A2%E3%83%AB%E5%A4%A7%E4%BA%8B%E5%85%B8-%E6%B8%A1%E9%83%A8-%E6%9C%89%E9%9A%86-ebook/dp/B085VHBD3W/ref=tmm_kin_swatch_0?_encoding=UTF8&qid=&sr=) - アルゴリズム・データ構造の計算方法と結果をビジュアル的に捉えることができる書籍。スマートフォンのカメラで、[QRコードにアクセスするとアルゴリズム・データ構造に関するアニメーションが閲覧できるページ](https://yutaka-watanobe.github.io/star-aida/books/)もある。
- [なっとく！アルゴリズム](https://www.amazon.co.jp/%E3%81%AA%E3%81%A3%E3%81%A8%E3%81%8F%EF%BC%81%E3%82%A2%E3%83%AB%E3%82%B4%E3%83%AA%E3%82%BA%E3%83%A0-%E3%82%A2%E3%83%87%E3%82%A3%E3%83%86%E3%82%A3%E3%82%A2%E3%83%BBY%E3%83%BB%E3%83%90%E3%83%BC%E3%82%AC%E3%83%90-ebook/dp/B01N14WBX3/ref=tmm_kin_swatch_0?_encoding=UTF8&qid=1594869441&sr=8-1) - 解説の丁寧さと図の豊富さが特徴。

    !!! warning "注意"

        サンプルコードがPython2(公式のサポート終了)で書かれているため、print文などはPython3の書き方を調べる必要がある。

### コンテストで頻出・典型的な知識を習得する

- [アルゴリズム的思考力が身につく! プログラミングコンテストAtCoder入門](https://www.amazon.co.jp/dp/404604408X/) - [drken](https://atcoder.jp/users/drken)さんによる書籍の第3弾(通称、AtCodeer本)。記事「[AtCoderに登録したら次にやること ～ これだけ解けば十分闘える！過去問精選10問 ～](https://qiita.com/drken/items/fd4e5e3630d0f5859067)」を単行本化したAtCoderの入門書。C++とPythonの文法、AtCoder Beginner Contest (通称、ABC)のC問題を解くための典型的な知識などが習得できる。
    - [著者の紹介記事](https://drken1215.hatenablog.com/entry/atcodeer) - 書籍のコンセプト・内容・想定読者が紹介されている。
- [最強最速アルゴリズマー養成講座 プログラミングコンテストTopCoder攻略ガイド](https://www.amazon.co.jp/dp/B00E4FW2TE/ref=dp-kindle-redirect?_encoding=UTF8&btkr=1) - 通称、チーター本。著者が[AtCoder](https://atcoder.jp/)社長[chokudai](https://twitter.com/chokudai)さんの書籍。
- [プログラミングコンテスト攻略のためのアルゴリズムとデータ構造](https://www.amazon.co.jp/%E3%83%97%E3%83%AD%E3%82%B0%E3%83%A9%E3%83%9F%E3%83%B3%E3%82%B0%E3%82%B3%E3%83%B3%E3%83%86%E3%82%B9%E3%83%88%E6%94%BB%E7%95%A5%E3%81%AE%E3%81%9F%E3%82%81%E3%81%AE%E3%82%A2%E3%83%AB%E3%82%B4%E3%83%AA%E3%82%BA%E3%83%A0%E3%81%A8%E3%83%87%E3%83%BC%E3%82%BF%E6%A7%8B%E9%80%A0-%E6%B8%A1%E9%83%A8-%E6%9C%89%E9%9A%86-ebook/dp/B00U5MVXZO/ref=sr_1_3?__mk_ja_JP=%E3%82%AB%E3%82%BF%E3%82%AB%E3%83%8A&dchild=1&keywords=%E3%82%A2%E3%83%AB%E3%82%B4%E3%83%AA%E3%82%BA%E3%83%A0&qid=1589179447&s=digital-text&sr=1-3) - 通称、螺旋本。後述する蟻本と比べると初心者向け。基本的なアルゴリズムが詳しく解説されている。
- [問題解決力を鍛える!アルゴリズムとデータ構造](https://www.amazon.co.jp/dp/4065128447/) - [drken](https://atcoder.jp/users/drken)さんによる書籍(通称、けんちょん本)。後述する蟻本を読み進めるための基礎が学べる。
    - [内容や難易度の詳細](https://drken1215.hatenablog.com/entry/2020/08/10/041137)
    - [書籍に掲載されているソースコードや章末問題の略解](https://github.com/drken1215/book_algorithm_solution)
    - [yuk1ty/book-algorithm-solution](https://github.com/yuk1ty/book-algorithm-solution) ![GitHub Repo stars](https://img.shields.io/github/stars/yuk1ty/book-algorithm-solution?style=plastic) - 有志が本文のソースコード(C++)をPythonで書き直している。
- [競技プログラミングの鉄則 ~アルゴリズム力と思考力を高める77の技術~](https://www.amazon.co.jp/dp/483997750X) - [E869120](https://atcoder.jp/users/E869120)さんによる書籍の第2弾。アルゴリズムや思考テクニックを学ぶことができる。豊富なオリジナル問題やヒューリスティック最適化への対応などが特徴。
    - [書籍「競技プログラミングの鉄則」を書きました](https://e869120.hatenablog.com/entry/2022/09/08/214552) - 著者による書籍の内容と想定読者の説明。
    - [【発売即重版】書籍『競技プログラミングの鉄則』を著者が解説](https://www.youtube.com/watch?v=iZ_-sGVHBVg) - 著者による書籍の解説動画。視聴者からの質問・回答コーナーもある。
    - [『競技プログラミングの鉄則』序盤20,000文字+目次を無料公開します！](https://e869120.hatenablog.com/entry/2022/11/01/224639) - 著者が書籍の目次と序章・第1章を無料で公開している記事。
    - [E869120/kyopro-tessoku](https://github.com/E869120/kyopro-tessoku) ![GitHub Repo stars](https://img.shields.io/github/stars/E869120/kyopro-tessoku?style=plastic) - ソースコード(C++、Python、Java)、節末問題・力試し問題の解答、正誤表が掲載されている。
    - [競技プログラミングの鉄則　演習問題集](https://atcoder.jp/contests/tessoku-book) - [AtCoder](https://atcoder.jp/)の自動採点システムで、書籍に掲載されている問題を解くことができる。
        - [演習問題のテストケース](https://www.dropbox.com/sh/nx3tnilzqz7df8a/AABh1dWn9MpTS1XX_t3_2nHfa/tessoku-book)
    - [有志による紹介動画](https://twitter.com/kaede20203/status/1570163622755827713) - [kaede2020](https://atcoder.jp/users/kaede2020)さんが、書籍の7章「ヒューリスティック」の概要を紹介している。
    - [有志による書評](https://zenn.dev/reputeless/articles/idea-tessoku-review) - [Ryo Suzuki](https://twitter.com/reputeless)さんによる書評。
- [プログラミングコンテストチャレンジブック [第2版] ～問題解決のアルゴリズム活用力とコーディングテクニックを鍛える～](https://www.amazon.co.jp/dp/B00CY9256C/ref=dp-kindle-redirect?_encoding=UTF8&btkr=1) - 通称、蟻本。初級編からかなり難しいが、典型的なアルゴリズムと考え方が収録されている。

    !!! info "参考"

        解説がとてもシンプル、かつ、第2版発行からやや時間が経過していることから、Web記事・解説ブログとともに参照することを推奨。

### 幅広い分野の基礎を学ぶ

- [Pythonで学ぶアルゴリズムとデータ構造](https://www.amazon.co.jp/dp/B084G23P7N) - アルゴリズム・データ構造をPythonで学ぶための入門書。ソート・データの探索・グラフ理論・動的計画法・計算量に加えて、乱択アルゴリズム・数論や社会への応用例など幅広い話題が解説されている。
    - [ソースコード](https://github.com/tsjshg/pyalgdata) ![GitHub Repo stars](https://img.shields.io/github/stars/tsjshg/pyalgdata?style=plastic)

### 特定の分野を重点的に学ぶ

- [Open Data Structures](https://sites.google.com/view/open-data-structures-ja) - データ構造に関する入門書。ソースコードが[GitHub](https://github.com/spinute/ods)で公開されている。
- [高校数学の基礎が150分でわかる本](https://www.amazon.co.jp/dp/4478117802/) - [E869120](https://atcoder.jp/users/E869120)さんが執筆した高校数学の入門書。フルカラーの図解、中学数学のサポート、実用的な具体例、穴埋め式の演習問題が用意されていることに加え、気軽に読めることが特徴。
    - [著者の紹介記事](https://e869120.hatenablog.com/entry/2023/07/05/224456) - 書籍の内容および特徴・想定読者などが紹介されている。

### 他分野とのコラボ

- [問題解決のための「アルゴリズム×数学」が基礎からしっかり身につく本](https://www.amazon.co.jp/dp/4297125218/) - [E869120](https://atcoder.jp/users/E869120)さんによる書籍(略称: 「アルゴリズム×数学」本、または、#アルゴ数学本([出典](https://twitter.com/e869120/status/1477948316805922817)))。有名アルゴリズムの紹介だけでなく、関連する数学的知識・アルゴリズムの活用に向けた数学的考察についても解説されている。
    - [書籍の詳細な内容や想定読者](https://e869120.hatenablog.com/entry/2021/12/02/225743)
    - [ソースコード(C++、Python、Java、C)・問題の解答・正誤表](https://github.com/E869120/math-algorithm-book)
    - [AtCoderの自動採点システムを利用して演習問題を解く](https://atcoder.jp/contests/math-and-algorithm) - 書籍に掲載されているプログラミング問題が[AtCoder](https://atcoder.jp/)で解くことができる。
        - [E869120本をSwiftで解く(問題58-90)](https://qiita.com/b150005/items/4c19bf6779060571d58d) - 有志によるSwiftでの解答例。
    - [執筆体験記](https://e869120.hatenablog.com/entry/2021/12/30/210649) - 著者が、書籍を書くことになったきっかけから出版までの過程を振り返った記事。
- [パズルで鍛えるアルゴリズム力](https://www.amazon.co.jp/%E3%83%91%E3%82%BA%E3%83%AB%E3%81%A7%E9%8D%9B%E3%81%88%E3%82%8B%E3%82%A2%E3%83%AB%E3%82%B4%E3%83%AA%E3%82%BA%E3%83%A0%E5%8A%9B-%E5%A4%A7%E6%A7%BB-%E5%85%BC%E8%B3%87/dp/4297126796) - [drken](https://atcoder.jp/users/drken)さんによる書籍の第2弾。有名なパズル(数独・虫食い算・迷路など)を題材に、アルゴリズムの考え方を学ぶことができる。
    - [著者の紹介記事](https://drken1215.hatenablog.com/entry/2022/04/13/224634) - 書籍の内容・想定読者・伝えたいメッセージなどが紹介されている。
    - [パズルのソルバーと解答、正誤表](https://github.com/drken1215/book_puzzle_algorithm)

### 情報オリンピック・国際大学対抗プログラミングコンテストに参加する

- [JOI公式テキスト Pythonで問題解決 情報オリンピックに出てみよう](https://www.jikkyo.co.jp/book/detail/22510044) - 日本情報オリンピック(JOI: Japanese Olympiad in Informatics)の公式テキスト。Pythonの基礎的な文法から二次予選の攻略までに必要な知識を学ぶことができる。
    - [書籍の紹介と便利リンク集](https://pro-ktmr.github.io/joi-text/)
    - [公式解説動画](https://www.youtube.com/channel/UCI_npX8-fWv235zqCj8Oa9w)
    - [PyTry](https://pro-ktmr.github.io/pytry/) - 競技プログラミング初心者向けのPython実行環境。
- [競技プログラマーハンドブック](https://github.com/recuraki/cphb-ja) ![GitHub Repo stars](https://img.shields.io/github/stars/recuraki/cphb-ja?style=plastic) - [Competitive Programmer’s Handbook](https://cses.fi/book/book.pdf)の和訳。基本的なアルゴリズムから発展的な内容まで幅広く扱われている。主な想定読者は、国際情報学オリンピック（IOI）や国際大学対抗プログラミングコンテスト（ICPC）への参加を考えている学生。

### アルゴリズム実技検定を受ける

- [アルゴリズム実技検定 公式テキスト[エントリー~中級編]](https://www.amazon.co.jp/gp/product/483997277X/ref=as_li_ss_tl?ie=UTF8&linkCode=sl1&tag=rust-twitter-22&linkId=f436393e211c3e53630445f04c8d65c9&language=ja_JP) - [betrue12](https://atcoder.jp/users/betrue12)さんと[kenkoooo](https://atcoder.jp/users/kenkoooo)さんによる書籍(通称、PAST本)。「アルゴリズム実技検定(PAST)」初の公式テキスト。
    - [著者のブログ](https://betrue12.hateblo.jp/entry/2021/02/20/123103) - 書籍の特徴・解説の範囲・使用言語などが紹介されている。
    - [解答例](https://github.com/kenkoooo/pastbook-source-code)
- [アルゴリズム実技検定 公式テキスト[上級～エキスパート編]](https://www.amazon.co.jp/dp/4839979499) - PAST本の続編。著者は、[drken](https://atcoder.jp/users/drken)さん、[tsutaj](https://atcoder.jp/users/tsutaj)さん、[kenkoooo](https://atcoder.jp/users/kenkoooo)さん。
    - [tsutaj/pastbook-2-source-code](https://github.com/tsutaj/pastbook-2-source-code) ![GitHub Repo stars](https://img.shields.io/github/stars/tsutaj/pastbook-2-source-code?style=plastic) - ソースコード(C++、Python)とリンク集が掲載されている。

## ヒューリスティック部門

- [ゲームで学ぶ探索アルゴリズム実践入門～木探索とメタヒューリスティクス](https://www.amazon.co.jp/dp/4297133601/) - 探索アルゴリズムを体系的に学ぶことができる入門書。想定読者は、自作ゲームでCPU(対戦AI)を作成したい人やコンテスト(ゲームAI・ヒューリスティック型)に参加したい人。
    - [thunder本をRustで書いてみた(Greedyまで)](https://zenn.dev/tipstar0125/articles/59f845d3670470) - 有志が本文のソースコード(C++)をRustで実装している記事。
    - [「ゲームで学ぶ探索アルゴリズム実践入門」のサンプルコードでAtCoderの問題を解いてみた](https://qiita.com/thun-c/items/c5c2c7295f884cd0355c) - 筆者が同書のサンプルコードを利用して、コンテストの過去問を解く過程を解説している。
    - [数字集め迷路](https://thun-c.github.io/one_player_maze/one_player_maze.html) - 同書に掲載されているオリジナルゲームで遊ぶことができる。
- [メタヒューリスティクスの数理](https://www.amazon.co.jp/dp/B0C36F5TJY) - メタヒューリスティクス(難易度の高い最適化問題を解くための経験的手法を有機的に結合させたもの)の手法がうまく働く理由を数理的に説明している書籍。
- [Design of Heuristic Algorithms for Hard Optimization](https://link.springer.com/book/10.1007/978-3-031-13714-3) - 巡回セールスマン問題を題材に、主要なヒューリスティック・メタヒューリスティックスに関する手法がシンプルかつ厳密に解説されている。
- [Optunaによるブラックボックス最適化](https://www.amazon.co.jp/dp/4274230104) - 機械学習に不可欠なハイパーパラメータ調整を自動化するブラックボックス最適化を分かりやすく・詳しく説明した入門書。

## 小説

- [アルゴリズムの乙女たち](https://www.amazon.co.jp/dp/4198949344) - 競技プログラミングの全国大会出場を目指す大学生たちの姿を描いた小説。
- [ようこそ、競プロの世界へ！～異世界転生～](https://kakuyomu.jp/works/1177354054890434440) - 競技プログラミングの世界に転生した高校生を描いた小説。
