---
title: プログラミング言語を学ぶ
---

## C&#43;&#43;

- [C++入門 AtCoder Programming Guide for beginners (APG4b)](https://atcoder.jp/contests/APG4b) - [AtCoder](https://atcoder.jp/)公式が提供する汎用的なプログラミングの基礎を学ぶための入門教材。また、知識の定着を図るための練習問題と自分で書いたプログラムを自動で採点してくれるシステムがあるのが大きな特徴。
- [実践C++入門講座](https://theolizer.com/cpp-school-root/cpp-school/) - C++の解説記事。概念を理解するのが難しい内容やバグを埋め込みやすい点とその対処方法について、丁寧に解説されている。

    !!! warning "注意"
        実行環境を用意する部分に関しては記載内容が古くなっているため、最新の情報を調べる必要がある。

- [競プロのための標準 C++](https://zenn.dev/reputeless/books/standard-cpp-for-competitive-programming) - C++の主要な標準機能について、解説とサンプルがまとめられているオンラインドキュメント。
- [cpprefjp - C++日本語リファレンス](https://cpprefjp.github.io/) - C++のリファレンスを日本語で提供するWebサイト。サンプルコードも用意されている。
- [Google C++ スタイルガイド 日本語全訳](https://ttsuki.github.io/styleguide/cppguide.ja.html) - 「Google C++ Style Guide」の日本語訳。

    !!! warning "注意"
        C++のチュートリアルではなく、スタイルガイドであることに留意されたい。

- [isocpp/CppCoreGuidelines](https://github.com/isocpp/CppCoreGuidelines) ![GitHub Repo stars](https://img.shields.io/github/stars/isocpp/CppCoreGuidelines?style=plastic) - C++に関するガイドライン、ルール、ベストプラクティスをまとめたドキュメント。

    !!! info "参考"
        インターフェース、リソースおよびメモリの管理、並行処理など比較的高度な問題に焦点をあてているのが特徴。

## Fortran

- [Fortran入門(Fortran版APG4b)](https://qiita.com/jj1guj/items/43a1c876360ddf180f1f) - プログラミングの入門教材「[C++入門 AtCoder Programming Guide for beginners (APG4b)](https://atcoder.jp/contests/APG4b)」のFortran版。

## Haskell

- [AtCoder ガチ言語 Haskell 🔥](https://zenn.dev/toyboot4e/books/seriously-haskell) - AtCoderを通して、Haskellの基礎とアルゴリズムを同時に学ぶことができる。

## Kotlin

<!-- markdown-link-check-disable -->

- [Competitive Programming](https://kotlinlang.org/docs/tutorials/competitive-programming.html) - 競技プログラミングにおいて、[Kotlin](https://kotlinlang.org/)で参加する方法を解説した公式チュートリアル。

<!-- markdown-link-check-enable -->

## Python

- [1日で基本が身につく! Python超入門](https://speakerdeck.com/yuichi110/1ri-deji-ben-gashen-nituku-pythonchao-ru-men) - Pythonの基礎文法が分かりやすく解説されているスライド資料。さらに、レベル別のプログラミング上達方法なども紹介されている。
- [Python-izm](https://www.python-izm.com/) - Pythonの習得を目的としたWebサイト。入門編、基礎編、応用編などに分かれている。
- [Python入門（Python版 APG4b）](https://qiita.com/saba/items/b9418d7b54cce4b106e4) - プログラミングの入門教材「[C++入門 AtCoder Programming Guide for beginners (APG4b)](https://atcoder.jp/contests/APG4b)」のPython版。

## Rust

- [RustCoder ―― AtCoder と Rust で始める競技プログラミング入門](https://zenn.dev/toga/books/rust-atcoder) - AtCoderのジャッジシステムを利用して、プログラミング言語Rustを解説している。
- [atcoder-rust-resources](https://doc.rust-jp.rs/atcoder-rust-resources/) - コンテストにRustで参加するためのガイドブック。

    !!! warning "注意"
        現在は、日本語のみ対応。また、執筆途中の項目もある。
