---
title: 入門者・初心者向けの内容
---

アルゴリズム・競技プログラミングに関する入門者・初心者向けの記事を掲載しています。

## アルゴリズム・競技プログラミングの布教記事を読む

### アルゴリズムとは?

- [50分で学ぶアルゴリズム](https://speakerdeck.com/e869120/algorithms-in-50-minutes) - アルゴリズムの概略について、身近な例とともに分かりやすく解説されている。
- [アルゴリズムとは何か！？ ～ 文系理系問わず楽しめる精選6問 ～](https://qiita.com/drken/items/f909b79ee03e679c7142) - [drken](https://atcoder.jp/users/drken)さんによる記事。アルゴリズムとは何か?という疑問に対して、平易で分かりやすい文章と図表を駆使して解説されている。また、アルゴリズムを学ぶ意義・メリットについても書かれている。
- [アルゴリズムの世界地図](https://qiita.com/square1001/items/6d414167ca95c97bd8b2) - アルゴリズムを7つのカテゴリーに分けて俯瞰的に紹介されている記事。各カテゴリーの概観と解けるようになる問題の紹介に力点が置かれているが特徴。

### 競技プログラミングとは?

- [初心者こそ、競技プログラミングに挑戦してほしい。髙橋直大の「世界にAtCoderを広める」という夢](https://persol-tech-s.co.jp/i-engineer/human/atcoder) - [AtCoder](https://atcoder.jp/)社長の[chokudai](https://twitter.com/chokudai)さんが、プログラミング初心者に競技プログラミングを勧めている記事。また、同氏がプログラミングと出会ったきっかけ・競技プログラミングの魅力・会社設立に至った経緯なども語られている。
    - [日本最大のプログラミングコンテストサイト AtCoder　全世界での登録者数が70万人を突破！](https://prtimes.jp/main/html/rd/p/000000052.000028415.html) - AtCoderの登録者数が70万人（2024年10月現在）を突破したことを報告している。競技プログラミングにおける国際大会の変化や世界トッププレイヤーのコメントが紹介されている。
- [競技プログラミングことはじめ](https://speakerdeck.com/e869120/20221122-jing-ji-puroguramingukotohazime) - 競技プログラミングに関連する教育コンテンツを多数作成されている[E869120](https://atcoder.jp/users/E869120)さんのスライド。基本的な説明から、コンテストサイト[AtCoder](https://atcoder.jp/)の登録方法・問題の解き方・求められるスキルなどが紹介されている。
    - [楽しい競技プログラミングの世界](https://drive.google.com/file/d/1Vu1_9VzPhMjiVKfJvCPUhmXBbkywG6co) - 生成AI時代に競技プログラミングに取り組む意義、上達方法などがまとめられているスライド。
    - [Let’s 競技プログラミング! E8さんが教える アルゴリズム発想のキホン](https://news.mynavi.jp/techplus/series/algorithm/) - 同名の著者によるアルゴリズムの紹介・解説記事(全24回)。

        !!! warning "注意"
            全文を読むには、会員登録が必要。

- [競プロのすすめ](https://speakerdeck.com/uya116/jing-purofalsesusume) - 競技プログラミングの概要と例題、コンテストの参加手順などが紹介されている。
- [やってみよう競技プログラミング](https://docs.google.com/presentation/d/1N5MTwRdZPCtUwTwQTajOwkyEvHWSSiRl8xIx-BPfOl0/view#slide=id.p) - 競技プログラミングそのものの説明から、コンテストの参加にまつわるアンチパターンとオススメの練習方法が解説されている。
- [122人に聞いた！「競技プログラミングを始めたばかりの人に伝えたいこと」](https://qiita.com/sakofsuken/items/6194f8ee83b40749c0e4) - 「競技プログラミングを始めたばかりの人に伝えたいこと」について、筆者を含む122人のアンケート結果(回答者属性・競技プログラミング(競プロ)を始めたきっかけ・競プロをおすすめしたい人・アドバイスなど)がまとめられている記事。
- [競プロのエコシステムについて](https://blog.hamayanhamayan.com/entry/2021/12/10/223827) - 競技プログラミングを構成する要素・グループを俯瞰的な視点からまとめた記事。各カテゴリ(コンテストサイト、就活/転職サイト・検定、年次コンテスト、コミュニティ、有志によるサービス・アプリ・解説ブログ、書籍)の特徴・代表的な内容が紹介されている。

### 中学生・高校生向け

- [情報オリンピックへのいざない　～日本一の競技プログラマーを決める戦い～](https://qiita.com/e869120/items/43181c2084e6e5337ca9) - 主に高校生以下を対象としたコンテストである「情報オリンピック」の説明から、大会の面白さ・上位に入るためテクニックを解説した記事。高専・大学生以上の人にも一読の価値があると思われる。
- [中高生向け 学校対抗競技プログラミング「AtCoder Junior League2023」を開催](https://prtimes.jp/main/html/rd/p/000000037.000028415.html) - 中高生を対象として、2023年5月〜12月のコンテストの成績に基づいた学校・個人のランキングが作成されることを紹介した記事。中学・高校での競技プログラミングの普及、同世代で切磋琢磨できる環境と交流の機会の確保、教員による認知・応援を目的としている。
    - [AtCoder Junior League 2024](https://atcoder.jp/contests/ajl2024) - [AtCoder](https://atcoder.jp/)の特設ページ。
    - [中高生向け 学校対抗競技プログラミング「AtCoder Junior League 2024 Summer」入賞校・入賞者を発表](https://prtimes.jp/main/html/rd/p/000000051.000028415.html) - 入賞校・入賞者が公表されている。
    - [日本最大のプログラミングコンテストサイトAtCoder　中高生に特化した学校対抗リーグ「AtCoder Junior League」開催にかける思いとは](https://prtimes.jp/story/detail/zrELeosmk4x) - [AtCoder](https://atcoder.jp/)社長の[chokudai](https://twitter.com/chokudai)さんとAtCoder Junior League (AJL) 運営担当者である[kaede2020](https://atcoder.jp/users/kaede2020)さんへの取材記事。中高生に特化した部門が設置された背景・狙い、2023年9月上旬時点での参加状況、今後の展望などが語られている。

### 社会人向け

- [数学得意じゃない系の社会人エンジニアに競プロとAtCoderを全力で布教したい。あるいは競プロのよくある誤解と楽しむコツ](https://note.com/kirimin_chan/n/n821560df3165) - [kirimin](https://atcoder.jp/users/kirimin)さんが、社会人エンジニアに競技プログラミングを勧めている記事。自身の経験から、競技プログラミングの面白さ、コンテストの出題傾向、心構え(レーティングとの付き合い方、業務で求められる知識との違い)などを紹介している。
- [社会人からはじめる競技プログラミング](https://qiita.com/tutuz/items/2a81e7b5f30b28e28377) - 競技プログラミングのうち、アルゴリズムに関するコンテストに焦点を当てて、その面白さや役に立つ点を紹介した記事。
- [競技プログラミング入門者の成長のためのメモ](https://qiita.com/masakinihirota/items/d1ffac54e70a1adf084c) - 競技プログラミングを始めるにあたって、チーム開発との違い、目標設定の重要性、言語や各種ツールの選定、コンテストサイトの紹介、学習方法など幅広い内容について解説されている。

## AtCoderアカウントの登録〜コンテスト参加

- [【初心者向け】AtCoder Beginner Contestの取り組み方](https://qiita.com/rute_not_route/items/d1ae32a80d1c3a50d017) - [AtCoder](https://atcoder.jp/)アカウントの作成方法からコンテストの参加登録・問題の取り組み方と注意事項、コンテスト後の復習までの流れを丁寧に解説した記事。
- [AtCoderに登録したら次にやること ～ これだけ解けば十分闘える！過去問精選10問 ～](https://qiita.com/drken/items/fd4e5e3630d0f5859067) - [drken](https://atcoder.jp/users/drken)さんによる、[AtCoder](https://atcoder.jp/)のコンテストに初めて参加する方に向けた精選10問。さまざまな言語による解答例のリンクなどの資料も充実している。

    <details>
      <summary>各言語で実装された解答例のリンクを開く/閉じる</summary>
      <ul>
        <li><a href="https://qiita.com/cielavenir/items/ee1e47b844d05dcfc66e">C</a></li>
        <li><a href="https://qiita.com/tomerun/items/23ce2a2ed6ead291d222">Crystal</a></li>
        <li><a href="https://qiita.com/NotFounds/items/7b166af69a6f52a332de">C#</a></li>
        <li><a href="http://takeo1116.sakura.ne.jp/ABS_D.html">D</a></li>
        <li><a href="https://qiita.com/koyo-miyamura/items/9f224a3e56ea75939dca">Elixir</a></li>
        <li><a href="https://yukiutaai.wordpress.com/2018/03/21/atcoder%e3%81%ab%e7%99%bb%e9%8c%b2%e3%81%97%e3%81%9f%e3%82%89%e8%a7%a3%e3%81%8f%e3%81%b9%e3%81%8d%e7%b2%be%e9%81%b8%e9%81%8e%e5%8e%bb%e5%95%8f10%e3%82%92fortran%e3%81%a7%e8%a7%a3%e3%81%84%e3%81%a6/">Fortran</a></li>
        <li><a href="https://qiita.com/kuuso1/items/606b75c172cafa1d07f6">F#</a></li>
        <li><a href="https://qiita.com/ktateish/items/afdda77497c8e2ee0742">Go</a></li>
        <li><a href="https://qiita.com/hsjoihs/items/25a08b426196ab2b9bb0">Haskell</a></li>
        <li><a href="https://qiita.com/0x841/items/0ce887c86cf081312a08#">Java</a></li>
        <li><a href="https://qiita.com/ytanto/items/caf7bf0ba287da81b20f">JavaScript</a></li>
        <li><a href="https://sites.google.com/view/ymatsux/atcoder-abs-kotlin">Kotlin</a></li>
        <li><a href="https://qiita.com/Kutimoti_T/items/635bacddfa1304de40db">Nim</a></li>
        <li><a href="https://qiita.com/kotatsugame/items/dd73cf6441b17f27bb01">Perl6 (Raku)</a></li>
        <li><a href="https://qiita.com/rock619/items/3c4cc60416c94d081c54">PHP</a></li>
        <li><a href="http://delta114514.hatenablog.jp/entry/2018/03/15/014555">Python3</a></li>
        <li><a href="https://qiita.com/d_nishiyama85/items/f79e034f6dcd4175cdc1">Ruby</a></li>
        <li><a href="https://qiita.com/tubo28/items/e6076e9040da57368845">Rust</a></li>
        <li><a href="https://qiita.com/kgtkr/items/9b5798d02563e885d2ac">Scala</a></li>
        <li><a href="https://qiita.com/cielavenir/items/b90a94dce60a620fa2dc">Swift</a></li>
      </ul>
    </details>

    !!! warning "注意"
        記事に掲載されているコードが最新のジャッジシステムで動作しない場合もある。

- [競プロの問題文、言葉遣いについて](https://atcoder.jp/contests/abc273/editorial/5044) - 競技プログラミングの初心者に向けて、問題文・言葉遣いを解釈する方法が紹介されている記事。

## 練習で実力を伸ばす

### 練習方法を知る

#### C&#43;&#43;

- [APG4bからAtCoderを始めた人向けの導線](https://mogurin1000000007.hatenablog.com/entry/2021/02/09/162158) - [AtCoder](https://atcoder.jp/)が提供するプログラミングの入門教材[C++入門 AtCoder Programming Guide for beginners (APG4b)](https://atcoder.jp/contests/APG4b)の概説と、APG4bをある程度学習した人に向けた基本的な練習方法やTipsが紹介されている記事。

#### Python

- [Python入門 AtCoder Programming Guide for beginners (APG4bPython)](https://atcoder.jp/contests/APG4bPython) - [AtCoder](https://atcoder.jp/)が提供している、Pythonで競技プログラミングを始める人向けの入門教材。
- [【Python版】AtCoder を始めた方必見！とりあえず見てください！](https://qiita.com/ryusuke920/items/4a3bf6cd07d4df39c06e) - [AtCoder](https://atcoder.jp/)およびPythonを始めた人に向けて書かれた記事。競技プログラミングの概要、コンテストの種類と難易度、Pythonにおける標準的な入出力、過去問のサンプル、筆者のおすすめのWebサービス・ツールなどについて紹介されている記事。
    - [AtCoderで始めるPython入門](https://qiita.com/KoyanagiHitoshi/items/3286fbc65d56dd67737c) - [AtCoder](https://atcoder.jp/)で開催されているAtCoder Beginner Contest (ABC)のA問題、B問題をPython(3.8.2)で解くための解説記事。

---

<div align="center">
    <a href="../programming_languages">もっと読む</a>
</div>

### 上達のコツを知る

- [レッドコーダーが教える、競プロ・AtCoder上達のガイドライン【初級編：競プロを始めよう】](https://qiita.com/e869120/items/f1c6f98364d1443148b3) - [AtCoder](https://atcoder.jp/)でレッドコーダーの[E869120](https://atcoder.jp/users/E869120)さんによる記事。初心者に向けて競技プログラミングの特徴・面白さ、アカウントの登録方法やレーティングの説明がされている。さらに、上達するためのガイドラインが丁寧に解説されている。
    - [中級編](https://qiita.com/e869120/items/eb50fdaece12be418faa)
    - [上級編](https://qiita.com/e869120/items/acba3dd8649d913102b5)
    - [精選100+50問チャレンジシート](https://terumiyake.hatenablog.com/entry/2020/08/01/131528) - [TeruMiyake](https://atcoder.jp/users/TeruMiyake)さんが作成・公開。
- [現役高校生が、AtCoderでレッドコーダーになるまでにやってきたこと。プログラミング上達の秘訣を全て教えます](https://engineer-lab.findy-code.io/redcoder) - [E869120](https://atcoder.jp/users/E869120)さんが、競技プログラミングを通して得た経験を共有するために書かれた記事。競技プログラミングやアルゴリズムの面白さ、上達するための練習方法、参考資料などが紹介されている。

---

<div align="center">
    <a href="../how_to_practice">もっと読む</a>
</div>

### 典型的なアルゴリズム・考え方を学ぶ

!!! info "参考"
    中・上級者向けの内容も含まれています。

    難しすぎる内容だと思ったときは、[複数の解説](../algorithm)を読んだり、少し時間を置いて読み直してみたりみましょう。

- [AtCoder Daily Training](https://atcoder.jp/contests/adt_top) - [AtCoder](https://atcoder.jp/)公式が提供を予定しているAtCoder Beginner Contestの練習用バーチャルコンテスト（コンテストに仮想的に参加できる機能）。過去に出題された問題を対象として、複数の難易度・日時から選択して参加できる。
- [競プロ典型90問](https://twitter.com/e869120/status/1376089196100653060) - 競技プログラミング・アルゴリズムに関する教育的な問題が[常設コンテスト](https://atcoder.jp/contests/typical90)としてまとめられている。
    - 補助資料
        - [Qiita](https://qiita.com/e869120/items/1b2a5f0f07fd927e44e9) - コンテンツの活用方法
        - [GitHub](https://github.com/E869120/kyopro_educational_90) - 解説やサンプルコード
        - [Googleスプレッドシート](https://docs.google.com/spreadsheets/d/1GG4Higis4n4GJBViVltjcbuNfyr31PzUY_ZY1zh2GuI/edit#gid=0) - 非公式の難易度表
    - [E869120](https://atcoder.jp/users/E869120)さんによる企画・運営の振り返り
        - [企画レポート 〜104日間の軌跡〜](https://drive.google.com/file/d/1YCRma2mD79njHtP88_FiB9ozdhnfEfpz/view)
        - [表彰式・閉会式](https://www.youtube.com/watch?v=CIuTD1Igo1M)
    - 有志による実装例
        - [C++17](https://github.com/Reputeless/tenkei_90) ![GitHub Repo stars](https://img.shields.io/github/stars/Reputeless/tenkei_90?style=plastic)
        - [Java](https://github.com/NASU41/tenkei90) ![GitHub Repo stars](https://img.shields.io/github/stars/NASU41/tenkei90?style=plastic)
        - [Python](https://github.com/ryusuke920/kyopro_educational_90_python) ![GitHub Repo stars](https://img.shields.io/github/stars/ryusuke920/kyopro_educational_90_python?style=plastic)

- [AtCoder版！蟻本 (初級編)](https://qiita.com/drken/items/e77685614f3c6bf86f44) - 書籍「[プログラミングコンテストチャレンジブック [第2版] ～問題解決のアルゴリズム活用力とコーディングテクニックを鍛える～](https://www.amazon.co.jp/dp/B00CY9256C/ref=dp-kindle-redirect?_encoding=UTF8&btkr=1)」(通称、蟻本)の例題を[AtCoder](https://atcoder.jp/)などで出題された問題に対応づけた記事。
    - [中級編](https://qiita.com/drken/items/2f56925972c1d34e05d8)
    - [上級編](https://qiita.com/drken/items/9b311d553aa434bb26e4)
    - [発展的トピック編](https://qiita.com/drken/items/0de3d205690d92307b7c)
- [絶対にAtCoderで青コーダーになる！典型別 良問500選](https://note.com/rikimarublack/n/n3074b0955e95) - 典型的なアルゴリズム・テクニックを約150種類に分類し、それらの例題を紹介している。

---

<div align="center">
    <a href="../algorithm">もっと読む</a>
</div>
