---
title: Others
---

## C

### 言語アップデートによる影響

!!! warning "注意"

    ジャッジシステムの修正(2023年8月25日)に伴い、標準ライブラリの数学関数が利用できるようになった([出典](https://atcoder.jp/contests/editor-update-test))。このため、以下の対応は不要になったが、しばらく掲載予定。

- [AtCoderのC言語で標準数学関数が使えなくなるようなので、x87を使えるようにしておく](https://qiita.com/mikecat_mixc/items/f458fe46542087c06a97) - ジャッジシステムの言語アップデート(2023年8月)に伴い、標準ライブラリの数学関数が利用できなくなったことと対策方法が紹介されている記事。
    - [AtCoder新ジャッジにC言語で数学関数（libm）を使うためのおまじない](https://hotman78.hatenablog.com/entry/2023/08/15/201456) - 上記の記事を受け、数学関数を利用するためのスニペット(3行)が紹介されている記事。

## Crystal

### 文法・言語仕様

- [プログラミング言語Crystalで競プロをする際のテクニックまとめ](https://qiita.com/hakatashi/items/0892366ea47f1e88083d) - Crystalでコンテストに参加するときに陥りがちな点をまとめた記事。

    !!! warning "注意"
        記事の最終更新が2020年3月であるため、コンテスト前にジャッジシステムで動作確認を行うことを推奨。

### 言語アップデートによる新機能のまとめ

- [【Crystal】AtCoderの言語アップデートで嬉しいことまとめ！](https://qiita.com/ngng628/items/37ebd481a0f9d9ef6ad8) - ジャッジシステムの言語アップデート(2023年8月予定)に伴い、競技プログラミングで便利な機能がまとめられている記事。

## C&#35;

### 文法・言語仕様

- [ハイパー LINQ集 (AtCoder 2020年4月)](https://avant-garde-code.hatenablog.com/entry/hyper-linq-atcoder-202004) - LINQを利用して簡潔に書ける例題を紹介した記事。

### 定数倍高速化

- [JOI 2015 予選 財宝(Treasure) 解説 (with C#での定数倍高速化に関する知見)](https://fairy-lettuce.hatenadiary.com/entry/2020/11/11/174913) - [第14回日本情報オリンピック予選のF問題](https://atcoder.jp/contests/joi2015yo/tasks/joi2015yo_f)を題材に、C#における定数倍高速化の知見をまとめた記事。

## dc

### 文法・言語仕様

- [AtCoderのABCのA問題でdcで書きやすいものまとめ](https://qiita.com/shogo314/items/fff4be1573d2f86dba2a) - AtCoder Beginner Contest 100までのA問題を対象として、各問題の解答の方針がまとめられている。

## Fortran

### 文法・言語仕様

- [AtCoderのFortranでfortran-stdlibが使えるようになったので何が楽になるかを考える](https://qiita.com/osada-yum/items/3674eb515fc25c891ecf) - ジャッジシステムで利用可能なライブラリfortran-stdlibのうち、ソート・文字列入力・連想配列の実用性について言及されている。

## Go

### 文法・言語仕様

- [Go言語による各種データ構造の扱い方(やや競プロer向け)](https://zenn.dev/smartshopping/articles/5feb3666ba40b2) - Go言語におけるデータ構造(配列、キュー・スタック、優先度付きキュー、HashMap・HashSet、TreeMap・TreeSet)の扱い方がまとめられている。

#### 注意事項

- [Go言語でAtCoderに参加する場合の注意点｜テンプレートも公開](https://tech.aru-zakki.com/atcoder-golang/) - Goで競技プログラミングに参加するときに、入出力・標準関数に関する注意事項と、これらの課題に対応したテンプレートが紹介されている記事。

### イディオム・スニペット

- [Go言語でmod計算をするライブラリ for AtCoder](https://tech.aru-zakki.com/modulo-calcuration-lib-for-golang/) - 剰余を含む演算(ModInt)の実装例が紹介されている記事。

## JavaScript

### 文法・言語仕様

- [AtCoderをVS CodeとJavaScriptで挑戦する方法](https://iwb.jp/howto-challenge-atcoder-with-vscode-and-javascript/) - JavaScriptで問題を解くときに、入力データの受け取り方やテストツールの利用方法などが紹介されている。

### 別の言語を利用して高速化

- [【Atcoder】JavaScriptでもC++のSTLが使いたい！](https://qiita.com/sdk40010/items/a93eebcb5e55c154e577) - JavaScript(TypeScript)環境で、C++の標準ライブラリStandard Template Library (STL)を利用する方法について紹介した記事。

## R

### 文法・言語仕様

- [R言語でAtCoderの問題を解いてみた](https://qiita.com/bo9chan/items/4b2fecefa8c076235c5a) - 入出力の方法およびパッケージの一覧、それらの注意事項がまとめられている記事。

## SageMath

### 文法・言語仕様

- [AtCoderでSageMathを使う](https://qiita.com/kusano_k/items/b082423861705c41cac8) - Pythonの文法に近く、便利なライブラリが多く用意されているSageMathを紹介した記事。環境構築の方法、Pythonとの違い、デメリット、ライブラリの利用例が解説されている。

## Swift

### 文法・言語仕様

- [競プロで使えるアルゴリズム関数一覧(Swift)](https://qiita.com/uhooi/items/d4998e90f3f2fed01e68) - 主に整数に関するアルゴリズムをSwiftで実装する方法が紹介されている記事。
- [競プロで使える便利なエクステンション一覧(Swift)](https://qiita.com/uhooi/items/ff1113c337d7a756d580) - 競技プログラミングにおいて、便利な拡張メソッドやコンピューテッドプロパティを紹介した記事。

### アルゴリズム・データ構造の活用による高速化

- [Swift版 競プロ用チートシート(初心者向け)](https://qiita.com/TARDIGRADE/items/71b0a774d7f22418fdf5) - よく使うアルゴリズム・データ構造をコピー&ペーストして使えるようにまとめられている記事。

## TypeScript

### 文法・言語仕様

- [TypeScriptでAtCoderをやってみよう!](https://qiita.com/cosocaf/items/255003ecec1d3badfc7b) - TypeScriptで問題を解くために、環境構築や標準入出力の方法・テンプレートを紹介した記事。
- [【AtCoder】TypeScript で Python の `input()` ライクな入力を実現する](https://qiita.com/seijinrosen/items/5a3c54d574d9622cd2ce) - Pythonの`input()`のような形式で入力を受け取るためのTypeScriptのテンプレートを紹介した記事。

## Zig

### 文法・言語仕様

- [Zig言語の練習に AtCoder 202308 新ジャッジテストコンテスト A-E を解いてみた](https://qiita.com/hossie/items/080f8d49ec445022284b) - Zigによる回答例に加えて、Rustの実装例との比較も行われている。
