---
title: 複数の言語
---

## ジャッジシステムで利用可能な言語とライブラリ一覧

- [使用できる言語とライブラリの一覧](https://img.atcoder.jp/file/language-update/language-list.html) - ジャッジシステムのアップデート(2023年8月)に伴い、利用可能な言語とライブラリの一覧がまとめられている。

## 文法・言語仕様

- [Python と C++ の文法の比較](https://qiita.com/toriidao/items/6ffee7f40cc2e47c3e22) - PythonとC++における入出力・基本的な文法が比較できるようにまとめられている記事。

### 浮動小数点の誤差評価

- [浮動小数点数オタクが AtCoder Beginner Contest 169 のC問題をガチで解説してみる](https://qiita.com/mod_poppo/items/910b5fb9303baf864bf7) - 浮動小数点数に関する計算精度・誤差に関する解説記事。コンテストで実際に出題された問題を題材に、各種言語による実装例と実行結果が記載されている。
- [AtCoder ABC308-Cの実数演算誤差に負けない複数のC++, Rust実装例](https://qiita.com/hossie/items/329adf98680ef1816ede) - コンテストで出題された問題を題材に、浮動小数点の誤差評価問題について複数の実装例(C++とRust)が紹介されている記事。
- [浮動小数点型の算術とお近づきになりたい人向けの記事](https://rsk0315.hatenablog.com/entry/2024/02/25/231237) - 浮動小数点型に関する幅広い話題(丸め、誤差、桁落ちなど)がまとめられている。

    !!! info "参考"

        超大作の記事であるため、必要に応じて該当する部分を参照するとよいと思われる。

### 正規表現

- [パソコン詳しくない系競プロ勢向け正規表現](https://snuke.hatenablog.com/entry/2017/12/27/191600) - 正規表現の基本的な説明とメリットが解説されている記事。また、競技プログラミングにおける使用例として、文字列を扱う問題(C++)やコンテストに出題する問題の入力チェック(Python)が紹介されている。

## アルゴリズム・データ構造の活用による高速化

- [要素の追加・削除とmexを対数時間で処理するよ](https://rsk0315.hatenablog.com/entry/2020/10/11/125049) - 整数の集合に対して、「n以上で、集合に含まれない最小の整数」を対数時間で求める方法を解説した記事。C++とRustによる実装例もある。

## 最短コードを書く・読む

- [AtCoder Beginner ContestのA問題の最短コードを読む（旧）](https://qiita.com/kotatsugame/items/184bfd63d9b21f214475) - AtCoder Beginner Contest 125までのA問題を対象として、最短コードの書き方がまとめられている。

    !!! info "参考"
        最新のジャッジシステムでは、より短く記述できる可能性もある。
