---
title: コンテストに向けた練習方法を知る
---

## 練習方法を知る

### コンテストに参加しながら学ぶ

- [AtCoderでの勉強の仕方（コンテスト編）](http://chokudai.hatenablog.com/entry/2014/08/07/212849) - [AtCoder](https://atcoder.jp/)社長の[chokudai](https://twitter.com/chokudai)さんによる記事。プログラミングコンテストの参加を通して、アルゴリズムの学習を継続的に行う方法について解説している。

### AtCoder公式の提供サービスを活用

- [AtCoder練習・活用サービス](https://atcoder.jp/posts/1134) - AtCoder公式が提供しているサービスの一覧。平日に開催されている過去問練習コンテスト、中高生向けの学校対抗戦/学年別個人戦、資格試験、コンテストの成績を活用した就転職サービスが掲載されている。

### 上位陣の考え方・方法

- [rng_58さんがオススメする学習方法](https://twitter.com/rng_58/status/1238824295230361600) - [rng_58](https://twitter.com/rng_58)さんが、問題を楽に解くための方針を身につける方法についてコメントしている。
    - [基本的な練習方法](https://info.atcoder.jp/entry/2023/12/04/103759)
    - [茶色コーダーを目指すために必要なこと](https://info.atcoder.jp/entry/2024/03/18/160342)
    - [AtCoder Beginner Contest (ABC)を中心とした練習方法](https://twitter.com/kyopro_dekomor2/status/1412385847974895620)
- [競技プログラミングの問題の解き方、そのマニュアル](https://kmyk.github.io/blog/blog/2016/06/21/how-to-solve-problems-in-competitive-programming/) - 問題を解くときに、それぞれの段階(コンテスト前の準備、問題文を読む、前処理、方針の探索、実装、解けない問題への対処方法など)で考慮すべき項目が言語化されている記事。
- [競技プログラミングの練習法](https://hitoare.hatenablog.com/entry/2024/07/14/195940) - [hitoare](https://atcoder.jp/users/hitoare)さんが考える効率の良い練習方法が紹介されている。
- [精進について](https://kyopro-friends.hatenablog.com/entry/2020/02/03/202835) - [kyopro_friends](https://atcoder.jp/users/kyopro_friends)さんの練習に対する考え方や方法について書かれた記事。

### 練習の質を高める

- [競技プログラミングの生産性向上についてとその方法【AtCoder】](https://qiita.com/Kota-Y/items/0f3b9206516fe426188a) - コンテストで高い順位を目指す、練習では実力を高めるために多くの問題を解くという観点から方法論や便利ツールを紹介した記事。
- [競プロの精進の質を上げたい！ ~問題との向き合い方~](https://qiita.com/AIris_Solid/items/e9e1817f13e8d15b55ad) - 普段の練習の質を高めることに注目した記事。問題を解く力を知識量・考察力・実装力の3つに分解して、それぞれ観点から必要なことがまとめられている。
- [早解きをするために大切なスキルとそれらの身に付け方について](https://twitter.com/e869120/status/1408803727415255045) - 問題を解く過程を3つに分けて、それぞれのスキルを高める方法と不正解を減らす工夫について紹介されている。

## 問題を解く

### 問題のカテゴリを知る

- [AtCoderの問題を分類しました](https://zenn.dev/koyanagihitoshi?tab=books) - [AtCoder](https://atcoder.jp/)で開催されたコンテストについて、問題が分類(入出力、組み込み型、組み込み関数・モジュール、データ構造・アルゴリズム、数学などの6種類)されている。
    - [Pythonによる解答例](https://github.com/KoyanagiHitoshi/AtCoder-Python-Introduction) - 動作環境は、Python3.11.4。
- [【AtCoder】 AtCoder Beginner Contest A~C問題の傾向と対策 part1](https://qiita.com/darake/items/dd66663b80f6974cd8a9) - AtCoder Beginner Contest 200〜225のA〜C問題に関する出題傾向・活用方法がまとめられている。

### 問題の作成者が公開している問題集

- [フレンズ問題](https://docs.google.com/spreadsheets/d/1IkOQbXnC8Mb9EWuxEACGf2UcponRdk7SHCrQMoK9Ml8/edit?pli=1#gid=0) - [kyopro_friends](https://atcoder.jp/users/kyopro_friends)さんが原案・作成した問題の一覧。AtCoder Beginner Contest (ABC)で出題された問題が多い。
- [自作問題 - maspyのHP](https://maspypy.com/category/%E8%87%AA%E4%BD%9C%E5%95%8F%E9%A1%8C) - [maspy](https://atcoder.jp/users/maspy)さんが作成した問題の一覧。大部分がAtCoder Regular/Grand Contest (通称ARC、AGC)で出題されている。
- [nok0 問題集](https://hackmd.io/@nok0/SkQxZznwh) - [nok0](https://atcoder.jp/users/nok0)さんが原案の問題集(一部)。典型的な問題と応用的な問題に大別されている。
- [rng問題](https://docs.google.com/spreadsheets/d/1-dwOvCUGF7ITCYXg2LUFo0YqvZc7PTNX3jz1USuXuBE/edit#gid=0) - [rng_58](https://twitter.com/rng_58)さんが作成した問題の難易度を[Topcoder](https://www.topcoder.com/)の基準で点数化している。また、有志によって難易度の評価やおすすめ問題の投票が行われている。

### 競技プログラミングと生成AIとの関係

<!-- markdown-link-check-disable -->

- [AtCoder生成AI対策ルール - 20241206版](https://info.atcoder.jp/entry/llm-rules-ja) - AtCoder Beginner Contest (通称 ABC) および AtCoder Regular Contest (同 ARC)のコンテスト開催中を対象として、生成AIの利用における禁止事項が説明されている ([英語版](https://info.atcoder.jp/entry/llm-rules-en))。
    - [生成AIの技術向上に伴うABCおよびARCにおけるルール変更について](https://atcoder.jp/posts/1347) - 上記のルール変更の背景、作成方針、概要、今後の変更の可能性について言及されている ([英語版](https://atcoder.jp/posts/1350))。
    - [ARCのDivision制に伴うルール変更について](https://atcoder.jp/posts/1368) - ARC の Division制の導入に伴うルールの変更点が紹介されている。
- [ARCのDivision制についての告知](https://atcoder.jp/posts/1364) - ARC189以降、AtCoder Regular Contest (通称 ARC) は難易度の異なる2種類のコンテストに分けられることが告知されている。
- [競技プログラミングとChatGPTを含むAIについて](https://chokudai.hatenablog.com/entry/2022/12/07/161959) - [ChatGPT](https://openai.com/blog/chatgpt/)の公開に伴い、[AtCoder](https://atcoder.jp/)社長の[chokudai](https://twitter.com/chokudai)さんが個人的な見解を述べた記事。AIの実力、競技性や教育への影響、コンテストでの使用の是非などについて言及されている。
- [大実験！ChatGPTは競プロの問題を解けるのか (2024年5月版)](https://e869120.hatenablog.com/entry/2024/05/15/100804) - 筆者がオリジナルの問題を作成し、GPT-4oの回答性能を実験・調査している。

<!-- markdown-link-check-enable -->

## コンテストに関するTips集

- [AtCoder コンテストについてのtips](https://qiita.com/drken/items/8a6f139158cde8a61dce) - [AtCoder](https://atcoder.jp/)におけるコンテストの成績の解釈方法、参加に関するTips、プログラミングコンテストサイトの紹介について書かれている。
