---
title: 難問を解く
---

難問を解くためのテクニックをまとめた記事・スライドを掲載しています。

!!! warning "注意"
    - コンテストで出題された問題をもとに解説している資料では、ネタバレの可能性が高いです。


## 問題への取り組み方

### 着眼点・考え方を知る

- [競技プログラミングで解法を思いつくための典型的な考え方](https://algo-logic.info/how-to-think-cp/) - 問題を解くときの着眼点・言い換え・典型的な知識をカテゴリ別にまとめた記事。
- [ABC 解説まとめ (高難易度のみ)](https://github.com/NyaanNyaan/ABC_editorial) ![GitHub Repo stars](https://img.shields.io/github/stars/NyaanNyaan/ABC_editorial?style=plastic) - AtCoder Beginner Contest (通称、ABC)のG問題・H / Ex問題を中心とした解説がまとめられている。

### コードを書いて観察

- [競プロにおける「実験コード」の書き方](https://speakerdeck.com/physics0523/jing-puroniokeru-shi-yan-kodo-falseshu-kifang) - ある問題を解くときに、より小さな / 簡単な問題を解いて観察するための「実験コード」の書き方を紹介したスライド。実験コードが有効なケース、戦略、実践例が解説されている。

## ジャンル別の問題集

- [過去に作った競技プログラミングのスライド集](https://tsutaj.hatenablog.com/entry/2022/07/16/230000) - [tsutaj](https://atcoder.jp/users/tsutaj)さんが作成した競技プログラミングに関するスライドのリンク集。包除原理、確率DP、数え上げテクニックなどの解説と練習問題が紹介されている。
- [競技プログラミング練習問題集](https://blog.hamayanhamayan.com/entry/2100/01/01/000000) - 分野ごとに、手法の概要と類題がまとめられている記事のリンク集。

## グラフ理論

### 木問題

- [高難易度木問題を解くテクニック集](https://speakerdeck.com/tatyam_prime/gao-nan-yi-du-mu-wen-ti-wojie-kutekunitukuji) - [tatyam](https://atcoder.jp/users/tatyam)さんが、木問題の性質・考察をまとめたスライド資料。

### ネットワークフロー

- [燃やす埋める纏める](https://kanpurin.hatenablog.com/entry/moyasu-umeru) - 「燃やす埋める問題」の概略、問題として解ける制約条件、計算量、ライブラリの作成方針、練習問題などがまとめられている記事。

## 数学

### 整数論

- [整数論テクニック集](http://kirika-comp.hatenablog.com/entry/2018/03/12/210446) - [kirika_comp](https://atcoder.jp/users/kirika_comp)さんによる「整数論」に関するテクニックをまとめた資料集。

### 数え上げ

- [もう数え上げも怖くない ―競プロ数え上げ問題40選―](https://zrkkkk.hatenablog.com/entry/2020/03/26/002932) - [Rho17](https://atcoder.jp/users/Rho17)さんによる「数え上げ」の問題の定石と考え方を解説した資料。後述の「数え上げテクニック集」よりも簡単な部分に焦点を絞っているのが特徴。また、紹介されている定石や考え方を利用した例題とヒントが掲載されている。
- [数え上げテクニック集](https://drive.google.com/file/d/1WC7Y2Ni-8elttUgorfbix9tO1fvYN3g3/view) - [DEGwer](https://atcoder.jp/users/DEGwer)さんによる「数え上げ」の問題を解くコツが凝縮された資料集。難易度は、書籍「[プログラミングコンテストチャレンジブック](https://www.amazon.co.jp/dp/B00CY9256C/ref=dp-kindle-redirect?_encoding=UTF8&btkr=1)」(通称、蟻本)よりも、やや難しい程度と記載されている。

## 構築/構成

### 平面上で構築

- [平面上のロシアゲー（構築ゲー）を解くためのそこそこ一般的なテクについて](https://kokiymgch.hatenablog.com/entry/2017/12/12/153419) - 平面上で何かを構築するタイプの問題へのアプローチ方法を解説した記事。
