<?php

/*
 * Regis – Static analysis as a service
 * Copyright (C) 2016-2017 Kévin Gomez <contact@kevingomez.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

declare(strict_types=1);

namespace Tests\Regis\AppContext\Domain\Entity;

use PHPUnit\Framework\TestCase;
use Regis\AppContext\Domain\Entity\User;
use Regis\Kernel;
use Symfony\Component\Security\Core\User\UserInterface;
use Tests\Regis\Helper\ObjectManipulationHelper;

class UserTest extends TestCase
{
    use ObjectManipulationHelper;

    public function testItImplementsTheRightInterfaces()
    {
        $user = new User();
        $this->setPrivateValue($user, 'id', 'identifier');
        $this->setPrivateValue($user, 'roles', ['ROLE_USER']);

        $this->assertInstanceOf(Kernel\User::class, $user);
        $this->assertSame('identifier', $user->accountId());

        $this->assertInstanceOf(UserInterface::class, $user);
        $this->assertEmpty($user->getPassword());
        $this->assertNull($user->getSalt());
        $this->assertNull($user->eraseCredentials());
        $this->assertSame('identifier', $user->getUsername());
        $this->assertSame(['ROLE_USER'], $user->getRoles());
    }
}
