<?php

/*
 * Regis – Static analysis as a service
 * Copyright (C) 2016-2017 Kévin Gomez <contact@kevingomez.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

declare(strict_types=1);

namespace Regis\GithubContext\Domain\Model;

use Regis\GithubContext\Domain\Entity\Violation;

class ReviewComment
{
    private $content;
    private $position;
    private $file;

    public static function fromViolation(Violation $violation): self
    {
        $formattedComment = sprintf("**[%s]**\n```\n%s\n```", $violation->analysis()->type(), $violation->description());

        return new static($violation->file(), $violation->position(), $formattedComment);
    }

    public function __construct(string $file, int $position, string $content)
    {
        $this->file = $file;
        $this->position = $position;
        $this->content = $content;
    }

    public function getContent(): string
    {
        return $this->content;
    }

    public function getPosition(): int
    {
        return $this->position;
    }

    public function getFile(): string
    {
        return $this->file;
    }
}
