<?php

/*
 * Regis – Static analysis as a service
 * Copyright (C) 2016-2017 Kévin Gomez <contact@kevingomez.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

declare(strict_types=1);

namespace Regis\AppContext\Infrastructure\Bundle\AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Regis\AppContext\Application\Command;
use Regis\AppContext\Domain\Entity;

class RepositoryCreatorController extends Controller
{
    public function newAction()
    {
        return $this->render('@RegisApp/Repositories/new.html.twig');
    }

    public function remoteRepositoriesListAction()
    {
        $repositories = $this->get('regis.app.remote.repositories')->forUser($this->getUser());

        return new Response($this->get('serializer')->serialize([
            'repositories' => $repositories,
        ], 'json'), Response::HTTP_OK, [
            'Content-Type' => 'application/json',
        ]);
    }

    // TODO what happens if the repository is already registered by another user (spoiler: bad things!)
    public function createAction(Request $request)
    {
        $command = new Command\Repository\Register(
            $this->getUser(),
            $request->request->get('type'),
            $request->request->get('identifier'),
            $request->request->get('name')
        );

        /** @var Entity\Repository $repository */
        $repository = $this->get('tactician.commandbus')->handle($command);

        $this->addFlash('info', 'Repository added.');

        return $this->redirectToRoute('repositories_detail', ['id' => $repository->getId()]);
    }
}
