INCLUDE "data/trainers/party_pointers.asm"

Trainers:
; Trainer data structure:
; - db "NAME@", TRAINERTYPE_* constant
; - 1 to 6 Pokémon:
;    * for TRAINERTYPE_NORMAL:     db level, species
;    * for TRAINERTYPE_MOVES:      db level, species, 4 moves
;    * for TRAINERTYPE_ITEM:       db level, species, item
;    * for TRAINERTYPE_ITEM_MOVES: db level, species, item, 4 moves
; - db -1 ; end

FalknerGroup:
	; FALKNER (1)
	db "FALKNER@", TRAINERTYPE_MOVES
	db 10, PIDGEY,    TACKLE, GUST, MUD_SLAP, NO_MOVE
	db 12, HOOTHOOT,  TACKLE, GROWL, PECK, NO_MOVE
	db 13, PIDGEOTTO,  GUST, MUD_SLAP, SAND_ATTACK, NO_MOVE
	db -1 ; end
	
	; FALKNER (2)
	db "FALKNER@", TRAINERTYPE_ITEM_MOVES
	db 68, PIDGEOT,     SHARP_BEAK,	  WING_ATTACK, MUD_SLAP, SWAGGER, DOUBLE_TEAM
	db 65, FEAROW,		SHARP_BEAK,	  DRILL_PECK, PURSUIT, DETECT, STEEL_WING
	db 63, NOCTOWL,		TWISTEDSPOON, SHADOW_BALL, HYPNOSIS, NIGHTMARE, FLY
	db 65, MURKROW,		SHARP_BEAK,	  MEAN_LOOK, PURSUIT, NIGHT_SHADE, THUNDER_WAVE
	db 66, XATU,		TWISTEDSPOON,  PSYCHIC_M, CONFUSE_RAY, NIGHT_SHADE, PROTECT
	db 65, SKARMORY,	METAL_COAT,	  DRILL_PECK, PURSUIT, SKY_ATTACK, STEEL_WING
	db -1 ; end

BugsyGroup:
	; BUGSY (1)
	db "BUGSY@", TRAINERTYPE_MOVES
	db 14, BUTTERFREE, TACKLE, POISONPOWDER, SLEEP_POWDER, CONFUSION
	db 15, BEEDRILL,   POISON_STING, STRING_SHOT, HARDEN, FURY_ATTACK
	db 16, SCYTHER,    QUICK_ATTACK, LEER, FURY_CUTTER, PURSUIT
	db -1 ; end
	
	; BUGSY (2)
	db "BUGSY@", TRAINERTYPE_ITEM_MOVES
	db 65, BUTTERFREE,  TWISTEDSPOON,  	  	PSYBEAM, POISONPOWDER, STUN_SPORE, MEGA_DRAIN
	db 67, PINSIR,	    SILVERPOWDER,   	EARTHQUAKE, GUILLOTINE, FURY_CUTTER, PIN_MISSILE
	db 65, ARIADOS,		TWISTEDSPOON,	  	PSYCHIC_M, SPIDER_WEB, SLUDGE_BOMB, GIGA_DRAIN
	db 68, HERACROSS,	SILVERPOWDER,	  	MEGAHORN, DETECT, COUNTER, EARTHQUAKE
	db 64, YANMA,		MIRACLE_SEED,	  	TOXIC, GIGA_DRAIN, DETECT, ANCIENTPOWER
	db 72, SCIZOR,    	METAL_COAT,	  	QUICK_ATTACK, METAL_CLAW, FURY_CUTTER, SWORDS_DANCE
	db -1 ; end

WhitneyGroup:
	; WHITNEY (1)
	db "WHITNEY@", TRAINERTYPE_MOVES
	db 18, CLEFAIRY,   DOUBLESLAP, MIMIC, ENCORE, METRONOME
	db 19, AIPOM,      SCRATCH, DOUBLESLAP, SAND_ATTACK, FURY_SWIPES
	db 20, MILTANK,    ROLLOUT, ATTRACT, STOMP, MILK_DRINK
	db -1 ; end
	
	; WHITNEY (2)
	db "WHITNEY@", TRAINERTYPE_ITEM_MOVES
	db 68, LICKITUNG,	PINK_BOW,  		FLAMETHROWER, ICE_BEAM, THUNDERBOLT, HYPER_BEAM
	db 64, GIRAFARIG,	TWISTEDSPOON,   HYPER_BEAM, BATON_PASS, PSYCHIC_M, SHADOW_BALL
	db 65, FURRET,		PINK_BOW,  		SURF, ICE_BEAM, DOUBLE_TEAM, REST
	db 68, BLISSEY,		MIRACLEBERRY,   HEAL_BELL, EGG_BOMB, SOFTBOILED, HYPER_BEAM
	db 65, CLEFABLE,    PINK_BOW, 		FIRE_BLAST, THUNDER, BLIZZARD, METRONOME
	db 69, MILTANK,     MIRACLEBERRY, 	ROLLOUT, ATTRACT, BODY_SLAM, MILK_DRINK
	db -1 ; end

MortyGroup:
	; MORTY (1)
	db "MORTY@", TRAINERTYPE_MOVES
	db 24, HAUNTER,    HYPNOSIS, CONFUSE_RAY, DISABLE, NIGHT_SHADE
	db 24, NOCTOWL,    HYPNOSIS, NIGHT_SHADE, FAINT_ATTACK, PECK
	db 25, MISDREAVUS,  PSYWAVE, CONFUSE_RAY, SHADOW_BALL, CURSE
	db 26, GENGAR,     HYPNOSIS, SHADOW_BALL, NIGHT_SHADE, DREAM_EATER
	db -1 ; end
	
	; MORTY (2)
	db "MORTY@", TRAINERTYPE_ITEM_MOVES
	db 65, GENGAR,     SPELL_TAG, CONFUSE_RAY, NIGHT_SHADE, SHADOW_BALL, CURSE
	db 67, NOCTOWL,    SPELL_TAG, HYPNOSIS, NIGHT_SHADE, DREAM_EATER, CONFUSION
	db 68, MISDREAVUS, SPELL_TAG, PAIN_SPLIT, MEAN_LOOK, PERISH_SONG, NIGHT_SHADE
	db 72, GENGAR,     SPELL_TAG, HYPNOSIS, SHADOW_BALL, MEAN_LOOK, DREAM_EATER
	db -1 ; end

ChuckGroup:
	; CHUCK (1)
	db "CHUCK@", TRAINERTYPE_MOVES
	db 30, PRIMEAPE,   LEER, RAGE, KARATE_CHOP, FURY_SWIPES
	db 30, MACHOKE,    KARATE_CHOP, SEISMIC_TOSS, FOCUS_ENERGY, DYNAMICPUNCH
	db 29, HITMONTOP,  FOCUS_ENERGY, ROLLING_KICK, HI_JUMP_KICK, RAPID_SPIN
	db 31, POLIWRATH,  HYPNOSIS, BELLY_DRUM, SURF, DYNAMICPUNCH
	db -1 ; end
	
	; CHUCK (2)
	db "CHUCK@", TRAINERTYPE_ITEM_MOVES
	db 67, PRIMEAPE, 	BLACKBELT_I,  SWAGGER, THUNDERPUNCH, CROSS_CHOP, FURY_SWIPES
	db 67, HITMONCHAN, 	BLACKBELT_I,  SWAGGER, COUNTER, DOUBLE_TEAM, MACH_PUNCH
	db 67, HITMONLEE, 	BLACKBELT_I,  ROCK_SMASH, HI_JUMP_KICK, FORESIGHT, DOUBLE_TEAM
	db 67, HITMONTOP, 	BLACKBELT_I,  ROCK_SMASH, TRIPLE_KICK, DETECT, RAPID_SPIN
	db 67, MACHAMP, 	     BLACKBELT_I,  ROCK_SMASH, CROSS_CHOP, SUBMISSION, FOCUS_ENERGY
	db 70, POLIWRATH,    BLACKBELT_I,  HYPNOSIS, BELLY_DRUM, SURF, DYNAMICPUNCH
	db -1 ; end

JasmineGroup:
	; JASMINE (1)
	db "JASMINE@", TRAINERTYPE_MOVES
	db 34, MAGNETON,  SUPERSONIC, THUNDER_WAVE, THUNDERBOLT, TRI_ATTACK
	db 34, FORRETRESS,  PIN_MISSILE, SELFDESTRUCT, ROLLOUT, RAPID_SPIN
	db 35, SKARMORY,  MUD_SLAP, SWIFT, FURY_ATTACK, STEEL_WING
	db 36, STEELIX,    RAGE, HARDEN, ROCK_THROW, IRON_TAIL
	db -1 ; end

	; JASMINE (2)
	db "JASMINE@", TRAINERTYPE_ITEM_MOVES
	db 66, MAGNETON,  MAGNET, THUNDERBOLT, ZAP_CANNON, LOCK_ON, THUNDER_WAVE
	db 65, SKARMORY,  METAL_COAT,	  DRILL_PECK, FURY_ATTACK, SKY_ATTACK, STEEL_WING
	db 66, SCIZOR, MAGNET, PURSUIT, FURY_CUTTER, METAL_CLAW, SLASH
	db 66, FORRETRESS,	METAL_COAT,	  SPIKES, PROTECT, SANDSTORM, DOUBLE_TEAM
	db 70, STEELIX,   METAL_COAT,  ROAR, CRUNCH, ROCK_SLIDE, IRON_TAIL
	db -1 ; end

PryceGroup:
	; PRYCE (1)
	db "PRYCE@", TRAINERTYPE_MOVES
	db 37, DEWGONG,    HEADBUTT, ICY_WIND, AURORA_BEAM, RAIN_DANCE
	db 37, SNEASEL,    SCREECH, FAINT_ATTACK, ICY_WIND, FURY_SWIPES
	db 38, CLOYSTER,   WITHDRAW, SUPERSONIC, AURORA_BEAM, CLAMP
	db 42, PILOSWINE,  ICY_WIND, FURY_ATTACK, MIST, BLIZZARD
	db -1 ; end

	; PRYCE (2)
	db "PRYCE@", TRAINERTYPE_ITEM_MOVES
	db 64, SNEASEL,   NEVERMELTICE, SLASH, BEAT_UP, ICY_WIND, FURY_SWIPES
	db 69, DEWGONG,   NEVERMELTICE, HEADBUTT, ICY_WIND, AURORA_BEAM, REST
	db 64, JYNX,	  NEVERMELTICE,	ICE_PUNCH, MEAN_LOOK, PERISH_SONG, ICY_WIND
	db 64, CLOYSTER,  NEVERMELTICE,	SPIKES, SURF, PROTECT, ICY_WIND
	db 67, PILOSWINE, NEVERMELTICE, ICY_WIND, EARTHQUAKE, MIST, BLIZZARD
	db -1 ; end

ClairGroup:
	; CLAIR (1)
	db "CLAIR@", TRAINERTYPE_MOVES
	db 42, GYARADOS,   TWISTER, THRASH, DRAGON_RAGE, HYDRO_PUMP
	db 42, DRAGONAIR,  THUNDER_WAVE, THUNDERBOLT, SLAM, DRAGONBREATH
	db 44, AMPHAROS,   THUNDER_WAVE, LIGHT_SCREEN, THUNDERBOLT, THUNDERPUNCH
	db 45, KINGDRA,    SMOKESCREEN, SURF, HYPER_BEAM, DRAGONBREATH
	db -1 ; end
	
	; CLAIR (2)
	db "CLAIR@", TRAINERTYPE_ITEM_MOVES
	db 67, AMPHAROS,   MAGNET, THUNDER_WAVE, BODY_SLAM, THUNDER, THUNDERBOLT
	db 67, DRAGONITE,  DRAGON_FANG, THUNDER, SAFEGUARD, HYPER_BEAM, DRAGONBREATH
	db 68, CHARIZARD,  DRAGON_FANG, FLAMETHROWER, WING_ATTACK, SLASH, FLY
	db 67, AERODACTYL, DRAGON_FANG, ROCK_SLIDE, EARTHQUAKE, ROAR, ANCIENTPOWER
	db 67, GYARADOS,   DRAGON_FANG, HYDRO_PUMP, RAIN_DANCE, TWISTER, DRAGONBREATH
	db 70, KINGDRA,    DRAGON_FANG, ICE_BEAM, HYDRO_PUMP, HYPER_BEAM, DRAGONBREATH
	db -1 ; end

Rival1Group:
	; RIVAL1 (1)
	db "?@", TRAINERTYPE_NORMAL
	db  4, RATTATA
	db  5, CHIKORITA
	db -1 ; end

	; RIVAL1 (2)
	db "?@", TRAINERTYPE_NORMAL
	db  4, RATTATA
	db  5, CYNDAQUIL
	db -1 ; end

	; RIVAL1 (3)
	db "?@", TRAINERTYPE_NORMAL
	db  4, RATTATA
	db  5, TOTODILE
	db -1 ; end

	; RIVAL1 (4)
	db "?@", TRAINERTYPE_NORMAL
	db 14, GASTLY
	db 16, ZUBAT
	db 18, BAYLEEF
	db -1 ; end

	; RIVAL1 (5)
	db "?@", TRAINERTYPE_NORMAL
	db 14, GASTLY
	db 16, ZUBAT
	db 18, QUILAVA
	db -1 ; end

	; RIVAL1 (6)
	db "?@", TRAINERTYPE_NORMAL
	db 14, GASTLY
	db 16, ZUBAT
	db 18, CROCONAW
	db -1 ; end

	; RIVAL1 (7)
	db "?@", TRAINERTYPE_MOVES
	db 20, HAUNTER,    LICK, SPITE, MEAN_LOOK, CURSE
	db 18, MAGNEMITE,  TACKLE, THUNDERSHOCK, SUPERSONIC, SONICBOOM
	db 19, DROWZEE,    HYPNOSIS, CONFUSION, DISABLE, POUND
	db 20, ZUBAT,      LEECH_LIFE, SUPERSONIC, BITE, CONFUSE_RAY
	db 22, BAYLEEF,    GROWL, REFLECT, RAZOR_LEAF, POISONPOWDER
	db -1 ; end

	; RIVAL1 (8)
	db "?@", TRAINERTYPE_MOVES
	db 20, HAUNTER,    LICK, SPITE, MEAN_LOOK, CURSE
	db 18, MAGNEMITE,  TACKLE, THUNDERSHOCK, SUPERSONIC, SONICBOOM
	db 19, DROWZEE,    HYPNOSIS, CONFUSION, DISABLE, POUND
	db 20, ZUBAT,      LEECH_LIFE, SUPERSONIC, BITE, CONFUSE_RAY
	db 22, QUILAVA,    LEER, SMOKESCREEN, EMBER, QUICK_ATTACK
	db -1 ; end

	; RIVAL1 (9)
	db "?@", TRAINERTYPE_MOVES
	db 20, HAUNTER,    LICK, SPITE, MEAN_LOOK, CURSE
	db 18, MAGNEMITE,  TACKLE, THUNDERSHOCK, SUPERSONIC, SONICBOOM
	db 19, DROWZEE,    HYPNOSIS, CONFUSION, DISABLE, POUND
	db 20, ZUBAT,      LEECH_LIFE, SUPERSONIC, BITE, CONFUSE_RAY
	db 22, CROCONAW,   LEER, RAGE, WATER_GUN, BITE
	db -1 ; end

	; RIVAL1 (10)
	db "?@", TRAINERTYPE_MOVES
	db 32, GOLBAT,     LEECH_LIFE, BITE, CONFUSE_RAY, WING_ATTACK
	db 34, MAGNETON,  TACKLE, THUNDERSHOCK, SONICBOOM, THUNDER_WAVE
	db 34, HAUNTER,    LICK, MEAN_LOOK, CURSE, SHADOW_BALL
	db 32, SNEASEL,    LEER, QUICK_ATTACK, SCREECH, FAINT_ATTACK
	db 36, MEGANIUM,   REFLECT, RAZOR_LEAF, POISONPOWDER, BODY_SLAM
	db -1 ; end

	; RIVAL1 (11)
	db "?@", TRAINERTYPE_MOVES
	db 32, GOLBAT,     LEECH_LIFE, BITE, CONFUSE_RAY, WING_ATTACK
	db 34, MAGNETON,  TACKLE, THUNDERSHOCK, SONICBOOM, THUNDER_WAVE
	db 34, HAUNTER,    LICK, MEAN_LOOK, CURSE, SHADOW_BALL
	db 32, SNEASEL,    LEER, QUICK_ATTACK, SCREECH, FAINT_ATTACK
	db 36, TYPHLOSION,    SMOKESCREEN, EMBER, QUICK_ATTACK, FLAME_WHEEL
	db -1 ; end

	; RIVAL1 (12)
	db "?@", TRAINERTYPE_MOVES
	db 32, GOLBAT,     LEECH_LIFE, BITE, CONFUSE_RAY, WING_ATTACK
	db 34, MAGNETON,  TACKLE, THUNDERSHOCK, SONICBOOM, THUNDER_WAVE
	db 34, HAUNTER,    LICK, MEAN_LOOK, CURSE, SHADOW_BALL
	db 32, SNEASEL,    LEER, QUICK_ATTACK, SCREECH, FAINT_ATTACK
	db 36, FERALIGATR, RAGE, WATER_GUN, BITE, SCARY_FACE
	db -1 ; end

	; RIVAL1 (13)
	db "?@", TRAINERTYPE_MOVES
	db 42, SNEASEL,    QUICK_ATTACK, SCREECH, FAINT_ATTACK, FURY_CUTTER
	db 42, GOLBAT,     LEECH_LIFE, BITE, CONFUSE_RAY, WING_ATTACK
	db 44, MAGNETON,   THUNDERSHOCK, SONICBOOM, THUNDER_WAVE, SWIFT
	db 42, GENGAR,    MEAN_LOOK, CURSE, SHADOW_BALL, CONFUSE_RAY
	db 44, ALAKAZAM,    DISABLE, PSYBEAM, RECOVER, FUTURE_SIGHT
	db 46, MEGANIUM,   REFLECT, RAZOR_LEAF, POISONPOWDER, BODY_SLAM
	db -1 ; end

	; RIVAL1 (14)
	db "?@", TRAINERTYPE_MOVES
	db 42, SNEASEL,    QUICK_ATTACK, SCREECH, FAINT_ATTACK, FURY_CUTTER
	db 42, GOLBAT,     LEECH_LIFE, BITE, CONFUSE_RAY, WING_ATTACK
	db 44, MAGNETON,   THUNDERSHOCK, SONICBOOM, THUNDER_WAVE, SWIFT
	db 42, GENGAR,    MEAN_LOOK, CURSE, SHADOW_BALL, CONFUSE_RAY
	db 44, ALAKAZAM,    DISABLE, PSYBEAM, RECOVER, FUTURE_SIGHT
	db 46, TYPHLOSION, SMOKESCREEN, EMBER, QUICK_ATTACK, FLAME_WHEEL
	db -1 ; end

	; RIVAL1 (15)
	db "?@", TRAINERTYPE_MOVES
	db 42, SNEASEL,    QUICK_ATTACK, SCREECH, FAINT_ATTACK, FURY_CUTTER
	db 42, GOLBAT,     LEECH_LIFE, BITE, CONFUSE_RAY, WING_ATTACK
	db 44, MAGNETON,   THUNDERSHOCK, SONICBOOM, THUNDER_WAVE, SWIFT
	db 42, GENGAR,    MEAN_LOOK, CURSE, SHADOW_BALL, CONFUSE_RAY
	db 44, ALAKAZAM,    DISABLE, PSYBEAM, RECOVER, FUTURE_SIGHT
	db 46, FERALIGATR, RAGE, WATER_GUN, SCARY_FACE, SLASH
	db -1 ; end

PokemonProfGroup:

WillGroup:
	; WILL (1)
	db "WILL@", TRAINERTYPE_MOVES
	db 44, XATU,       QUICK_ATTACK, FUTURE_SIGHT, CONFUSE_RAY, PSYCHIC_M
	db 45, JYNX,       DOUBLESLAP, LOVELY_KISS, ICE_PUNCH, PSYCHIC_M
	db 43, EXEGGUTOR,  REFLECT, LEECH_SEED, EGG_BOMB, PSYCHIC_M
	db 45, SLOWBRO,    CURSE, AMNESIA, BODY_SLAM, PSYCHIC_M
	db 46, XATU,       QUICK_ATTACK, FUTURE_SIGHT, CONFUSE_RAY, PSYCHIC_M
	db -1 ; end

PKMNTrainerGroup:
	; CAL (1)
	db "CAL@", TRAINERTYPE_NORMAL
	db 10, CHIKORITA
	db 10, CYNDAQUIL
	db 10, TOTODILE
	db -1 ; end

	; CAL (2)
	db "CAL@", TRAINERTYPE_NORMAL
	db 30, BAYLEEF
	db 30, QUILAVA
	db 30, CROCONAW
	db -1 ; end

	; CAL (3)
	db "CAL@", TRAINERTYPE_NORMAL
	db 50, MEGANIUM
	db 50, TYPHLOSION
	db 50, FERALIGATR
	db -1 ; end
	
KogaGroup:
	; KOGA (1)
	db "KOGA@", TRAINERTYPE_MOVES
	db 45, ARIADOS,    DOUBLE_TEAM, SPIDER_WEB, BATON_PASS, GIGA_DRAIN
	db 45, VENOMOTH,   SUPERSONIC, GUST, PSYCHIC_M, TOXIC
	db 47, FORRETRESS, PROTECT, SWIFT, EXPLOSION, SPIKES
	db 46, MUK,        MINIMIZE, ACID_ARMOR, SLUDGE_BOMB, TOXIC
	db 48, CROBAT,     DOUBLE_TEAM, QUICK_ATTACK, WING_ATTACK, TOXIC
	db -1 ; end

BrunoGroup:
	; BRUNO (1)
	db "BRUNO@", TRAINERTYPE_MOVES
	db 45, HITMONTOP,  PURSUIT, QUICK_ATTACK, DIG, DETECT
	db 46, HITMONLEE,  SWAGGER, DOUBLE_KICK, HI_JUMP_KICK, FORESIGHT
	db 45, HITMONCHAN, THUNDERPUNCH, ICE_PUNCH, FIRE_PUNCH, MACH_PUNCH
	db 47, ONIX,       BIND, EARTHQUAKE, SANDSTORM, ROCK_SLIDE
	db 48, MACHAMP,    ROCK_SLIDE, FORESIGHT, VITAL_THROW, CROSS_CHOP
	db -1 ; end

KarenGroup:
	; KAREN (1)
	db "KAREN@", TRAINERTYPE_MOVES
	db 46, UMBREON,    SAND_ATTACK, CONFUSE_RAY, FAINT_ATTACK, MEAN_LOOK
	db 47, VILEPLUME,  STUN_SPORE, ACID, MOONLIGHT, PETAL_DANCE
	db 48, GENGAR,     LICK, SPITE, CURSE, DESTINY_BOND
	db 48, MURKROW,    QUICK_ATTACK, WHIRLWIND, PURSUIT, FAINT_ATTACK
	db 50, HOUNDOOM,   ROAR, PURSUIT, FLAMETHROWER, CRUNCH
	db -1 ; end
	
ChampionGroup:
	; CHAMPION (1)
	db "LANCE@", TRAINERTYPE_MOVES
	db 50, GYARADOS,   FLAIL, RAIN_DANCE, SURF, HYPER_BEAM
	db 54, KINGDRA,    DRAGON_RAGE, TWISTER, ICE_BEAM, HYDRO_PUMP
	db 54, DRAGONITE,  THUNDER_WAVE, TWISTER, BLIZZARD, HYPER_BEAM
	db 52, AERODACTYL, WING_ATTACK, ANCIENTPOWER, ROCK_SLIDE, HYPER_BEAM
	db 52, CHARIZARD,  FLAMETHROWER, WING_ATTACK, SLASH, HYPER_BEAM
	db 56, DRAGONITE,  FIRE_BLAST, SAFEGUARD, OUTRAGE, HYPER_BEAM
	db -1 ; end

BrockGroup:
	; BROCK (1)
	db "BROCK@", TRAINERTYPE_MOVES
	db 51, GRAVELER,   DEFENSE_CURL, ROCK_SLIDE, ROLLOUT, EARTHQUAKE
	db 51, RHYHORN,    FURY_ATTACK, SCARY_FACE, EARTHQUAKE, HORN_DRILL
	db 52, OMASTAR,    BITE, SURF, PROTECT, SPIKE_CANNON
	db 54, ONIX,       BIND, ROCK_SLIDE, BIDE, SANDSTORM
	db 52, KABUTOPS,   SLASH, SURF, ENDURE, GIGA_DRAIN
	db -1 ; end

	; BROCK (2)
	db "BROCK@", TRAINERTYPE_ITEM_MOVES
	db 64, GOLEM,      HARD_STONE, DEFENSE_CURL, ROCK_SLIDE, SANDSTORM, EARTHQUAKE
	db 66, RHYHORN,    SOFT_SAND,  FURY_ATTACK, SCARY_FACE, EARTHQUAKE, HORN_DRILL
	db 63, OMASTAR,    GOLD_BERRY, SANDSTORM, SURF, PROTECT, ANCIENTPOWER
	db 68, ONIX,       HARD_STONE, BIND, ROCK_SLIDE, SPIKES, SANDSTORM
	db 65, SUDOWOODO,  GOLD_BERRY, ROCK_SLIDE, HIDDEN_POWER, THUNDERPUNCH, EARTHQUAKE
	db 65, KABUTOPS,   GOLD_BERRY, SLASH, SURF, ENDURE, GIGA_DRAIN
	db -1 ; end
	
MistyGroup:
	; MISTY (1)
	db "MISTY@", TRAINERTYPE_MOVES
	db 52, GOLDUCK,    SURF, DISABLE, PSYCH_UP, PSYCHIC_M
	db 52, QUAGSIRE,   SURF, AMNESIA, EARTHQUAKE, RAIN_DANCE
	db 54, LAPRAS,     SURF, PERISH_SONG, BLIZZARD, RAIN_DANCE
	db 56, STARMIE,    SURF, CONFUSE_RAY, RECOVER, ICE_BEAM
	db -1 ; end
	
	; MISTY (2)
	db "MISTY@", TRAINERTYPE_ITEM_MOVES
	db 64, GOLDUCK,    MYSTIC_WATER, SURF, DISABLE, PSYCH_UP, PSYCHIC_M
	db 65, QUAGSIRE,   MYSTIC_WATER, SURF, AMNESIA, EARTHQUAKE, RAIN_DANCE
	db 64, LAPRAS,     MYSTIC_WATER, SURF, PERISH_SONG, BLIZZARD, RAIN_DANCE
	db 66, CLOYSTER,   MYSTIC_WATER, SPIKES, SURF, PROTECT, ICY_WIND
	db 68, LANTURN,    MYSTIC_WATER, THUNDERBOLT, SURF, CONFUSE_RAY, THUNDER_WAVE
	db 70, STARMIE,    MYSTIC_WATER, SURF, PSYCHIC_M, THUNDERBOLT, ICE_BEAM
	db -1 ; end

LtSurgeGroup:
	; LT_SURGE (1)
	db "LT.SURGE@", TRAINERTYPE_MOVES
	db 54, RAICHU,     THUNDER_WAVE, QUICK_ATTACK, THUNDERBOLT, THUNDER
	db 50, ELECTRODE,  SCREECH, DOUBLE_TEAM, SWIFT, EXPLOSION
	db 50, MAGNETON,   LOCK_ON, DOUBLE_TEAM, SWIFT, ZAP_CANNON
	db 50, ELECTRODE,  SCREECH, DOUBLE_TEAM, SWIFT, EXPLOSION
	db 56, ELECTABUZZ, QUICK_ATTACK, THUNDERPUNCH, LIGHT_SCREEN, THUNDER
	db -1 ; end
	
	; LT_SURGE (2)
	db "LT.SURGE@", TRAINERTYPE_ITEM_MOVES
	db 68, RAICHU,     MAGNET,  THUNDER_WAVE, QUICK_ATTACK, THUNDERBOLT, THUNDER
	db 65, ELECTRODE,  MAGNET,  THUNDERBOLT, DOUBLE_TEAM, THUNDER_WAVE, EXPLOSION
	db 66, MAGNETON,   MAGNET,  LOCK_ON, DOUBLE_TEAM, SWIFT, ZAP_CANNON
	db 64, ELECTRODE,  MAGNET,  SCREECH, DOUBLE_TEAM, SWIFT, EXPLOSION
	db 66, JOLTEON,	   MAGNET,  DETECT,  THUNDER,	  THUNDER_WAVE, THUNDERBOLT
	db 66, ELECTABUZZ, MAGNET,  QUICK_ATTACK, THUNDERPUNCH, LIGHT_SCREEN, THUNDER
	db -1 ; end

ScientistGroup:
	; SCIENTIST (1)
	db "ROSS@", TRAINERTYPE_NORMAL
	db 26, KOFFING
	db 26, KOFFING
	db -1 ; end

	; SCIENTIST (2)
	db "MITCH@", TRAINERTYPE_NORMAL
	db 28, DITTO
	db -1 ; end

	; SCIENTIST (3)
	db "JED@", TRAINERTYPE_NORMAL
	db 23, MAGNEMITE
	db 23, MAGNEMITE
	db 23, MAGNEMITE
	db -1 ; end

	; SCIENTIST (4)
	db "MARC@", TRAINERTYPE_NORMAL
	db 33, MAGNEMITE
	db 33, MAGNEMITE
	db 33, MAGNEMITE
	db -1 ; end

	; SCIENTIST (5)
	db "RICH@", TRAINERTYPE_MOVES
	db 36, PORYGON,    CONVERSION, CONVERSION2, RECOVER, TRI_ATTACK
	db -1 ; end

ErikaGroup:
	; ERIKA (1)
	db "ERIKA@", TRAINERTYPE_MOVES
	db 52, TANGELA,    VINE_WHIP, BIND, GIGA_DRAIN, SLEEP_POWDER
	db 51, JUMPLUFF,   MEGA_DRAIN, LEECH_SEED, COTTON_SPORE, GIGA_DRAIN
	db 56, VICTREEBEL, SUNNY_DAY, SYNTHESIS, ACID, RAZOR_LEAF
	db 56, BELLOSSOM,  SUNNY_DAY, SYNTHESIS, PETAL_DANCE, SOLARBEAM
	db -1 ; end
	
	; ERIKA (2)
	db "ERIKA@", TRAINERTYPE_ITEM_MOVES
	db 64, TANGELA,    MIRACLE_SEED, VINE_WHIP, EARTHQUAKE, GIGA_DRAIN, ROCK_SLIDE
	db 65, JUMPLUFF,   MIRACLE_SEED, SLEEP_POWDER, LEECH_SEED, COTTON_SPORE, GIGA_DRAIN
	db 66, VICTREEBEL, MIRACLE_SEED, SUNNY_DAY, SYNTHESIS, SLUDGE_BOMB, RAZOR_LEAF
	db 66, BELLOSSOM,  MIRACLE_SEED, SUNNY_DAY, ATTRACT, GIGA_DRAIN, SOLARBEAM
	db 67, EXEGGUTOR,  MIRACLE_SEED, SUNNY_DAY, PSYCHIC_M, GIGA_DRAIN, SOLARBEAM
	db 69, VILEPLUME,  MIRACLE_SEED, SUNNY_DAY, SYNTHESIS, PETAL_DANCE, SOLARBEAM
	db -1 ; end

YoungsterGroup:
	; YOUNGSTER (1)
	db "JOEY@", TRAINERTYPE_NORMAL
	db  4, RATTATA
	db -1 ; end

	; YOUNGSTER (2)
	db "MIKEY@", TRAINERTYPE_NORMAL
	db  4, PIDGEY
	db  4, RATTATA
	db -1 ; end

	; YOUNGSTER (3)
	db "ALBERT@", TRAINERTYPE_NORMAL
	db  7, RATTATA
	db  9, ZUBAT
	db -1 ; end

	; YOUNGSTER (4)
	db "GORDON@", TRAINERTYPE_NORMAL
	db 11, WOOPER
	db -1 ; end

	; YOUNGSTER (5)
	db "SAMUEL@", TRAINERTYPE_NORMAL
	db  8, RATTATA
	db 11, SANDSHREW
	db  9, SPEAROW
	db  9, SPEAROW
	db -1 ; end

	; YOUNGSTER (6)
	db "IAN@", TRAINERTYPE_NORMAL
	db 11, MANKEY
	db 13, DIGLETT
	db -1 ; end

	; YOUNGSTER (7)
	db "JOEY@", TRAINERTYPE_NORMAL
	db 17, RATTATA
	db -1 ; end

	; YOUNGSTER (8)
	db "JOEY@", TRAINERTYPE_MOVES
	db 25, RATICATE,   TAIL_WHIP, QUICK_ATTACK, HYPER_FANG, SCARY_FACE
	db -1 ; end

	; YOUNGSTER (9)
	db "WARREN@", TRAINERTYPE_NORMAL
	db 43, FEAROW
	db -1 ; end

	; YOUNGSTER (10)
	db "JIMMY@", TRAINERTYPE_NORMAL
	db 41, RATICATE
	db 41, ARBOK
	db -1 ; end

	; YOUNGSTER (11)
	db "OWEN@", TRAINERTYPE_NORMAL
	db 43, GROWLITHE
	db -1 ; end

	; YOUNGSTER (12)
	db "JASON@", TRAINERTYPE_NORMAL
	db 41, SANDSLASH
	db 41, CROBAT
	db -1 ; end

	; YOUNGSTER (13)
	db "JOEY@", TRAINERTYPE_MOVES
	db 36, RATICATE,   TAIL_WHIP, QUICK_ATTACK, HYPER_FANG, PURSUIT
	db -1 ; end

	; YOUNGSTER (14)
	db "JOEY@", TRAINERTYPE_MOVES
	db 44, RATICATE,   HYPER_BEAM, QUICK_ATTACK, HYPER_FANG, PURSUIT
	db -1 ; end

SchoolboyGroup:
	; SCHOOLBOY (1)
	db "JACK@", TRAINERTYPE_NORMAL
	db 13, ODDISH
	db 17, VOLTORB
	db -1 ; end

	; SCHOOLBOY (2)
	db "KIPP@", TRAINERTYPE_NORMAL
	db 33, VOLTORB
	db 33, MAGNEMITE
	db 38, VOLTORB
	db 38, MAGNETON
	db -1 ; end

	; SCHOOLBOY (3)
	db "ALAN@", TRAINERTYPE_NORMAL
	db 18, TANGELA
	db -1 ; end

	; SCHOOLBOY (4)
	db "JOHNNY@", TRAINERTYPE_NORMAL
	db 35, BELLSPROUT
	db 38, WEEPINBELL
	db 41, VICTREEBEL
	db -1 ; end

	; SCHOOLBOY (5)
	db "DANNY@", TRAINERTYPE_NORMAL
	db 38, JYNX
	db 38, ELECTABUZZ
	db 38, MAGMAR
	db -1 ; end

	; SCHOOLBOY (6)
	db "TOMMY@", TRAINERTYPE_NORMAL
	db 40, XATU
	db 42, ALAKAZAM
	db -1 ; end

	; SCHOOLBOY (7)
	db "DUDLEY@", TRAINERTYPE_NORMAL
	db 43, ODDISH
	db -1 ; end

	; SCHOOLBOY (8)
	db "JOE@", TRAINERTYPE_NORMAL
	db 41, TANGELA
	db 41, VAPOREON
	db -1 ; end

	; SCHOOLBOY (9)
	db "BILLY@", TRAINERTYPE_NORMAL
	db 33, PARAS
	db 33, PARAS
	db 33, POLIWHIRL
	db 43, DITTO
	db -1 ; end

	; SCHOOLBOY (10)
	db "CHAD@", TRAINERTYPE_NORMAL
	db 22, MR__MIME
	db -1 ; end

	; SCHOOLBOY (11)
	db "NATE@", TRAINERTYPE_NORMAL
	db 40, LEDIAN
	db 40, EXEGGUTOR
	db -1 ; end

	; SCHOOLBOY (12)
	db "RICKY@", TRAINERTYPE_NORMAL
	db 40, AIPOM
	db 40, DITTO
	db -1 ; end

	; SCHOOLBOY (13)
	db "JACK@", TRAINERTYPE_NORMAL
	db 16, ODDISH
	db 20, VOLTORB
	db -1 ; end

	; SCHOOLBOY (14)
	db "JACK@", TRAINERTYPE_NORMAL
	db 34, GLOOM
	db 38, ELECTRODE
	db -1 ; end

	; SCHOOLBOY (15)
	db "ALAN@", TRAINERTYPE_NORMAL
	db 20, TANGELA
	db 20, YANMA
	db -1 ; end

	; SCHOOLBOY (16)
	db "ALAN@", TRAINERTYPE_NORMAL
	db 23, NATU
	db 26, TANGELA
	db 23, QUAGSIRE
	db 30, YANMA
	db -1 ; end

	; SCHOOLBOY (17)
	db "CHAD@", TRAINERTYPE_NORMAL
	db 22, MR__MIME
	db 22, MAGNEMITE
	db -1 ; end

	; SCHOOLBOY (18)
	db "CHAD@", TRAINERTYPE_NORMAL
	db 33, MR__MIME
	db 38, MAGNETON
	db -1 ; end

	; SCHOOLBOY (19)
	db "JACK@", TRAINERTYPE_NORMAL
	db 36, GLOOM
	db 41, GROWLITHE
	db 41, ELECTRODE
	db -1 ; end

	; SCHOOLBOY (20)
	db "JACK@", TRAINERTYPE_MOVES
	db 43, ELECTRODE,  SCREECH, SONICBOOM, ROLLOUT, LIGHT_SCREEN
	db 43, GROWLITHE,  SUNNY_DAY, LEER, TAKE_DOWN, FLAME_WHEEL
	db 44, VILEPLUME,  SOLARBEAM, SLEEP_POWDER, ACID, MOONLIGHT
	db -1 ; end

	; SCHOOLBOY (21)
	db "ALAN@", TRAINERTYPE_NORMAL
	db 33, NATU
	db 33, TANGELA
	db 36, QUAGSIRE
	db 36, YANMA
	db -1 ; end

	; SCHOOLBOY (22)
	db "ALAN@", TRAINERTYPE_MOVES
	db 43, XATU,       PECK, NIGHT_SHADE, SWIFT, FUTURE_SIGHT
	db 40, TANGELA,    POISONPOWDER, VINE_WHIP, BIND, MEGA_DRAIN
	db 40, YANMA,      QUICK_ATTACK, DOUBLE_TEAM, SONICBOOM, SUPERSONIC
	db 43, QUAGSIRE,   TAIL_WHIP, SLAM, AMNESIA, EARTHQUAKE
	db -1 ; end

	; SCHOOLBOY (23)
	db "CHAD@", TRAINERTYPE_NORMAL
	db 36, MR__MIME
	db 42, MAGNETON
	db -1 ; end

	; SCHOOLBOY (24)
	db "CHAD@", TRAINERTYPE_MOVES
	db 42, MR__MIME,   PSYCHIC_M, LIGHT_SCREEN, REFLECT, ENCORE
	db 46, MAGNETON,   ZAP_CANNON, THUNDER_WAVE, LOCK_ON, SWIFT
	db -1 ; end

BirdKeeperGroup:
	; BIRD_KEEPER (1)
	db "ROD@", TRAINERTYPE_NORMAL
	db  10, PIDGEY
	db  10, PIDGEY
	db -1 ; end

	; BIRD_KEEPER (2)
	db "ABE@", TRAINERTYPE_NORMAL
	db 12, SPEAROW
	db -1 ; end

	; BIRD_KEEPER (3)
	db "BRYAN@", TRAINERTYPE_NORMAL
	db 13, PIDGEY
	db 16, PIDGEOTTO
	db -1 ; end

	; BIRD_KEEPER (4)
	db "THEO@", TRAINERTYPE_NORMAL
	db 20, PIDGEY
	db 17, PIDGEY
	db 22, PIDGEY
	db 17, PIDGEY
	db 17, PIDGEY
	db -1 ; end

	; BIRD_KEEPER (5)
	db "TOBY@", TRAINERTYPE_NORMAL
	db 17, DODUO
	db 18, DODUO
	db 20, DODUO
	db -1 ; end

	; BIRD_KEEPER (6)
	db "DENIS@", TRAINERTYPE_NORMAL
	db 21, SPEAROW
	db 23, FEAROW
	db 21, SPEAROW
	db -1 ; end

	; BIRD_KEEPER (7)
	db "VANCE@", TRAINERTYPE_NORMAL
	db 30, PIDGEOTTO
	db 30, PIDGEOTTO
	db -1 ; end

	; BIRD_KEEPER (8)
	db "HANK@", TRAINERTYPE_NORMAL
	db 13, PIDGEY
	db 42, PIDGEOT
	db -1 ; end

	; BIRD_KEEPER (9)
	db "ROY@", TRAINERTYPE_NORMAL
	db 35, FEAROW
	db 43, FEAROW
	db -1 ; end

	; BIRD_KEEPER (10)
	db "BORIS@", TRAINERTYPE_NORMAL
	db 36, DODUO
	db 34, DODUO
	db 40, DODRIO
	db -1 ; end

	; BIRD_KEEPER (11)
	db "BOB@", TRAINERTYPE_NORMAL
	db 42, NOCTOWL
	db -1 ; end

	; BIRD_KEEPER (12)
	db "JOSE@", TRAINERTYPE_NORMAL
	db 43, FARFETCH_D
	db -1 ; end

	; BIRD_KEEPER (13)
	db "PETER@", TRAINERTYPE_NORMAL
	db  7, PIDGEY
	db  7, PIDGEY
	db  9, SPEAROW
	db -1 ; end

	; BIRD_KEEPER (14)
	db "JOSE@", TRAINERTYPE_NORMAL
	db 42, FARFETCH_D
	db -1 ; end

	; BIRD_KEEPER (15)
	db "PERRY@", TRAINERTYPE_NORMAL
	db 42, FARFETCH_D
	db -1 ; end

	; BIRD_KEEPER (16)
	db "BRET@", TRAINERTYPE_NORMAL
	db 40, PIDGEOTTO
	db 40, FEAROW
	db -1 ; end

	; BIRD_KEEPER (17)
	db "JOSE@", TRAINERTYPE_MOVES
	db 48, FARFETCH_D, FURY_ATTACK, DETECT, FLY, SLASH
	db -1 ; end

	; BIRD_KEEPER (18)
	db "VANCE@", TRAINERTYPE_NORMAL
	db 40, PIDGEOTTO
	db 40, PIDGEOTTO
	db -1 ; end

	; BIRD_KEEPER (19)
	db "VANCE@", TRAINERTYPE_MOVES
	db 46, PIDGEOT,    TOXIC, QUICK_ATTACK, WHIRLWIND, FLY
	db 46, PIDGEOT,    SWIFT, DETECT, STEEL_WING, FLY
	db -1 ; end

LassGroup:
	; LASS (1)
	db "CARRIE@", TRAINERTYPE_MOVES
	db 21, SNUBBULL,   SCARY_FACE, CHARM, BITE, LICK
	db -1 ; end

	; LASS (2)
	db "BRIDGET@", TRAINERTYPE_NORMAL
	db 17, JIGGLYPUFF
	db 17, JIGGLYPUFF
	db 17, JIGGLYPUFF
	db -1 ; end

	; LASS (3)
	db "ALICE@", TRAINERTYPE_NORMAL
	db 36, GLOOM
	db 42, ARBOK
	db 36, GLOOM
	db -1 ; end

	; LASS (4)
	db "KRISE@", TRAINERTYPE_NORMAL
	db 13, ODDISH
	db 17, CUBONE
	db -1 ; end

	; LASS (5)
	db "CONNIE@", TRAINERTYPE_NORMAL
	db 25, MARILL
	db -1 ; end

	; LASS (6)
	db "LINDA@", TRAINERTYPE_NORMAL
	db 36, BULBASAUR
	db 40, IVYSAUR
	db 42, VENUSAUR
	db -1 ; end

	; LASS (7)
	db "LAURA@", TRAINERTYPE_NORMAL
	db 34, GLOOM
	db 38, PIDGEOTTO
	db 38, BELLOSSOM
	db -1 ; end

	; LASS (8)
	db "SHANNON@", TRAINERTYPE_NORMAL
	db 35, PARAS
	db 35, PARAS
	db 40, PARASECT
	db -1 ; end

	; LASS (9)
	db "MICHELLE@", TRAINERTYPE_NORMAL
	db 40, SKIPLOOM
	db 41, HOPPIP
	db 42, JUMPLUFF
	db -1 ; end

	; LASS (10)
	db "DANA@", TRAINERTYPE_MOVES
	db 21, FLAAFFY,    TACKLE, GROWL, THUNDERSHOCK, THUNDER_WAVE
	db 21, PSYDUCK,    SCRATCH, TAIL_WHIP, DISABLE, CONFUSION
	db -1 ; end

	; LASS (11)
	db "ELLEN@", TRAINERTYPE_NORMAL
	db 36, WIGGLYTUFF
	db 42, GRANBULL
	db -1 ; end

	; LASS (12)
	db "CONNIE@", TRAINERTYPE_NORMAL
	db 25, MARILL
	db -1 ; end

	; LASS (13)
	db "CONNIE@", TRAINERTYPE_NORMAL
	db 25, MARILL
	db -1 ; end

	; LASS (14)
	db "DANA@", TRAINERTYPE_MOVES
	db 25, FLAAFFY,    TACKLE, GROWL, THUNDERSHOCK, THUNDER_WAVE
	db 25, PSYDUCK,    SCRATCH, TAIL_WHIP, DISABLE, CONFUSION
	db -1 ; end

	; LASS (15)
	db "DANA@", TRAINERTYPE_MOVES
	db 35, PSYDUCK,    SCRATCH, DISABLE, CONFUSION, SCREECH
	db 35, AMPHAROS,   TACKLE, THUNDERSHOCK, THUNDER_WAVE, COTTON_SPORE
	db -1 ; end

	; LASS (16)
	db "DANA@", TRAINERTYPE_MOVES
	db 40, PSYDUCK,    SCRATCH, DISABLE, CONFUSION, SCREECH
	db 40, AMPHAROS,   TACKLE, THUNDERPUNCH, THUNDER_WAVE, COTTON_SPORE
	db -1 ; end

	; LASS (17)
	db "DANA@", TRAINERTYPE_MOVES
	db 43, AMPHAROS,   SWIFT, THUNDERPUNCH, THUNDER_WAVE, COTTON_SPORE
	db 43, GOLDUCK,    DISABLE, SURF, PSYCHIC_M, SCREECH
	db -1 ; end

JanineGroup:
	; JANINE (1)
	db "JANINE@", TRAINERTYPE_MOVES
	db 54, CROBAT,     SCREECH, SUPERSONIC, CONFUSE_RAY, WING_ATTACK
	db 52, WEEZING,    SMOG, SLUDGE_BOMB, TOXIC, EXPLOSION
	db 54, WEEZING,    SMOG, SLUDGE_BOMB, TOXIC, EXPLOSION
	db 52, ARIADOS,    SCARY_FACE, GIGA_DRAIN, STRING_SHOT, NIGHT_SHADE
	db 56, VENOMOTH,   FORESIGHT, DOUBLE_TEAM, GUST, PSYCHIC_M
	db -1 ; end
	
	; JANINE (2)
	db "JANINE@", TRAINERTYPE_ITEM_MOVES
	db 66, CROBAT,     POISON_BARB, SCREECH, SUPERSONIC, CONFUSE_RAY, WING_ATTACK
	db 64, WEEZING,    POISON_BARB, THUNDERBOLT, SLUDGE_BOMB, TOXIC, EXPLOSION
	db 64, WEEZING,    POISON_BARB, SMOG, SLUDGE_BOMB, TOXIC, EXPLOSION
	db 67, ARIADOS,    POISON_BARB, TOXIC, GIGA_DRAIN, PSYCHIC_M, NIGHT_SHADE
	db 66, MUK,	  	   POISON_BARB, SLUDGE_BOMB, ACID_ARMOR, TOXIC, MINIMIZE
	db 69, VENOMOTH,   POISON_BARB, SLEEP_POWDER, DOUBLE_TEAM, GUST, PSYCHIC_M
	db -1 ; end

CooltrainerMGroup:
	; COOLTRAINERM (1)
	db "NICK@", TRAINERTYPE_MOVES
	db 31, CHARMANDER, EMBER, SMOKESCREEN, RAGE, SCARY_FACE
	db 31, SQUIRTLE,   WITHDRAW, WATER_GUN, BITE, CURSE
	db 31, BULBASAUR,  LEECH_SEED, POISONPOWDER, SLEEP_POWDER, RAZOR_LEAF
	db -1 ; end

	; COOLTRAINERM (2)
	db "AARON@", TRAINERTYPE_NORMAL
	db 28, IVYSAUR
	db 28, CHARMELEON
	db 28, WARTORTLE
	db -1 ; end

	; COOLTRAINERM (3)
	db "PAUL@", TRAINERTYPE_NORMAL
	db 42, DRATINI
	db 42, DRATINI
	db 42, DRATINI
	db -1 ; end

	; COOLTRAINERM (4)
	db "CODY@", TRAINERTYPE_NORMAL
	db 42, HORSEA
	db 43, SEADRA
	db -1 ; end

	; COOLTRAINERM (5)
	db "MIKE@", TRAINERTYPE_NORMAL
	db 44, DRAGONAIR
	db -1 ; end

	; COOLTRAINERM (6)
	db "GAVEN@", TRAINERTYPE_MOVES
	db 43, VICTREEBEL, WRAP, TOXIC, ACID, RAZOR_LEAF
	db 43, KINGLER,    BUBBLEBEAM, STOMP, GUILLOTINE, PROTECT
	db 43, FLAREON,    SAND_ATTACK, QUICK_ATTACK, BITE, FIRE_SPIN
	db -1 ; end

	; COOLTRAINERM (7)
	db "GAVEN@", TRAINERTYPE_ITEM_MOVES
	db 47, VICTREEBEL, NO_ITEM,      GIGA_DRAIN, TOXIC, SLUDGE_BOMB, RAZOR_LEAF
	db 47, KINGLER,    KINGS_ROCK,   SURF, STOMP, GUILLOTINE, BLIZZARD
	db 47, FLAREON,    NO_ITEM,      FLAMETHROWER, QUICK_ATTACK, BITE, FIRE_SPIN
	db -1 ; end

	; COOLTRAINERM (8)
	db "RYAN@", TRAINERTYPE_MOVES
	db 30, PIDGEOT,    SAND_ATTACK, QUICK_ATTACK, WHIRLWIND, WING_ATTACK
	db 33, ELECTABUZZ, THUNDERPUNCH, LIGHT_SCREEN, SWIFT, SCREECH
	db -1 ; end

	; COOLTRAINERM (9)
	db "JAKE@", TRAINERTYPE_MOVES
	db 41, PARASECT,   LEECH_LIFE, SPORE, SLASH, SWORDS_DANCE
	db 43, GOLDUCK,    CONFUSION, SCREECH, PSYCH_UP, FURY_SWIPES
	db -1 ; end

	; COOLTRAINERM (10)
	db "GAVEN@", TRAINERTYPE_MOVES
	db 40, VICTREEBEL, WRAP, TOXIC, ACID, RAZOR_LEAF
	db 40, KINGLER,    BUBBLEBEAM, STOMP, GUILLOTINE, PROTECT
	db 40, FLAREON,    SAND_ATTACK, QUICK_ATTACK, BITE, FIRE_SPIN
	db -1 ; end

	; COOLTRAINERM (11)
	db "BLAKE@", TRAINERTYPE_MOVES
	db 41, MAGNETON,   THUNDERBOLT, SUPERSONIC, SWIFT, SCREECH
	db 38, QUAGSIRE,   WATER_GUN, SLAM, AMNESIA, EARTHQUAKE
	db 38, EXEGGCUTE,  LEECH_SEED, CONFUSION, SLEEP_POWDER, SOLARBEAM
	db -1 ; end

	; COOLTRAINERM (12)
	db "BRIAN@", TRAINERTYPE_MOVES
	db 43, SANDSLASH,  SAND_ATTACK, POISON_STING, SLASH, SWIFT
	db -1 ; end

	; COOLTRAINERM (13)
	db "ERICK@", TRAINERTYPE_NORMAL
	db 11, BULBASAUR
	db 11, CHARMANDER
	db 11, SQUIRTLE
	db -1 ; end

	; COOLTRAINERM (14)
	db "ANDY@", TRAINERTYPE_NORMAL
	db 11, BULBASAUR
	db 11, CHARMANDER
	db 11, SQUIRTLE
	db -1 ; end

	; COOLTRAINERM (15)
	db "TYLER@", TRAINERTYPE_NORMAL
	db 11, BULBASAUR
	db 11, CHARMANDER
	db 11, SQUIRTLE
	db -1 ; end

	; COOLTRAINERM (16)
	db "SEAN@", TRAINERTYPE_NORMAL
	db 43, FLAREON
	db 43, TANGELA
	db 43, TAUROS
	db -1 ; end

	; COOLTRAINERM (17)
	db "KEVIN@", TRAINERTYPE_NORMAL
	db 46, RHYHORN
	db 43, CHARMELEON
	db 43, WARTORTLE
	db -1 ; end

	; COOLTRAINERM (18)
	db "STEVE@", TRAINERTYPE_NORMAL
	db 16, BULBASAUR
	db 16, CHARMANDER
	db 16, SQUIRTLE
	db -1 ; end

	; COOLTRAINERM (19)
	db "ALLEN@", TRAINERTYPE_MOVES
	db 33, CHARMELEON, EMBER, SMOKESCREEN, RAGE, SCARY_FACE
	db -1 ; end

	; COOLTRAINERM (20)
	db "DARIN@", TRAINERTYPE_MOVES
	db 44, DRAGONAIR,  WRAP, SURF, DRAGON_RAGE, SLAM
	db -1 ; end

CooltrainerFGroup:
	; COOLTRAINERF (1)
	db "GWEN@", TRAINERTYPE_NORMAL
	db 31, EEVEE
	db 26, FLAREON
	db 26, VAPOREON
	db 26, JOLTEON
	db -1 ; end

	; COOLTRAINERF (2)
	db "LOIS@", TRAINERTYPE_MOVES
	db 30, SKIPLOOM,   SYNTHESIS, POISONPOWDER, MEGA_DRAIN, LEECH_SEED
	db 30, NINETALES,  EMBER, QUICK_ATTACK, CONFUSE_RAY, SAFEGUARD
	db -1 ; end

	; COOLTRAINERF (3)
	db "FRAN@", TRAINERTYPE_NORMAL
	db 44, SEADRA
	db -1 ; end

	; COOLTRAINERF (4)
	db "LOLA@", TRAINERTYPE_NORMAL
	db 42, DRATINI
	db 43, DRAGONAIR
	db -1 ; end

	; COOLTRAINERF (5)
	db "KATE@", TRAINERTYPE_NORMAL
	db 31, SHELLDER
	db 34, CLOYSTER
	db -1 ; end

	; COOLTRAINERF (6)
	db "IRENE@", TRAINERTYPE_NORMAL
	db 26, GOLDEEN
	db 28, SEAKING
	db -1 ; end

	; COOLTRAINERF (7)
	db "KELLY@", TRAINERTYPE_NORMAL
	db 33, MARILL
	db 28, WARTORTLE
	db 28, WARTORTLE
	db -1 ; end

	; COOLTRAINERF (8)
	db "JOYCE@", TRAINERTYPE_MOVES
	db 43, PIKACHU,    QUICK_ATTACK, DOUBLE_TEAM, THUNDERBOLT, THUNDER
	db 40, BLASTOISE,  BITE, CURSE, SURF, RAIN_DANCE
	db -1 ; end

	; COOLTRAINERF (9)
	db "BETH@", TRAINERTYPE_MOVES
	db 43, RAPIDASH,   STOMP, FIRE_SPIN, FURY_ATTACK, AGILITY
	db -1 ; end

	; COOLTRAINERF (10)
	db "REENA@", TRAINERTYPE_NORMAL
	db 38, STARMIE
	db 41, NIDOQUEEN
	db 38, STARMIE
	db -1 ; end

	; COOLTRAINERF (11)
	db "MEGAN@", TRAINERTYPE_MOVES
	db 40, BULBASAUR,  GROWL, LEECH_SEED, POISONPOWDER, RAZOR_LEAF
	db 40, IVYSAUR,    GROWL, LEECH_SEED, POISONPOWDER, RAZOR_LEAF
	db 40, VENUSAUR,   BODY_SLAM, SLEEP_POWDER, RAZOR_LEAF, SWEET_SCENT
	db -1 ; end

	; COOLTRAINERF (12)
	db "BETH@", TRAINERTYPE_MOVES
	db 47, RAPIDASH,   STOMP, FIRE_SPIN, FURY_ATTACK, AGILITY
	db -1 ; end

	; COOLTRAINERF (13)
	db "CAROL@", TRAINERTYPE_NORMAL
	db 43, ELECTRODE
	db 43, STARMIE
	db 43, NINETALES
	db -1 ; end

	; COOLTRAINERF (14)
	db "QUINN@", TRAINERTYPE_NORMAL
	db 46, IVYSAUR
	db 46, STARMIE
	db -1 ; end

	; COOLTRAINERF (15)
	db "EMMA@", TRAINERTYPE_NORMAL
	db 34, POLIWHIRL
	db -1 ; end

	; COOLTRAINERF (16)
	db "CYBIL@", TRAINERTYPE_MOVES
	db 30, BUTTERFREE, CONFUSION, SLEEP_POWDER, WHIRLWIND, GUST
	db 30, BELLOSSOM,  ABSORB, STUN_SPORE, ACID, SOLARBEAM
	db -1 ; end

	; COOLTRAINERF (17)
	db "JENN@", TRAINERTYPE_NORMAL
	db 28, STARYU
	db 31, STARMIE
	db -1 ; end

	; COOLTRAINERF (18)
	db "BETH@", TRAINERTYPE_ITEM_MOVES
	db 43, RAPIDASH,   FOCUS_BAND,   STOMP, FIRE_SPIN, FURY_ATTACK, FIRE_BLAST
	db -1 ; end

	; COOLTRAINERF (19)
	db "REENA@", TRAINERTYPE_NORMAL
	db 42, STARMIE
	db 43, NIDOQUEEN
	db 42, STARMIE
	db -1 ; end

	; COOLTRAINERF (20)
	db "REENA@", TRAINERTYPE_ITEM_MOVES
	db 46, STARMIE,    NO_ITEM,      DOUBLE_TEAM, PSYCHIC_M, WATERFALL, CONFUSE_RAY
	db 48, NIDOQUEEN,  PINK_BOW,     EARTHQUAKE, DOUBLE_KICK, TOXIC, BODY_SLAM
	db 46, STARMIE,    NO_ITEM,      BLIZZARD, PSYCHIC_M, WATERFALL, RECOVER
	db -1 ; end

	; COOLTRAINERF (21)
	db "CARA@", TRAINERTYPE_MOVES
	db 41, HORSEA,     SMOKESCREEN, LEER, WHIRLPOOL, TWISTER
	db 41, HORSEA,     SMOKESCREEN, LEER, WHIRLPOOL, TWISTER
	db 43, SEADRA,     SWIFT, LEER, WATERFALL, TWISTER
	db -1 ; end

BeautyGroup:
	; BEAUTY (1)
	db "VICTORIA@", TRAINERTYPE_NORMAL
	db 10, SENTRET
	db 15, SENTRET
	db 20, SENTRET
	db -1 ; end

	; BEAUTY (2)
	db "SAMANTHA@", TRAINERTYPE_MOVES
	db 18, MEOWTH,     SCRATCH, GROWL, BITE, PAY_DAY
	db 18, MEOWTH,     SCRATCH, GROWL, BITE, SLASH
	db -1 ; end

	; BEAUTY (3)
	db "JULIE@", TRAINERTYPE_NORMAL
	db 17, SENTRET
	db -1 ; end

	; BEAUTY (4)
	db "JACLYN@", TRAINERTYPE_NORMAL
	db 17, SENTRET
	db -1 ; end

	; BEAUTY (5)
	db "BRENDA@", TRAINERTYPE_NORMAL
	db 18, FURRET
	db -1 ; end

	; BEAUTY (6)
	db "CASSIE@", TRAINERTYPE_NORMAL
	db 34, VILEPLUME
	db 42, BUTTERFREE
	db -1 ; end

	; BEAUTY (7)
	db "CAROLINE@", TRAINERTYPE_NORMAL
	db 36, MARILL
	db 40, SEEL
	db 36, MARILL
	db -1 ; end

	; BEAUTY (8)
	db "CARLENE@", TRAINERTYPE_NORMAL
	db 17, SENTRET
	db -1 ; end

	; BEAUTY (9)
	db "JESSICA@", TRAINERTYPE_NORMAL
	db 17, SENTRET
	db -1 ; end

	; BEAUTY (10)
	db "RACHAEL@", TRAINERTYPE_NORMAL
	db 17, SENTRET
	db -1 ; end

	; BEAUTY (11)
	db "ANGELICA@", TRAINERTYPE_NORMAL
	db 17, SENTRET
	db -1 ; end

	; BEAUTY (12)
	db "KENDRA@", TRAINERTYPE_NORMAL
	db 17, SENTRET
	db -1 ; end

	; BEAUTY (13)
	db "VERONICA@", TRAINERTYPE_NORMAL
	db 17, SENTRET
	db -1 ; end

	; BEAUTY (14)
	db "JULIA@", TRAINERTYPE_NORMAL
	db 40, PARAS
	db 40, EXEGGCUTE
	db 43, PARASECT
	db -1 ; end

	; BEAUTY (15)
	db "THERESA@", TRAINERTYPE_NORMAL
	db 17, SENTRET
	db -1 ; end

	; BEAUTY (16)
	db "VALERIE@", TRAINERTYPE_MOVES
	db 20, HOPPIP,     SYNTHESIS, TAIL_WHIP, TACKLE, POISONPOWDER
	db 20, SKIPLOOM,   SYNTHESIS, TAIL_WHIP, TACKLE, STUN_SPORE
	db -1 ; end

	; BEAUTY (17)
	db "OLIVIA@", TRAINERTYPE_NORMAL
	db 22, CORSOLA
	db -1 ; end

PokemaniacGroup:
	; POKEMANIAC (1)
	db "LARRY@", TRAINERTYPE_NORMAL
	db 11, SLOWPOKE
	db -1 ; end

	; POKEMANIAC (2)
	db "ANDREW@", TRAINERTYPE_NORMAL
	db 28, MAROWAK
	db 28, MAROWAK
	db -1 ; end

	; POKEMANIAC (3)
	db "CALVIN@", TRAINERTYPE_NORMAL
	db 31, KANGASKHAN
	db -1 ; end

	; POKEMANIAC (4)
	db "SHANE@", TRAINERTYPE_NORMAL
	db 18, NIDORINA
	db 18, NIDORINO
	db -1 ; end

	; POKEMANIAC (5)
	db "BEN@", TRAINERTYPE_NORMAL
	db 22, SLOWBRO
	db -1 ; end

	; POKEMANIAC (6)
	db "BRENT@", TRAINERTYPE_NORMAL
	db 22, LICKITUNG
	db -1 ; end

	; POKEMANIAC (7)
	db "RON@", TRAINERTYPE_NORMAL
	db 22, NIDOKING
	db -1 ; end

	; POKEMANIAC (8)
	db "ETHAN@", TRAINERTYPE_NORMAL
	db 38, RHYHORN
	db 38, RHYDON
	db -1 ; end

	; POKEMANIAC (9)
	db "BRENT@", TRAINERTYPE_NORMAL
	db 30, KANGASKHAN
	db -1 ; end

	; POKEMANIAC (10)
	db "BRENT@", TRAINERTYPE_MOVES
	db 43, PORYGON,    RECOVER, PSYCHIC_M, CONVERSION2, TRI_ATTACK
	db -1 ; end

	; POKEMANIAC (11)
	db "ISSAC@", TRAINERTYPE_MOVES
	db 13, LICKITUNG,  LICK, SUPERSONIC, CUT, NO_MOVE
	db -1 ; end

	; POKEMANIAC (12)
	db "DONALD@", TRAINERTYPE_NORMAL
	db 11, SLOWPOKE
	db 11, SLOWPOKE
	db -1 ; end

	; POKEMANIAC (13)
	db "ZACH@", TRAINERTYPE_NORMAL
	db 33, RHYHORN
	db -1 ; end

	; POKEMANIAC (14)
	db "BRENT@", TRAINERTYPE_MOVES
	db 41, CHANSEY,    ROLLOUT, ATTRACT, EGG_BOMB, SOFTBOILED
	db -1 ; end

	; POKEMANIAC (15)
	db "MILLER@", TRAINERTYPE_NORMAL
	db 20, NIDOKING
	db 20, NIDOQUEEN
	db -1 ; end

GruntMGroup:
	; GRUNTM (1)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 16, KOFFING
	db -1 ; end

	; GRUNTM (2)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db  8, RATTATA
	db 10, ZUBAT
	db 10, ZUBAT
	db -1 ; end

	; GRUNTM (3)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 28, RATICATE
	db 28, RATICATE
	db -1 ; end

	; GRUNTM (4)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 27, GRIMER
	db 27, GRIMER
	db 30, MUK
	db -1 ; end

	; GRUNTM (5)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 25, RATTATA
	db 25, RATTATA
	db 27, RATTATA
	db 27, RATTATA
	db 27, RATTATA
	db -1 ; end

	; GRUNTM (6)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 31, ZUBAT
	db 31, ZUBAT
	db -1 ; end

	; GRUNTM (7)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 27, KOFFING
	db 27, GRIMER
	db 27, ZUBAT
	db 27, RATTATA
	db -1 ; end

	; GRUNTM (8)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 31, WEEZING
	db -1 ; end

	; GRUNTM (9)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 28, RATICATE
	db 31, KOFFING
	db -1 ; end

	; GRUNTM (10)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 26, ZUBAT
	db 28, GOLBAT
	db 26, GRIMER
	db -1 ; end

	; GRUNTM (11)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 27, MUK
	db 27, KOFFING
	db 30, RATTATA
	db -1 ; end

	; GRUNTM (12)
	db "EXECUTIVE@", TRAINERTYPE_NORMAL
	db 41, HOUNDOUR
	db -1 ; end

	; GRUNTM (13)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 33, RATTATA
	db -1 ; end

	; GRUNTM (14)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 28, RATICATE
	db 28, GOLBAT
	db -1 ; end

	; GRUNTM (15)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 31, GRIMER
	db 27, WEEZING
	db -1 ; end

	; GRUNTM (16)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 18, RATTATA
	db 18, RATTATA
	db 18, RATTATA
	db 18, RATTATA
	db -1 ; end

	; GRUNTM (17)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 21, GOLBAT
	db -1 ; end

	; GRUNTM (18)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 20, RATTATA
	db 20, ZUBAT
	db 20, RATTATA
	db -1 ; end

	; GRUNTM (19)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 21, VENONAT
	db 21, VENONAT
	db -1 ; end

	; GRUNTM (20)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 20, DROWZEE
	db 22, ZUBAT
	db -1 ; end

	; GRUNTM (21)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 18, ZUBAT
	db 20, GRIMER
	db 21, RATTATA
	db -1 ; end

	; GRUNTM (22)
	db "EXECUTIVE@", TRAINERTYPE_NORMAL
	db 43, GOLBAT
	db -1 ; end

	; GRUNTM (23)
	db "EXECUTIVE@", TRAINERTYPE_NORMAL
	db 36, KOFFING
	db -1 ; end

	; GRUNTM (24)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 30, KOFFING
	db 30, KOFFING
	db -1 ; end

	; GRUNTM (25)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 28, KOFFING
	db 28, MUK
	db -1 ; end

	; GRUNTM (26)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 17, RATTATA
	db 17, RATTATA
	db -1 ; end

	; GRUNTM (27)
	db "EXECUTIVE@", TRAINERTYPE_NORMAL
	db 26, ZUBAT
	db -1 ; end

	; GRUNTM (28)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 22, RATICATE
	db -1 ; end

	; GRUNTM (29)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 10, RATTATA
	db 10, RATTATA
	db -1 ; end

	; GRUNTM (30)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 30, GOLBAT
	db 30, GOLBAT
	db 36, ARBOK
	db -1 ; end

	; GRUNTM (31)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 36, GOLBAT
	db -1 ; end

GentlemanGroup:
	; GENTLEMAN (1)
	db "PRESTON@", TRAINERTYPE_NORMAL
	db 21, GROWLITHE
	db 21, GROWLITHE
	db -1 ; end

	; GENTLEMAN (2)
	db "EDWARD@", TRAINERTYPE_NORMAL
	db 41, PERSIAN
	db -1 ; end

	; GENTLEMAN (3)
	db "GREGORY@", TRAINERTYPE_NORMAL
	db 44, PIKACHU
	db 41, FLAAFFY
	db -1 ; end

	; GENTLEMAN (4)
	db "VIRGIL@", TRAINERTYPE_NORMAL
	db 23, PONYTA
	db -1 ; end

	; GENTLEMAN (5)
	db "ALFRED@", TRAINERTYPE_NORMAL
	db 23, NOCTOWL
	db -1 ; end

SkierGroup:
	; SKIER (1)
	db "ROXANNE@", TRAINERTYPE_NORMAL
	db 34, JYNX
	db -1 ; end

	; SKIER (2)
	db "CLARISSA@", TRAINERTYPE_NORMAL
	db 34, DEWGONG
	db -1 ; end

TeacherGroup:
	; TEACHER (1)
	db "COLETTE@", TRAINERTYPE_NORMAL
	db 43, CLEFAIRY
	db -1 ; end

	; TEACHER (2)
	db "HILLARY@", TRAINERTYPE_NORMAL
	db 40, AIPOM
	db 43, CUBONE
	db -1 ; end

	; TEACHER (3)
	db "SHIRLEY@", TRAINERTYPE_NORMAL
	db 43, JIGGLYPUFF
	db -1 ; end

SabrinaGroup:
	; SABRINA (1)
	db "SABRINA@", TRAINERTYPE_MOVES
	db 54, ESPEON,     SAND_ATTACK, QUICK_ATTACK, SWIFT, PSYCHIC_M
	db 52, GIRAFARIG,   PSYCHIC_M, CRUNCH, AGILITY, PSYBEAM
	db 54, MR__MIME,   BARRIER, REFLECT, BATON_PASS, PSYCHIC_M
	db 56, ALAKAZAM,   RECOVER, FUTURE_SIGHT, PSYCHIC_M, REFLECT
	db -1 ; end
	
	; SABRINA (1)
	db "SABRINA@", TRAINERTYPE_ITEM_MOVES
	db 66, ESPEON,     TWISTEDSPOON, SHADOW_BALL, BATON_PASS, SWIFT, PSYCHIC_M
	db 66, WOBBUFFET,  GOLD_BERRY,   MIRROR_COAT, COUNTER, DESTINY_BOND, ENCORE
	db 66, XATU,	   TWISTEDSPOON, PSYCHIC_M, CONFUSE_RAY, NIGHT_SHADE, PROTECT
	db 68, JYNX,   	   NEVERMELTICE, PSYCHIC_M, ICE_PUNCH, BLIZZARD, PERISH_SONG
	db 66, MR__MIME,   TWISTEDSPOON, BARRIER, REFLECT, THUNDER, PSYCHIC_M
	db 68, ALAKAZAM,   TWISTEDSPOON, RECOVER, FUTURE_SIGHT, PSYCHIC_M, REFLECT
	db -1 ; end

BugCatcherGroup:
	; BUG_CATCHER (1)
	db "DON@", TRAINERTYPE_NORMAL
	db  4, CATERPIE
	db  4, CATERPIE
	db -1 ; end

	; BUG_CATCHER (2)
	db "ROB@", TRAINERTYPE_NORMAL
	db 40, BEEDRILL
	db 40, BUTTERFREE
	db -1 ; end

	; BUG_CATCHER (3)
	db "ED@", TRAINERTYPE_NORMAL
	db 36, BEEDRILL
	db 36, BEEDRILL
	db 36, BEEDRILL
	db -1 ; end

	; BUG_CATCHER (4)
	db "WADE@", TRAINERTYPE_NORMAL
	db  4, CATERPIE
	db  4, CATERPIE
	db  4, WEEDLE
	db  4, CATERPIE
	db -1 ; end

	; BUG_CATCHER (5)
	db "BENNY@", TRAINERTYPE_NORMAL
	db  8, WEEDLE
	db 10, KAKUNA
	db 13, BEEDRILL
	db -1 ; end

	; BUG_CATCHER (6)
	db "AL@", TRAINERTYPE_NORMAL
	db 13, CATERPIE
	db 13, WEEDLE
	db -1 ; end

	; BUG_CATCHER (7)
	db "JOSH@", TRAINERTYPE_NORMAL
	db 15, PARAS
	db -1 ; end

	; BUG_CATCHER (8)
	db "ARNIE@", TRAINERTYPE_NORMAL
	db 17, VENONAT
	db -1 ; end

	; BUG_CATCHER (9)
	db "KEN@", TRAINERTYPE_NORMAL
	db 36, ARIADOS
	db 40, PINSIR
	db -1 ; end

	; BUG_CATCHER (10)
	db "WADE@", TRAINERTYPE_NORMAL
	db 10, METAPOD
	db 10, METAPOD
	db 11, KAKUNA
	db 10, METAPOD
	db -1 ; end

	; BUG_CATCHER (11)
	db "WADE@", TRAINERTYPE_NORMAL
	db 16, BUTTERFREE
	db 16, BUTTERFREE
	db 17, BEEDRILL
	db 16, BUTTERFREE
	db -1 ; end

	; BUG_CATCHER (12)
	db "DOUG@", TRAINERTYPE_NORMAL
	db 42, ARIADOS
	db -1 ; end

	; BUG_CATCHER (13)
	db "ARNIE@", TRAINERTYPE_NORMAL
	db 22, VENONAT
	db -1 ; end

	; BUG_CATCHER (14)
	db "ARNIE@", TRAINERTYPE_MOVES
	db 34, VENOMOTH,   DISABLE, SUPERSONIC, CONFUSION, LEECH_LIFE
	db -1 ; end

	; BUG_CATCHER (15)
	db "WADE@", TRAINERTYPE_MOVES
	db 28, BUTTERFREE, CONFUSION, POISONPOWDER, SUPERSONIC, WHIRLWIND
	db 28, BUTTERFREE, CONFUSION, STUN_SPORE, SUPERSONIC, WHIRLWIND
	db 30, BEEDRILL,   FURY_ATTACK, FOCUS_ENERGY, TWINEEDLE, RAGE
	db 28, BUTTERFREE, CONFUSION, SLEEP_POWDER, SUPERSONIC, WHIRLWIND
	db -1 ; end

	; BUG_CATCHER (16)
	db "WADE@", TRAINERTYPE_MOVES
	db 36, BUTTERFREE, CONFUSION, POISONPOWDER, SUPERSONIC, GUST
	db 36, BUTTERFREE, CONFUSION, STUN_SPORE, SUPERSONIC, GUST
	db 40, BEEDRILL,   FURY_ATTACK, PURSUIT, TWINEEDLE, DOUBLE_TEAM
	db 42, BUTTERFREE, PSYBEAM, SLEEP_POWDER, GUST, WHIRLWIND
	db -1 ; end

	; BUG_CATCHER (17)
	db "ARNIE@", TRAINERTYPE_MOVES
	db 43, VENOMOTH,   GUST, SUPERSONIC, PSYBEAM, LEECH_LIFE
	db -1 ; end

	; BUG_CATCHER (18)
	db "ARNIE@", TRAINERTYPE_MOVES
	db 48, VENOMOTH,   GUST, SUPERSONIC, PSYCHIC_M, TOXIC
	db -1 ; end

	; BUG_CATCHER (19)
	db "WAYNE@", TRAINERTYPE_NORMAL
	db  9, LEDYBA
	db 11, PARAS
	db -1 ; end

FisherGroup:
	; FISHER (1)
	db "JUSTIN@", TRAINERTYPE_NORMAL
	db  6, MAGIKARP
	db  6, MAGIKARP
	db 17, MAGIKARP
	db  6, MAGIKARP
	db -1 ; end

	; FISHER (2)
	db "RALPH@", TRAINERTYPE_NORMAL
	db 11, GOLDEEN
	db -1 ; end

	; FISHER (3)
	db "ARNOLD@", TRAINERTYPE_NORMAL
	db 42, TENTACRUEL
	db -1 ; end

	; FISHER (4)
	db "KYLE@", TRAINERTYPE_NORMAL
	db 34, SEAKING
	db 38, POLIWHIRL
	db 38, SEAKING
	db -1 ; end

	; FISHER (5)
	db "HENRY@", TRAINERTYPE_NORMAL
	db  9, POLIWAG
	db  9, POLIWAG
	db -1 ; end

	; FISHER (6)
	db "MARVIN@", TRAINERTYPE_NORMAL
	db 11, MAGIKARP
	db 11, GYARADOS
	db 17, MAGIKARP
	db 17, GYARADOS
	db -1 ; end

	; FISHER (7)
	db "TULLY@", TRAINERTYPE_NORMAL
	db 21, QWILFISH
	db -1 ; end

	; FISHER (8)
	db "ANDRE@", TRAINERTYPE_NORMAL
	db 33, GYARADOS
	db -1 ; end

	; FISHER (9)
	db "RAYMOND@", TRAINERTYPE_NORMAL
	db 26, MAGIKARP
	db 26, MAGIKARP
	db 26, MAGIKARP
	db 26, MAGIKARP
	db -1 ; end

	; FISHER (10)
	db "WILTON@", TRAINERTYPE_NORMAL
	db 27, GOLDEEN
	db 27, GOLDEEN
	db 30, SEAKING
	db -1 ; end

	; FISHER (11)
	db "EDGAR@", TRAINERTYPE_MOVES
	db 30, REMORAID,   LOCK_ON, PSYBEAM, AURORA_BEAM, BUBBLEBEAM
	db 30, REMORAID,   LOCK_ON, PSYBEAM, AURORA_BEAM, BUBBLEBEAM
	db -1 ; end

	; FISHER (12)
	db "JONAH@", TRAINERTYPE_NORMAL
	db 30, SHELLDER
	db 35, OCTILLERY
	db 30, REMORAID
	db 35, CLOYSTER
	db -1 ; end

	; FISHER (13)
	db "MARTIN@", TRAINERTYPE_NORMAL
	db 40, REMORAID
	db 40, REMORAID
	db -1 ; end

	; FISHER (14)
	db "STEPHEN@", TRAINERTYPE_NORMAL
	db 30, MAGIKARP
	db 30, MAGIKARP
	db 38, QWILFISH
	db 38, TENTACRUEL
	db -1 ; end

	; FISHER (15)
	db "BARNEY@", TRAINERTYPE_NORMAL
	db 36, GYARADOS
	db 36, GYARADOS
	db 36, GYARADOS
	db -1 ; end

	; FISHER (16)
	db "RALPH@", TRAINERTYPE_NORMAL
	db 20, GOLDEEN
	db -1 ; end

	; FISHER (17)
	db "RALPH@", TRAINERTYPE_NORMAL
	db 20, QWILFISH
	db 22, GOLDEEN
	db -1 ; end

	; FISHER (18)
	db "TULLY@", TRAINERTYPE_NORMAL
	db 27, QWILFISH
	db -1 ; end

	; FISHER (19)
	db "TULLY@", TRAINERTYPE_NORMAL
	db 40, GOLDEEN
	db 40, GOLDEEN
	db 40, QWILFISH
	db -1 ; end

	; FISHER (20)
	db "WILTON@", TRAINERTYPE_NORMAL
	db 35, GOLDEEN
	db 35, GOLDEEN
	db 40, SEAKING
	db -1 ; end

	; FISHER (21)
	db "SCOTT@", TRAINERTYPE_NORMAL
	db 36, QWILFISH
	db 36, QWILFISH
	db 42, SEAKING
	db -1 ; end

	; FISHER (22)
	db "WILTON@", TRAINERTYPE_MOVES
	db 42, SEAKING,    SUPERSONIC, WATERFALL, FLAIL, FURY_ATTACK
	db 42, SEAKING,    SUPERSONIC, WATERFALL, FLAIL, FURY_ATTACK
	db 46, REMORAID,   PSYBEAM, AURORA_BEAM, BUBBLEBEAM, HYPER_BEAM
	db -1 ; end

	; FISHER (23)
	db "RALPH@", TRAINERTYPE_NORMAL
	db 36, QWILFISH
	db 40, GOLDEEN
	db -1 ; end

	; FISHER (24)
	db "RALPH@", TRAINERTYPE_MOVES
	db 43, QWILFISH,   TOXIC, MINIMIZE, SURF, PIN_MISSILE
	db 47, SEAKING,    ENDURE, FLAIL, FURY_ATTACK, WATERFALL
	db -1 ; end

	; FISHER (25)
	db "TULLY@", TRAINERTYPE_MOVES
	db 42, SEAKING,    SUPERSONIC, RAIN_DANCE, WATERFALL, FURY_ATTACK
	db 42, SEAKING,    SUPERSONIC, RAIN_DANCE, WATERFALL, FURY_ATTACK
	db 44, QWILFISH,   ROLLOUT, SURF, PIN_MISSILE, TAKE_DOWN
	db -1 ; end

SwimmerMGroup:
	; SWIMMERM (1)
	db "HAROLD@", TRAINERTYPE_NORMAL
	db 40, REMORAID
	db 36, SEADRA
	db -1 ; end

	; SWIMMERM (2)
	db "SIMON@", TRAINERTYPE_NORMAL
	db 23, TENTACOOL
	db 23, TENTACOOL
	db -1 ; end

	; SWIMMERM (3)
	db "RANDALL@", TRAINERTYPE_NORMAL
	db 21, SHELLDER
	db 23, WARTORTLE
	db 21, SHELLDER
	db -1 ; end

	; SWIMMERM (4)
	db "CHARLIE@", TRAINERTYPE_NORMAL
	db 25, SHELLDER
	db 22, TENTACOOL
	db 22, TENTACRUEL
	db -1 ; end

	; SWIMMERM (5)
	db "GEORGE@", TRAINERTYPE_NORMAL
	db 18, TENTACOOL
	db 20, TENTACOOL
	db 18, TENTACOOL
	db 22, STARYU
	db 20, TENTACOOL
	db 22, REMORAID
	db -1 ; end

	; SWIMMERM (6)
	db "BERKE@", TRAINERTYPE_NORMAL
	db 27, QWILFISH
	db -1 ; end

	; SWIMMERM (7)
	db "KIRK@", TRAINERTYPE_NORMAL
	db 23, GYARADOS
	db 23, GYARADOS
	db -1 ; end

	; SWIMMERM (8)
	db "MATHEW@", TRAINERTYPE_NORMAL
	db 27, KRABBY
	db -1 ; end

	; SWIMMERM (9)
	db "HAL@", TRAINERTYPE_NORMAL
	db 28, SEEL
	db 30, DEWGONG
	db 28, SEEL
	db -1 ; end

	; SWIMMERM (10)
	db "PATON@", TRAINERTYPE_NORMAL
	db 31, PILOSWINE
	db 31, PILOSWINE
	db -1 ; end

	; SWIMMERM (11)
	db "DARYL@", TRAINERTYPE_NORMAL
	db 28, SHELLDER
	db 30, CLOYSTER
	db 28, SHELLDER
	db -1 ; end

	; SWIMMERM (12)
	db "WALTER@", TRAINERTYPE_NORMAL
	db 17, HORSEA
	db 17, HORSEA
	db 23, SEADRA
	db -1 ; end

	; SWIMMERM (13)
	db "TONY@", TRAINERTYPE_NORMAL
	db 15, STARYU
	db 21, STARMIE
	db 18, HORSEA
	db -1 ; end

	; SWIMMERM (14)
	db "JEROME@", TRAINERTYPE_NORMAL
	db 31, SEADRA
	db 34, TENTACOOL
	db 36, TENTACRUEL
	db 34, GOLDEEN
	db -1 ; end

	; SWIMMERM (15)
	db "TUCKER@", TRAINERTYPE_NORMAL
	db 36, SHELLDER
	db 42, CLOYSTER
	db -1 ; end

	; SWIMMERM (16)
	db "RICK@", TRAINERTYPE_NORMAL
	db 15, STARYU
	db 21, STARMIE
	db 18, HORSEA
	db -1 ; end

	; SWIMMERM (17)
	db "CAMERON@", TRAINERTYPE_NORMAL
	db 42, MARILL
	db -1 ; end

	; SWIMMERM (18)
	db "SETH@", TRAINERTYPE_NORMAL
	db 35, QUAGSIRE
	db 35, OCTILLERY
	db 40, QUAGSIRE
	db -1 ; end

	; SWIMMERM (19)
	db "JAMES@", TRAINERTYPE_NORMAL
	db 15, STARYU
	db 21, STARMIE
	db 18, HORSEA
	db -1 ; end

	; SWIMMERM (20)
	db "LEWIS@", TRAINERTYPE_NORMAL
	db 15, STARYU
	db 21, STARMIE
	db 18, HORSEA
	db -1 ; end

	; SWIMMERM (21)
	db "PARKER@", TRAINERTYPE_NORMAL
	db 40, HORSEA
	db 40, HORSEA
	db 43, SEADRA
	db -1 ; end

SwimmerFGroup:
	; SWIMMERF (1)
	db "ELAINE@", TRAINERTYPE_NORMAL
	db 25, STARYU
	db -1 ; end

	; SWIMMERF (2)
	db "PAULA@", TRAINERTYPE_NORMAL
	db 22, STARYU
	db 22, SHELLDER
	db -1 ; end

	; SWIMMERF (3)
	db "KAYLEE@", TRAINERTYPE_NORMAL
	db 21, GOLDEEN
	db 23, GOLDEEN
	db 23, SEAKING
	db -1 ; end

	; SWIMMERF (4)
	db "SUSIE@", TRAINERTYPE_MOVES
	db 23, PSYDUCK,    SCRATCH, TAIL_WHIP, DISABLE, CONFUSION
	db 26, GOLDEEN,    PECK, TAIL_WHIP, SUPERSONIC, HORN_ATTACK
	db -1 ; end

	; SWIMMERF (5)
	db "DENISE@", TRAINERTYPE_NORMAL
	db 26, SEEL
	db -1 ; end

	; SWIMMERF (6)
	db "KARA@", TRAINERTYPE_NORMAL
	db 23, STARYU
	db 23, STARMIE
	db -1 ; end

	; SWIMMERF (7)
	db "WENDY@", TRAINERTYPE_MOVES
	db 25, HORSEA,     BUBBLE, SMOKESCREEN, LEER, WATER_GUN
	db 25, HORSEA,     DRAGON_RAGE, SMOKESCREEN, LEER, WATER_GUN
	db -1 ; end

	; SWIMMERF (8)
	db "LISA@", TRAINERTYPE_NORMAL
	db 34, JYNX
	db -1 ; end

	; SWIMMERF (9)
	db "JILL@", TRAINERTYPE_NORMAL
	db 34, DEWGONG
	db -1 ; end

	; SWIMMERF (10)
	db "MARY@", TRAINERTYPE_NORMAL
	db 23, SEAKING
	db -1 ; end

	; SWIMMERF (11)
	db "KATIE@", TRAINERTYPE_NORMAL
	db 41, DEWGONG
	db -1 ; end

	; SWIMMERF (12)
	db "DAWN@", TRAINERTYPE_NORMAL
	db 42, SEAKING
	db -1 ; end

	; SWIMMERF (13)
	db "TARA@", TRAINERTYPE_NORMAL
	db 23, SEAKING
	db -1 ; end

	; SWIMMERF (14)
	db "NICOLE@", TRAINERTYPE_NORMAL
	db 35, MARILL
	db 35, MARILL
	db 40, LAPRAS
	db -1 ; end

	; SWIMMERF (15)
	db "LORI@", TRAINERTYPE_NORMAL
	db 40, STARMIE
	db 40, STARMIE
	db -1 ; end

	; SWIMMERF (16)
	db "JODY@", TRAINERTYPE_NORMAL
	db 23, SEAKING
	db -1 ; end

	; SWIMMERF (17)
	db "NIKKI@", TRAINERTYPE_NORMAL
	db 34, SEEL
	db 34, SEEL
	db 34, SEEL
	db 34, DEWGONG
	db -1 ; end

	; SWIMMERF (18)
	db "DIANA@", TRAINERTYPE_NORMAL
	db 44, GOLDUCK
	db -1 ; end

	; SWIMMERF (19)
	db "BRIANA@", TRAINERTYPE_NORMAL
	db 43, SEAKING
	db 43, SEAKING
	db -1 ; end

SailorGroup:
	; SAILOR (1)
	db "EUGENE@", TRAINERTYPE_NORMAL
	db 20, POLIWHIRL
	db 20, RATICATE
	db 22, KRABBY
	db -1 ; end

	; SAILOR (2)
	db "HUEY@", TRAINERTYPE_NORMAL
	db 21, POLIWAG
	db 21, POLIWHIRL
	db -1 ; end

	; SAILOR (3)
	db "TERRELL@", TRAINERTYPE_NORMAL
	db 23, POLIWHIRL
	db -1 ; end

	; SAILOR (4)
	db "KENT@", TRAINERTYPE_MOVES
	db 21, KRABBY,     BUBBLE, LEER, VICEGRIP, HARDEN
	db 23, KRABBY,     BUBBLEBEAM, LEER, VICEGRIP, HARDEN
	db -1 ; end

	; SAILOR (5)
	db "ERNEST@", TRAINERTYPE_NORMAL
	db 21, MACHOP
	db 21, MACHOP
	db 21, POLIWHIRL
	db -1 ; end

	; SAILOR (6)
	db "JEFF@", TRAINERTYPE_NORMAL
	db 40, RATICATE
	db 40, RATICATE
	db -1 ; end

	; SAILOR (7)
	db "GARRETT@", TRAINERTYPE_NORMAL
	db 42, KINGLER
	db -1 ; end

	; SAILOR (8)
	db "KENNETH@", TRAINERTYPE_NORMAL
	db 34, MACHOP
	db 34, MACHOP
	db 34, POLIWRATH
	db 34, MACHOP
	db -1 ; end

	; SAILOR (9)
	db "STANLY@", TRAINERTYPE_NORMAL
	db 38, MACHOP
	db 41, MACHOKE
	db 31, PSYDUCK
	db -1 ; end

	; SAILOR (10)
	db "HARRY@", TRAINERTYPE_NORMAL
	db 22, WOOPER
	db -1 ; end

	; SAILOR (11)
	db "HUEY@", TRAINERTYPE_NORMAL
	db 34, POLIWHIRL
	db 34, POLIWHIRL
	db -1 ; end

	; SAILOR (12)
	db "HUEY@", TRAINERTYPE_NORMAL
	db 42, POLIWHIRL
	db 42, POLIWRATH
	db -1 ; end

	; SAILOR (13)
	db "HUEY@", TRAINERTYPE_MOVES
	db 46, POLITOED,   WHIRLPOOL, RAIN_DANCE, BODY_SLAM, PERISH_SONG
	db 46, POLIWRATH,  SURF, STRENGTH, ICE_PUNCH, SUBMISSION
	db -1 ; end

SuperNerdGroup:
	; SUPER_NERD (1)
	db "STAN@", TRAINERTYPE_NORMAL
	db 23, GRIMER
	db -1 ; end

	; SUPER_NERD (2)
	db "ERIC@", TRAINERTYPE_NORMAL
	db 12, GRIMER
	db 12, GRIMER
	db -1 ; end

	; SUPER_NERD (3)
	db "GREGG@", TRAINERTYPE_NORMAL
	db 23, MAGNEMITE
	db 23, MAGNEMITE
	db 23, MAGNEMITE
	db -1 ; end

	; SUPER_NERD (4)
	db "JAY@", TRAINERTYPE_NORMAL
	db 26, KOFFING
	db 26, KOFFING
	db -1 ; end

	; SUPER_NERD (5)
	db "DAVE@", TRAINERTYPE_NORMAL
	db 28, DITTO
	db -1 ; end

	; SUPER_NERD (6)
	db "SAM@", TRAINERTYPE_NORMAL
	db 42, GRIMER
	db 42, MUK
	db -1 ; end

	; SUPER_NERD (7)
	db "TOM@", TRAINERTYPE_NORMAL
	db 40, MAGNEMITE
	db 40, MAGNEMITE
	db 40, MAGNEMITE
	db -1 ; end

	; SUPER_NERD (8)
	db "PAT@", TRAINERTYPE_NORMAL
	db 43, PORYGON
	db -1 ; end

	; SUPER_NERD (9)
	db "SHAWN@", TRAINERTYPE_NORMAL
	db 38, MAGNEMITE
	db 41, MUK
	db 38, MAGNEMITE
	db -1 ; end

	; SUPER_NERD (10)
	db "TERU@", TRAINERTYPE_NORMAL
	db  8, MAGNEMITE
	db 12, VOLTORB
	db  8, MAGNEMITE
	db 10, MAGNEMITE
	db -1 ; end

	; SUPER_NERD (11)
	db "RUSS@", TRAINERTYPE_NORMAL
	db 33, MAGNEMITE
	db 33, MAGNEMITE
	db 33, MAGNEMITE
	db -1 ; end

	; SUPER_NERD (12)
	db "NORTON@", TRAINERTYPE_MOVES
	db 36, PORYGON,    CONVERSION, CONVERSION2, RECOVER, TRI_ATTACK
	db -1 ; end

	; SUPER_NERD (13)
	db "HUGH@", TRAINERTYPE_MOVES
	db 47, SEADRA,     SMOKESCREEN, TWISTER, SURF, WATERFALL
	db -1 ; end

	; SUPER_NERD (14)
	db "MARKUS@", TRAINERTYPE_MOVES
	db 22, SLOWPOKE,   CURSE, WATER_GUN, GROWL, STRENGTH
	db -1 ; end
	
Rival2Group:
	; RIVAL2 (1)
	db "?@", TRAINERTYPE_MOVES
	db 50, SNEASEL,    QUICK_ATTACK, SCREECH, FAINT_ATTACK, FURY_CUTTER
	db 52, GOLBAT,     LEECH_LIFE, BITE, CONFUSE_RAY, WING_ATTACK
	db 50, MAGNETON,   THUNDERSHOCK, SONICBOOM, THUNDER_WAVE, SWIFT
	db 50, GENGAR,     MEAN_LOOK, CURSE, SHADOW_BALL, CONFUSE_RAY
	db 52, ALAKAZAM,   DISABLE, RECOVER, FUTURE_SIGHT, PSYCHIC_M
	db 56, MEGANIUM,   RAZOR_LEAF, POISONPOWDER, BODY_SLAM, LIGHT_SCREEN
	db -1 ; end

	; RIVAL2 (2)
	db "?@", TRAINERTYPE_MOVES
	db 50, SNEASEL,    QUICK_ATTACK, SCREECH, FAINT_ATTACK, FURY_CUTTER
	db 52, GOLBAT,     LEECH_LIFE, BITE, CONFUSE_RAY, WING_ATTACK
	db 50, MAGNETON,   THUNDERSHOCK, SONICBOOM, THUNDER_WAVE, SWIFT
	db 50, GENGAR,     MEAN_LOOK, CURSE, SHADOW_BALL, CONFUSE_RAY
	db 52, ALAKAZAM,   DISABLE, RECOVER, FUTURE_SIGHT, PSYCHIC_M
	db 56, TYPHLOSION, SMOKESCREEN, QUICK_ATTACK, FLAME_WHEEL, SWIFT
	db -1 ; end

	; RIVAL2 (3)
	db "?@", TRAINERTYPE_MOVES
	db 50, SNEASEL,    QUICK_ATTACK, SCREECH, FAINT_ATTACK, FURY_CUTTER
	db 52, GOLBAT,     LEECH_LIFE, BITE, CONFUSE_RAY, WING_ATTACK
	db 50, MAGNETON,   THUNDERSHOCK, SONICBOOM, THUNDER_WAVE, SWIFT
	db 50, GENGAR,     MEAN_LOOK, CURSE, SHADOW_BALL, CONFUSE_RAY
	db 52, ALAKAZAM,   DISABLE, RECOVER, FUTURE_SIGHT, PSYCHIC_M
	db 56, FERALIGATR, RAGE, WATER_GUN, SCARY_FACE, SLASH
	db -1 ; end

	; RIVAL2 (4)
	db "?@", TRAINERTYPE_MOVES
	db 56, SNEASEL,    QUICK_ATTACK, SCREECH, FAINT_ATTACK, FURY_CUTTER
	db 58, CROBAT,     TOXIC, BITE, CONFUSE_RAY, WING_ATTACK
	db 56, MAGNETON,   THUNDER, SONICBOOM, THUNDER_WAVE, SWIFT
	db 56, GENGAR,     MEAN_LOOK, CURSE, SHADOW_BALL, CONFUSE_RAY
	db 58, ALAKAZAM,   RECOVER, FUTURE_SIGHT, PSYCHIC_M, REFLECT
	db 62, MEGANIUM,   GIGA_DRAIN, BODY_SLAM, LIGHT_SCREEN, SAFEGUARD
	db -1 ; end

	; RIVAL2 (5)
	db "?@", TRAINERTYPE_MOVES
	db 56, SNEASEL,    QUICK_ATTACK, SCREECH, FAINT_ATTACK, FURY_CUTTER
	db 58, CROBAT,     TOXIC, BITE, CONFUSE_RAY, WING_ATTACK
	db 56, MAGNETON,   THUNDER, SONICBOOM, THUNDER_WAVE, SWIFT
	db 56, GENGAR,     MEAN_LOOK, CURSE, SHADOW_BALL, CONFUSE_RAY
	db 58, ALAKAZAM,   RECOVER, FUTURE_SIGHT, PSYCHIC_M, REFLECT
	db 62, TYPHLOSION, SMOKESCREEN, QUICK_ATTACK, FIRE_BLAST, SWIFT
	db -1 ; end

	; RIVAL2 (6)
	db "?@", TRAINERTYPE_MOVES
	db 56, SNEASEL,    QUICK_ATTACK, SCREECH, FAINT_ATTACK, FURY_CUTTER
	db 58, CROBAT,     TOXIC, BITE, CONFUSE_RAY, WING_ATTACK
	db 56, MAGNETON,   THUNDER, SONICBOOM, THUNDER_WAVE, SWIFT
	db 56, GENGAR,     MEAN_LOOK, CURSE, SHADOW_BALL, CONFUSE_RAY
	db 58, ALAKAZAM,   RECOVER, FUTURE_SIGHT, PSYCHIC_M, REFLECT
	db 62, FERALIGATR, SURF, RAIN_DANCE, SLASH, SCREECH
	db -1 ; end

GuitaristGroup:
	; GUITARIST (1)
	db "CLYDE@", TRAINERTYPE_NORMAL
	db 42, ELECTABUZZ
	db -1 ; end

	; GUITARIST (2)
	db "VINCENT@", TRAINERTYPE_NORMAL
	db 33, MAGNEMITE
	db 41, VOLTORB
	db 40, MAGNEMITE
	db 40, MAGNEMITE
	db -1 ; end

HikerGroup:
	; HIKER (1)
	db "ANTHONY@", TRAINERTYPE_NORMAL
	db 18, GEODUDE
	db 21, MACHAMP
	db -1 ; end

	; HIKER (2)
	db "RUSSELL@", TRAINERTYPE_NORMAL
	db  4, GEODUDE
	db  7, GEODUDE
	db  9, GEODUDE
	db -1 ; end

	; HIKER (3)
	db "PHILLIP@", TRAINERTYPE_NORMAL
	db 27, GEODUDE
	db 27, GEODUDE
	db 27, GRAVELER
	db -1 ; end

	; HIKER (4)
	db "LEONARD@", TRAINERTYPE_NORMAL
	db 27, GEODUDE
	db 30, MACHOP
	db -1 ; end

	; HIKER (5)
	db "ANTHONY@", TRAINERTYPE_NORMAL
	db 12, GEODUDE
	db 12, MACHOP
	db -1 ; end

	; HIKER (6)
	db "BENJAMIN@", TRAINERTYPE_NORMAL
	db 16, DIGLETT
	db 16, GEODUDE
	db 18, DUGTRIO
	db -1 ; end

	; HIKER (7)
	db "ERIK@", TRAINERTYPE_NORMAL
	db 28, MACHOP
	db 33, GRAVELER
	db 33, MACHOP
	db -1 ; end

	; HIKER (8)
	db "MICHAEL@", TRAINERTYPE_NORMAL
	db 30, GEODUDE
	db 30, GRAVELER
	db 30, GOLEM
	db -1 ; end

	; HIKER (9)
	db "PARRY@", TRAINERTYPE_NORMAL
	db 43, ONIX
	db 41, SWINUB
	db -1 ; end

	; HIKER (10)
	db "TIMOTHY@", TRAINERTYPE_MOVES
	db 33, DIGLETT,    MAGNITUDE, DIG, SAND_ATTACK, SLASH
	db 33, DUGTRIO,    MAGNITUDE, DIG, SAND_ATTACK, SLASH
	db -1 ; end

	; HIKER (11)
	db "BAILEY@", TRAINERTYPE_NORMAL
	db 15, GEODUDE
	db 15, GEODUDE
	db 15, GEODUDE
	db 15, GEODUDE
	db 15, GEODUDE
	db -1 ; end

	; HIKER (12)
	db "ANTHONY@", TRAINERTYPE_NORMAL
	db 30, GRAVELER
	db 33, GRAVELER
	db 35, MACHOKE
	db -1 ; end

	; HIKER (13)
	db "TIM@", TRAINERTYPE_NORMAL
	db 38, GRAVELER
	db 38, GRAVELER
	db 38, GRAVELER
	db -1 ; end

	; HIKER (14)
	db "NOLAND@", TRAINERTYPE_NORMAL
	db 38, SANDSLASH
	db 41, GOLEM
	db -1 ; end

	; HIKER (15)
	db "SIDNEY@", TRAINERTYPE_NORMAL
	db 42, DUGTRIO
	db 40, ONIX
	db -1 ; end

	; HIKER (16)
	db "KENNY@", TRAINERTYPE_NORMAL
	db 33, SANDSLASH
	db 35, GRAVELER
	db 38, GOLEM
	db 35, GRAVELER
	db -1 ; end

	; HIKER (17)
	db "JIM@", TRAINERTYPE_NORMAL
	db 43, MACHAMP
	db -1 ; end

	; HIKER (18)
	db "DANIEL@", TRAINERTYPE_NORMAL
	db 12, ONIX
	db -1 ; end

	; HIKER (19)
	db "PARRY@", TRAINERTYPE_MOVES
	db 43, PILOSWINE,  EARTHQUAKE, BLIZZARD, REST, TAKE_DOWN
	db 43, DUGTRIO,    MAGNITUDE, DIG, MUD_SLAP, SLASH
	db 46, STEELIX,    DIG, IRON_TAIL, SANDSTORM, SLAM
	db -1 ; end

	; HIKER (20)
	db "PARRY@", TRAINERTYPE_NORMAL
	db 35, ONIX
	db -1 ; end

	; HIKER (21)
	db "ANTHONY@", TRAINERTYPE_NORMAL
	db 36, GRAVELER
	db 36, GRAVELER
	db 40, MACHOKE
	db -1 ; end

	; HIKER (22)
	db "ANTHONY@", TRAINERTYPE_MOVES
	db 42, GRAVELER,   MAGNITUDE, SELFDESTRUCT, DEFENSE_CURL, ROLLOUT
	db 43, GOLEM,      MAGNITUDE, SELFDESTRUCT, DEFENSE_CURL, ROLLOUT
	db 42, MACHOKE,    KARATE_CHOP, VITAL_THROW, HEADBUTT, DIG
	db -1 ; end

BikerGroup:
	; BIKER (1)
	db "BENNY@", TRAINERTYPE_NORMAL
	db 23, KOFFING
	db 23, KOFFING
	db 23, KOFFING
	db -1 ; end

	; BIKER (2)
	db "KAZU@", TRAINERTYPE_NORMAL
	db 23, KOFFING
	db 23, KOFFING
	db 23, KOFFING
	db -1 ; end

	; BIKER (3)
	db "DWAYNE@", TRAINERTYPE_NORMAL
	db 33, KOFFING
	db 34, KOFFING
	db 35, KOFFING
	db 36, KOFFING
	db -1 ; end

	; BIKER (4)
	db "HARRIS@", TRAINERTYPE_NORMAL
	db 42, FLAREON
	db -1 ; end

	; BIKER (5)
	db "ZEKE@", TRAINERTYPE_NORMAL
	db 40, KOFFING
	db 40, KOFFING
	db -1 ; end

	; BIKER (6)
	db "CHARLES@", TRAINERTYPE_NORMAL
	db 36, KOFFING
	db 36, CHARMELEON
	db 36, WEEZING
	db -1 ; end

	; BIKER (7)
	db "RILEY@", TRAINERTYPE_NORMAL
	db 42, WEEZING
	db -1 ; end

	; BIKER (8)
	db "JOEL@", TRAINERTYPE_NORMAL
	db 40, MAGMAR
	db 40, MAGMAR
	db -1 ; end

	; BIKER (9)
	db "GLENN@", TRAINERTYPE_NORMAL
	db 34, KOFFING
	db 36, MAGMAR
	db 40, WEEZING
	db -1 ; end

BlaineGroup:
	; BLAINE (1)
	db "BLAINE@", TRAINERTYPE_MOVES
	db 55, MAGCARGO,   CURSE, SMOG, FLAMETHROWER, ROCK_SLIDE
	db 55, MAGMAR,     THUNDERPUNCH, FIRE_PUNCH, SUNNY_DAY, CONFUSE_RAY
	db 56, NINETALES,  FIRE_SPIN, FLAMETHROWER, SUNNY_DAY, CONFUSE_RAY
	db 58, RAPIDASH,   QUICK_ATTACK, FIRE_SPIN, FURY_ATTACK, FIRE_BLAST
	db -1 ; end
	
	; BLAINE (2)
	db "BLAINE@", TRAINERTYPE_ITEM_MOVES
	db 65, NINETALES,  CHARCOAL, FLAMETHROWER, HYPNOSIS, FIRE_SPIN, SAFEGUARD
	db 66, ARCANINE,   CHARCOAL, FLAMETHROWER, FLAME_WHEEL, FIRE_SPIN, SAFEGUARD
	db 65, HOUNDOOM,   CHARCOAL, FLAMETHROWER, SHADOW_BALL, CURSE, CRUNCH
	db 67, MAGCARGO,   CHARCOAL, CURSE, SMOG, FLAMETHROWER, ROCK_SLIDE
	db 65, MAGMAR,     CHARCOAL, THUNDERBOLT, FLAMETHROWER, FIRE_BLAST, CONFUSE_RAY
	db 70, RAPIDASH,   CHARCOAL, QUICK_ATTACK, FIRE_SPIN, MEGAHORN, FIRE_BLAST
	db -1 ; end

BurglarGroup:
	; BURGLAR (1)
	db "DUNCAN@", TRAINERTYPE_NORMAL
	db 27, KOFFING
	db 30, MAGMAR
	db 27, KOFFING
	db -1 ; end

	; BURGLAR (2)
	db "EDDIE@", TRAINERTYPE_MOVES
	db 31, GROWLITHE,  ROAR, EMBER, LEER, TAKE_DOWN
	db 28, KOFFING,    TACKLE, SMOG, SLUDGE, SMOKESCREEN
	db -1 ; end

	; BURGLAR (3)
	db "COREY@", TRAINERTYPE_NORMAL
	db 30, KOFFING
	db 34, MAGMAR
	db 30, KOFFING
	db 36, KOFFING
	db -1 ; end

FirebreatherGroup:
	; FIREBREATHER (1)
	db "OTIS@", TRAINERTYPE_NORMAL
	db 35, MAGMAR
	db 40, WEEZING
	db 35, MAGMAR
	db -1 ; end

	; FIREBREATHER (2)
	db "DICK@", TRAINERTYPE_NORMAL
	db 20, CHARMELEON
	db -1 ; end

	; FIREBREATHER (3)
	db "NED@", TRAINERTYPE_NORMAL
	db 17, KOFFING
	db 18, GROWLITHE
	db 17, KOFFING
	db -1 ; end

	; FIREBREATHER (4)
	db "BURT@", TRAINERTYPE_NORMAL
	db 40, KOFFING
	db 40, SLUGMA
	db -1 ; end

	; FIREBREATHER (5)
	db "BILL@", TRAINERTYPE_NORMAL
	db  7, KOFFING
	db  7, KOFFING
	db -1 ; end

	; FIREBREATHER (6)
	db "WALT@", TRAINERTYPE_NORMAL
	db 12, MAGMAR
	db 15, MAGMAR
	db -1 ; end

	; FIREBREATHER (7)
	db "RAY@", TRAINERTYPE_NORMAL
	db 10, VULPIX
	db -1 ; end

	; FIREBREATHER (8)
	db "LYLE@", TRAINERTYPE_NORMAL
	db 34, KOFFING
	db 38, FLAREON
	db 34, KOFFING
	db -1 ; end

JugglerGroup:
	; JUGGLER (1)
	db "IRWIN@", TRAINERTYPE_NORMAL
	db  4, VOLTORB
	db  7, VOLTORB
	db 11, VOLTORB
	db 16, VOLTORB
	db -1 ; end

	; JUGGLER (2)
	db "FRITZ@", TRAINERTYPE_NORMAL
	db 35, MR__MIME
	db 35, MAGMAR
	db 35, MACHOKE
	db -1 ; end

	; JUGGLER (3)
	db "HORTON@", TRAINERTYPE_NORMAL
	db 41, ELECTRODE
	db 41, ELECTRODE
	db 41, ELECTRODE
	db 41, ELECTRODE
	db -1 ; end

	; JUGGLER (4)
	db "IRWIN@", TRAINERTYPE_NORMAL
	db  7, VOLTORB
	db 11, VOLTORB
	db 16, VOLTORB
	db 21, VOLTORB
	db -1 ; end

	; JUGGLER (5)
	db "IRWIN@", TRAINERTYPE_NORMAL
	db 21, VOLTORB
	db 26, VOLTORB
	db 31, VOLTORB
	db 36, ELECTRODE
	db -1 ; end

	; JUGGLER (6)
	db "IRWIN@", TRAINERTYPE_NORMAL
	db 21, VOLTORB
	db 26, VOLTORB
	db 31, VOLTORB
	db 36, ELECTRODE
	db -1 ; end

BlackbeltGroup:
	; BLACKBELT_T (1)
	db "KENJI@", TRAINERTYPE_NORMAL
	db 33, ONIX
	db 36, HITMONLEE
	db 33, ONIX
	db 40, MACHOKE
	db -1 ; end

	; BLACKBELT_T (2)
	db "YOSHI@", TRAINERTYPE_MOVES
	db 33, HITMONLEE,  DOUBLE_KICK, MEDITATE, JUMP_KICK, FOCUS_ENERGY
	db -1 ; end

	; BLACKBELT_T (3)
	db "KENJI@", TRAINERTYPE_MOVES
	db 41, ONIX,       BIND, ROCK_THROW, TOXIC, DIG
	db 46, MACHAMP,    HEADBUTT, SWAGGER, THUNDERPUNCH, VITAL_THROW
	db 41, STEELIX,    EARTHQUAKE, ROCK_THROW, IRON_TAIL, SANDSTORM
	db 43, HITMONLEE,  DOUBLE_TEAM, HI_JUMP_KICK, MUD_SLAP, SWIFT
	db -1 ; end

	; BLACKBELT_T (4)
	db "LAO@", TRAINERTYPE_MOVES
	db 33, HITMONCHAN, COMET_PUNCH, THUNDERPUNCH, ICE_PUNCH, FIRE_PUNCH
	db -1 ; end

	; BLACKBELT_T (5)
	db "NOB@", TRAINERTYPE_MOVES
	db 30, MACHOP,     LEER, FOCUS_ENERGY, KARATE_CHOP, SEISMIC_TOSS
	db 30, MACHOKE,    LEER, KARATE_CHOP, SEISMIC_TOSS, ROCK_SLIDE
	db -1 ; end

	; BLACKBELT_T (6)
	db "KIYO@", TRAINERTYPE_NORMAL
	db 42, HITMONLEE
	db 42, HITMONCHAN
	db -1 ; end

	; BLACKBELT_T (7)
	db "LUNG@", TRAINERTYPE_NORMAL
	db 27, MANKEY
	db 27, MANKEY
	db 30, PRIMEAPE
	db -1 ; end

	; BLACKBELT_T (8)
	db "KENJI@", TRAINERTYPE_NORMAL
	db 34, MACHOKE
	db -1 ; end

	; BLACKBELT_T (9)
	db "WAI@", TRAINERTYPE_NORMAL
	db 36, MACHOKE
	db 40, MACHOKE
	db 42, MACHOKE
	db -1 ; end

ExecutiveMGroup:
	; EXECUTIVEM (1)
	db "EXECUTIVE@", TRAINERTYPE_MOVES
	db 41, HOUNDOUR,   EMBER, ROAR, BITE, FAINT_ATTACK
	db 41, KOFFING,    TACKLE, SLUDGE, SMOKESCREEN, HAZE
	db 43, HOUNDOOM,   EMBER, SMOG, BITE, FAINT_ATTACK
	db -1 ; end

	; EXECUTIVEM (2)
	db "EXECUTIVE@", TRAINERTYPE_MOVES
	db 43, GOLBAT,     LEECH_LIFE, BITE, CONFUSE_RAY, WING_ATTACK
	db -1 ; end

	; EXECUTIVEM (3)
	db "EXECUTIVE@", TRAINERTYPE_MOVES
	db 36, KOFFING,    TACKLE, SELFDESTRUCT, SLUDGE, SMOKESCREEN
	db 36, KOFFING,    TACKLE, SELFDESTRUCT, SLUDGE, SMOKESCREEN
	db 36, KOFFING,    TACKLE, SELFDESTRUCT, SLUDGE, SMOKESCREEN
	db 40, WEEZING,    TACKLE, EXPLOSION, SLUDGE, SMOKESCREEN
	db 36, KOFFING,    TACKLE, SELFDESTRUCT, SLUDGE, SMOKESCREEN
	db 36, KOFFING,    TACKLE, SMOG, SLUDGE, SMOKESCREEN
	db -1 ; end

	; EXECUTIVEM (4)
	db "EXECUTIVE@", TRAINERTYPE_NORMAL
	db 26, ZUBAT
	db 28, RATICATE
	db 26, KOFFING
	db -1 ; end

PsychicGroup:
	; PSYCHIC_T (1)
	db "NATHAN@", TRAINERTYPE_NORMAL
	db 31, GIRAFARIG
	db -1 ; end

	; PSYCHIC_T (2)
	db "FRANKLIN@", TRAINERTYPE_NORMAL
	db 44, KADABRA
	db -1 ; end

	; PSYCHIC_T (3)
	db "HERMAN@", TRAINERTYPE_NORMAL
	db 36, EXEGGCUTE
	db 36, EXEGGCUTE
	db 36, EXEGGUTOR
	db -1 ; end

	; PSYCHIC_T (4)
	db "FIDEL@", TRAINERTYPE_NORMAL
	db 42, XATU
	db -1 ; end

	; PSYCHIC_T (5)
	db "GREG@", TRAINERTYPE_MOVES
	db 20, DROWZEE,    HYPNOSIS, DISABLE, DREAM_EATER, NO_MOVE
	db -1 ; end

	; PSYCHIC_T (6)
	db "NORMAN@", TRAINERTYPE_MOVES
	db 20, SLOWPOKE,   TACKLE, GROWL, WATER_GUN, NO_MOVE
	db 23, SLOWPOKE,   CURSE, BODY_SLAM, WATER_GUN, CONFUSION
	db -1 ; end

	; PSYCHIC_T (7)
	db "MARK@", TRAINERTYPE_MOVES
	db 15, ABRA,       TELEPORT, FLASH, NO_MOVE, NO_MOVE
	db 15, ABRA,       TELEPORT, FLASH, NO_MOVE, NO_MOVE
	db 17, KADABRA,    TELEPORT, KINESIS, CONFUSION, NO_MOVE
	db -1 ; end

	; PSYCHIC_T (8)
	db "PHIL@", TRAINERTYPE_MOVES
	db 28, NATU,       LEER, NIGHT_SHADE, FUTURE_SIGHT, CONFUSE_RAY
	db 31, KADABRA,    DISABLE, PSYBEAM, RECOVER, FUTURE_SIGHT
	db -1 ; end

	; PSYCHIC_T (9)
	db "RICHARD@", TRAINERTYPE_NORMAL
	db 43, ESPEON
	db -1 ; end

	; PSYCHIC_T (10)
	db "GILBERT@", TRAINERTYPE_NORMAL
	db 36, STARMIE
	db 36, EXEGGCUTE
	db 42, GIRAFARIG
	db -1 ; end

	; PSYCHIC_T (11)
	db "JARED@", TRAINERTYPE_NORMAL
	db 40, MR__MIME
	db 40, EXEGGCUTE
	db 43, EXEGGCUTE
	db -1 ; end

	; PSYCHIC_T (12)
	db "RODNEY@", TRAINERTYPE_NORMAL
	db 35, DROWZEE
	db 41, HYPNO
	db -1 ; end

PicnickerGroup:
	; PICNICKER (1)
	db "LIZ@", TRAINERTYPE_NORMAL
	db 10, NIDORAN_F
	db -1 ; end

	; PICNICKER (2)
	db "GINA@", TRAINERTYPE_NORMAL
	db 10, HOPPIP
	db 10, HOPPIP
	db 13, BULBASAUR
	db -1 ; end

	; PICNICKER (3)
	db "BROOKE@", TRAINERTYPE_MOVES
	db 18, PIKACHU,    THUNDERSHOCK, GROWL, QUICK_ATTACK, DOUBLE_TEAM
	db -1 ; end

	; PICNICKER (4)
	db "KIM@", TRAINERTYPE_NORMAL
	db 17, VULPIX
	db -1 ; end

	; PICNICKER (5)
	db "CINDY@", TRAINERTYPE_NORMAL
	db 43, NIDOQUEEN
	db -1 ; end

	; PICNICKER (6)
	db "HOPE@", TRAINERTYPE_NORMAL
	db 42, FLAAFFY
	db -1 ; end

	; PICNICKER (7)
	db "SHARON@", TRAINERTYPE_NORMAL
	db 38, FURRET
	db 41, RAPIDASH
	db -1 ; end

	; PICNICKER (8)
	db "DEBRA@", TRAINERTYPE_NORMAL
	db 41, SEAKING
	db -1 ; end

	; PICNICKER (9)
	db "GINA@", TRAINERTYPE_NORMAL
	db 16, HOPPIP
	db 16, HOPPIP
	db 20, IVYSAUR
	db -1 ; end

	; PICNICKER (10)
	db "ERIN@", TRAINERTYPE_NORMAL
	db 18, PONYTA
	db 18, PONYTA
	db -1 ; end

	; PICNICKER (11)
	db "LIZ@", TRAINERTYPE_NORMAL
	db 17, WEEPINBELL
	db 17, NIDORINA
	db -1 ; end

	; PICNICKER (12)
	db "LIZ@", TRAINERTYPE_NORMAL
	db 22, WEEPINBELL
	db 22, NIDORINO
	db 25, NIDOQUEEN
	db -1 ; end

	; PICNICKER (13)
	db "HEIDI@", TRAINERTYPE_NORMAL
	db 40, SKIPLOOM
	db 40, SKIPLOOM
	db -1 ; end

	; PICNICKER (14)
	db "EDNA@", TRAINERTYPE_NORMAL
	db 36, NIDORINA
	db 42, RAICHU
	db -1 ; end

	; PICNICKER (15)
	db "GINA@", TRAINERTYPE_NORMAL
	db 31, SKIPLOOM
	db 31, SKIPLOOM
	db 35, IVYSAUR
	db -1 ; end

	; PICNICKER (16)
	db "TIFFANY@", TRAINERTYPE_MOVES
	db 38, CLEFAIRY,   ENCORE, SING, DOUBLESLAP, MINIMIZE
	db -1 ; end

	; PICNICKER (17)
	db "TIFFANY@", TRAINERTYPE_MOVES
	db 44, CLEFAIRY,   ENCORE, DOUBLESLAP, MINIMIZE, METRONOME
	db -1 ; end

	; PICNICKER (18)
	db "ERIN@", TRAINERTYPE_NORMAL
	db 40, PONYTA
	db 40, PONYTA
	db -1 ; end

	; PICNICKER (19)
	db "TANYA@", TRAINERTYPE_NORMAL
	db 44, EXEGGUTOR
	db -1 ; end

	; PICNICKER (20)
	db "TIFFANY@", TRAINERTYPE_MOVES
	db 23, CLEFAIRY,   ENCORE, SING, DOUBLESLAP, MINIMIZE
	db -1 ; end

	; PICNICKER (21)
	db "ERIN@", TRAINERTYPE_MOVES
	db 43, PONYTA,     DOUBLE_TEAM, STOMP, FIRE_SPIN, SUNNY_DAY
	db 42, RAICHU,     SWIFT, MUD_SLAP, QUICK_ATTACK, THUNDERBOLT
	db 43, PONYTA,     DOUBLE_TEAM, STOMP, FIRE_SPIN, SUNNY_DAY
	db -1 ; end

	; PICNICKER (22)
	db "LIZ@", TRAINERTYPE_NORMAL
	db 28, WEEPINBELL
	db 31, NIDORINO
	db 31, NIDOQUEEN
	db -1 ; end

	; PICNICKER (23)
	db "LIZ@", TRAINERTYPE_MOVES
	db 36, WEEPINBELL, SLEEP_POWDER, POISONPOWDER, STUN_SPORE, SLUDGE_BOMB
	db 40, NIDOKING,   EARTHQUAKE, DOUBLE_KICK, POISON_STING, IRON_TAIL
	db 40, NIDOQUEEN,  EARTHQUAKE, DOUBLE_KICK, TAIL_WHIP, BODY_SLAM
	db -1 ; end

	; PICNICKER (24)
	db "GINA@", TRAINERTYPE_NORMAL
	db 36, SKIPLOOM
	db 36, SKIPLOOM
	db 40, IVYSAUR
	db -1 ; end

	; PICNICKER (25)
	db "GINA@", TRAINERTYPE_MOVES
	db 41, JUMPLUFF,   STUN_SPORE, SUNNY_DAY, LEECH_SEED, COTTON_SPORE
	db 41, JUMPLUFF,   SUNNY_DAY, SLEEP_POWDER, LEECH_SEED, COTTON_SPORE
	db 46, VENUSAUR,   SOLARBEAM, RAZOR_LEAF, HEADBUTT, MUD_SLAP
	db -1 ; end

	; PICNICKER (26)
	db "TIFFANY@", TRAINERTYPE_MOVES
	db 43, CLEFAIRY,   METRONOME, ENCORE, MOONLIGHT, MINIMIZE
	db -1 ; end

CamperGroup:
	; CAMPER (1)
	db "ROLAND@", TRAINERTYPE_NORMAL
	db 10, NIDORAN_M
	db -1 ; end

	; CAMPER (2)
	db "TODD@", TRAINERTYPE_NORMAL
	db 16, PSYDUCK
	db -1 ; end

	; CAMPER (3)
	db "IVAN@", TRAINERTYPE_NORMAL
	db 11, DIGLETT
	db 11, ZUBAT
	db 16, DIGLETT
	db -1 ; end

	; CAMPER (4)
	db "ELLIOT@", TRAINERTYPE_NORMAL
	db 15, SANDSHREW
	db 17, MARILL
	db -1 ; end

	; CAMPER (5)
	db "BARRY@", TRAINERTYPE_NORMAL
	db 43, NIDOKING
	db -1 ; end

	; CAMPER (6)
	db "LLOYD@", TRAINERTYPE_NORMAL
	db 42, NIDOKING
	db -1 ; end

	; CAMPER (7)
	db "DEAN@", TRAINERTYPE_NORMAL
	db 41, GOLDUCK
	db 38, SANDSLASH
	db -1 ; end

	; CAMPER (8)
	db "SID@", TRAINERTYPE_NORMAL
	db 40, DUGTRIO
	db 35, PRIMEAPE
	db 35, POLIWRATH
	db -1 ; end

	; CAMPER (9)
	db "HARVEY@", TRAINERTYPE_NORMAL
	db 17, NIDORINO
	db -1 ; end

	; CAMPER (10)
	db "DALE@", TRAINERTYPE_NORMAL
	db 17, NIDORINO
	db -1 ; end

	; CAMPER (11)
	db "TED@", TRAINERTYPE_NORMAL
	db 20, MANKEY
	db -1 ; end

	; CAMPER (12)
	db "TODD@", TRAINERTYPE_NORMAL
	db 20, GEODUDE
	db 20, GEODUDE
	db 27, PSYDUCK
	db -1 ; end

	; CAMPER (13)
	db "TODD@", TRAINERTYPE_NORMAL
	db 27, GEODUDE
	db 27, GEODUDE
	db 31, PSYDUCK
	db -1 ; end

	; CAMPER (14)
	db "THOMAS@", TRAINERTYPE_NORMAL
	db 41, GRAVELER
	db 43, GRAVELER
	db 48, GOLBAT
	db 42, GOLDUCK
	db -1 ; end

	; CAMPER (15)
	db "LEROY@", TRAINERTYPE_NORMAL
	db 41, GRAVELER
	db 43, GRAVELER
	db 48, GOLBAT
	db 42, GOLDUCK
	db -1 ; end

	; CAMPER (16)
	db "DAVID@", TRAINERTYPE_NORMAL
	db 41, GRAVELER
	db 43, GRAVELER
	db 48, GOLBAT
	db 42, GOLDUCK
	db -1 ; end

	; CAMPER (17)
	db "JOHN@", TRAINERTYPE_NORMAL
	db 41, GRAVELER
	db 43, GRAVELER
	db 48, GOLBAT
	db 42, GOLDUCK
	db -1 ; end

	; CAMPER (18)
	db "JERRY@", TRAINERTYPE_NORMAL
	db 44, SANDSLASH
	db -1 ; end

	; CAMPER (19)
	db "SPENCER@", TRAINERTYPE_NORMAL
	db 20, SANDSHREW
	db 20, SANDSLASH
	db 22, ZUBAT
	db -1 ; end

	; CAMPER (20)
	db "TODD@", TRAINERTYPE_NORMAL
	db 36, GRAVELER
	db 36, GRAVELER
	db 36, SLUGMA
	db 40, PSYDUCK
	db -1 ; end

	; CAMPER (21)
	db "TODD@", TRAINERTYPE_MOVES
	db 41, GRAVELER,   SELFDESTRUCT, ROCK_THROW, HARDEN, MAGNITUDE
	db 41, GRAVELER,   SELFDESTRUCT, ROCK_THROW, HARDEN, MAGNITUDE
	db 43, MAGCARGO,   ROCK_THROW, HARDEN, AMNESIA, FLAMETHROWER
	db 42, GOLDUCK,    DISABLE, PSYCHIC_M, SURF, PSYCH_UP
	db -1 ; end

	; CAMPER (22)
	db "QUENTIN@", TRAINERTYPE_NORMAL
	db 36, FEAROW
	db 36, PRIMEAPE
	db 36, TAUROS
	db -1 ; end

ExecutiveFGroup:
	; EXECUTIVEF (1)
	db "EXECUTIVE@", TRAINERTYPE_MOVES
	db 40, ARBOK,      WRAP, POISON_STING, BITE, GLARE
	db 40, VILEPLUME,  ABSORB, SWEET_SCENT, SLEEP_POWDER, ACID
	db 40, MURKROW,    PECK, PURSUIT, HAZE, NIGHT_SHADE
	db -1 ; end

	; EXECUTIVEF (2)
	db "EXECUTIVE@", TRAINERTYPE_MOVES
	db 27, ARBOK,      WRAP, LEER, POISON_STING, BITE
	db 27, GLOOM,      ABSORB, SWEET_SCENT, SLEEP_POWDER, ACID
	db 30, MURKROW,    PECK, PURSUIT, HAZE, NO_MOVE
	db -1 ; end

SageGroup:
	; SAGE (1)
	db "CHOW@", TRAINERTYPE_NORMAL
	db  5, BELLSPROUT
	db  5, BELLSPROUT
	db  5, BELLSPROUT
	db -1 ; end

	; SAGE (2)
	db "NICO@", TRAINERTYPE_NORMAL
	db  5, BELLSPROUT
	db  5, BELLSPROUT
	db  5, BELLSPROUT
	db -1 ; end

	; SAGE (3)
	db "JIN@", TRAINERTYPE_NORMAL
	db  8, BELLSPROUT
	db -1 ; end

	; SAGE (4)
	db "TROY@", TRAINERTYPE_NORMAL
	db  8, BELLSPROUT
	db  8, HOOTHOOT
	db -1 ; end

	; SAGE (5)
	db "JEFFREY@", TRAINERTYPE_NORMAL
	db 26, HAUNTER
	db -1 ; end

	; SAGE (6)
	db "PING@", TRAINERTYPE_NORMAL
	db 18, GASTLY
	db 18, GASTLY
	db 18, GASTLY
	db 18, GASTLY
	db 18, GASTLY
	db -1 ; end

	; SAGE (7)
	db "EDMOND@", TRAINERTYPE_NORMAL
	db  5, BELLSPROUT
	db  5, BELLSPROUT
	db  5, BELLSPROUT
	db -1 ; end

	; SAGE (8)
	db "NEAL@", TRAINERTYPE_NORMAL
	db  10, BELLSPROUT
	db -1 ; end

	; SAGE (9)
	db "LI@", TRAINERTYPE_NORMAL
	db  10, BELLSPROUT
	db  10, BELLSPROUT
	db 11, HOOTHOOT
	db -1 ; end

	; SAGE (10)
	db "GAKU@", TRAINERTYPE_NORMAL
	db 40, NOCTOWL
	db 40, FLAREON
	db -1 ; end

	; SAGE (11)
	db "MASA@", TRAINERTYPE_NORMAL
	db 40, NOCTOWL
	db 40, JOLTEON
	db -1 ; end

	; SAGE (12)
	db "KOJI@", TRAINERTYPE_NORMAL
	db 40, NOCTOWL
	db 40, VAPOREON
	db -1 ; end

MediumGroup:
	; MEDIUM (1)
	db "MARTHA@", TRAINERTYPE_NORMAL
	db 21, GASTLY
	db 23, HAUNTER
	db 23, GASTLY
	db -1 ; end

	; MEDIUM (2)
	db "GRACE@", TRAINERTYPE_NORMAL
	db 23, HAUNTER
	db 23, HAUNTER
	db -1 ; end

	; MEDIUM (3)
	db "BETHANY@", TRAINERTYPE_NORMAL
	db 30, HAUNTER
	db -1 ; end

	; MEDIUM (4)
	db "MARGRET@", TRAINERTYPE_NORMAL
	db 30, HAUNTER
	db -1 ; end

	; MEDIUM (5)
	db "ETHEL@", TRAINERTYPE_NORMAL
	db 30, HAUNTER
	db -1 ; end

	; MEDIUM (6)
	db "REBECCA@", TRAINERTYPE_NORMAL
	db 43, DROWZEE
	db 43, HYPNO
	db -1 ; end

	; MEDIUM (7)
	db "DORIS@", TRAINERTYPE_NORMAL
	db 42, SLOWPOKE
	db 43, SLOWBRO
	db -1 ; end

BoarderGroup:
	; BOARDER (1)
	db "RONALD@", TRAINERTYPE_NORMAL
	db 28, SEEL
	db 30, DEWGONG
	db 28, SEEL
	db -1 ; end

	; BOARDER (2)
	db "BRAD@", TRAINERTYPE_NORMAL
	db 31, SWINUB
	db 31, SWINUB
	db -1 ; end

	; BOARDER (3)
	db "DOUGLAS@", TRAINERTYPE_NORMAL
	db 28, SHELLDER
	db 30, CLOYSTER
	db 28, SHELLDER
	db -1 ; end

PokefanMGroup:
	; POKEFANM (1)
	db "WILLIAM@", TRAINERTYPE_ITEM
	db 16, RAICHU,     BERRY
	db -1 ; end

	; POKEFANM (2)
	db "DEREK@", TRAINERTYPE_ITEM
	db 20, PIKACHU,    BERRY
	db -1 ; end

	; POKEFANM (3)
	db "ROBERT@", TRAINERTYPE_ITEM
	db 41, QUAGSIRE,   BERRY
	db -1 ; end

	; POKEFANM (4)
	db "JOSHUA@", TRAINERTYPE_ITEM
	db 27, PIKACHU,    BERRY
	db 27, PIKACHU,    BERRY
	db 27, PIKACHU,    BERRY
	db 27, PIKACHU,    BERRY
	db 27, PIKACHU,    BERRY
	db 27, PIKACHU,    BERRY
	db -1 ; end

	; POKEFANM (5)
	db "CARTER@", TRAINERTYPE_ITEM
	db 35, BULBASAUR,  BERRY
	db 35, CHARMANDER, BERRY
	db 35, SQUIRTLE,   BERRY
	db -1 ; end

	; POKEFANM (6)
	db "TREVOR@", TRAINERTYPE_ITEM
	db 41, PSYDUCK,    BERRY
	db -1 ; end

	; POKEFANM (7)
	db "BRANDON@", TRAINERTYPE_ITEM
	db 15, SNUBBULL,   BERRY
	db -1 ; end

	; POKEFANM (8)
	db "JEREMY@", TRAINERTYPE_ITEM
	db 34, MEOWTH,     BERRY
	db 34, MEOWTH,     BERRY
	db 34, MEOWTH,     BERRY
	db -1 ; end

	; POKEFANM (9)
	db "COLIN@", TRAINERTYPE_ITEM
	db 40, DELIBIRD,   BERRY
	db -1 ; end

	; POKEFANM (10)
	db "DEREK@", TRAINERTYPE_ITEM
	db 22, PIKACHU,    BERRY
	db -1 ; end

	; POKEFANM (11)
	db "DEREK@", TRAINERTYPE_ITEM
	db 43, PIKACHU,    BERRY
	db -1 ; end

	; POKEFANM (12)
	db "ALEX@", TRAINERTYPE_ITEM
	db 35, NIDOKING,   BERRY
	db 35, SLOWKING,   BERRY
	db 35, SEAKING,    BERRY
	db -1 ; end

	; POKEFANM (13)
	db "REX@", TRAINERTYPE_ITEM
	db 43, PHANPY,     BERRY
	db -1 ; end

	; POKEFANM (14)
	db "ALLAN@", TRAINERTYPE_ITEM
	db 43, TEDDIURSA,  BERRY
	db -1 ; end

KimonoGirlGroup:
	; KIMONO_GIRL (1)
	db "NAOKO@", TRAINERTYPE_NORMAL
	db 23, SKIPLOOM
	db 23, VULPIX
	db 21, SKIPLOOM
	db -1 ; end

	; KIMONO_GIRL (2)
	db "NAOKO@", TRAINERTYPE_NORMAL
	db 20, FLAREON
	db -1 ; end

	; KIMONO_GIRL (3)
	db "SAYO@", TRAINERTYPE_NORMAL
	db 20, ESPEON
	db -1 ; end

	; KIMONO_GIRL (4)
	db "ZUKI@", TRAINERTYPE_NORMAL
	db 20, UMBREON
	db -1 ; end

	; KIMONO_GIRL (5)
	db "KUNI@", TRAINERTYPE_NORMAL
	db 20, VAPOREON
	db -1 ; end

	; KIMONO_GIRL (6)
	db "MIKI@", TRAINERTYPE_NORMAL
	db 20, JOLTEON
	db -1 ; end

TwinsGroup:
	; TWINS (1)
	db "AMY & MAY@", TRAINERTYPE_NORMAL
	db 11, SPINARAK
	db 11, LEDYBA
	db -1 ; end

	; TWINS (2)
	db "ANN & ANNE@", TRAINERTYPE_MOVES
	db 18, CLEFAIRY,   GROWL, ENCORE, DOUBLESLAP, METRONOME
	db 18, JIGGLYPUFF, SING, DEFENSE_CURL, POUND, DISABLE
	db -1 ; end

	; TWINS (3)
	db "ANN & ANNE@", TRAINERTYPE_MOVES
	db 18, JIGGLYPUFF, SING, DEFENSE_CURL, POUND, DISABLE
	db 18, CLEFAIRY,   GROWL, ENCORE, DOUBLESLAP, METRONOME
	db -1 ; end

	; TWINS (4)
	db "AMY & MAY@", TRAINERTYPE_NORMAL
	db 11, LEDYBA
	db 11, SPINARAK
	db -1 ; end

	; TWINS (5)
	db "JO & ZOE@", TRAINERTYPE_NORMAL
	db 43, VICTREEBEL
	db 43, VILEPLUME
	db -1 ; end

	; TWINS (6)
	db "JO & ZOE@", TRAINERTYPE_NORMAL
	db 43, VILEPLUME
	db 43, VICTREEBEL
	db -1 ; end

	; TWINS (7)
	db "MEG & PEG@", TRAINERTYPE_NORMAL
	db 38, TEDDIURSA
	db 38, PHANPY
	db -1 ; end

	; TWINS (8)
	db "MEG & PEG@", TRAINERTYPE_NORMAL
	db 38, PHANPY
	db 38, TEDDIURSA
	db -1 ; end

	; TWINS (9)
	db "LEA & PIA@", TRAINERTYPE_MOVES
	db 43, DRATINI,    THUNDER_WAVE, TWISTER, FLAMETHROWER, HEADBUTT
	db 43, DRATINI,    THUNDER_WAVE, TWISTER, ICE_BEAM, HEADBUTT
	db -1 ; end

	; TWINS (10)
	db "LEA & PIA@", TRAINERTYPE_MOVES
	db 46, DRATINI,    THUNDER_WAVE, TWISTER, ICE_BEAM, HEADBUTT
	db 46, DRATINI,    THUNDER_WAVE, TWISTER, FLAMETHROWER, HEADBUTT
	db -1 ; end

PokefanFGroup:
	; POKEFANF (1)
	db "BEVERLY@", TRAINERTYPE_ITEM
	db 16, SNUBBULL,   BERRY
	db -1 ; end

	; POKEFANF (2)
	db "RUTH@", TRAINERTYPE_ITEM
	db 20, PIKACHU,    BERRY
	db -1 ; end

	; POKEFANF (3)
	db "BEVERLY@", TRAINERTYPE_ITEM
	db 21, SNUBBULL,   BERRY
	db -1 ; end

	; POKEFANF (4)
	db "BEVERLY@", TRAINERTYPE_ITEM
	db 36, GRANBULL,   BERRY
	db -1 ; end

	; POKEFANF (5)
	db "GEORGIA@", TRAINERTYPE_ITEM
	db 27, SENTRET,    BERRY
	db 27, SENTRET,    BERRY
	db 27, SENTRET,    BERRY
	db 34, FURRET,     BERRY
	db 27, SENTRET,    BERRY
	db -1 ; end

	; POKEFANF (6)
	db "JAIME@", TRAINERTYPE_ITEM
	db 18, MEOWTH,     BERRY
	db -1 ; end

RedGroup:
	; RED (1)
	db "RED@", TRAINERTYPE_MOVES
	db 84, PIKACHU,    CHARM, QUICK_ATTACK, THUNDERBOLT, THUNDER
	db 76, ESPEON,     MUD_SLAP, REFLECT, SWIFT, PSYCHIC_M
	db 78, SNORLAX,    AMNESIA, SNORE, REST, BODY_SLAM
	db 82, VENUSAUR,   SUNNY_DAY, GIGA_DRAIN, SYNTHESIS, SOLARBEAM
	db 82, CHARIZARD,  FLAMETHROWER, WING_ATTACK, SLASH, FIRE_SPIN
	db 82, BLASTOISE,  RAIN_DANCE, SURF, BLIZZARD, WHIRLPOOL
	db -1 ; end

BlueGroup:
	; BLUE (1)
	db "BLUE@", TRAINERTYPE_MOVES
	db 60, PIDGEOT,    QUICK_ATTACK, WHIRLWIND, WING_ATTACK, MIRROR_MOVE
	db 60, ALAKAZAM,   DISABLE, RECOVER, PSYCHIC_M, REFLECT
	db 62, RHYDON,     FURY_ATTACK, SANDSTORM, ROCK_SLIDE, EARTHQUAKE
	db 62, GYARADOS,   TWISTER, HYDRO_PUMP, RAIN_DANCE, HYPER_BEAM
	db 62, EXEGGUTOR,  SUNNY_DAY, LEECH_SEED, EGG_BOMB, SOLARBEAM
	db 64, ARCANINE,   ROAR, SWIFT, FLAMETHROWER, EXTREMESPEED
	db -1 ; end
	
	; BLUE (2)
	db "BLUE@", TRAINERTYPE_MOVES
	db 68, PIDGEOT,    STEEL_WING, FLY, WING_ATTACK, MIRROR_MOVE
	db 68, ALAKAZAM,   DISABLE, RECOVER, PSYCHIC_M, REFLECT
	db 68, RHYDON,     MEGAHORN, SANDSTORM, ROCK_SLIDE, EARTHQUAKE
	db 70, GYARADOS,   TWISTER, HYDRO_PUMP, RAIN_DANCE, HYPER_BEAM
	db 70, EXEGGUTOR,  PSYCHIC_M, EXPLOSION, EGG_BOMB, SOLARBEAM
	db 72, ARCANINE,   CRUNCH, SWIFT, FLAMETHROWER, EXTREMESPEED
	db -1 ; end

OfficerGroup:
	; OFFICER (1)
	db "KEITH@", TRAINERTYPE_NORMAL
	db 20, GROWLITHE
	db -1 ; end

	; OFFICER (2)
	db "DIRK@", TRAINERTYPE_NORMAL
	db 16, GROWLITHE
	db 16, GROWLITHE
	db -1 ; end

GruntFGroup:
	; GRUNTF (1)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 10, ZUBAT
	db 12, EKANS
	db -1 ; end

	; GRUNTF (2)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 31, ARBOK
	db -1 ; end

	; GRUNTF (3)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 30, GLOOM
	db 30, GLOOM
	db -1 ; end

	; GRUNTF (4)
	db "GRUNT@", TRAINERTYPE_NORMAL
	db 25, EKANS
	db 27, ODDISH
	db 25, EKANS
	db 28, GLOOM
	db -1 ; end

	; GRUNTF (5)
	db "GRUNT@", TRAINERTYPE_MOVES
	db 21, EKANS,      WRAP, LEER, POISON_STING, BITE
	db 21, GLOOM,      ABSORB, SWEET_SCENT, STUN_SPORE, SLEEP_POWDER
	db -1 ; end

MysticalmanGroup:
	; MYSTICALMAN (1)
	db "EUSINE@", TRAINERTYPE_MOVES
	db 27, DROWZEE,    DREAM_EATER, HYPNOSIS, DISABLE, CONFUSION
	db 27, HAUNTER,    LICK, HYPNOSIS, MEAN_LOOK, CURSE
	db 30, ELECTRODE,  SCREECH, SONICBOOM, THUNDER, ROLLOUT
	db -1 ; end
