<div align="center">

# OS Scripting

A collection of macOS, Linux, Windows, and other operating system scripts that can be used to automate deploying and administering computers.

[![Build Status](https://github.com/Justintime50/os-scripting/workflows/build/badge.svg)](https://github.com/Justintime50/os-scripting/actions)
[![Licence](https://img.shields.io/github/license/justintime50/os-scripting)](LICENSE)

<img src="https://raw.githubusercontent.com/justintime50/assets/main/src/os-scripting/macos.png" alt="Showcase">

</div>

This project is intended to save IT professionals valuable hours, reduce user error, and provide consistency configuring computers. OS Scripting contains scripts to troubleshoot typical OS problems, configure and deploy new machines, and administer other machines - perfect for a fleet of devices or just as a template to script for your own device.

## Usage

Each operating system has a separate folder in the `src` directory with its own `README` file describing the available scripts and how to use them.

**Note:** Some of the macOS and Linux scripts can be used on either OS.

* [Linux Scripting](src/linux/README.md)
* [macOS Scripting](src/macos/README.md)
* [Raspberry Pi Scripting](src/raspberry-pi/README.md)
* [UbiOS Scripting](src/ubios/README.md)
* [Vagrant Scripting](src/vagrant/README.md)
* [Windows Scripting](src/windows/README.md)
