//
//  Copyright SkeletonView. All Rights Reserved.
//
//  Licensed under the MIT License (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//      https://opensource.org/licenses/MIT
//
//  UICollectionView+Extensions.swift
//
//  Created by Juanpe Catalán on 19/8/21.

import UIKit

public extension UICollectionView {
    
    static let automaticNumberOfSkeletonItems = -1
    
    func prepareSkeleton(completion: @escaping (Bool) -> Void) {
        guard let originalDataSource = self.dataSource as? SkeletonCollectionViewDataSource,
            !(originalDataSource is SkeletonCollectionDataSource)
            else { return }
        
        let dataSource = SkeletonCollectionDataSource(collectionViewDataSource: originalDataSource, rowHeight: 0.0)
        self.skeletonDataSource = dataSource
        performBatchUpdates({
            self.reloadData()
        }) { done in
            completion(done)
            
        }
    }
}
