/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.ValueHolder;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.primefaces.component.api.RTLAware;
import org.primefaces.component.api.Widget;
import org.primefaces.config.ConfigContainer;
import org.primefaces.context.RequestContext;
import org.primefaces.expression.SearchExpressionFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentUtils {
    public static final EnumSet<VisitHint> VISIT_HINTS_SKIP_UNRENDERED = EnumSet.of(VisitHint.SKIP_UNRENDERED);

    public static String getValueToRender(FacesContext context, UIComponent component) {
        if (component instanceof ValueHolder) {
            ValueHolder valueHolder;
            Object value;
            if (component instanceof EditableValueHolder) {
                EditableValueHolder input = (EditableValueHolder)component;
                Object submittedValue = input.getSubmittedValue();
                ConfigContainer config = RequestContext.getCurrentInstance().getApplicationContext().getConfig();
                if (config.isInterpretEmptyStringAsNull() && submittedValue == null && context.isValidationFailed() && !input.isValid()) {
                    return null;
                }
                if (submittedValue != null) {
                    return submittedValue.toString();
                }
            }
            if ((value = (valueHolder = (ValueHolder)component).getValue()) != null) {
                Converter converter = valueHolder.getConverter();
                if (converter == null) {
                    Class<?> valueType = value.getClass();
                    if (valueType == String.class && !RequestContext.getCurrentInstance().getApplicationContext().getConfig().isStringConverterAvailable()) {
                        return (String)value;
                    }
                    converter = context.getApplication().createConverter(valueType);
                }
                if (converter != null) {
                    return converter.getAsString(context, component, value);
                }
                return value.toString();
            }
            return null;
        }
        return null;
    }

    public static Converter getConverter(FacesContext context, UIComponent component) {
        if (!(component instanceof ValueHolder)) {
            return null;
        }
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression valueExpression = component.getValueExpression("value");
        if (valueExpression == null) {
            return null;
        }
        Class converterType = valueExpression.getType(context.getELContext());
        if (converterType == null || converterType == Object.class) {
            return null;
        }
        if (converterType == String.class && !RequestContext.getCurrentInstance().getApplicationContext().getConfig().isStringConverterAvailable()) {
            return null;
        }
        return context.getApplication().createConverter(converterType);
    }

    public static UIComponent findParentForm(FacesContext context, UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIForm)) continue;
            return parent;
        }
        return null;
    }

    public static UniqueIdVendor findParentUniqueIdVendor(UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UniqueIdVendor)) continue;
            return (UniqueIdVendor)parent;
        }
        return null;
    }

    public static UIComponent findParentNamingContainer(UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof NamingContainer)) continue;
            return parent;
        }
        return null;
    }

    @Deprecated
    public static void decorateAttribute(UIComponent component, String attribute, String value) {
        String attributeValue = (String)component.getAttributes().get(attribute);
        if (attributeValue != null) {
            if (attributeValue.indexOf(value) == -1) {
                String decoratedValue = attributeValue + ";" + value;
                component.getAttributes().put(attribute, decoratedValue);
            } else {
                component.getAttributes().put(attribute, attributeValue);
            }
        } else {
            component.getAttributes().put(attribute, value);
        }
    }

    @Deprecated
    public static List<SelectItem> createSelectItems(UIComponent component) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UISelectItem) {
                UISelectItem selectItem = (UISelectItem)child;
                items.add(new SelectItem(selectItem.getItemValue(), selectItem.getItemLabel()));
                continue;
            }
            if (!(child instanceof UISelectItems)) continue;
            Object selectItems = ((UISelectItems)child).getValue();
            if (selectItems instanceof SelectItem[]) {
                SelectItem[] itemsArray;
                for (SelectItem item : itemsArray = (SelectItem[])selectItems) {
                    items.add(new SelectItem(item.getValue(), item.getLabel()));
                }
                continue;
            }
            if (!(selectItems instanceof Collection)) continue;
            Collection collection = (Collection)selectItems;
            for (SelectItem item : collection) {
                items.add(new SelectItem(item.getValue(), item.getLabel()));
            }
        }
        return items;
    }

    public static String escapeJQueryId(String id) {
        return "#" + id.replaceAll(":", "\\\\\\\\:");
    }

    @Deprecated
    public static String findClientIds(FacesContext context, UIComponent component, String list) {
        if (list == null) {
            return "@none";
        }
        String[] ids = list.split("[,\\s]+");
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i].trim();
            if (ComponentUtils.isValueBlank(id)) continue;
            if (i != 0 && buffer.length() > 0) {
                buffer.append(" ");
            }
            if (id.equals("@all") || id.equals("@none")) {
                buffer.append(id);
                continue;
            }
            if (id.equals("@this")) {
                buffer.append(component.getClientId(context));
                continue;
            }
            if (id.equals("@form")) {
                UIComponent form = ComponentUtils.findParentForm(context, component);
                if (form == null) {
                    throw new FacesException("Component " + component.getClientId(context) + " needs to be enclosed in a form");
                }
                buffer.append(form.getClientId(context));
                continue;
            }
            if (id.equals("@parent")) {
                buffer.append(component.getParent().getClientId(context));
                continue;
            }
            if (id.equals("@namingcontainer")) {
                UIComponent container = ComponentUtils.findParentNamingContainer(component);
                if (container == null) continue;
                buffer.append(container.getClientId(context));
                continue;
            }
            UIComponent comp = component.findComponent(id);
            if (comp != null) {
                buffer.append(comp.getClientId(context));
                continue;
            }
            throw new FacesException("Cannot find component with identifier \"" + id + "\" referenced from \"" + component.getClientId(context) + "\".");
        }
        String clientIds = buffer.toString();
        if (ComponentUtils.isValueBlank(clientIds)) {
            return "@none";
        }
        return clientIds;
    }

    @Deprecated
    public static String findComponentClientId(String id) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIComponent component = ComponentUtils.findComponent((UIComponent)facesContext.getViewRoot(), id);
        return component.getClientId(facesContext);
    }

    @Deprecated
    public static UIComponent findComponent(UIComponent base, String id) {
        if (id.equals(base.getId())) {
            return base;
        }
        UIComponent kid = null;
        UIComponent result = null;
        Iterator kids = base.getFacetsAndChildren();
        while (kids.hasNext() && result == null) {
            kid = (UIComponent)kids.next();
            if (id.equals(kid.getId())) {
                result = kid;
                break;
            }
            result = ComponentUtils.findComponent(kid, id);
            if (result == null) continue;
            break;
        }
        return result;
    }

    public static String resolveWidgetVar(String expression) {
        return ComponentUtils.resolveWidgetVar(expression, (UIComponent)FacesContext.getCurrentInstance().getViewRoot());
    }

    public static String resolveWidgetVar(String expression, UIComponent component) {
        UIComponent resolvedComponent = SearchExpressionFacade.resolveComponent(FacesContext.getCurrentInstance(), component, expression);
        if (resolvedComponent instanceof Widget) {
            return "PF('" + ((Widget)resolvedComponent).resolveWidgetVar() + "')";
        }
        throw new FacesException("Component with clientId " + resolvedComponent.getClientId() + " is not a Widget");
    }

    @Deprecated
    public static boolean isLiteralText(UIComponent component) {
        return component.getFamily().equalsIgnoreCase("facelets.LiteralText");
    }

    public static Locale toLocale(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len != 2 && len != 5 && len < 7) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        char ch0 = str.charAt(0);
        char ch1 = str.charAt(1);
        if (ch0 < 'a' || ch0 > 'z' || ch1 < 'a' || ch1 > 'z') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        if (len == 2) {
            return new Locale(str, "");
        }
        if (str.charAt(2) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        char ch3 = str.charAt(3);
        if (ch3 == '_') {
            return new Locale(str.substring(0, 2), "", str.substring(4));
        }
        char ch4 = str.charAt(4);
        if (ch3 < 'A' || ch3 > 'Z' || ch4 < 'A' || ch4 > 'Z') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        if (len == 5) {
            return new Locale(str.substring(0, 2), str.substring(3, 5));
        }
        if (str.charAt(5) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        return new Locale(str.substring(0, 2), str.substring(3, 5), str.substring(6));
    }

    public static boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    public static boolean isRTL(FacesContext context, RTLAware component) {
        boolean globalValue = RequestContext.getCurrentInstance().getApplicationContext().getConfig().isRightToLeft();
        return globalValue || component.isRTL();
    }

    public static void processDecodesOfFacetsAndChilds(UIComponent component, FacesContext context) {
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                facet.processDecodes(context);
            }
        }
        if (component.getChildCount() > 0) {
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                child.processDecodes(context);
            }
        }
    }

    public static void processValidatorsOfFacetsAndChilds(UIComponent component, FacesContext context) {
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                facet.processValidators(context);
            }
        }
        if (component.getChildCount() > 0) {
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                child.processValidators(context);
            }
        }
    }

    public static void processUpdatesOfFacetsAndChilds(UIComponent component, FacesContext context) {
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                facet.processUpdates(context);
            }
        }
        if (component.getChildCount() > 0) {
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                child.processUpdates(context);
            }
        }
    }

    public static NavigationCase findNavigationCase(FacesContext context, String outcome) {
        ConfigurableNavigationHandler navHandler = (ConfigurableNavigationHandler)context.getApplication().getNavigationHandler();
        String outcomeValue = outcome == null ? context.getViewRoot().getViewId() : outcome;
        return navHandler.getNavigationCase(context, null, outcomeValue);
    }

    public static Map<String, List<String>> getUIParams(UIComponent component) {
        List children = component.getChildren();
        LinkedHashMap<String, ArrayList<String>> params = null;
        if (children != null && children.size() > 0) {
            params = new LinkedHashMap<String, ArrayList<String>>();
            for (UIComponent child : children) {
                UIParameter uiParam;
                if (!child.isRendered() || !(child instanceof UIParameter) || (uiParam = (UIParameter)child).isDisable()) continue;
                ArrayList<String> paramValues = (ArrayList<String>)params.get(uiParam.getName());
                if (paramValues == null) {
                    paramValues = new ArrayList<String>();
                    params.put(uiParam.getName(), paramValues);
                }
                paramValues.add(String.valueOf(uiParam.getValue()));
            }
        }
        return params;
    }
}

