/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.menu;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuGroup;
import org.primefaces.model.menu.MenuModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseMenuModel
implements MenuModel,
Serializable {
    private List<MenuElement> elements = new ArrayList<MenuElement>();

    @Override
    public void addElement(MenuElement element) {
        this.elements.add(element);
    }

    @Override
    public List<MenuElement> getElements() {
        return this.elements;
    }

    @Override
    public void generateUniqueIds() {
        this.generateUniqueIds(this.getElements(), null);
    }

    private void generateUniqueIds(List<MenuElement> elements, String seed) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        int counter = 0;
        for (MenuElement element : elements) {
            String id = seed == null ? String.valueOf(counter++) : seed + "_" + counter++;
            element.setId(id);
            if (!(element instanceof MenuGroup)) continue;
            this.generateUniqueIds(((MenuGroup)element).getElements(), id);
        }
    }
}

