/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.tool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.tool.CommandLine;
import org.w3.x2001.xmlSchema.SchemaDocument;

public class TypeHierarchyPrinter {
    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws Exception {
        block18: {
            block19: {
                cl = new CommandLine(args, Collections.EMPTY_SET);
                if (cl.getOpt("license") != null) {
                    CommandLine.printLicense();
                    System.exit(0);
                    return;
                }
                if (cl.args().length == 0) {
                    System.out.println("Prints inheritance hierarchy of types defined in a schema.");
                    System.out.println("Usage: xsdtree [-noanon] [-nopvr] [-noupa] [-license] file1.xsd file2.xsd ...");
                    return;
                }
                noanon = cl.getOpt("noanon") != null;
                nopvr = cl.getOpt("nopvr") != null;
                noupa = cl.getOpt("noupa") != null;
                schemaFiles = cl.getFiles();
                sdocs = new ArrayList<SchemaDocument>();
                i = 0;
                while (i < schemaFiles.length) {
                    try {
                        sdocs.add(SchemaDocument.Factory.parse(schemaFiles[i], new XmlOptions().setLoadLineNumbers()));
                    }
                    catch (Exception e) {
                        System.err.println(schemaFiles[i] + " not loadable: " + e);
                    }
                    ++i;
                }
                schemas = sdocs.toArray(new XmlObject[0]);
                compErrors = new ArrayList<E>();
                schemaOptions = new XmlOptions();
                schemaOptions.setErrorListener(compErrors);
                schemaOptions.setCompileDownloadUrls();
                if (nopvr) {
                    schemaOptions.setCompileNoPvrRule();
                }
                if (noupa) {
                    schemaOptions.setCompileNoUpaRule();
                }
                try {
                    typeSystem = XmlBeans.compileXsd(schemas, XmlBeans.getBuiltinTypeSystem(), schemaOptions);
                    break block18;
                }
                catch (XmlException e) {
                    System.out.println("Schema invalid");
                    if (compErrors.isEmpty()) {
                        System.out.println(e.getMessage());
                        break block19;
                    }
                    i = compErrors.iterator();
                    ** while (i.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    System.out.println(i.next());
                    continue;
                }
            }
            return;
        }
        prefixes = new HashMap<String, String>();
        prefixes.put("http://www.w3.org/XML/1998/namespace", "xml");
        prefixes.put("http://www.w3.org/2001/XMLSchema", "xs");
        System.out.println("xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"");
        childTypes = new HashMap<SchemaType, ArrayList<SchemaType>>();
        allSeenTypes = new ArrayList<SchemaType>();
        allSeenTypes.addAll(Arrays.asList(typeSystem.documentTypes()));
        allSeenTypes.addAll(Arrays.asList(typeSystem.attributeTypes()));
        allSeenTypes.addAll(Arrays.asList(typeSystem.globalTypes()));
        i = 0;
        while (i < allSeenTypes.size()) {
            sType = (SchemaType)allSeenTypes.get(i);
            if (!noanon) {
                allSeenTypes.addAll(Arrays.asList(sType.getAnonymousTypes()));
            }
            if (!sType.isDocumentType() && !sType.isAttributeType() && sType != XmlObject.type) {
                TypeHierarchyPrinter.noteNamespace(prefixes, sType);
                children = (ArrayList<SchemaType>)childTypes.get(sType.getBaseType());
                if (children == null) {
                    children = new ArrayList<SchemaType>();
                    childTypes.put(sType.getBaseType(), children);
                    if (sType.getBaseType().isBuiltinType()) {
                        allSeenTypes.add(sType.getBaseType());
                    }
                }
                children.add(sType);
            }
            ++i;
        }
        typesToPrint = new ArrayList<SchemaType>();
        typesToPrint.add(XmlObject.type);
        spaces = new StringBuffer();
        while (!typesToPrint.isEmpty()) {
            sType = (SchemaType)typesToPrint.remove(typesToPrint.size() - 1);
            if (sType == null) {
                spaces.setLength(Math.max(0, spaces.length() - 2));
                continue;
            }
            System.out.println(spaces + "+-" + QNameHelper.readable(sType, prefixes) + TypeHierarchyPrinter.notes(sType));
            children = (Collection)childTypes.get(sType);
            if (children == null || children.size() <= 0) continue;
            spaces.append(typesToPrint.size() == 0 || typesToPrint.get(typesToPrint.size() - 1) == null ? "  " : "| ");
            typesToPrint.add(null);
            typesToPrint.addAll(children);
        }
    }

    private static String notes(SchemaType sType) {
        if (sType.isBuiltinType()) {
            return " (builtin)";
        }
        if (sType.isSimpleType()) {
            switch (sType.getSimpleVariety()) {
                case 3: {
                    return " (list)";
                }
                case 2: {
                    return " (union)";
                }
            }
            if (sType.getEnumerationValues() != null) {
                return " (enumeration)";
            }
            return "";
        }
        switch (sType.getContentType()) {
            case 4: {
                return " (mixed)";
            }
            case 2: {
                return " (complex)";
            }
        }
        return "";
    }

    private static void noteNamespace(Map prefixes, SchemaType sType) {
        String base;
        String namespace = QNameHelper.namespace(sType);
        if (namespace.equals("") || prefixes.containsKey(namespace)) {
            return;
        }
        String result = base = QNameHelper.suggestPrefix(namespace);
        int n = 0;
        while (prefixes.containsValue(result)) {
            result = base + n;
            ++n;
        }
        prefixes.put(namespace, result);
        System.out.println("xmlns:" + result + "=\"" + namespace + "\"");
    }
}

