/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.store;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xmlbeans.QNameCache;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDocumentProperties;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlLineNumber;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlRuntimeException;
import org.apache.xmlbeans.XmlSaxHandler;
import org.apache.xmlbeans.impl.common.EncodingMap;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.XMLNameHelper;
import org.apache.xmlbeans.impl.store.Cursor;
import org.apache.xmlbeans.impl.store.Splay;
import org.apache.xmlbeans.impl.store.Text;
import org.apache.xmlbeans.impl.store.Type;
import org.apache.xmlbeans.impl.values.NamespaceManager;
import org.apache.xmlbeans.impl.values.TypeStoreFactory;
import org.apache.xmlbeans.impl.values.XmlStore;
import org.apache.xmlbeans.xml.stream.Attribute;
import org.apache.xmlbeans.xml.stream.AttributeIterator;
import org.apache.xmlbeans.xml.stream.CharacterData;
import org.apache.xmlbeans.xml.stream.Comment;
import org.apache.xmlbeans.xml.stream.Location;
import org.apache.xmlbeans.xml.stream.ProcessingInstruction;
import org.apache.xmlbeans.xml.stream.Space;
import org.apache.xmlbeans.xml.stream.StartDocument;
import org.apache.xmlbeans.xml.stream.StartElement;
import org.apache.xmlbeans.xml.stream.XMLEvent;
import org.apache.xmlbeans.xml.stream.XMLInputStream;
import org.apache.xmlbeans.xml.stream.XMLName;
import org.apache.xmlbeans.xml.stream.XMLStreamException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public final class Root
extends Splay.Finish
implements XmlStore {
    private static ThreadLocal tl_SaxLoaders;
    public static int dv;
    boolean _leftOnly;
    Splay.Doc _doc;
    Text _text;
    boolean _validateOnSet;
    private long __version;
    private long _debugChangeVersion;
    private ChangeClient _changeClients;
    DocProps _props;
    boolean _standAlone;
    final SchemaTypeLoader _schemaTypeSystem;
    int _cInvalidatableTypes;
    int _cElemOrderSensitiveTypes;
    nthCache _nthCache_A;
    nthCache _nthCache_B;
    TypeStoreFactory _factory;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$apache$xmlbeans$impl$store$Root;

    public Root(SchemaTypeLoader stl, SchemaType type, XmlOptions options) {
        super(5);
        if (!"true".equals(System.getProperty("treeasserts"))) {
            Root.disableStoreValidation();
        }
        this.__version = 1L;
        this._debugChangeVersion = 1L;
        this._nthCache_A = new nthCache();
        this._nthCache_B = new nthCache();
        if (!$assertionsDisabled && stl == null) {
            throw new AssertionError();
        }
        this._schemaTypeSystem = stl;
        this._leftOnly = true;
        this._props = new DocProps();
        this._doc = new Splay.Doc(this, null);
        this._leftSplay = this._doc;
        this._doc._parentSplay = this;
        this.adjustCdocBeginLeft(this._doc.getCdocBegin());
        this._text = new Text();
        SchemaType sType = null;
        options = XmlOptions.maskNull(options);
        if (options.hasOption("DOCUMENT_TYPE")) {
            sType = (SchemaType)options.get("DOCUMENT_TYPE");
        }
        if (sType == null) {
            sType = type;
        }
        if (sType == null) {
            sType = XmlObject.type;
        }
        this._validateOnSet = options.hasOption("VALIDATE_ON_SET");
        this._factory = (TypeStoreFactory)options.get("TypeStoreFactory");
        this._doc.setType(this, sType);
    }

    public static XmlStore newStore(SchemaTypeLoader stl, SchemaType type, XmlOptions options) {
        return new Root(stl, type, options);
    }

    public XmlDocumentProperties documentProperties() {
        return this._props;
    }

    public XmlCursor createCursor() {
        if (!$assertionsDisabled && !this.validate()) {
            throw new AssertionError();
        }
        return new Cursor(this, this._doc);
    }

    Splay.Container getContainer() {
        return this._doc;
    }

    boolean validateOnSet() {
        return this._validateOnSet;
    }

    public XmlObject getObject() {
        Type t = this._doc.peekType();
        return t == null ? null : t.getXmlObject();
    }

    public SchemaTypeLoader getSchemaTypeLoader() {
        return this._schemaTypeSystem;
    }

    boolean isEmpty() {
        return this._leftSplay == this._doc && this._doc._rightSplay == null && this._doc.isValid();
    }

    boolean isLeftOnly() {
        return this._leftOnly;
    }

    void ensureEmpty() {
        if (!this.isEmpty()) {
            this._doc.removeContent(this, true);
        }
        if (!$assertionsDisabled && !this.isEmpty()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.validate()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this._leftOnly) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getCchLeft() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._text.length() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getCdocBeginLeft() != 1) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this._doc != null && this._leftSplay == this._doc)) {
            throw new AssertionError();
        }
    }

    void updateCch(Splay s, int deltaCch) {
        if (!$assertionsDisabled && s.isRoot()) {
            throw new AssertionError();
        }
        if (deltaCch != 0) {
            s.splay(this, this);
            s.adjustCch(deltaCch);
            this.adjustCchLeft(deltaCch);
        }
    }

    int getCp(Splay s) {
        if (!this._leftOnly && s != this) {
            s.splay(this, this);
        }
        return s.getCchLeft();
    }

    int getDocBeginIndex(Splay s) {
        if (!this._leftOnly) {
            s.splay(this, this);
        }
        return s.getCdocBeginLeft();
    }

    Splay.Begin findNthBegin(Splay parent, QName name, QNameSet set, int n) {
        int db;
        Splay.Begin b;
        if (!$assertionsDisabled && name != null && set != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (parent == null || parent.isLeaf()) {
            return null;
        }
        int da = this._nthCache_A.distance(parent, name, set, n);
        Splay.Begin begin = b = da <= (db = this._nthCache_B.distance(parent, name, set, n)) ? this._nthCache_A.fetch(parent, name, set, n) : this._nthCache_B.fetch(parent, name, set, n);
        if (da == db) {
            nthCache temp = this._nthCache_A;
            this._nthCache_A = this._nthCache_B;
            this._nthCache_B = temp;
        }
        return b;
    }

    int count(Splay.Container parent, QName name, QNameSet set) {
        Splay s = this.findNthBegin(parent, name, set, 0);
        if (s == null) {
            return 0;
        }
        int n = 0;
        while (!s.isFinish()) {
            if (s.isBegin()) {
                if (set == null) {
                    if (s.getName().equals(name)) {
                        ++n;
                    }
                } else if (set.contains(s.getName())) {
                    ++n;
                }
                s = s.getFinishSplay();
            }
            s = s.nextSplay();
        }
        return n;
    }

    private boolean namespacesSame(QName n1, QName n2) {
        if (n1 == n2) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        if (n1.getNamespaceURI() == n2.getNamespaceURI()) {
            return true;
        }
        if (n1.getNamespaceURI() == null || n2.getNamespaceURI() == null) {
            return false;
        }
        return n1.getNamespaceURI().equals(n2.getNamespaceURI());
    }

    private void addNamespace(StringBuffer sb, QName name) {
        if (name.getNamespaceURI() == null) {
            sb.append("<no namespace>");
        } else {
            sb.append("\"");
            sb.append(name.getNamespaceURI());
            sb.append("\"");
        }
    }

    XmlObject autoTypedDocument(SchemaType factoryType, XmlOptions options) throws XmlException {
        SchemaType overrideType = (SchemaType)XmlOptions.safeGet(options, "DOCUMENT_TYPE");
        SchemaType theType = overrideType;
        if (theType == null && (factoryType == null || !factoryType.isDocumentType() && !factoryType.isAttributeType())) {
            SchemaType sniffedType;
            QName typeName = this._doc.getXsiTypeName(this);
            SchemaType schemaType = sniffedType = typeName == null ? null : this._schemaTypeSystem.findType(typeName);
            if (factoryType == null || factoryType.isAssignableFrom(sniffedType)) {
                theType = sniffedType;
            }
        }
        if (factoryType == null || factoryType.isDocumentType()) {
            XmlCursor c;
            if (theType == null) {
                QName factoryElemName;
                QName docElemName = null;
                c = this.createCursor();
                if (c.toFirstChild() && !c.toNextSibling()) {
                    docElemName = c.getName();
                }
                c.dispose();
                if (docElemName != null) {
                    theType = this._schemaTypeSystem.findDocumentType(docElemName);
                }
                if (factoryType != null && theType != null && !(factoryElemName = factoryType.getDocumentElementName()).equals(docElemName) && !factoryType.isValidSubstitution(docElemName)) {
                    throw new XmlException("Element " + QNameHelper.pretty(docElemName) + " is not a valid " + QNameHelper.pretty(factoryElemName) + " document or a valid substitution.");
                }
            }
            if (theType == null) {
                QName attrName = null;
                c = this.createCursor();
                if (c.toFirstAttribute() && !c.toNextAttribute()) {
                    attrName = c.getName();
                }
                c.dispose();
                if (attrName != null) {
                    theType = this._schemaTypeSystem.findAttributeType(attrName);
                }
            }
        }
        if (theType == null) {
            theType = factoryType;
        }
        if (theType == null) {
            theType = XmlBeans.NO_TYPE;
        }
        this._doc.setType(this, theType);
        if (factoryType != null) {
            if (theType.isDocumentType()) {
                this.verifyDocumentType(theType.getDocumentElementName());
            } else if (theType.isAttributeType()) {
                this.verifyAttributeType(theType.getAttributeTypeAttributeName());
            }
        }
        if (factoryType != null && !factoryType.isAssignableFrom(theType)) {
            throw new XmlException("XML object is not of type " + factoryType);
        }
        return this.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyDocumentType(QName docElemName) throws XmlException {
        XmlCursor c = this.createCursor();
        try {
            StringBuffer sb = null;
            if (!c.toFirstChild() || c.toNextSibling()) {
                sb = new StringBuffer();
                sb.append("The document is not a ");
                sb.append(QNameHelper.pretty(docElemName));
                if (c.currentTokenType().isStartdoc()) {
                    sb.append(": no document element");
                } else {
                    sb.append(": multiple document elements");
                }
            } else {
                QName name = c.getName();
                if (!name.equals(docElemName)) {
                    sb = new StringBuffer();
                    sb.append("The document is not a ");
                    sb.append(QNameHelper.pretty(docElemName));
                    if (docElemName.getLocalPart().equals(name.getLocalPart())) {
                        sb.append(": document element namespace mismatch ");
                        sb.append("expected ");
                        this.addNamespace(sb, docElemName);
                        sb.append(" got ");
                        this.addNamespace(sb, name);
                    } else if (this.namespacesSame(docElemName, name)) {
                        sb.append(": document element local name mismatch ");
                        sb.append("expected " + docElemName.getLocalPart());
                        sb.append(" got " + name.getLocalPart());
                    } else {
                        sb.append(": document element mismatch ");
                        sb.append("got ");
                        sb.append(QNameHelper.pretty(name));
                    }
                }
            }
            if (sb != null) {
                XmlError err = XmlError.forCursor(sb.toString(), c.newCursor());
                throw new XmlException(err.toString(), null, err);
            }
            Object var6_5 = null;
            c.dispose();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            c.dispose();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAttributeType(QName attrName) throws XmlException {
        XmlCursor c = this.createCursor();
        try {
            StringBuffer sb = null;
            if (!c.toFirstAttribute() || c.toNextAttribute()) {
                sb = new StringBuffer();
                sb.append("The document is not a ");
                sb.append(QNameHelper.pretty(attrName));
                if (c.currentTokenType().isStartdoc()) {
                    sb.append(": no attributes");
                } else {
                    sb.append(": multiple attributes");
                }
            } else {
                QName name = c.getName();
                if (!name.equals(attrName)) {
                    sb = new StringBuffer();
                    sb.append("The document is not a ");
                    sb.append(QNameHelper.pretty(attrName));
                    if (attrName.getLocalPart().equals(name.getLocalPart())) {
                        sb.append(": attribute namespace mismatch ");
                        sb.append("expected ");
                        this.addNamespace(sb, attrName);
                        sb.append(" got ");
                        this.addNamespace(sb, name);
                    } else if (this.namespacesSame(attrName, name)) {
                        sb.append(": attribute local name mismatch ");
                        sb.append("expected " + attrName.getLocalPart());
                        sb.append(" got " + name.getLocalPart());
                    } else {
                        sb.append(": attribute element mismatch ");
                        sb.append("got ");
                        sb.append(QNameHelper.pretty(name));
                    }
                }
            }
            if (sb != null) {
                XmlError err = XmlError.forCursor(sb.toString(), c.newCursor());
                throw new XmlException(err.toString(), null, err);
            }
            Object var6_5 = null;
            c.dispose();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            c.dispose();
            throw throwable;
        }
    }

    private static SaxLoader getSaxLoader() {
        return (SaxLoader)tl_SaxLoaders.get();
    }

    public XmlObject loadXml(InputStream in, SchemaType type, XmlOptions options) throws IOException, XmlException {
        String encodingOverride = (String)XmlOptions.safeGet(options, "CHARACTER_ENCODING");
        if (encodingOverride != null) {
            String javaEncoding = EncodingMap.getIANA2JavaMapping(encodingOverride);
            if (javaEncoding == null) {
                javaEncoding = encodingOverride;
            }
            return this.loadXml(new InputStreamReader(in, javaEncoding), type, options);
        }
        return this.loadXml(new InputSource(in), type, options);
    }

    public XmlObject loadXml(Reader r, SchemaType type, XmlOptions options) throws IOException, XmlException {
        return this.loadXml(new InputSource(r), type, options);
    }

    public XmlObject loadXml(InputSource is, SchemaType type, XmlOptions options) throws IOException, XmlException {
        is.setSystemId("file://");
        Root.getSaxLoader().load(this, is, options);
        return this.autoTypedDocument(type, options);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlObject loadXml(String s, SchemaType type, XmlOptions options) throws XmlException {
        XmlObject xmlObject;
        StringReader r = new StringReader(s);
        try {
            try {
                xmlObject = this.loadXml(r, type, options);
                Object var7_7 = null;
            }
            catch (IOException e) {
                if ($assertionsDisabled) throw new XmlException(e.getMessage(), e);
                throw new AssertionError((Object)"StringReader should not throw IOException");
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                ((Reader)r).close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return xmlObject;
        }
        ((Reader)r).close();
        return xmlObject;
    }

    private void associateSourceName(XmlOptions options) {
        String sourceName = (String)XmlOptions.safeGet(options, "DOCUMENT_SOURCE_NAME");
        if (sourceName != null) {
            this._props.setSourceName(sourceName);
        }
    }

    public XmlSaxHandler newSaxHandler(SchemaType type, XmlOptions options) {
        return new XmlSaxHandlerImpl(type, options);
    }

    private void newParseSax(InputSource in, XmlOptions options) {
        LoadContext loadContext = new LoadContext(this, options);
    }

    private void loadNodeChildren(Node n, LoadContext context) {
        Node c = n.getFirstChild();
        while (c != null) {
            this.loadNode(c, context);
            c = c.getNextSibling();
        }
    }

    private void loadNode(Node n, LoadContext context) {
        switch (n.getNodeType()) {
            case 5: 
            case 9: 
            case 11: {
                this.loadNodeChildren(n, context);
                break;
            }
            case 1: {
                String localName = n.getLocalName();
                if (localName == null) {
                    localName = n.getNodeName();
                }
                context.begin(localName, n.getNamespaceURI());
                NamedNodeMap attrs = n.getAttributes();
                int i = 0;
                while (i < attrs.getLength()) {
                    Node a = attrs.item(i);
                    String uri = a.getNamespaceURI();
                    String local = a.getLocalName();
                    String value = a.getNodeValue();
                    if (local == null) {
                        local = a.getNodeName();
                    }
                    if (uri != null && uri.equals("http://www.w3.org/2000/xmlns/")) {
                        if (local.equals("xmlns")) {
                            context.xmlns("", value);
                        } else {
                            context.xmlns(local, value);
                        }
                    } else {
                        context.attr(local, uri, value);
                    }
                    ++i;
                }
                this.loadNodeChildren(n, context);
                context.end();
                break;
            }
            case 3: 
            case 4: {
                context.text(n.getNodeValue());
                break;
            }
            case 8: {
                context.comment(n.getNodeValue());
                break;
            }
            case 7: {
                context.procinst(n.getNodeName(), n.getNodeValue());
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 12: {
                throw new RuntimeException("Unexpected node");
            }
        }
    }

    public XmlObject loadXml(Node node, SchemaType type, XmlOptions options) throws XmlException {
        LoadContext context = new LoadContext(this, options);
        this.loadNode(node, context);
        this.associateSourceName(options);
        return this.autoTypedDocument(type, options);
    }

    public XmlObject loadXml(XMLInputStream xis, SchemaType type, XmlOptions options) throws XMLStreamException, XmlException {
        this.loadXmlInputStream(xis, options);
        return this.autoTypedDocument(type, options);
    }

    public void loadXmlInputStream(XMLInputStream xis, XmlOptions options) throws XMLStreamException, XmlException {
        Map nsMap;
        options = XmlOptions.maskNull(options);
        XMLEvent x = xis.peek();
        if (x != null && x.getType() == 2 && (nsMap = ((StartElement)x).getNamespaceMap()) != null && nsMap.size() > 0) {
            HashMap namespaces = new HashMap();
            namespaces.putAll(nsMap);
            options = new XmlOptions(options);
            options.put((Object)"LOAD_ADDITIONAL_NAMESPACES", namespaces);
        }
        LoadContext context = new LoadContext(this, options);
        boolean lineNums = options.hasOption("LOAD_LINE_NUMBERS");
        XMLEvent xe = xis.next();
        block12: while (xe != null) {
            switch (xe.getType()) {
                case 256: {
                    StartDocument doc = (StartDocument)xe;
                    this._props.setDoctypeSystemId(doc.getSystemId());
                    this._props.setEncoding(doc.getCharacterEncodingScheme());
                    this._props.setVersion(doc.getVersion());
                    this._standAlone = doc.isStandalone();
                    if (!lineNums) break;
                    context.lineNumberAnnotation(xe);
                    break;
                }
                case 512: {
                    if (!lineNums) break block12;
                    context.lineNumberAnnotation(xe);
                    break block12;
                }
                case 128: {
                    if (xis.hasNext()) break;
                    break block12;
                }
                case 2: {
                    context.begin(XMLNameHelper.getQName(xe.getName()));
                    if (lineNums) {
                        context.lineNumberAnnotation(xe);
                    }
                    AttributeIterator ai = ((StartElement)xe).getAttributes();
                    while (ai.hasNext()) {
                        Attribute attr = ai.next();
                        context.attr(XMLNameHelper.getQName(attr.getName()), attr.getValue());
                    }
                    AttributeIterator ai2 = ((StartElement)xe).getNamespaces();
                    while (ai2.hasNext()) {
                        Attribute attr = ai2.next();
                        XMLName name = attr.getName();
                        String local = name.getLocalName();
                        if (name.getPrefix() == null && local.equals("xmlns")) {
                            local = "";
                        }
                        context.xmlns(local, attr.getValue());
                    }
                    break;
                }
                case 4: {
                    context.end();
                    if (!lineNums) break;
                    context.lineNumberAnnotation(xe);
                    break;
                }
                case 64: {
                    if (((Space)xe).ignorable()) break;
                }
                case 16: {
                    CharacterData cd = (CharacterData)xe;
                    if (!cd.hasContent()) break;
                    context.text(cd.getContent());
                    if (!lineNums) break;
                    context.lineNumberAnnotation(xe);
                    break;
                }
                case 32: {
                    Comment comment = (Comment)xe;
                    if (!comment.hasContent()) break;
                    context.comment(comment.getContent());
                    if (!lineNums) break;
                    context.lineNumberAnnotation(xe);
                    break;
                }
                case 8: {
                    ProcessingInstruction procInstr = (ProcessingInstruction)xe;
                    context.procinst(procInstr.getTarget(), procInstr.getData());
                    if (!lineNums) break;
                    context.lineNumberAnnotation(xe);
                    break;
                }
                case 1: 
                case 1024: 
                case 2048: 
                case 4096: 
                case 8192: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled xml event type: " + xe.getTypeAsString());
                }
            }
            xe = xis.next();
        }
        context.finish();
        this.associateSourceName(options);
        if (!$assertionsDisabled && !this.validate()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.isLeftOnly()) {
            throw new AssertionError();
        }
    }

    public static void dump(XmlObject x) {
        Root.dump(x, System.out);
    }

    public static void dump(XmlObject x, PrintStream ps) {
        XmlCursor xc = x.newCursor();
        Root r = ((Cursor)xc).getRoot();
        r.dump(ps, null, ((Cursor)xc).getSplay(), false);
        xc.dispose();
    }

    public static void dump(XmlCursor xc) {
        Root.dump(xc, System.out);
    }

    public static void dump(XmlCursor xc, PrintStream ps) {
        Root r = ((Cursor)xc).getRoot();
        r.dump(ps, null, ((Cursor)xc).getSplay(), false);
    }

    private void dumpText(PrintStream ps, int cp, int cch, Splay s, int p) {
        if (cp >= 0 && cp + cch <= this._text.length()) {
            this.dumpString(ps, this._text.fetch(cp, cch), s, p);
        } else {
            ps.print("[string: cp=" + cp + ", cch=" + cch + " ]");
        }
    }

    private void dumpText(PrintStream ps, int cp, int cch) {
        if (cp >= 0 && cp + cch <= this._text.length()) {
            this.dumpString(ps, this._text.fetch(cp, cch), null, 0);
        } else {
            ps.print("[string: cp=" + cp + ", cch=" + cch + " ]");
        }
    }

    private void dumpString(PrintStream ps, String s) {
        this.dumpString(ps, s, null, 0);
    }

    private void dumpGoobersInline(PrintStream ps, Splay s, int p) {
        Splay.Goober g = s.firstGoober();
        while (g != null) {
            if (g.getKind() == 0 && g.getPos() == p) {
                Splay.CursorGoober cg = (Splay.CursorGoober)g;
                ps.print("[" + ((Splay.CursorGoober)g).getDebugId() + "]");
            }
            g = s.nextGoober(g);
        }
    }

    private void dumpString(PrintStream ps, String str, Splay s, int p) {
        int i = 0;
        while (i < str.length()) {
            if (s != null) {
                this.dumpGoobersInline(ps, s, i + p);
            }
            if (i == 36) {
                ps.print("...");
                break;
            }
            char ch = str.charAt(i);
            if (ch == '\n') {
                ps.print("\\n");
            } else if (ch == '\r') {
                ps.print("\\r");
            } else if (ch == '\t') {
                ps.print("\\t");
            } else if (ch == '\"') {
                ps.print("\\\"");
            } else {
                ps.print(ch);
            }
            ++i;
        }
    }

    private void dumpGoobers(PrintStream ps, Splay.Goober g) {
        if (g == null) {
            return;
        }
        if (g.getKind() == 3) {
            ps.print(" {");
            this.dumpGoobers(ps, g._goobers);
            ps.print("}");
        } else {
            ps.print(" - " + g.getKindName() + " pos: " + g.getPos());
        }
        if (g.getKind() == 0) {
            ps.print(" id: " + ((Splay.CursorGoober)g).getDebugId());
        }
        if (g._next != g._parent._goobers) {
            this.dumpGoobers(ps, g._next);
        }
    }

    private void dumpSplayTree(Splay s, PrintStream ps) {
        if (s == null) {
            return;
        }
        if (s._rightSplay != null) {
            this.dumpSplayTree(s._rightSplay, ps);
        }
        Splay t = s._parentSplay;
        while (t != null) {
            ps.print("  ");
            t = t._parentSplay;
        }
        ps.print("[" + s.getDebugId());
        ps.print(" c:" + s.getCchLeft() + "(" + s.getCch() + ")");
        ps.print(" b:" + s.getCdocBeginLeft() + "(" + s.getCdocBegin() + ")");
        if (s._parentSplay != null) {
            ps.print(" p:" + s._parentSplay.getDebugId());
            ps.print(s._parentSplay._leftSplay == s ? "L" : "R");
        }
        ps.println("]");
        if (s._leftSplay != null) {
            this.dumpSplayTree(s._leftSplay, ps);
        }
    }

    public static void dump(XmlCursor c, boolean verbose) {
        ((Cursor)c).dump(verbose);
    }

    public void dump() {
        this.dump(System.out, null, this, false);
    }

    public void dump(boolean verbose) {
        this.dump(System.out, null, this, verbose);
    }

    public void dump(PrintStream ps) {
        this.dump(ps, null, this, false);
    }

    public void dump(PrintStream ps, String msg, Object src, boolean verbose) {
        File f = new File("c:\\");
        if (f.exists()) {
            FileOutputStream os;
            block8: {
                f = new File(f, "xbean.dmp");
                os = null;
                PrintStream ps2 = null;
                try {
                    os = new FileOutputStream(f);
                    ps2 = new PrintStream(os);
                    this.doDump(ps2, msg, src, verbose);
                }
                catch (Throwable t) {
                    if (ps2 == null) break block8;
                    ps2.println("Exception during dump.");
                    t.printStackTrace(ps2);
                }
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            this.doDump(ps, msg, src, verbose);
        }
        catch (Throwable t) {
            System.out.println("Exception during dump.");
            t.printStackTrace(System.out);
        }
    }

    public void doDump(PrintStream ps, String msg, Object src, boolean verbose) {
        if (!Splay._assertEnabled) {
            ps.println("No dump produced (assert needs to be enabled)");
            return;
        }
        DumpNsManager nsm = new DumpNsManager(ps);
        if (msg != null) {
            ps.println(msg);
        } else {
            ps.println("Dump:");
        }
        if (src != null) {
            if (src instanceof Cursor) {
                ps.println("  from cursor " + ((Cursor)src)._data._goober.getDebugId());
            } else if (src instanceof Splay) {
                ps.println("  from splay " + ((Splay)src).getDebugId());
            } else {
                ps.println("  from src " + src);
            }
        }
        int depth = 0;
        Splay s = this._doc;
        while (s != null) {
            Splay.Begin b;
            int kind = s.getKind();
            String ids = "" + s.getDebugId();
            ids = "        ".substring(0, 6 - ids.length()) + ids;
            ps.print(ids + ": ");
            if (kind == 6) {
                --depth;
            }
            if (!s.isRoot()) {
                int i = 0;
                while (i < depth) {
                    ps.print("  ");
                    ++i;
                }
            }
            this.dumpGoobersInline(ps, s, 0);
            switch (kind) {
                case 0: {
                    ps.print("DOC");
                    break;
                }
                case 1: {
                    Splay.Begin b2 = (Splay.Begin)s;
                    if (!b2.isLeaf()) {
                        ++depth;
                    }
                    ps.print("<");
                    ps.print(s.getName().toString());
                    ps.print(">");
                    if (!b2.isLeaf()) break;
                    if (b2.getCchValue() > 0) {
                        ps.print("\"");
                        this.dumpText(ps, s.getCpSlow(), b2.getCchValue(), s, 1);
                        ps.print("\"");
                    }
                    this.dumpGoobersInline(ps, s, s.getPosLeafEnd());
                    ps.print("</");
                    ps.print(s.getName().getLocalPart());
                    ps.print("/>");
                    break;
                }
                case 2: {
                    if (s.isXmlns()) {
                        ps.print("#xmlns:");
                        ps.print(s.getName().getLocalPart());
                        ps.print("=\"");
                        ps.print(s.getName().getNamespaceURI());
                        ps.print("\"");
                        break;
                    }
                    ps.print("@");
                    ps.print(s.getName());
                    ps.print("=\"");
                    this.dumpText(ps, s.getCpSlow(), s.getCchValue());
                    ps.print("\"");
                    break;
                }
                case 6: {
                    Splay.End es = (Splay.End)s;
                    b = es._begin;
                    ps.print("</");
                    ps.print(b.getName().getLocalPart());
                    ps.print("/>");
                    break;
                }
                case 3: {
                    if (s.isFragment()) {
                        ps.print("FRAG");
                        break;
                    }
                    ps.print("<!--");
                    this.dumpText(ps, s.getCpSlow(), s.getCchValue());
                    ps.print("-->");
                    break;
                }
                case 4: {
                    ps.print("<?");
                    ps.print(s.getLocal());
                    ps.print(" ");
                    this.dumpText(ps, s.getCpSlow(), s.getCchValue());
                    ps.print("?>");
                    break;
                }
                case 5: {
                    ps.print("ROOT");
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown splay kind");
                }
            }
            if (s.getCchAfter() > 0) {
                ps.print("\"");
                this.dumpText(ps, s.getCpSlow() + s.getCchValue(), s.getCchAfter(), s, s.getPosAfter());
                ps.print("\"");
            }
            this.dumpGoobersInline(ps, s, s.getEndPos());
            if (s.isInvalid()) {
                String value = s.peekType().build_text(nsm);
                ps.print(" [invalid:");
                ps.print("\"");
                this.dumpString(ps, value);
                ps.print("\"");
                ps.print("]");
            }
            this.dumpGoobers(ps, s._goobers);
            if (verbose) {
                switch (kind) {
                    case 1: {
                        Splay.Begin b3 = (Splay.Begin)s;
                        if (b3.getFinish() != null) {
                            ps.print(" [end: ");
                            ps.print(b3.getFinish().getDebugId());
                            ps.print("]");
                        }
                        if (b3.getContainer() == null) break;
                        ps.print(" [container: " + b3.getContainer().getDebugId() + "]");
                        break;
                    }
                    case 6: {
                        Splay.End es = (Splay.End)s;
                        b = es._begin;
                        ps.print(" [begin: " + b.getDebugId() + "]");
                        break;
                    }
                }
            }
            ps.println();
            s = s.nextSplay();
        }
        ps.println();
        if (this.getCchLeft() > this._text.length()) {
            ps.println("Text buffer has too few characters (" + (this.getCchLeft() - this._text.length()) + ")");
        } else if (this.getCchLeft() < this._text.length()) {
            ps.println("Text buffer has too many characters (" + (this._text.length() - this.getCchLeft()) + "): ");
            this.dumpString(ps, this._text.fetch(this.getCchLeft(), this._text.length() - this.getCchLeft()));
        }
        if (verbose) {
            ps.println("Splay tree:");
            ps.println("  isLeftOnly: " + this._leftOnly);
            ps.println("  version: " + this.getVersion());
            ps.println("  first: " + this._doc.getDebugId());
            ps.println();
            this.dumpSplayTree(this, ps);
            ps.println();
            ps.println();
        }
        ps.println();
    }

    void insertSplay(Splay s, Splay a) {
        if (!$assertionsDisabled && s == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && s.isRoot()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && a == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dv <= 0 && !this.validateSplayTree()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && a.isRoot()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dv <= 0 && a.getRootSlow() != this) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && s._parentSplay != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && s._rightSplay != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && s._leftSplay == null && s.getCchLeft() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && s._leftSplay == null && s.getCdocBeginLeft() != 0) {
            throw new AssertionError();
        }
        int cch = s.getCch();
        int cbegin = s.getCdocBegin();
        if (s._leftSplay != null) {
            cch += s.getCchLeft();
            cbegin += s.getCdocBeginLeft();
            this._leftOnly = false;
        }
        if (this._leftOnly && a == this._leftSplay) {
            s._leftSplay = this._leftSplay;
            s._parentSplay = this;
            if (!$assertionsDisabled && s.getCchLeft() != 0) {
                throw new AssertionError();
            }
            s.adjustCchLeft(this._leftSplay.getCchLeft() + this._leftSplay.getCch());
            if (!$assertionsDisabled && s.getCdocBeginLeft() != 0) {
                throw new AssertionError();
            }
            s.adjustCdocBeginLeft(this._leftSplay.getCdocBeginLeft() + this._leftSplay.getCdocBegin());
            this._leftSplay._parentSplay = s;
            this._leftSplay = s;
            this.adjustCchLeft(cch);
            this.adjustCdocBeginLeft(cbegin);
        } else if (this._leftOnly && cch == 0 && cbegin == 0) {
            s._parentSplay = a._parentSplay;
            s._leftSplay = a;
            a._parentSplay = s;
            s._parentSplay._leftSplay = s;
            s.adjustCchLeft(a.getCchLeft() + a.getCch());
            s.adjustCdocBeginLeft(a.getCdocBeginLeft() + a.getCdocBegin());
        } else {
            Splay t;
            Splay p;
            if (a._rightSplay == null) {
                p = a;
                a._rightSplay = s;
                this._leftOnly = false;
            } else {
                p = a._rightSplay;
                while (p._leftSplay != null) {
                    p = p._leftSplay;
                }
                p._leftSplay = s;
            }
            s._parentSplay = p;
            p = s;
            while ((t = p._parentSplay) != null) {
                if (t._leftSplay == p) {
                    t.adjustCchLeft(cch);
                    t.adjustCdocBeginLeft(cbegin);
                }
                p = t;
            }
            s.splay(this, this);
        }
        if (!$assertionsDisabled && !this.validateSplayTree()) {
            throw new AssertionError();
        }
    }

    void insertSingleSplaySansSplayInLeftOnlyTree(Splay s, Splay a) {
        if (!$assertionsDisabled && !this._leftOnly) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && s._rightSplay != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && s._leftSplay != null) {
            throw new AssertionError();
        }
        s._leftSplay = a;
        s._parentSplay = a._parentSplay;
        a._parentSplay._leftSplay = s;
        a._parentSplay = s;
        s.adjustCchLeft(a.getCchLeft() + a.getCch());
        s.adjustCdocBeginLeft(a.getCdocBeginLeft() + a.getCdocBegin());
        int cch = s.getCch();
        int cbegin = s.getCdocBegin();
        Splay p = s._parentSplay;
        while (p != null) {
            p.adjustCchLeft(cch);
            p.adjustCdocBeginLeft(cbegin);
            p = p._parentSplay;
        }
    }

    Splay removeSplays(Splay first, Splay last) {
        if (!$assertionsDisabled && !this.validateSplayTree()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && first == last) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && first.isRoot()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && first.isDoc()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dv <= 0 && first.getRootSlow() != this) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dv <= 0 && last.getRootSlow() != this) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dv <= 0 && first.compareSlow(last) != -1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && last.isRoot() && last != this) {
            throw new AssertionError();
        }
        Splay x = last.prevSplay();
        if (x == first) {
            return x.removeSplay(this);
        }
        if (last != this) {
            last.splay(this, this);
        }
        x.splay(this, last);
        first.splay(this, x);
        if (!$assertionsDisabled && this != last && this._leftSplay != last) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && last._leftSplay != x) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && x._leftSplay != first) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && x._rightSplay != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && first._leftSplay == null) {
            throw new AssertionError();
        }
        int firstCchLeft = first.getCchLeft();
        int firstCbeginLeft = first.getCdocBeginLeft();
        int deltaCchLeft = firstCchLeft - last.getCchLeft();
        int deltaCbeginLeft = firstCbeginLeft - last.getCdocBeginLeft();
        last.adjustCchLeft(deltaCchLeft);
        last.adjustCdocBeginLeft(deltaCbeginLeft);
        if (last != this) {
            this.adjustCchLeft(deltaCchLeft);
            this.adjustCdocBeginLeft(deltaCbeginLeft);
        }
        x.adjustCchLeft(-firstCchLeft);
        x.adjustCdocBeginLeft(-firstCbeginLeft);
        first.adjustCchLeft(-firstCchLeft);
        first.adjustCdocBeginLeft(-firstCbeginLeft);
        if (!$assertionsDisabled && first.getCchLeft() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && first.getCdocBeginLeft() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && x.getCchLeft() + deltaCchLeft + x.getCch() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && x.getCdocBeginLeft() + deltaCbeginLeft + x.getCdocBegin() != 0) {
            throw new AssertionError();
        }
        first._leftSplay._parentSplay = last;
        last._leftSplay = first._leftSplay;
        x._parentSplay = null;
        first._leftSplay = null;
        first._parentSplay = null;
        if (!$assertionsDisabled && !this.validateSplayTree()) {
            throw new AssertionError();
        }
        return x;
    }

    public static synchronized boolean disableStoreValidation() {
        ++dv;
        return true;
    }

    public static synchronized boolean enableStoreValidation() {
        --dv;
        return true;
    }

    public boolean validate() {
        if (dv != 0) {
            return true;
        }
        try {
            return this.doValidate();
        }
        catch (RuntimeException rte) {
            System.out.println("Document invalid: " + rte.getMessage());
            rte.printStackTrace();
            this.dump(true);
            throw rte;
        }
    }

    private Splay validateAttributes(Splay s) {
        while (s.getKind() == 2) {
            s = s.nextSplay();
        }
        return s;
    }

    private Splay validateContent(Splay s) {
        while (true) {
            int k;
            if ((k = s.getKind()) == 3 || k == 4) {
                s = s.nextSplay();
                continue;
            }
            Splay q = s;
            if (q == (s = this.validateElement(s))) break;
        }
        return s;
    }

    private Splay validateElement(Splay s) {
        if (s.getKind() == 1) {
            Splay b = s;
            s = this.validateAttributes(s.nextSplay());
            if (!b.isLeaf()) {
                s = this.validateContent(s);
                if (!$assertionsDisabled && !s.isEnd()) {
                    throw new AssertionError((Object)("Missing END, splay: " + s.getDebugId()));
                }
                s = s.nextSplay();
            }
        }
        return s;
    }

    private boolean validateDoc() {
        Splay s = this._doc.nextSplay();
        s = this.validateAttributes(s);
        s = this.validateContent(s);
        if (!$assertionsDisabled && !s.isRoot()) {
            throw new AssertionError((Object)"Expected root");
        }
        return true;
    }

    private void validateGoober(Splay.Goober g, Splay s, ValidateContext context) {
        if (g instanceof Type) {
            if (!$assertionsDisabled && g.getKind() != 1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !s.isTypeable()) {
                throw new AssertionError();
            }
            ++context._numSplayTypes;
            Type type = (Type)g;
            if (type.uses_invalidate_value()) {
                ++context._cInvalidatableTypes;
            }
            if (type.is_child_element_order_sensitive()) {
                ++context._cElemOrderSensitiveTypes;
            }
        } else if (!$assertionsDisabled && g.getKind() == 1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && g.getSplay() != s) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && g.getRoot() != this) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && g.getPos() < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && g.getPos() > s.getMaxPos()) {
            throw new AssertionError();
        }
    }

    private boolean doValidate() {
        if (!$assertionsDisabled && !this.validateDoc()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.validateSplayTree()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getCchLeft() != this._text.length()) {
            throw new AssertionError();
        }
        this.validateChangeListenerState();
        ValidateContext context = new ValidateContext();
        Splay recentContainer = null;
        Splay s = this._doc;
        while (s != null) {
            if (s.isRoot()) {
                if (!$assertionsDisabled && s.getCchAfter() != 0) {
                    throw new AssertionError();
                }
            } else if (s.isBegin()) {
                Splay.Begin b = (Splay.Begin)s;
                if (!$assertionsDisabled && b.getName() == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && b.getFinish() != null && b.getFinish().getContainer() != b) {
                    throw new AssertionError();
                }
                if (b.isLeaf()) {
                    if (!$assertionsDisabled && b.getFinish() != null) {
                        throw new AssertionError();
                    }
                } else {
                    if (!$assertionsDisabled && b.getFinish() == null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && b.getFinish().getContainer() != b) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && b.getCchValue() != 0) {
                        throw new AssertionError();
                    }
                }
            } else if (s.isAttr()) {
                if (!$assertionsDisabled && s.getName() == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && s.getCchAfter() != 0) {
                    throw new AssertionError();
                }
            }
            if (s.isProcinst()) {
                if (!$assertionsDisabled && s.getName().getNamespaceURI() == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && s.getName().getNamespaceURI().length() != 0) {
                    throw new AssertionError();
                }
            }
            if (s.isContainer()) {
                if (!$assertionsDisabled && s.getContainer() != recentContainer) {
                    throw new AssertionError();
                }
                if (!s.isLeaf()) {
                    recentContainer = (Splay.Container)s;
                }
            } else if (s.isFinish()) {
                if (!$assertionsDisabled && s.getContainer() != recentContainer) {
                    throw new AssertionError();
                }
                recentContainer = recentContainer.getContainer();
            }
            context._numSplayTypes = 0;
            Splay.Goober g = s.firstGoober();
            while (g != null) {
                this.validateGoober(g, s, context);
                g = s.nextGoober(g);
            }
            if (this.isInvalid()) {
                if (!$assertionsDisabled && !s.isTypeable()) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && s.peekType() == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && context._numSplayTypes != 1) {
                    throw new AssertionError();
                }
                if (s.isDoc()) {
                    if (!$assertionsDisabled && s.getCchAfter() != 0) {
                        throw new AssertionError();
                    }
                    Splay n = s.nextNonAttrSplay();
                    if (!$assertionsDisabled && !n.isRoot()) {
                        throw new AssertionError();
                    }
                } else if (s.isBegin()) {
                    if (!$assertionsDisabled && !s.isLeaf()) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && s.getCchValue() != 0) {
                        throw new AssertionError();
                    }
                } else if (s.isAttr() && !$assertionsDisabled && s.getCchValue() != 0) {
                    throw new AssertionError();
                }
            } else if (!$assertionsDisabled && context._numSplayTypes > 1) {
                throw new AssertionError();
            }
            s = s.nextSplay();
        }
        if (!$assertionsDisabled && context._cInvalidatableTypes != this._cInvalidatableTypes) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && context._cElemOrderSensitiveTypes != this._cElemOrderSensitiveTypes) {
            throw new AssertionError();
        }
        return true;
    }

    boolean validateSplayTree() {
        if (dv != 0) {
            return true;
        }
        try {
            return this.doValidateSplayTree();
        }
        catch (RuntimeException rte) {
            System.out.println("Splay tree invalid: " + rte);
            this.dump(true);
            throw rte;
        }
    }

    /*
     * Unable to fully structure code
     */
    boolean doValidateSplayTree() {
        Splay.assertAssertEnabled();
        stats = new ValidateStats();
        if (!Root.$assertionsDisabled && this._parentSplay != null) {
            throw new AssertionError();
        }
        if (!Root.$assertionsDisabled && this._rightSplay != null) {
            throw new AssertionError();
        }
        if (!Root.$assertionsDisabled && this._doc._leftSplay != null) {
            throw new AssertionError();
        }
        s = this;
        if (s._leftSplay != null) {
            s = s._leftSplay;
            while (s != null && s._leftSplay != null) {
                s = s._leftSplay;
            }
        }
        if (!Root.$assertionsDisabled && s != this._doc) {
            throw new AssertionError();
        }
        block1: while (true) lbl-1000:
        // 3 sources

        {
            block25: {
                if (s._leftSplay == null && s._rightSplay == null) {
                    stats.adjustCch(s, s.getCch());
                    stats.adjustCbegin(s, s.getCdocBegin());
                }
                if (s._rightSplay == null) break block25;
                s = s._rightSplay;
                while (true) {
                    if (s._leftSplay == null) ** GOTO lbl-1000
                    s = s._leftSplay;
                }
            }
            while ((p = s._parentSplay) != null) {
                if (p._rightSplay == null || p._rightSplay == s) {
                    s = p;
                    stats.adjustCch(s, s.getCch());
                    stats.adjustCbegin(s, s.getCdocBegin());
                    if (s._leftSplay != null) {
                        stats.adjustCch(s, stats.getCch(s._leftSplay));
                        stats.adjustCbegin(s, stats.getCbegin(s._leftSplay));
                    }
                    if (s._rightSplay == null) continue;
                    stats.adjustCch(s, stats.getCch(s._rightSplay));
                    stats.adjustCbegin(s, stats.getCbegin(s._rightSplay));
                    continue;
                }
                if (!Root.$assertionsDisabled && p._leftSplay != s) {
                    throw new AssertionError();
                }
                if (!Root.$assertionsDisabled && p._rightSplay == null) {
                    throw new AssertionError();
                }
                s = p._rightSplay;
                while (true) {
                    if (s._leftSplay == null) continue block1;
                    s = s._leftSplay;
                }
            }
            break;
        }
        s = this._doc;
        while (s != null) {
            if (!Root.$assertionsDisabled && this._leftOnly && s._rightSplay != null) {
                throw new AssertionError((Object)("" + s.getDebugId()));
            }
            if (!Root.$assertionsDisabled && s._leftSplay != null && s._leftSplay._parentSplay != s) {
                throw new AssertionError();
            }
            if (!Root.$assertionsDisabled && s._rightSplay != null && s._rightSplay._parentSplay != s) {
                throw new AssertionError();
            }
            if (s._leftSplay == null) {
                if (!Root.$assertionsDisabled && s.getCchLeft() != 0) {
                    throw new AssertionError();
                }
                if (!Root.$assertionsDisabled && s.getCdocBeginLeft() != 0) {
                    throw new AssertionError();
                }
            } else {
                if (!Root.$assertionsDisabled && s.getCchLeft() != stats.getCch(s._leftSplay)) {
                    throw new AssertionError((Object)("" + s.getDebugId()));
                }
                if (!Root.$assertionsDisabled && s.getCdocBeginLeft() != stats.getCbegin(s._leftSplay)) {
                    throw new AssertionError();
                }
            }
            s = s.nextSplay();
        }
        return true;
    }

    long getVersion() {
        return this.__version;
    }

    void invalidateVersion() {
        if (!$assertionsDisabled && this._changeClients != null) {
            throw new AssertionError();
        }
        ++this.__version;
        if ($assertionsDisabled || (this._debugChangeVersion = this.__version) != 0L) {
            // empty if block
        }
    }

    void restoreVersion(long oldVersion) {
        if (!$assertionsDisabled && this.__version < oldVersion) {
            throw new AssertionError();
        }
        this.__version = oldVersion;
        if ($assertionsDisabled || (this._debugChangeVersion = this.__version) != 0L) {
            // empty if block
        }
    }

    boolean validateChangeStarted() {
        if (!$assertionsDisabled && this._changeClients != null) {
            throw new AssertionError();
        }
        return this._changeClients == null;
    }

    boolean validateChangeListenerState() {
        if (!$assertionsDisabled && this._debugChangeVersion != this.__version) {
            throw new AssertionError();
        }
        return true;
    }

    void registerForChange(ChangeListener listener) {
        if (!$assertionsDisabled && !this.validateChangeListenerState()) {
            throw new AssertionError();
        }
        if (this._changeClients != null && this._changeClients._listener == listener) {
            return;
        }
        ChangeClient client = new ChangeClient();
        client._next = this._changeClients;
        client._listener = listener;
        this._changeClients = client;
    }

    void startChange() {
        if (!$assertionsDisabled && !this.validateChangeListenerState()) {
            throw new AssertionError();
        }
        long currentVersion = 0L;
        if (!$assertionsDisabled && (currentVersion = this.__version) != 0L) {
            // empty if block
        }
        while (this._changeClients != null) {
            this._changeClients._listener.changeNotification();
            this._changeClients = this._changeClients._next;
        }
        if (!$assertionsDisabled && currentVersion != this.__version) {
            throw new AssertionError();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$org$apache$xmlbeans$impl$store$Root == null ? (class$org$apache$xmlbeans$impl$store$Root = Root.class$("org.apache.xmlbeans.impl.store.Root")) : class$org$apache$xmlbeans$impl$store$Root).desiredAssertionStatus();
        tl_SaxLoaders = new ThreadLocal(){

            protected Object initialValue() {
                SaxLoader sl = PiccoloSaxLoader.newInstance();
                if (sl == null) {
                    sl = DefaultSaxLoader.newInstance();
                }
                if (sl == null) {
                    throw new RuntimeException("Can't find an XML parser");
                }
                return sl;
            }
        };
    }

    class nthCache {
        private long _version;
        private Splay _parent;
        private QName _name;
        private QNameSet _set;
        private Splay _child;
        private int _n;
        static final /* synthetic */ boolean $assertionsDisabled;

        nthCache() {
        }

        private boolean namesSame(QName pattern, QName name) {
            return pattern == null || pattern.equals(name);
        }

        private boolean setsSame(QNameSet patternSet, QNameSet set) {
            return patternSet != null && patternSet == set;
        }

        private boolean nameHit(QName namePattern, QNameSet setPattern, QName name) {
            if (setPattern == null) {
                return this.namesSame(namePattern, name);
            }
            return setPattern.contains(name);
        }

        private boolean cacheSame(QName namePattern, QNameSet setPattern) {
            return setPattern == null ? this.namesSame(namePattern, this._name) : this.setsSame(setPattern, this._set);
        }

        int distance(Splay parent, QName name, QNameSet set, int n) {
            if (!$assertionsDisabled && n < 0) {
                throw new AssertionError();
            }
            if (this._version != Root.this.getVersion()) {
                return 0x7FFFFFFE;
            }
            if (parent != this._parent || !this.cacheSame(name, set)) {
                return Integer.MAX_VALUE;
            }
            return n > this._n ? n - this._n : this._n - n;
        }

        Splay.Begin fetch(Splay parent, QName name, QNameSet set, int n) {
            block20: {
                Splay s;
                block19: {
                    if (!$assertionsDisabled && n < 0) {
                        throw new AssertionError();
                    }
                    if (this._version != Root.this.getVersion() || this._parent != parent || !this.cacheSame(name, set) || n == 0) {
                        this._version = Root.this.getVersion();
                        this._parent = parent;
                        this._name = name;
                        this._child = null;
                        this._n = -1;
                        if (!parent.isLeaf()) {
                            s = parent.nextSplay();
                            block4: while (true) {
                                switch (s.getKind()) {
                                    case 5: 
                                    case 6: {
                                        break block4;
                                    }
                                    case 1: {
                                        if (this.nameHit(name, set, s.getName())) {
                                            this._child = s;
                                            this._n = 0;
                                            break block4;
                                        }
                                        s = s.getFinishSplay();
                                    }
                                    default: {
                                        s = s.nextSplay();
                                        continue block4;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    if (this._n < 0) {
                        return null;
                    }
                    if (n <= this._n) break block19;
                    block5: while (n > this._n) {
                        s = this._child.getFinishSplay().nextSplay();
                        while (!s.isFinish()) {
                            if (s.isBegin()) {
                                if (this.nameHit(name, set, s.getName())) {
                                    this._child = s;
                                    ++this._n;
                                    continue block5;
                                }
                                s = s.getFinishSplay();
                            }
                            s = s.nextSplay();
                        }
                        return null;
                    }
                    break block20;
                }
                if (n >= this._n) break block20;
                block7: while (n < this._n) {
                    s = this._child;
                    while (true) {
                        if ((s = s.prevSplay()).isLeaf() || s.isEnd()) {
                            if (s.isEnd()) {
                                s = s.getContainer();
                            }
                            if (!this.nameHit(name, set, s.getName())) continue;
                            this._child = s;
                            --this._n;
                            continue block7;
                        }
                        if (s.isContainer()) break;
                    }
                    return null;
                }
            }
            return (Splay.Begin)this._child;
        }

        static {
            $assertionsDisabled = !(class$org$apache$xmlbeans$impl$store$Root == null ? (class$org$apache$xmlbeans$impl$store$Root = Root.class$("org.apache.xmlbeans.impl.store.Root")) : class$org$apache$xmlbeans$impl$store$Root).desiredAssertionStatus();
        }
    }

    static class DocProps
    extends XmlDocumentProperties {
        private HashMap _map = new HashMap();

        DocProps() {
        }

        public Object put(Object key, Object value) {
            return this._map.put(key, value);
        }

        public Object get(Object key) {
            return this._map.get(key);
        }

        public Object remove(Object key) {
            return this._map.remove(key);
        }
    }

    private static class ChangeClient {
        ChangeListener _listener;
        ChangeClient _next;

        private ChangeClient() {
        }
    }

    static interface ChangeListener {
        public void changeNotification();
    }

    private static class ValidateStats
    extends HashMap {
        private ValidateStats() {
        }

        int getCch(Splay s) {
            return this.getStats((Splay)s)._cch;
        }

        void adjustCch(Splay s, int cchDelta) {
            Stats stats = this.getStats(s);
            stats._cch += cchDelta;
        }

        int getCbegin(Splay s) {
            return this.getStats((Splay)s)._cbegin;
        }

        void adjustCbegin(Splay s, int cbeginDelta) {
            Stats stats = this.getStats(s);
            stats._cbegin += cbeginDelta;
        }

        private Stats getStats(Splay s) {
            Stats stats = (Stats)this.get(s);
            if (stats == null) {
                stats = new Stats();
                this.put(s, stats);
            }
            return stats;
        }

        private static class Stats {
            public int _cch;
            public int _cbegin;

            private Stats() {
            }
        }
    }

    private static class ValidateContext {
        int _numSplayTypes;
        int _cInvalidatableTypes;
        int _cElemOrderSensitiveTypes;

        private ValidateContext() {
        }
    }

    static class DumpNsManager
    implements NamespaceManager {
        PrintStream ps;
        private int i = 1;

        DumpNsManager(PrintStream ps) {
            this.ps = ps;
        }

        public String find_prefix_for_nsuri(String uri, String suggestion) {
            String prefix = "debug_prefix_" + this.i++;
            this.ps.print(" [find_prefix_for_nsuri: ");
            this.ps.print("\"" + uri + "\" (" + suggestion + ") -> " + prefix);
            this.ps.print("]");
            return prefix;
        }

        public String getNamespaceForPrefix(String prefix) {
            if (prefix != null && prefix.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            String uri = "debug_ns_" + this.i++;
            this.ps.print(" [lookup_nsuri_for_prefix: ");
            this.ps.print(prefix + " -> \"" + uri + "\"");
            this.ps.print("]");
            return uri;
        }
    }

    static final class LoadContext {
        private Root _root;
        private Splay _lastNonAttr;
        private Splay.Container _frontier;
        private Splay _lastSplay;
        private int _lastPos;
        private boolean _finished;
        private boolean _discardDocElem;
        private QName _replaceDocElem;
        private boolean _stripWhitespace;
        private boolean _stripComments;
        private boolean _stripProcinsts;
        private boolean _docElemDiscarded;
        private Map _substituteNamespaces;
        private Map _additionalNamespaces;
        private QNameCache _qnameCache;
        private XmlOptions _options;
        static final /* synthetic */ boolean $assertionsDisabled;

        LoadContext(Root root, XmlOptions options) {
            if (!$assertionsDisabled && root == null) {
                throw new AssertionError();
            }
            this._options = options = XmlOptions.maskNull(options);
            this._qnameCache = XmlBeans.getQNameCache();
            if (options.hasOption("LOAD_REPLACE_DOCUMENT_ELEMENT")) {
                QName name = (QName)options.get("LOAD_REPLACE_DOCUMENT_ELEMENT");
                if (name != null && name.getLocalPart().length() == 0) {
                    throw new IllegalArgumentException("Load Replace Document Element: Invalid name, local part empty");
                }
                this._discardDocElem = true;
                this._replaceDocElem = name;
            }
            this._stripWhitespace = options.hasOption("LOAD_STRIP_WHITESPACE");
            this._stripComments = options.hasOption("LOAD_STRIP_COMMENTS");
            this._stripProcinsts = options.hasOption("LOAD_STRIP_PROCINSTS");
            this._substituteNamespaces = (Map)options.get("LOAD_SUBSTITUTE_NAMESPACES");
            this._additionalNamespaces = (Map)options.get("LOAD_ADDITIONAL_NAMESPACES");
            this._root = root;
            this._root.ensureEmpty();
            this._lastNonAttr = this._root._doc;
            this._lastSplay = this._root._doc;
            this._lastPos = 0;
            this._frontier = this._root._doc;
        }

        private Root getRoot() {
            return this._root;
        }

        private int getCp(Splay s) {
            if (!$assertionsDisabled && !this._root.isLeftOnly()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && dv <= 0 && s.getCpSlow() != s.getCchLeft()) {
                throw new AssertionError();
            }
            return s.getCchLeft();
        }

        private void adjustCch(Splay s, int delta) {
            if (!$assertionsDisabled && !this._root.isLeftOnly()) {
                throw new AssertionError();
            }
            s.adjustCch(delta);
            s = s.nextSplay();
            while (s != null) {
                if (!($assertionsDisabled || s.isAttr() || s.isRoot())) {
                    throw new AssertionError();
                }
                s.adjustCchLeft(delta);
                s = s.nextSplay();
            }
        }

        private void insert(Splay s) {
            if (!$assertionsDisabled && this._finished) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && s.getCch() != 0) {
                throw new AssertionError();
            }
            this._root.insertSplay(s, this._root._leftSplay);
            this._lastSplay = s;
            this._lastPos = 0;
            if (!s.isAttr()) {
                this._lastNonAttr = s;
            }
        }

        private void insert(Splay s, char[] buf, int off, int cch) {
            if (!$assertionsDisabled && this._finished) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && s.getCch() != 0) {
                throw new AssertionError();
            }
            this.insert(s);
            this._root._text.insert(this.getCp(s), buf, off, cch);
            this.adjustCch(s, cch);
        }

        private void insert(Splay s, String text) {
            if (!$assertionsDisabled && this._finished) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && s.getCch() != 0) {
                throw new AssertionError();
            }
            this.insert(s);
            this._root._text.insert(this.getCp(s), text);
            this.adjustCch(s, text.length());
        }

        private void stripLeadingWhitespace() {
            int cchAfter = this._lastNonAttr.getCchAfter();
            if (cchAfter > 0) {
                int cch = cchAfter;
                int cpAfter = this._lastNonAttr.getCpForPos(this._root, this._lastNonAttr.getPosAfter());
                int off = this._root._text.unObscure(cpAfter, cch);
                while (cch > 0) {
                    if (!Splay.isWhiteSpace(this._root._text._buf[off + cch - 1])) break;
                    --cch;
                }
                int delta = cch - cchAfter;
                if (delta < 0) {
                    this._root._text.remove(cpAfter + cchAfter + delta, -delta);
                    this._lastNonAttr.adjustCchAfter(delta);
                    this.adjustCch(this._lastNonAttr, delta);
                }
            }
        }

        void abort() {
            block3: {
                while (this._frontier != this._root._doc) {
                    this.end();
                }
                try {
                    this.finish();
                }
                catch (XmlException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }

        void finish() throws XmlException {
            if (this._stripWhitespace) {
                this.stripLeadingWhitespace();
            }
            if (this._frontier != this._root._doc) {
                throw new XmlException("Document not ended");
            }
            if (!$assertionsDisabled && !this._root._leftOnly) {
                throw new AssertionError();
            }
            this._finished = true;
            this._lastSplay = this._root;
            this._lastPos = 0;
            if (this._options.hasOption("LOAD_TRIM_TEXT_BUFFER")) {
                this._root._text.trim();
            }
            if (this._additionalNamespaces != null) {
                Splay s = this._root._doc;
                while (!s.isRoot() && !s.isBegin()) {
                    s = s.nextSplay();
                }
                if (s.isBegin()) {
                    Iterator i = this._additionalNamespaces.keySet().iterator();
                    while (i.hasNext()) {
                        String prefix = (String)i.next();
                        if (prefix.toLowerCase().startsWith("xml")) continue;
                        String namespace = (String)this._additionalNamespaces.get(prefix);
                        if (s.namespaceForPrefix(prefix, false) != null) continue;
                        this._root.insertSingleSplaySansSplayInLeftOnlyTree(new Splay.Xmlns(new QName(namespace, prefix)), s);
                        if (!$assertionsDisabled && !this._root.isLeftOnly()) {
                            throw new AssertionError();
                        }
                    }
                }
            }
            this._root.invalidateVersion();
            if (!$assertionsDisabled && !this._root.isLeftOnly()) {
                throw new AssertionError();
            }
        }

        private QName checkName(String local, String uri) {
            String substituteUri;
            if (this._substituteNamespaces != null && (substituteUri = (String)this._substituteNamespaces.get(uri)) != null) {
                return this._qnameCache.getName(substituteUri, local);
            }
            return this._qnameCache.getName(uri, local);
        }

        private QName checkName(QName name) {
            String substituteUri;
            if (this._substituteNamespaces != null && (substituteUri = (String)this._substituteNamespaces.get(name.getNamespaceURI())) != null) {
                name = this._qnameCache.getName(substituteUri, name.getLocalPart());
            }
            return name;
        }

        private QName checkNameAttr(String local, String uri) {
            String substituteUri;
            if (this._substituteNamespaces != null && uri.length() > 0 && (substituteUri = (String)this._substituteNamespaces.get(uri)) != null) {
                return this._qnameCache.getName(substituteUri, local);
            }
            return this._qnameCache.getName(uri, local);
        }

        private QName checkNameAttr(QName name) {
            String substituteUri;
            if (this._substituteNamespaces != null && name.getNamespaceURI().length() > 0 && (substituteUri = (String)this._substituteNamespaces.get(name.getNamespaceURI())) != null) {
                name = this._qnameCache.getName(substituteUri, name.getLocalPart());
            }
            return name;
        }

        void doctype(String name, String publicID, String systemID) {
            this._root._props.setDoctypeName(name);
            this._root._props.setDoctypePublicId(publicID);
            this._root._props.setDoctypeSystemId(systemID);
        }

        private void insertBegin(QName name) {
            if (this._stripWhitespace) {
                this.stripLeadingWhitespace();
            }
            if (this._frontier.isDoc() && !this._docElemDiscarded && (this._discardDocElem || Splay.isXmlFragment(name))) {
                this._docElemDiscarded = true;
                if (this._replaceDocElem == null) {
                    this._root.ensureEmpty();
                    this._lastNonAttr = this._root._doc;
                    this._lastSplay = this._root._doc;
                    this._lastPos = 0;
                    this._frontier = this._root._doc;
                    return;
                }
                name = this._replaceDocElem;
            }
            this._frontier = new Splay.Begin(name, this._frontier);
            this.insert(this._frontier);
        }

        void begin(String local, String uri) {
            this.insertBegin(this.checkName(local, uri));
        }

        void begin(QName name) {
            this.insertBegin(this.checkName(name));
        }

        void end() {
            if (this._stripWhitespace) {
                this.stripLeadingWhitespace();
            }
            if (this._frontier.isDoc()) {
                if (!this._docElemDiscarded) {
                    throw new IllegalStateException("Too many end elements");
                }
            } else {
                if (!$assertionsDisabled && this._finished) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !this._frontier.isBegin()) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this._frontier.isLeaf()) {
                    throw new AssertionError();
                }
                if (this._lastNonAttr == this._frontier) {
                    this._lastSplay = this._frontier;
                    this._lastPos = 1 + this._frontier.getCch();
                    this._frontier.toggleIsLeaf();
                    int cch = this._frontier.getCchAfter();
                    this._frontier.adjustCchAfter(-cch);
                } else {
                    Splay.End e;
                    Splay.Begin b = (Splay.Begin)this._frontier;
                    b._end = e = new Splay.End(b);
                    this.insert(e);
                }
                this._frontier = this._frontier.getContainer();
            }
        }

        void attr(QName name, char[] buf, int off, int cch) {
            this.insert(new Splay.Attr(this.checkNameAttr(name)), buf, off, cch);
        }

        void attr(QName name, String value) {
            this.insert(new Splay.Attr(this.checkNameAttr(name)), value);
        }

        void attr(String local, String uri, String value) {
            this.insert(new Splay.Attr(this.checkNameAttr(local, uri)), value);
        }

        private boolean discardXmlns(QName name) {
            return this._docElemDiscarded && this._frontier.isDoc() && name.getNamespaceURI().equals("http://www.openuri.org/fragment");
        }

        void xmlns(String prefix, String uri) {
            QName name = this.checkName(prefix, uri);
            if (!this.discardXmlns(name)) {
                this.insert(new Splay.Xmlns(name));
            }
        }

        void xmlns(QName name) {
            if (!this.discardXmlns(name = this.checkName(name))) {
                this.insert(new Splay.Xmlns(name));
            }
        }

        void comment(char[] buf, int off, int cch) {
            if (!this._stripComments) {
                this.insert(new Splay.Comment(), buf, off, cch);
            }
        }

        void comment(String value) {
            if (!this._stripComments) {
                this.insert(new Splay.Comment(), value);
            }
        }

        void procinst(String target, char[] buf, int off, int cch) {
            if (!this._stripProcinsts) {
                this.insert(new Splay.Procinst(target), buf, off, cch);
            }
        }

        void procinst(String target, String value) {
            if (!this._stripProcinsts) {
                this.insert(new Splay.Procinst(target), value);
            }
        }

        int preText() {
            if (!$assertionsDisabled && this._finished) {
                throw new AssertionError();
            }
            return this.getCp(this._lastNonAttr) + this._lastNonAttr.getCch();
        }

        void postText(int cp, int cch) {
            if (this._stripWhitespace && this._lastNonAttr.getCchAfter() == 0) {
                int off = this._root._text.unObscure(cp, cch);
                int i = 0;
                while (i < cch && Splay.isWhiteSpace(this._root._text._buf[off + i])) {
                    ++i;
                }
                if (i > 0) {
                    this._root._text.remove(cp, i);
                    cch -= i;
                }
            }
            if (cch > 0) {
                this._lastSplay = this._lastNonAttr;
                this._lastPos = this._lastNonAttr.getEndPos();
                this._lastNonAttr.adjustCchAfter(cch);
                this.adjustCch(this._lastNonAttr, cch);
            }
        }

        void text(char[] buf, int off, int cch) {
            int cchText;
            if (!$assertionsDisabled && this._finished) {
                throw new AssertionError();
            }
            int start = off;
            int end = off + cch;
            if (this._stripWhitespace && this._lastNonAttr.getCchAfter() == 0) {
                while (start < end && Splay.isWhiteSpace(buf[start])) {
                    ++start;
                }
            }
            if ((cchText = end - start) > 0) {
                this._lastSplay = this._lastNonAttr;
                this._lastPos = this._lastNonAttr.getEndPos();
                this._root._text.insert(this.getCp(this._lastNonAttr) + this._lastNonAttr.getCch(), buf, start, cchText);
                this._lastNonAttr.adjustCchAfter(cchText);
                this.adjustCch(this._lastNonAttr, cchText);
            }
        }

        void text(String text) {
            int cchText;
            if (!$assertionsDisabled && this._finished) {
                throw new AssertionError();
            }
            int start = 0;
            int end = text.length();
            if (this._stripWhitespace && this._lastNonAttr.getCchAfter() == 0) {
                while (start < end && Splay.isWhiteSpace(text.charAt(start))) {
                    ++start;
                }
            }
            if ((cchText = end - start) > 0) {
                this._lastSplay = this._lastNonAttr;
                this._lastPos = this._lastNonAttr.getEndPos();
                this._root._text.insert(this.getCp(this._lastNonAttr) + this._lastNonAttr.getCch(), text, start, cchText);
                this._lastNonAttr.adjustCchAfter(cchText);
                this.adjustCch(this._lastNonAttr, cchText);
            }
        }

        void annotate(XmlCursor.XmlBookmark xmlBookmark) {
            new Splay.Annotation(this._root, xmlBookmark).set(this._lastSplay, this._lastPos);
        }

        void lineNumberAnnotation(int line, int column, int offset) {
            this.annotate(new XmlLineNumber(line, column, offset));
        }

        void lineNumberAnnotation(XMLEvent xe) {
            Location loc = xe.getLocation();
            if (loc != null) {
                this.lineNumberAnnotation(loc.getLineNumber(), loc.getColumnNumber(), -1);
            }
        }

        void javelinAnnotation(XmlCursor.XmlBookmark ja) {
            if (ja != null) {
                this.annotate(ja);
            }
        }

        static {
            $assertionsDisabled = !(class$org$apache$xmlbeans$impl$store$Root == null ? (class$org$apache$xmlbeans$impl$store$Root = Root.class$("org.apache.xmlbeans.impl.store.Root")) : class$org$apache$xmlbeans$impl$store$Root).desiredAssertionStatus();
        }
    }

    private class XmlSaxHandlerImpl
    extends SaxLoader
    implements XmlSaxHandler {
        private LoadContext _context;
        private SchemaType _type;
        private XmlOptions _options;
        static final /* synthetic */ boolean $assertionsDisabled;

        XmlSaxHandlerImpl(SchemaType type, XmlOptions options) {
            super(null, null);
            if (!$assertionsDisabled && !Root.this.isEmpty()) {
                throw new AssertionError();
            }
            this._options = options;
            this._type = type;
            this._context = new LoadContext(Root.this, options);
            this.setContext(this._context, options);
        }

        public ContentHandler getContentHandler() {
            return this._context == null ? null : this;
        }

        public LexicalHandler getLexicalHandler() {
            return this._context == null ? null : this;
        }

        public XmlObject getObject() throws XmlException {
            if (this._context == null) {
                return null;
            }
            this._context.finish();
            this._context = null;
            Root.this.associateSourceName(this._options);
            return Root.this.autoTypedDocument(this._type, this._options);
        }

        static {
            $assertionsDisabled = !(class$org$apache$xmlbeans$impl$store$Root == null ? (class$org$apache$xmlbeans$impl$store$Root = Root.class$("org.apache.xmlbeans.impl.store.Root")) : class$org$apache$xmlbeans$impl$store$Root).desiredAssertionStatus();
        }
    }

    private static class SaxLoader
    implements ContentHandler,
    LexicalHandler,
    ErrorHandler,
    EntityResolver {
        protected XMLReader _xr;
        private Locator _locator;
        private LoadContext _context;
        private boolean _wantLineNumbers;
        private Locator _startLocator;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected SaxLoader(XMLReader xr, Locator startLocator) {
            this._xr = xr;
            this._startLocator = startLocator;
            if (xr != null) {
                try {
                    xr.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                    xr.setFeature("http://xml.org/sax/features/namespaces", true);
                    xr.setFeature("http://xml.org/sax/features/validation", false);
                    xr.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                    xr.setContentHandler(this);
                    xr.setErrorHandler(this);
                    xr.setEntityResolver(this);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }

        protected void setContext(LoadContext context, XmlOptions options) {
            this._context = context;
            this._wantLineNumbers = XmlOptions.maskNull(options).hasOption("LOAD_LINE_NUMBERS") && this._startLocator != null;
        }

        protected void postLoad(Root r) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void load(Root r, InputSource inputSource, XmlOptions options) throws IOException, XmlException {
            LoadContext context = new LoadContext(r, options);
            this.setContext(context, options);
            try {
                try {
                    if (!$assertionsDisabled) {
                        if (!r.disableStoreValidation()) {
                            throw new AssertionError();
                        }
                    }
                    this._xr.parse(inputSource);
                    this.postLoad(r);
                    context.finish();
                    r.associateSourceName(options);
                }
                catch (XmlRuntimeException e) {
                    context.abort();
                    throw new XmlException(e);
                }
                catch (SAXParseException e) {
                    context.abort();
                    XmlError err = XmlError.forLocation(e.getMessage(), (String)XmlOptions.safeGet(options, "DOCUMENT_SOURCE_NAME"), e.getLineNumber(), e.getColumnNumber(), -1);
                    throw new XmlException(err.toString(), (Throwable)e, err);
                }
                catch (SAXException e) {
                    context.abort();
                    XmlError err = XmlError.forMessage(e.getMessage());
                    throw new XmlException(err.toString(), (Throwable)e, err);
                }
                catch (RuntimeException e) {
                    context.abort();
                    throw e;
                }
                Object var10_5 = null;
                if ($assertionsDisabled) return;
            }
            catch (Throwable throwable) {
                Object var10_6 = null;
                if (!$assertionsDisabled) {
                    if (!r.enableStoreValidation()) {
                        throw new AssertionError();
                    }
                }
                throw throwable;
            }
            if (!r.enableStoreValidation()) {
                throw new AssertionError();
            }
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
            this._context = null;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.length() == 0) {
                localName = qName;
            }
            if (qName.indexOf(58) >= 0 && namespaceURI.length() == 0) {
                XmlError err = XmlError.forMessage("Use of undefined namespace prefix: " + qName.substring(0, qName.indexOf(58)));
                throw new XmlRuntimeException(err.toString(), null, err);
            }
            this._context.begin(localName, namespaceURI);
            if (this._wantLineNumbers) {
                this._context.lineNumberAnnotation(this._startLocator.getLineNumber(), this._startLocator.getColumnNumber(), -1);
            }
            int i = 0;
            int len = atts.getLength();
            while (i < len) {
                String aqn = atts.getQName(i);
                if (aqn.equals("xmlns")) {
                    this._context.xmlns("", atts.getValue(i));
                } else if (aqn.startsWith("xmlns:")) {
                    String prefix = aqn.substring(6);
                    if (prefix.length() == 0) {
                        XmlError err = XmlError.forMessage("Prefix not specified", 0);
                        throw new XmlRuntimeException(err.toString(), null, err);
                    }
                    String uri = atts.getValue(i);
                    if (uri.length() == 0) {
                        XmlError err = XmlError.forMessage("Prefix can't be mapped to no namespace: " + prefix, 0);
                        throw new XmlRuntimeException(err.toString(), null, err);
                    }
                    this._context.xmlns(prefix, uri);
                } else {
                    String attrUri = atts.getURI(i);
                    String attrLocal = atts.getLocalName(i);
                    if (attrLocal.length() == 0) {
                        attrLocal = aqn;
                    }
                    this._context.attr(attrLocal, attrUri, atts.getValue(i));
                }
                ++i;
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this._context.end();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this._context.text(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this._context.text(ch, start, length);
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            this._context.comment(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this._context.procinst(target, data);
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this._context.doctype(name, publicId, systemId);
        }

        public void endDTD() throws SAXException {
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public void error(SAXParseException e) throws SAXException {
            XmlError err = XmlError.forMessage("Error: " + e.getMessage(), 0);
            throw new XmlRuntimeException(err.toString(), null, err);
        }

        public void warning(SAXParseException e) throws SAXException {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringReader(""));
        }

        public void setDocumentLocator(Locator locator) {
            this._locator = locator;
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (!(!Splay.beginsWithXml(prefix) || "xml".equals(prefix) && "http://www.w3.org/XML/1998/namespace".equals(uri))) {
                XmlError err = XmlError.forMessage("Prefix can't begin with XML: " + prefix, 0);
                throw new XmlRuntimeException(err.toString(), null, err);
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        static {
            $assertionsDisabled = !(class$org$apache$xmlbeans$impl$store$Root == null ? (class$org$apache$xmlbeans$impl$store$Root = Root.class$("org.apache.xmlbeans.impl.store.Root")) : class$org$apache$xmlbeans$impl$store$Root).desiredAssertionStatus();
        }
    }

    private static class DefaultSaxLoader
    extends SaxLoader {
        public static SaxLoader newInstance() {
            try {
                return new DefaultSaxLoader(SAXParserFactory.newInstance().newSAXParser().getXMLReader());
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        private DefaultSaxLoader(XMLReader xr) {
            super(xr, null);
        }
    }

    private static class PiccoloSaxLoader
    extends SaxLoader {
        private Method _m_getEncoding;
        private Method _m_getVersion;

        public static SaxLoader newInstance() {
            try {
                Class<?> pc = Class.forName("com.bluecast.xml.Piccolo");
                XMLReader xr = (XMLReader)pc.newInstance();
                Method m_getEncoding = pc.getMethod("getEncoding", null);
                Method m_getVersion = pc.getMethod("getVersion", null);
                Method m_getStartLocator = pc.getMethod("getStartLocator", null);
                Locator startLocator = (Locator)m_getStartLocator.invoke((Object)xr, null);
                return new PiccoloSaxLoader(xr, startLocator, m_getEncoding, m_getVersion);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        protected void postLoad(Root r) {
            try {
                r._props.setEncoding((String)this._m_getEncoding.invoke((Object)this._xr, null));
                r._props.setVersion((String)this._m_getVersion.invoke((Object)this._xr, null));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        private PiccoloSaxLoader(XMLReader xr, Locator startLocator, Method m_getEncoding, Method m_getVersion) {
            super(xr, startLocator);
            this._m_getEncoding = m_getEncoding;
            this._m_getVersion = m_getVersion;
        }
    }
}

