/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate4;

import java.io.IOException;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.transaction.internal.jta.CMTTransactionFactory;
import org.hibernate.service.jta.platform.internal.WebSphereExtendedJtaPlatform;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.orm.hibernate4.ConfigurableJtaPlatform;
import org.springframework.orm.hibernate4.SpringSessionContext;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalSessionFactoryBuilder
extends Configuration {
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private static final TypeFilter[] ENTITY_TYPE_FILTERS = new TypeFilter[]{new AnnotationTypeFilter(Entity.class, false), new AnnotationTypeFilter(Embeddable.class, false), new AnnotationTypeFilter(MappedSuperclass.class, false)};
    private final ResourcePatternResolver resourcePatternResolver;

    public LocalSessionFactoryBuilder(DataSource dataSource) {
        this(dataSource, (ResourceLoader)new PathMatchingResourcePatternResolver());
    }

    public LocalSessionFactoryBuilder(DataSource dataSource, ClassLoader classLoader) {
        this(dataSource, (ResourceLoader)new PathMatchingResourcePatternResolver(classLoader));
    }

    public LocalSessionFactoryBuilder(DataSource dataSource, ResourceLoader resourceLoader) {
        this.getProperties().put("hibernate.current_session_context_class", SpringSessionContext.class.getName());
        if (dataSource != null) {
            this.getProperties().put("hibernate.connection.datasource", dataSource);
        }
        this.getProperties().put("hibernate.classLoader.application", resourceLoader.getClassLoader());
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
    }

    public LocalSessionFactoryBuilder setJtaTransactionManager(Object jtaTransactionManager) {
        Assert.notNull((Object)jtaTransactionManager, (String)"Transaction manager reference must not be null");
        if (jtaTransactionManager instanceof JtaTransactionManager) {
            boolean webspherePresent = ClassUtils.isPresent((String)"com.ibm.wsspi.uow.UOWManager", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            if (webspherePresent) {
                this.getProperties().put("hibernate.transaction.jta.platform", new WebSphereExtendedJtaPlatform());
            } else {
                JtaTransactionManager jtaTm = (JtaTransactionManager)jtaTransactionManager;
                if (jtaTm.getTransactionManager() == null) {
                    throw new IllegalArgumentException("Can only apply JtaTransactionManager which has a TransactionManager reference set");
                }
                this.getProperties().put("hibernate.transaction.jta.platform", (Object)new ConfigurableJtaPlatform(jtaTm.getTransactionManager(), jtaTm.getUserTransaction()));
            }
        } else if (jtaTransactionManager instanceof TransactionManager) {
            this.getProperties().put("hibernate.transaction.jta.platform", (Object)new ConfigurableJtaPlatform((TransactionManager)jtaTransactionManager, null));
        } else {
            throw new IllegalArgumentException("Unknown transaction manager type: " + jtaTransactionManager.getClass().getName());
        }
        this.getProperties().put("hibernate.transaction.factory_class", new CMTTransactionFactory());
        return this;
    }

    public LocalSessionFactoryBuilder addAnnotatedClasses(Class<?> ... annotatedClasses) {
        for (Class<?> annotatedClass : annotatedClasses) {
            this.addAnnotatedClass(annotatedClass);
        }
        return this;
    }

    public LocalSessionFactoryBuilder addPackages(String ... annotatedPackages) {
        for (String annotatedPackage : annotatedPackages) {
            this.addPackage(annotatedPackage);
        }
        return this;
    }

    public LocalSessionFactoryBuilder scanPackages(String ... packagesToScan) throws HibernateException {
        try {
            for (String pkg : packagesToScan) {
                String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + RESOURCE_PATTERN;
                Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                for (Resource resource : resources) {
                    if (!resource.isReadable()) continue;
                    MetadataReader reader = readerFactory.getMetadataReader(resource);
                    String className = reader.getClassMetadata().getClassName();
                    if (!this.matchesFilter(reader, (MetadataReaderFactory)readerFactory)) continue;
                    this.addAnnotatedClasses(this.resourcePatternResolver.getClassLoader().loadClass(className));
                }
            }
            return this;
        }
        catch (IOException ex) {
            throw new MappingException("Failed to scan classpath for unlisted classes", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new MappingException("Failed to load annotated classes from classpath", (Throwable)ex);
        }
    }

    private boolean matchesFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        for (TypeFilter filter : ENTITY_TYPE_FILTERS) {
            if (!filter.match(reader, readerFactory)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionFactory buildSessionFactory() throws HibernateException {
        boolean overrideClassLoader;
        ClassLoader appClassLoader = (ClassLoader)this.getProperties().get("hibernate.classLoader.application");
        Thread currentThread = Thread.currentThread();
        ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
        boolean bl = overrideClassLoader = appClassLoader != null && !appClassLoader.equals(threadContextClassLoader);
        if (overrideClassLoader) {
            currentThread.setContextClassLoader(appClassLoader);
        }
        try {
            SessionFactory sessionFactory = super.buildSessionFactory();
            return sessionFactory;
        }
        finally {
            if (overrideClassLoader) {
                currentThread.setContextClassLoader(threadContextClassLoader);
            }
        }
    }
}

