/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.pattern;

import java.util.Vector;
import jp.sourceforge.qrcode.QRCodeDecoder;
import jp.sourceforge.qrcode.exception.FinderPatternNotFoundException;
import jp.sourceforge.qrcode.exception.InvalidVersionException;
import jp.sourceforge.qrcode.exception.InvalidVersionInfoException;
import jp.sourceforge.qrcode.exception.VersionInformationException;
import jp.sourceforge.qrcode.geom.Axis;
import jp.sourceforge.qrcode.geom.Line;
import jp.sourceforge.qrcode.geom.Point;
import jp.sourceforge.qrcode.reader.QRCodeImageReader;
import jp.sourceforge.qrcode.util.DebugCanvas;

public class FinderPattern {
    public static final int UL = 0;
    public static final int UR = 1;
    public static final int DL = 2;
    static final int[] VersionInfoBit = new int[]{31892, 34236, 39577, 42195, 48118, 51042, 55367, 58893, 63784, 68472, 70749, 76311, 79154, 84390, 87683, 92361, 96236, 102084, 102881, 110507, 110734, 117786, 119615, 126325, 127568, 133589, 136944, 141498, 145311, 150283, 152622, 158308, 161089, 167017};
    static DebugCanvas canvas = QRCodeDecoder.getCanvas();
    Point[] center;
    int version;
    int[] sincos;
    int[] width;
    int[] moduleSize;

    public static FinderPattern findFinderPattern(boolean[][] blArray) throws FinderPatternNotFoundException, VersionInformationException {
        Line[] lineArray = FinderPattern.findLineAcross(blArray);
        Line[] lineArray2 = FinderPattern.findLineCross(lineArray);
        Point[] pointArray = null;
        pointArray = FinderPattern.getCenter(lineArray2);
        int[] nArray = FinderPattern.getAngle(pointArray);
        pointArray = FinderPattern.sort(pointArray, nArray);
        int[] nArray2 = FinderPattern.getWidth(blArray, pointArray, nArray);
        int[] nArray3 = new int[]{(nArray2[0] << QRCodeImageReader.DECIMAL_POINT) / 7, (nArray2[1] << QRCodeImageReader.DECIMAL_POINT) / 7, (nArray2[2] << QRCodeImageReader.DECIMAL_POINT) / 7};
        int n = FinderPattern.calcRoughVersion(pointArray, nArray2);
        if (n > 6) {
            try {
                n = FinderPattern.calcExactVersion(pointArray, nArray, nArray3, blArray);
            }
            catch (VersionInformationException versionInformationException) {
                // empty catch block
            }
        }
        return new FinderPattern(pointArray, n, nArray, nArray2, nArray3);
    }

    FinderPattern(Point[] pointArray, int n, int[] nArray, int[] nArray2, int[] nArray3) {
        this.center = pointArray;
        this.version = n;
        this.sincos = nArray;
        this.width = nArray2;
        this.moduleSize = nArray3;
    }

    public Point[] getCenter() {
        return this.center;
    }

    public Point getCenter(int n) {
        if (n >= 0 && n <= 2) {
            return this.center[n];
        }
        return null;
    }

    public int getWidth(int n) {
        return this.width[n];
    }

    public int[] getAngle() {
        return this.sincos;
    }

    public int getVersion() {
        return this.version;
    }

    public int getModuleSize() {
        return this.moduleSize[0];
    }

    public int getModuleSize(int n) {
        return this.moduleSize[n];
    }

    public int getSqrtNumModules() {
        return 17 + 4 * this.version;
    }

    static Line[] findLineAcross(boolean[][] blArray) {
        int n;
        int n2 = blArray.length;
        int n3 = blArray[0].length;
        Point point = new Point();
        Vector<Line> vector = new Vector<Line>();
        int[] nArray = new int[5];
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            boolean bl3;
            if ((bl3 = blArray[point.getX()][point.getY()]) == bl2) {
                int n5 = n4;
                nArray[n5] = nArray[n5] + 1;
            } else {
                if (!bl3 && FinderPattern.checkPattern(nArray, n4)) {
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    if (!bl) {
                        n = point.getX();
                        for (n9 = 0; n9 < 5; ++n9) {
                            n -= nArray[n9];
                        }
                        n8 = point.getX() - 1;
                        n6 = n7 = point.getY();
                    } else {
                        n = n8 = point.getX();
                        n6 = point.getY();
                        for (n9 = 0; n9 < 5; ++n9) {
                            n6 -= nArray[n9];
                        }
                        n7 = point.getY() - 1;
                    }
                    vector.addElement(new Line(n, n6, n8, n7));
                }
                n4 = (n4 + 1) % 5;
                nArray[n4] = 1;
                boolean bl4 = bl2 = !bl2;
            }
            if (!bl) {
                if (point.getX() < n2 - 1) {
                    point.translate(1, 0);
                    continue;
                }
                if (point.getY() < n3 - 1) {
                    point.set(0, point.getY() + 1);
                    nArray = new int[5];
                    continue;
                }
                point.set(0, 0);
                nArray = new int[5];
                bl = true;
                continue;
            }
            if (point.getY() < n3 - 1) {
                point.translate(0, 1);
                continue;
            }
            if (point.getX() >= n2 - 1) break;
            point.set(point.getX() + 1, 0);
            nArray = new int[5];
        }
        Line[] lineArray = new Line[vector.size()];
        for (n = 0; n < lineArray.length; ++n) {
            lineArray[n] = (Line)vector.elementAt(n);
        }
        canvas.drawLines(lineArray, 0xBBFFBB);
        return lineArray;
    }

    static boolean checkPattern(int[] nArray, int n) {
        int n2;
        int[] nArray2 = new int[]{1, 1, 3, 1, 1};
        int n3 = 0;
        for (n2 = 0; n2 < 5; ++n2) {
            n3 += nArray[n2];
        }
        n3 <<= QRCodeImageReader.DECIMAL_POINT;
        n3 /= 7;
        for (n2 = 0; n2 < 5; ++n2) {
            int n4 = n3 * nArray2[n2] - n3 / 2;
            int n5 = n3 * nArray2[n2] + n3 / 2;
            int n6 = nArray[(n + n2 + 1) % 5] << QRCodeImageReader.DECIMAL_POINT;
            if (n6 >= n4 && n6 <= n5) continue;
            return false;
        }
        return true;
    }

    static Line[] findLineCross(Line[] lineArray) {
        int n;
        int n2;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector<Line> vector3 = new Vector<Line>();
        for (n2 = 0; n2 < lineArray.length; ++n2) {
            vector3.addElement(lineArray[n2]);
        }
        block1: for (n2 = 0; n2 < vector3.size() - 1; ++n2) {
            vector2.removeAllElements();
            vector2.addElement(vector3.elementAt(n2));
            for (n = n2 + 1; n < vector3.size(); ++n) {
                int n3;
                Line line;
                if (Line.isNeighbor((Line)vector2.lastElement(), (Line)vector3.elementAt(n))) {
                    vector2.addElement(vector3.elementAt(n));
                    line = (Line)vector2.lastElement();
                    if (vector2.size() * 5 <= line.getLength() || n != vector3.size() - 1) continue;
                    vector.addElement(vector2.elementAt(vector2.size() / 2));
                    for (n3 = 0; n3 < vector2.size(); ++n3) {
                        vector3.removeElement(vector2.elementAt(n3));
                    }
                    continue;
                }
                if (!FinderPattern.cantNeighbor((Line)vector2.lastElement(), (Line)vector3.elementAt(n)) && n != vector3.size() - 1) continue;
                line = (Line)vector2.lastElement();
                if (vector2.size() * 6 <= line.getLength()) continue block1;
                vector.addElement(vector2.elementAt(vector2.size() / 2));
                for (n3 = 0; n3 < vector2.size(); ++n3) {
                    vector3.removeElement(vector2.elementAt(n3));
                }
                continue block1;
            }
        }
        Line[] lineArray2 = new Line[vector.size()];
        for (n = 0; n < lineArray2.length; ++n) {
            lineArray2[n] = (Line)vector.elementAt(n);
        }
        return lineArray2;
    }

    static boolean cantNeighbor(Line line, Line line2) {
        if (Line.isCross(line, line2)) {
            return true;
        }
        return line.isHorizontal() ? Math.abs(line.getP1().getY() - line2.getP1().getY()) > 1 : Math.abs(line.getP1().getX() - line2.getP1().getX()) > 1;
    }

    static int[] getAngle(Point[] pointArray) {
        Line[] lineArray = new Line[3];
        for (int i = 0; i < lineArray.length; ++i) {
            lineArray[i] = new Line(pointArray[i], pointArray[(i + 1) % lineArray.length]);
        }
        Line line = Line.getLongest(lineArray);
        Point point = new Point();
        for (int i = 0; i < pointArray.length; ++i) {
            if (line.getP1().equals(pointArray[i]) || line.getP2().equals(pointArray[i])) continue;
            point = pointArray[i];
            break;
        }
        canvas.println("originPoint is: " + point);
        Point point2 = new Point();
        point2 = point.getY() <= line.getP1().getY() & point.getY() <= line.getP2().getY() ? (line.getP1().getX() < line.getP2().getX() ? line.getP2() : line.getP1()) : (point.getX() >= line.getP1().getX() & point.getX() >= line.getP2().getX() ? (line.getP1().getY() < line.getP2().getY() ? line.getP2() : line.getP1()) : (point.getY() >= line.getP1().getY() & point.getY() >= line.getP2().getY() ? (line.getP1().getX() < line.getP2().getX() ? line.getP1() : line.getP2()) : (line.getP1().getY() < line.getP2().getY() ? line.getP1() : line.getP2())));
        int n = new Line(point, point2).getLength();
        int[] nArray = new int[]{(point2.getY() - point.getY() << QRCodeImageReader.DECIMAL_POINT) / n, (point2.getX() - point.getX() << QRCodeImageReader.DECIMAL_POINT) / n};
        return nArray;
    }

    static Point[] getCenter(Line[] lineArray) throws FinderPatternNotFoundException {
        Vector<Point> vector = new Vector<Point>();
        for (int i = 0; i < lineArray.length - 1; ++i) {
            Line line = lineArray[i];
            for (int j = i + 1; j < lineArray.length; ++j) {
                Line line2 = lineArray[j];
                if (!Line.isCross(line, line2)) continue;
                int n = 0;
                int n2 = 0;
                if (line.isHorizontal()) {
                    n = line.getCenter().getX();
                    n2 = line2.getCenter().getY();
                } else {
                    n = line2.getCenter().getX();
                    n2 = line.getCenter().getY();
                }
                vector.addElement(new Point(n, n2));
            }
        }
        Point[] pointArray = new Point[vector.size()];
        for (int i = 0; i < pointArray.length; ++i) {
            pointArray[i] = (Point)vector.elementAt(i);
        }
        if (pointArray.length == 3) {
            canvas.drawPolygon(pointArray, 0xFF88888);
            return pointArray;
        }
        throw new FinderPatternNotFoundException("Invalid number of Finder Pattern detected");
    }

    static Point[] sort(Point[] pointArray, int[] nArray) {
        Point[] pointArray2 = new Point[3];
        int n = FinderPattern.getURQuadrant(nArray);
        switch (n) {
            case 1: {
                pointArray2[1] = FinderPattern.getPointAtSide(pointArray, 1, 2);
                pointArray2[2] = FinderPattern.getPointAtSide(pointArray, 2, 4);
                break;
            }
            case 2: {
                pointArray2[1] = FinderPattern.getPointAtSide(pointArray, 2, 4);
                pointArray2[2] = FinderPattern.getPointAtSide(pointArray, 8, 4);
                break;
            }
            case 3: {
                pointArray2[1] = FinderPattern.getPointAtSide(pointArray, 4, 8);
                pointArray2[2] = FinderPattern.getPointAtSide(pointArray, 1, 8);
                break;
            }
            case 4: {
                pointArray2[1] = FinderPattern.getPointAtSide(pointArray, 8, 1);
                pointArray2[2] = FinderPattern.getPointAtSide(pointArray, 2, 1);
            }
        }
        for (int i = 0; i < pointArray.length; ++i) {
            if (pointArray[i].equals(pointArray2[1]) || pointArray[i].equals(pointArray2[2])) continue;
            pointArray2[0] = pointArray[i];
        }
        return pointArray2;
    }

    static int getURQuadrant(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        if (n >= 0 && n2 > 0) {
            return 1;
        }
        if (n > 0 && n2 <= 0) {
            return 2;
        }
        if (n <= 0 && n2 < 0) {
            return 3;
        }
        if (n < 0 && n2 >= 0) {
            return 4;
        }
        return 0;
    }

    static Point getPointAtSide(Point[] pointArray, int n, int n2) {
        Point point = new Point();
        int n3 = n == 1 || n2 == 1 ? 0 : Integer.MAX_VALUE;
        int n4 = n == 2 || n2 == 2 ? 0 : Integer.MAX_VALUE;
        point = new Point(n3, n4);
        block6: for (int i = 0; i < pointArray.length; ++i) {
            switch (n) {
                case 1: {
                    if (point.getX() < pointArray[i].getX()) {
                        point = pointArray[i];
                        continue block6;
                    }
                    if (point.getX() != pointArray[i].getX()) continue block6;
                    if (n2 == 2) {
                        if (point.getY() >= pointArray[i].getY()) continue block6;
                        point = pointArray[i];
                        continue block6;
                    }
                    if (point.getY() <= pointArray[i].getY()) continue block6;
                    point = pointArray[i];
                    continue block6;
                }
                case 2: {
                    if (point.getY() < pointArray[i].getY()) {
                        point = pointArray[i];
                        continue block6;
                    }
                    if (point.getY() != pointArray[i].getY()) continue block6;
                    if (n2 == 1) {
                        if (point.getX() >= pointArray[i].getX()) continue block6;
                        point = pointArray[i];
                        continue block6;
                    }
                    if (point.getX() <= pointArray[i].getX()) continue block6;
                    point = pointArray[i];
                    continue block6;
                }
                case 4: {
                    if (point.getX() > pointArray[i].getX()) {
                        point = pointArray[i];
                        continue block6;
                    }
                    if (point.getX() != pointArray[i].getX()) continue block6;
                    if (n2 == 2) {
                        if (point.getY() >= pointArray[i].getY()) continue block6;
                        point = pointArray[i];
                        continue block6;
                    }
                    if (point.getY() <= pointArray[i].getY()) continue block6;
                    point = pointArray[i];
                    continue block6;
                }
                case 8: {
                    if (point.getY() > pointArray[i].getY()) {
                        point = pointArray[i];
                        continue block6;
                    }
                    if (point.getY() != pointArray[i].getY()) continue block6;
                    if (n2 == 1) {
                        if (point.getX() >= pointArray[i].getX()) continue block6;
                        point = pointArray[i];
                        continue block6;
                    }
                    if (point.getX() <= pointArray[i].getX()) continue block6;
                    point = pointArray[i];
                }
            }
        }
        return point;
    }

    static int[] getWidth(boolean[][] blArray, Point[] pointArray, int[] nArray) throws ArrayIndexOutOfBoundsException {
        int[] nArray2 = new int[3];
        for (int i = 0; i < 3; ++i) {
            int n;
            int n2;
            boolean bl = false;
            int n3 = pointArray[i].getY();
            for (n2 = pointArray[i].getX(); n2 >= 0; --n2) {
                if (!blArray[n2][n3] || blArray[n2 - 1][n3]) continue;
                if (bl) break;
                bl = true;
            }
            bl = false;
            for (n = pointArray[i].getX(); n < blArray.length; ++n) {
                if (!blArray[n][n3] || blArray[n + 1][n3]) continue;
                if (bl) break;
                bl = true;
            }
            nArray2[i] = n - n2 + 1;
        }
        return nArray2;
    }

    static int calcRoughVersion(Point[] pointArray, int[] nArray) {
        int n = QRCodeImageReader.DECIMAL_POINT;
        int n2 = new Line(pointArray[0], pointArray[1]).getLength() << n;
        int n3 = (nArray[0] + nArray[1] << n) / 14;
        int n4 = (n2 / n3 - 10) / 4;
        if ((n2 / n3 - 10) % 4 >= 2) {
            ++n4;
        }
        return n4;
    }

    static int calcExactVersion(Point[] pointArray, int[] nArray, int[] nArray2, boolean[][] blArray) throws InvalidVersionInfoException, InvalidVersionException {
        Point point;
        int n;
        boolean[] blArray2 = new boolean[18];
        Point[] pointArray2 = new Point[18];
        Axis axis = new Axis(nArray, nArray2[1]);
        axis.setOrigin(pointArray[1]);
        for (n = 0; n < 6; ++n) {
            for (int i = 0; i < 3; ++i) {
                point = axis.translate(i - 7, n - 3);
                blArray2[i + n * 3] = blArray[point.getX()][point.getY()];
                pointArray2[i + n * 3] = point;
            }
        }
        canvas.drawPoints(pointArray2, 0xFF88888);
        n = 0;
        try {
            n = FinderPattern.checkVersionInfo(blArray2);
        }
        catch (InvalidVersionInfoException invalidVersionInfoException) {
            canvas.println("Version info error. now retry with other place one.");
            axis.setOrigin(pointArray[2]);
            axis.setModulePitch(nArray2[2]);
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 3; ++j) {
                    point = axis.translate(i - 3, j - 7);
                    blArray2[j + i * 3] = blArray[point.getX()][point.getY()];
                    pointArray2[i + j * 3] = point;
                }
            }
            canvas.drawPoints(pointArray2, 0xFF88888);
            n = FinderPattern.checkVersionInfo(blArray2);
        }
        return n;
    }

    static int checkVersionInfo(boolean[] blArray) throws InvalidVersionInfoException {
        int n;
        int n2 = 0;
        for (n = 0; n < VersionInfoBit.length; ++n) {
            n2 = 0;
            for (int i = 0; i < 18; ++i) {
                if (!(blArray[i] ^ (VersionInfoBit[n] >> i) % 2 == 1)) continue;
                ++n2;
            }
            if (n2 <= 3) break;
        }
        if (n2 <= 3) {
            return 7 + n;
        }
        throw new InvalidVersionInfoException("Too many errors in version information");
    }
}

