/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.geom;

import jp.sourceforge.qrcode.geom.Line;
import jp.sourceforge.qrcode.geom.Point;

public class SamplingGrid {
    private AreaGrid[][] grid;

    public SamplingGrid(int n) {
        this.grid = new AreaGrid[n][n];
    }

    public void initGrid(int n, int n2, int n3, int n4) {
        this.grid[n][n2] = new AreaGrid(n3, n4);
    }

    public void setXLine(int n, int n2, int n3, Line line) {
        this.grid[n][n2].setXLine(n3, line);
    }

    public void setYLine(int n, int n2, int n3, Line line) {
        this.grid[n][n2].setYLine(n3, line);
    }

    public Line getXLine(int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        return this.grid[n][n2].getXLine(n3);
    }

    public Line getYLine(int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        return this.grid[n][n2].getYLine(n3);
    }

    public Line[] getXLines(int n, int n2) {
        return this.grid[n][n2].getXLines();
    }

    public Line[] getYLines(int n, int n2) {
        return this.grid[n][n2].getYLines();
    }

    public int getWidth() {
        return this.grid[0].length;
    }

    public int getHeight() {
        return this.grid.length;
    }

    public int getWidth(int n, int n2) {
        return this.grid[n][n2].getWidth();
    }

    public int getHeight(int n, int n2) {
        return this.grid[n][n2].getHeight();
    }

    public int getTotalWidth() {
        int n = 0;
        for (int i = 0; i < this.grid.length; ++i) {
            n += this.grid[i][0].getWidth();
            if (i <= 0) continue;
            --n;
        }
        return n;
    }

    public int getTotalHeight() {
        int n = 0;
        for (int i = 0; i < this.grid[0].length; ++i) {
            n += this.grid[0][i].getHeight();
            if (i <= 0) continue;
            --n;
        }
        return n;
    }

    public int getX(int n, int n2) {
        int n3 = n2;
        for (int i = 0; i < n; ++i) {
            n3 += this.grid[i][0].getWidth() - 1;
        }
        return n3;
    }

    public int getY(int n, int n2) {
        int n3 = n2;
        for (int i = 0; i < n; ++i) {
            n3 += this.grid[0][i].getHeight() - 1;
        }
        return n3;
    }

    public void adjust(Point point) {
        int n = point.getX();
        int n2 = point.getY();
        for (int i = 0; i < this.grid[0].length; ++i) {
            for (int j = 0; j < this.grid.length; ++j) {
                int n3;
                for (n3 = 0; n3 < this.grid[j][i].xLine.length; ++n3) {
                    this.grid[j][i].xLine[n3].translate(n, n2);
                }
                for (n3 = 0; n3 < this.grid[j][i].yLine.length; ++n3) {
                    this.grid[j][i].yLine[n3].translate(n, n2);
                }
            }
        }
    }

    private class AreaGrid {
        protected Line[] xLine;
        protected Line[] yLine;

        public AreaGrid(int n, int n2) {
            this.xLine = new Line[n];
            this.yLine = new Line[n2];
        }

        public int getWidth() {
            return this.xLine.length;
        }

        public int getHeight() {
            return this.yLine.length;
        }

        public Line getXLine(int n) throws ArrayIndexOutOfBoundsException {
            return this.xLine[n];
        }

        public Line getYLine(int n) throws ArrayIndexOutOfBoundsException {
            return this.yLine[n];
        }

        public Line[] getXLines() {
            return this.xLine;
        }

        public Line[] getYLines() {
            return this.yLine;
        }

        public void setXLine(int n, Line line) {
            this.xLine[n] = line;
        }

        public void setYLine(int n, Line line) {
            this.yLine[n] = line;
        }
    }
}

